/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service.sms.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.recuritment.utils.RecCacheUtil;
import com.kingdee.shr.recuritment.utils.RecSettingUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsEmpSha256Util {
    private static Logger logger = LoggerFactory.getLogger(SmsEmpSha256Util.class);

    public static HashMap<String, String> getHeader(Context ctx, String phone, String content) {
        ICloudServiceConfig irecConfig = null;
        HashMap<String, String> header = new HashMap<String, String>();
        try {
            irecConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            CloudServiceConfigCollection coll = irecConfig.getCloudServiceConfigCollection();
            CloudServiceConfigInfo configInfo = null;
            if (coll.size() > 0) {
                configInfo = coll.get(0);
                header.put("tenantId", configInfo.getServiceID());
                header.put("token", configInfo.getAccessToken());
            } else {
                header.put("envCode", SmsEmpSha256Util.getEnvCode(ctx));
                header.put("enContent", SmsEmpSha256Util.getSMSHashText(ctx, phone, content));
            }
        }
        catch (BOSException e) {
            String label0 = SHRServerResource.getString((String)"com.kingdee.shr.preentry.PreEntrySmsResource", (String)"label0", (Context)ctx);
            logger.error("com.kingdee.shr.preentry.util.SmsEmpSha256Util.getHeader label0 e:" + label0 + e.getMessage());
        }
        return header;
    }

    private static String getSMSHashText(Context ctx, String phone, String content) {
        String envCode = SmsEmpSha256Util.getEnvCode(ctx);
        String token = SmsEmpSha256Util.accessToken(ctx);
        String str = token + phone + envCode + content;
        if (logger.isDebugEnabled()) {
            logger.error("before hash Text:" + str);
        }
        String encodeString = SmsEmpSha256Util.getSHA256(str);
        if (logger.isDebugEnabled()) {
            logger.error("after hash Text:" + encodeString);
        }
        return encodeString;
    }

    private static String accessToken(Context ctx) {
        String token = RecCacheUtil.getString("SMS_SERVICE_DEFAULT_TOKEN");
        if (StringUtils.isEmpty((CharSequence)token)) {
            try {
                token = RecSettingUtil.getByKey(ctx, "SMS_SERVICE_DEFAULT_TOKEN");
                if (StringUtils.isNotEmpty((CharSequence)token)) {
                    RecCacheUtil.put("SMS_SERVICE_DEFAULT_TOKEN", token);
                }
            }
            catch (BOSException e) {
                logger.error("\u83b7\u53d6\u77ed\u4fe1\u670d\u52a1\u7684AccessToken\u51fa\u9519");
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return token;
    }

    private static String getEnvCode(Context ctx) {
        String envCode = "";
        try {
            if (logger.isDebugEnabled()) {
                logger.error("try to get the envCode!");
            }
            envCode = LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getLicenseBaseInfo().getProductInstanceID();
            if (logger.isDebugEnabled()) {
                logger.error("envCode: " + envCode);
            }
            if (StringUtils.isEmpty((CharSequence)envCode)) {
                envCode = "defaultEnvCode";
            }
        }
        catch (Exception e) {
            logger.error("get envCode failed ! use the default code" + e.getMessage());
        }
        return envCode;
    }

    private static String getSHA256(String str) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = SmsEmpSha256Util.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }
}

