/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service.sms.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.shr.recuritment.app.service.sms.util.SmsEmpSha256Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SmsUtils {
    private static Logger logger = LoggerFactory.getLogger(SmsUtils.class);

    public static Map<String, Object> smsHttpPost(Context ctx, Map<String, String> paramMap) {
        Map map = SmsUtils.verifySmsParams(ctx, paramMap);
        if (logger.isDebugEnabled()) {
            logger.error("sms url:" + map.get("apiUrl"));
        }
        String resp = SmsUtils.httpPost((String)map.get("apiUrl"), (Map)map.get("param"), (Map)map.get("smsCommonHeader"));
        if (logger.isDebugEnabled()) {
            logger.error("[recSms]sms smsHttpPost resp:" + resp);
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
            if (resultJsonObject != null && resultJsonObject.get((Object)"data") != null) {
                JSONObject data = resultJsonObject.getJSONObject("data");
                if (data != null && data.get((Object)"errorcode") != null) {
                    resultMap.put("state", data.get((Object)"errorcode").toString());
                } else {
                    resultMap.put("state", -1);
                }
                resultMap.put("responseMsg", resultJsonObject.getString("data"));
            } else {
                resultMap.put("errorMsg", "can not connect to tsp sms service!");
                resultMap.put("responseMsg", resultJsonObject.getString("data"));
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u53d1\u9001\u77ed\u4fe1\u8fd4\u56de\u503c\u51fa\u9519");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String httpPost(String url, Map params, Map<String, String> header) {
        if (logger.isDebugEnabled()) {
            logger.error("[recSms]doHttpPost params:" + JSON.toJSONString((Object)params));
            logger.error("[recSms]doHttpPost header:" + JSON.toJSONString(header));
        }
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("accept", "*/*");
        httpPost.addHeader("content-Type", "application/json");
        if (!header.isEmpty()) {
            Set<Map.Entry<String, String>> headEntrys = header.entrySet();
            for (Map.Entry<String, String> entry : headEntrys) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!params.isEmpty()) {
            JSONObject jsonObject = new JSONObject();
            Set paramEntrys = params.entrySet();
            for (Map.Entry entry : paramEntrys) {
                jsonObject.put((String)entry.getKey(), entry.getValue());
            }
            StringEntity stringEntity = new StringEntity(jsonObject.toString(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        String result = "";
        try {
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONObject successObject = new JSONObject();
            successObject.put("code", (Object)response.getStatusLine().getStatusCode());
            successObject.put("data", (Object)string);
            result = successObject.toJSONString();
            if (logger.isDebugEnabled()) {
                logger.error("[recSms] smsUtils#doHttpPost, result:" + result);
            }
        }
        catch (Exception e) {
            logger.error("[recSms] it is failed to doHttpPost", (Throwable)e);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("code", (Object)"400");
            result = jSONObject.toJSONString();
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error("[recSms] it is failed to close doHttpPost", (Throwable)e);
            }
        }
        return result;
    }

    private static Map verifySmsParams(Context ctx, Map<String, String> paramMap) {
        String phone = paramMap.get("phone");
        String content = paramMap.get("content");
        String smsCode = paramMap.get("smsCode");
        String apiUrl = paramMap.get("apiUrl");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("phone", phone);
        param.put("tempNumber", smsCode);
        param.put("content", content);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map smsCommonHeader = SmsUtils.getSmsCommonHeader(ctx, phone, content);
        if (CollectionUtils.isEmpty((Map)smsCommonHeader)) {
            result.put("errorcode", "-1");
            result.put("errormsg", "sms header can't empty");
            return result;
        }
        result.put("param", param);
        result.put("apiUrl", apiUrl);
        result.put("smsCommonHeader", smsCommonHeader);
        if (logger.isDebugEnabled()) {
            logger.error("[recSms]sms verifySmsParams:" + JSON.toJSONString(result));
        }
        return result;
    }

    private static Map getSmsCommonHeader(Context ctx, String phone, String content) {
        return SmsEmpSha256Util.getHeader(ctx, phone, content);
    }
}

