/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service.videoInterview;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.recuritment.IInterviewPlan;
import com.kingdee.shr.recuritment.IVideoInterviewRecord;
import com.kingdee.shr.recuritment.InterviewPlanCollection;
import com.kingdee.shr.recuritment.InterviewPlanFactory;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.VideoInterviewConfigInfo;
import com.kingdee.shr.recuritment.VideoInterviewRecordCollection;
import com.kingdee.shr.recuritment.VideoInterviewRecordFactory;
import com.kingdee.shr.recuritment.VideoInterviewRecordInfo;
import com.kingdee.shr.recuritment.VideoInterviewType;
import com.kingdee.shr.recuritment.app.service.videoInterview.VideoInterviewService;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class VideoInterviewRunnable
implements Callable {
    private static Logger logger = Logger.getLogger(VideoInterviewRunnable.class);
    public static final String CREATE = "createMeeting";
    public static final String DELETE = "deleteMeeting";
    private Context ctx;
    private String[] interviewPlanIds;
    private String oper;

    public Object call() throws Exception {
        String videoInterviewType = VideoInterviewService.getInstance().getVideoInterviewType(this.ctx);
        if (StringUtils.isEmpty((CharSequence)videoInterviewType)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"VideoInterview token is not initialize");
            }
            return "error";
        }
        if (this.oper.equals(CREATE)) {
            this.createVideoMeeting(videoInterviewType);
        } else if (this.oper.equals(DELETE)) {
            this.deleteVideoMeeting(videoInterviewType);
        }
        return "success";
    }

    public VideoInterviewRunnable(Context ctx, String[] interviewPlanIds, String oper) {
        this.ctx = ctx;
        this.interviewPlanIds = interviewPlanIds;
        this.oper = oper;
    }

    private void createVideoMeeting(String videoInterviewType) {
        block19: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"create videoMeeting start");
            }
            try {
                if (this.interviewPlanIds == null || this.interviewPlanIds.length <= 0) break block19;
                HashSet<String> billIdSet = new HashSet<String>(Arrays.asList(this.interviewPlanIds));
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("groupInterview");
                selector.add("interviewTime");
                selector.add("videoInterConfig.waitingRoom");
                selector.add("videoInterConfig.userId");
                selector.add("videoInterRecord.meetingId");
                selector.add("videoInterRecord.videoType");
                selector.add("interview.resumeBaseRec.name");
                view.setSelector(selector);
                view.getSorter().add(new SorterItemInfo("interviewTime"));
                IInterviewPlan iInterviewPlan = null;
                IVideoInterviewRecord iVideoInterviewRecord = null;
                InterviewPlanCollection collection = null;
                try {
                    iInterviewPlan = InterviewPlanFactory.getLocalInstance(this.ctx);
                    iVideoInterviewRecord = VideoInterviewRecordFactory.getLocalInstance(this.ctx);
                    collection = iInterviewPlan.getInterviewPlanCollection(view);
                }
                catch (BOSException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)"get InterviewPlanCollection error", (Throwable)e);
                }
                if (collection != null && collection.size() > 0) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    InterviewPlanInfo interviewPlanInfo = collection.get(0);
                    VideoInterviewConfigInfo videoInterConfig = interviewPlanInfo.getVideoInterConfig();
                    boolean isGroupInterview = interviewPlanInfo.isGroupInterview();
                    if (isGroupInterview) {
                        if (videoInterConfig == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"VideoInterviewConfig is not initialize");
                            }
                            return;
                        }
                        String userId = videoInterConfig.getUserId();
                        boolean waitingRoom = videoInterConfig.isWaitingRoom();
                        String start_time = sdf.format(interviewPlanInfo.getInterviewTime());
                        StringBuilder topic = new StringBuilder();
                        topic.append(interviewPlanInfo.getInterview().getResumeBaseRec().getName()).append("\u7684\u89c6\u9891\u9762\u8bd5\u4f1a\u8bae");
                        JSONObject meeting = VideoInterviewService.getInstance().createMeeting(this.ctx, userId, topic.toString(), start_time, waitingRoom, videoInterviewType);
                        for (int i = 0; i < collection.size(); ++i) {
                            try {
                                interviewPlanInfo = collection.get(i);
                                this.doMeeting(iInterviewPlan, iVideoInterviewRecord, interviewPlanInfo, meeting, videoInterviewType);
                                continue;
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                logger.error((Object)"create videoMeeting error", (Throwable)e);
                            }
                        }
                    } else {
                        for (int i = 0; i < collection.size(); ++i) {
                            try {
                                interviewPlanInfo = collection.get(i);
                                videoInterConfig = interviewPlanInfo.getVideoInterConfig();
                                if (videoInterConfig == null) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)"VideoInterviewConfig is not initialize");
                                    }
                                    return;
                                }
                                String userId = videoInterConfig.getUserId();
                                boolean waitingRoom = videoInterConfig.isWaitingRoom();
                                String start_time = sdf.format(interviewPlanInfo.getInterviewTime());
                                StringBuilder topic = new StringBuilder();
                                topic.append(interviewPlanInfo.getInterview().getResumeBaseRec().getName()).append("\u7684\u89c6\u9891\u9762\u8bd5\u4f1a\u8bae");
                                JSONObject meeting = VideoInterviewService.getInstance().createMeeting(this.ctx, userId, topic.toString(), start_time, waitingRoom, videoInterviewType);
                                this.doMeeting(iInterviewPlan, iVideoInterviewRecord, interviewPlanInfo, meeting, videoInterviewType);
                                continue;
                            }
                            catch (Exception e) {
                                logger.error((Object)e.getMessage(), (Throwable)e);
                                logger.error((Object)"delete videoMeeting error", (Throwable)e);
                            }
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"create videoMeeting end");
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)"delete videoMeeting error", (Throwable)e);
            }
        }
    }

    private void doMeeting(IInterviewPlan iInterviewPlan, IVideoInterviewRecord iVideoInterviewRecord, InterviewPlanInfo interviewPlanInfo, JSONObject meeting, String videoInterviewType) throws BOSException, EASBizException {
        VideoInterviewRecordInfo videoInterRecord = interviewPlanInfo.getVideoInterRecord();
        String meetingId = meeting.getString("id");
        String host_id = meeting.getString("host_id");
        String start_url = meeting.getString("start_url");
        String join_url = meeting.getString("join_url");
        if (videoInterRecord != null) {
            String oldMeetingId = videoInterRecord.getMeetingId();
            String oldHostId = videoInterRecord.getMeetingHostId();
            String oldVideoInterviewType = videoInterRecord.getVideoType() != null ? videoInterRecord.getVideoType().getValue() : "";
            videoInterRecord.setMeetingId(meetingId);
            videoInterRecord.setMeetingHostId(host_id);
            videoInterRecord.setMeetingStartUrl(start_url);
            videoInterRecord.setMeetingJoinUrl(join_url);
            videoInterRecord.setVideoType(VideoInterviewType.getEnum(videoInterviewType));
            videoInterRecord.setInterviewplanId(interviewPlanInfo.getId().toString());
            iVideoInterviewRecord.update((IObjectPK)new ObjectUuidPK(videoInterRecord.getId()), videoInterRecord);
            VideoInterviewRecordCollection videoInterviewRecordCollection = iVideoInterviewRecord.getVideoInterviewRecordCollection("where meetingId = '" + oldMeetingId + "'");
            if (videoInterviewRecordCollection.size() == 0) {
                VideoInterviewService.getInstance().deleteMeeting(this.ctx, oldMeetingId, oldHostId, StringUtils.isEmpty((CharSequence)oldVideoInterviewType) ? videoInterviewType : oldVideoInterviewType);
            }
        } else {
            videoInterRecord = new VideoInterviewRecordInfo();
            videoInterRecord.setMeetingId(meetingId);
            videoInterRecord.setMeetingHostId(host_id);
            videoInterRecord.setMeetingStartUrl(start_url);
            videoInterRecord.setMeetingJoinUrl(join_url);
            videoInterRecord.setVideoType(VideoInterviewType.getEnum(videoInterviewType));
            videoInterRecord.setInterviewplanId(interviewPlanInfo.getId().toString());
            iVideoInterviewRecord.addnew(videoInterRecord);
            interviewPlanInfo.setVideoInterRecord(videoInterRecord);
            iInterviewPlan.update((IObjectPK)new ObjectUuidPK(interviewPlanInfo.getId()), interviewPlanInfo);
        }
    }

    private void deleteVideoMeeting(String videoInterviewType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete videoMeeting start");
        }
        if (this.interviewPlanIds != null && this.interviewPlanIds.length > 0) {
            HashSet<String> billIdSet = new HashSet<String>(Arrays.asList(this.interviewPlanIds));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("videoInterRecord.meetingId");
            selector.add("videoInterRecord.meetingHostId");
            selector.add("videoInterRecord.videoType");
            view.setSelector(selector);
            IInterviewPlan iInterviewPlan = null;
            IVideoInterviewRecord iVideoInterviewRecord = null;
            InterviewPlanCollection collection = null;
            try {
                iInterviewPlan = InterviewPlanFactory.getLocalInstance(this.ctx);
                iVideoInterviewRecord = VideoInterviewRecordFactory.getLocalInstance(this.ctx);
                collection = iInterviewPlan.getInterviewPlanCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.error((Object)"get InterviewPlanCollection error", (Throwable)e);
            }
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    try {
                        InterviewPlanInfo interviewPlanInfo = collection.get(i);
                        VideoInterviewRecordInfo videoInterRecord = interviewPlanInfo.getVideoInterRecord();
                        if (videoInterRecord == null) continue;
                        String meetingId = videoInterRecord.getMeetingId();
                        String oldVideoInterviewType = videoInterRecord.getVideoType() != null ? videoInterRecord.getVideoType().getValue() : "";
                        InterviewPlanCollection interviewPlanCollection = iInterviewPlan.getInterviewPlanCollection("where videoInterRecord.meetingId = '" + meetingId + "' and id <> '" + interviewPlanInfo.getId() + "'");
                        if (interviewPlanCollection.size() == 0) {
                            VideoInterviewService.getInstance().deleteMeeting(this.ctx, meetingId, videoInterRecord.getMeetingHostId(), StringUtils.isEmpty((CharSequence)oldVideoInterviewType) ? videoInterviewType : oldVideoInterviewType);
                        }
                        iVideoInterviewRecord.delete("where id = '" + videoInterRecord.getId() + "'");
                        interviewPlanInfo.setVideoInterRecord(null);
                        iInterviewPlan.update((IObjectPK)new ObjectUuidPK(interviewPlanInfo.getId()), interviewPlanInfo);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        logger.error((Object)"delete videoMeeting error", (Throwable)e);
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete videoMeeting end");
        }
    }
}

