/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.service.videoInterview;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.recuritment.RecSecretkeyCollection;
import com.kingdee.shr.recuritment.RecSecretkeyFactory;
import com.kingdee.shr.recuritment.RecSecretkeyInfo;
import com.kingdee.shr.recuritment.app.util.EvaluateHttpUtil;
import com.kingdee.shr.recuritment.utils.CloudServiceUtil;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class VideoInterviewService {
    private static Logger logger = Logger.getLogger(VideoInterviewService.class);
    private static VideoInterviewService videoInterviewService;

    public static synchronized VideoInterviewService getInstance() {
        if (videoInterviewService == null) {
            videoInterviewService = new VideoInterviewService();
        }
        return videoInterviewService;
    }

    public void addConfig(Context ctx, RecSecretkeyInfo recSecretkeyInfo) throws BOSException {
        String result;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setting video interview config");
        }
        CloudServiceConfigInfo recConfigInfo = this.getCloudServiceConfig(ctx);
        String serviceId = recConfigInfo.getServiceID();
        String serviceUrl = CloudServiceUtil.getServiceUrl(ctx, "60");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("serviceId", serviceId);
        JSONObject settingConfig = new JSONObject();
        settingConfig.put("accessToken", (Object)recSecretkeyInfo.getAppToken());
        settingConfig.put("appKey", (Object)recSecretkeyInfo.getAppKey());
        settingConfig.put("appSecret", (Object)recSecretkeyInfo.getAppSecret());
        settingConfig.put("appId", (Object)recSecretkeyInfo.getAppId());
        settingConfig.put("sdkId", (Object)recSecretkeyInfo.getSdkId());
        param.put("settingConfig", settingConfig.toJSONString());
        param.put("type", recSecretkeyInfo.getInterfaceType());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("url:" + serviceUrl));
            logger.debug((Object)("param:" + ((Object)param).toString()));
        }
        if (StringUtils.isEmpty((CharSequence)(result = EvaluateHttpUtil.post(ctx, serviceUrl, param)))) {
            throw new BOSException("\u89c6\u9891\u9762\u8bd5\u8bbe\u7f6e-\u914d\u7f6e\u4fe1\u606f\u65e0\u6548\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (jsonObject.getInteger("code") != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setting video interview error:" + jsonObject.getString("msg")));
            }
            throw new BOSException(jsonObject.getString("msg"));
        }
    }

    public JSONObject createMeeting(Context ctx, String userId, String topic, String start_time, boolean waiting_room, String videoInterviewType) throws BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"create meeting start");
        }
        CloudServiceConfigInfo recConfigInfo = this.getCloudServiceConfig(ctx);
        String serviceId = recConfigInfo.getServiceID();
        String serviceUrl = CloudServiceUtil.getServiceUrl(ctx, "62");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("serviceId", serviceId);
        RecSecretkeyCollection recSecretkeyCollection = RecSecretkeyFactory.getLocalInstance(ctx).getRecSecretkeyCollection("where interfaceType ='tencent'");
        if (recSecretkeyCollection.size() > 0 && null != recSecretkeyCollection.get(0).getUserId()) {
            param.put("userId", recSecretkeyCollection.get(0).getUserId());
        } else {
            param.put("userId", userId);
        }
        param.put("type", videoInterviewType);
        JSONObject meetingConfig = new JSONObject();
        meetingConfig.put("topic", (Object)topic);
        meetingConfig.put("start_time", (Object)start_time);
        meetingConfig.put("waiting_room", (Object)waiting_room);
        param.put("meetingConfig", meetingConfig.toJSONString());
        String result = EvaluateHttpUtil.post(ctx, serviceUrl, param);
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new BOSException("\u521b\u5efa\u89c6\u9891\u4f1a\u8bae\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (jsonObject.getInteger("code") != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("create meeting error\uff1a" + jsonObject.getString("msg")));
            }
            throw new BOSException(jsonObject.getString("msg"));
        }
        JSONObject meeting = jsonObject.getJSONObject("data");
        return meeting;
    }

    public void deleteMeeting(Context ctx, String meetingId, String userId, String videoInterviewType) throws BOSException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"delete meeting start");
        }
        CloudServiceConfigInfo recConfigInfo = this.getCloudServiceConfig(ctx);
        String serviceId = recConfigInfo.getServiceID();
        String serviceUrl = CloudServiceUtil.getServiceUrl(ctx, "63");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("serviceId", serviceId);
        param.put("meetingId", meetingId);
        param.put("userId", userId);
        param.put("type", videoInterviewType);
        String result = EvaluateHttpUtil.post(ctx, serviceUrl, param);
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new BOSException("\u5220\u9664\u89c6\u9891\u4f1a\u8bae\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        if (jsonObject.getInteger("code") != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("delete meeting error\uff1a" + jsonObject.getString("msg")));
            }
            throw new BOSException(jsonObject.getString("msg"));
        }
    }

    public String getVideoInterviewType(Context ctx) {
        try {
            RecSecretkeyCollection recSecretkeyCollection = RecSecretkeyFactory.getLocalInstance(ctx).getRecSecretkeyCollection("where interfaceType in ('zoom','tencent')");
            if (recSecretkeyCollection.size() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"VideoInterviewConfig is not initialize");
                }
                return null;
            }
            RecSecretkeyInfo recSecretkeyInfo = recSecretkeyCollection.get(0);
            return recSecretkeyInfo.getInterfaceType();
        }
        catch (BOSException e) {
            logger.error((Object)("get VideoInterviewConfig error:" + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public CloudServiceConfigInfo getCloudServiceConfig(Context ctx) throws BOSException {
        CloudServiceConfigInfo recConfigInfo = null;
        ICloudServiceConfig iConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
        CloudServiceConfigCollection recCollection = iConfig.getCloudServiceConfigCollection();
        if (recCollection.size() <= 0) {
            throw new BOSException("\u5c1a\u672a\u6ce8\u518c\u4e91\u670d\u52a1\uff01");
        }
        recConfigInfo = recCollection.get(0);
        return recConfigInfo;
    }
}

