/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.MD5Util;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IAttachmentManagerFacade;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtCollection;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.recuritment.app.bo.OfferAttachmentBean;
import com.kingdee.shr.recuritment.app.util.StreamReleaseUtil;
import com.kingdee.shr.recuritment.utils.RandomUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AttachmentUtil {
    private static Logger logger = Logger.getLogger(AttachmentUtil.class);
    public static final Map<String, String> TYPEMAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("image/jpeg", "jpg");
            this.put("image/png", "png");
            this.put("image/gif", "gif");
            this.put("image/x-icon", "ico");
            this.put("image/pnetvue", "net");
        }
    };

    public static AttachmentInfo getImageInfoByUrl(String url) {
        if (url.startsWith("https:")) {
            return AttachmentUtil.getImageInfoByHttpsUrl(url);
        }
        if (url.startsWith("http:")) {
            url = url.replaceFirst("http:", "https:");
            return AttachmentUtil.getImageInfoByHttpsUrl(url);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static AttachmentInfo getImageInfoByHttpsUrl(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AttachmentInfo getImageInfoByHttpUrl(String url) {
        AttachmentInfo ai = null;
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(url);
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
            if (statusCode != 200) {
                System.err.println("Method failed: " + getMethod.getStatusLine());
            }
            String contentType = getMethod.getResponseHeader("Content-Type").getElements()[0].getName();
            String type = TYPEMAP.get(contentType);
            byte[] responseBody = getMethod.getResponseBody();
            String fullname = url.substring(url.lastIndexOf("/") + 1, url.length()) + "." + type;
            String mainname = fullname.substring(0, fullname.indexOf("."));
            String extname = fullname.substring(fullname.indexOf(".") + 1, fullname.length());
            extname = extname.toLowerCase();
            byte[] content = responseBody;
            ai = new AttachmentInfo();
            ai.setName(mainname);
            ai.setSimpleName(extname);
            ai.setFile(content);
            ai.setIsShared(false);
            ai.setSharedDesc("\u5426");
            int size = responseBody.length;
            if (size < 1024) {
                ai.setSize(size + "\u5b57\u8282");
            } else {
                ai.setSize(size / 1024 + "KB");
            }
            ai.setSizeInByte(size);
            ai.setAttachID("" + System.currentTimeMillis());
            ai.setType(type);
        }
        catch (HttpException e) {
            logger.error((Object)"Please check your provided http address!");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            getMethod.releaseConnection();
        }
        return ai;
    }

    public static List<String> convertAttachToImageSrc(Context ctx, List<Map<String, String>> attachmentList) {
        ArrayList<String> attachImageSrc = new ArrayList<String>();
        try {
            if (attachmentList.size() > 0) {
                int size = attachmentList.size();
                for (int i = 0; i < size; ++i) {
                    Map<String, String> map = attachmentList.get(i);
                    String imageSrc = AttachmentUtil.downImage(ctx, map.get("attachId"), map.get("attachName"));
                    if (StringUtils.isEmpty((CharSequence)imageSrc)) continue;
                    attachImageSrc.add(imageSrc);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"get attachment error!");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return attachImageSrc;
    }

    public static List<Map<String, String>> convertAttachToFile(Context ctx, List<Map<String, String>> attachmentList) {
        try {
            if (attachmentList.size() > 0) {
                int size = attachmentList.size();
                for (int i = 0; i < size; ++i) {
                    Map<String, String> map = attachmentList.get(i);
                    String imageSrc = AttachmentUtil.downImage(ctx, map.get("attachId"), map.get("attachName"));
                    if (StringUtils.isEmpty((CharSequence)imageSrc)) continue;
                    map.put("fileUrl", imageSrc);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"get attachment error!");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return attachmentList;
    }

    public static List<OfferAttachmentBean> convertAttachToFileByBeans(Context ctx, List<OfferAttachmentBean> attachmentBeans) {
        try {
            if (attachmentBeans.size() > 0) {
                int size = attachmentBeans.size();
                for (int i = 0; i < size; ++i) {
                    OfferAttachmentBean attachmentBean = attachmentBeans.get(i);
                    String imageSrc = AttachmentUtil.downImage(ctx, attachmentBean.getAttachId(), attachmentBean.getMD5Name());
                    if (StringUtils.isEmpty((CharSequence)imageSrc)) continue;
                    attachmentBean.setFileUrl(imageSrc);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"get attachment error!");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return attachmentBeans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String downImage(Context ctx, String attachId, String fileName) {
        FileOutputStream out = null;
        String imageSrc = "";
        try {
            IAttachmentManagerFacade iAttachmentFtpFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            String fileDir = File.separator + AttachmentUtil.StringFilter(attachId) + File.separator;
            String realFileDir = SHRSyssettingUtil.getShrWebWarTmpPath() + fileDir;
            File filePath = new File(realFileDir);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            fileName = RandomUtil.getString(8);
            String realFileName = realFileDir + fileName;
            File file = new File(realFileName);
            imageSrc = "/tmp/" + AttachmentUtil.StringFilter(attachId) + "/" + fileName;
            if (file.exists()) {
                String string = imageSrc;
                return string;
            }
            byte[] content = iAttachmentFtpFacade.downLoad(attachId);
            if (content.length < 1) {
                content = iAttachmentFtpFacade.downLoad(attachId);
            }
            if (content.length < 1) {
                String string = "";
                return string;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            out = new FileOutputStream(file);
            byte[] flush = new byte[10240];
            int len = -1;
            while ((len = is.read(flush)) != -1) {
                ((OutputStream)out).write(flush, 0, len);
            }
            out.flush();
            if (out == null) return imageSrc;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return imageSrc;
        }
        finally {
            if (out != null) {
                StreamReleaseUtil.safeClose(out);
            }
        }
        StreamReleaseUtil.safeClose(out);
        return imageSrc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String uploadFile(Context ctx, byte[] content, String fileName) {
        FileOutputStream out = null;
        String imageSrc = "";
        try {
            String realFileDir = SHRSyssettingUtil.getShrWebWarTmpPath() + File.separator;
            File filePath = new File(realFileDir);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            fileName = AttachmentUtil.StringFilter(fileName);
            String realFileName = realFileDir + fileName;
            logger.info((Object)("realFileName:" + realFileName));
            File file = new File(realFileName);
            imageSrc = "/tmp/" + fileName;
            if (file.exists()) {
                String string = imageSrc;
                return string;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            out = new FileOutputStream(file);
            byte[] flush = new byte[10240];
            int len = -1;
            while ((len = is.read(flush)) != -1) {
                ((OutputStream)out).write(flush, 0, len);
            }
            out.flush();
            if (out == null) return imageSrc;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return imageSrc;
        }
        finally {
            if (out != null) {
                StreamReleaseUtil.safeClose(out);
            }
        }
        StreamReleaseUtil.safeClose(out);
        return imageSrc;
    }

    public static String StringFilter(String str) throws PatternSyntaxException {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\]<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        str = m.replaceAll("");
        str = str.replace(" ", "");
        return str.trim();
    }

    public static List<Map<String, String>> getAttachments(Context ctx, String boId) {
        ArrayList<Map<String, String>> attachs = new ArrayList<Map<String, String>>();
        try {
            HashMap<String, String> attach = null;
            String queryAttachmentSql = "select ATTACH.FID attachId,ATTACH.FNAME_l2 attachName,ATTACH.FSIMPLENAME attachType,ATTACH.FSIZEINBYTE fileSize from T_BAS_Attachment ATTACH where FID IN ( SELECT FATTACHMENTID FROM T_BAS_BoAttchAsso where FBOID = ? union all SELECT FATTACHMENT FROM T_HR_SHRATTACHMENTEXT where FBOID = ? )";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryAttachmentSql, (Object[])new Object[]{boId, boId});
            if (rs != null) {
                while (rs.next()) {
                    attach = new HashMap<String, String>();
                    attach.put("attachId", rs.getString("attachId"));
                    attach.put("attachName", rs.getString("attachName"));
                    attach.put("attachType", rs.getString("attachType"));
                    attach.put("fileSize", rs.getString("fileSize"));
                    attach.put("fileDownloadUrl", AttachmentUtil.downImage(ctx, (String)attach.get("attachId"), MD5Util.getMD5String((String)((String)attach.get("attachName")))));
                    attachs.add(attach);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return attachs;
    }

    public static void syncAttachments(Context ctx, String sourceBoID, String targetBoID) {
        try {
            ISHRAttachmentExt iSHRAttachmentExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            IAttachment iAttachment = AttachmentFactory.getLocalInstance((Context)ctx);
            SHRAttachmentExtCollection bosAssoCollection = iSHRAttachmentExt.getSHRAttachmentExtCollection(" where boID='" + targetBoID + "'");
            int bosAssoSize = bosAssoCollection.size();
            for (int j = 0; j < bosAssoSize; ++j) {
                SHRAttachmentExtInfo shrAttchExt = bosAssoCollection.get(j);
                String attachmentId = shrAttchExt.getAttachment().getId().toString();
                iAttachment.delete("where id='" + attachmentId + "'");
            }
            iSHRAttachmentExt.delete(" where boID='" + targetBoID + "'");
            SHRAttachmentExtCollection coll = iSHRAttachmentExt.getSHRAttachmentExtCollection(" where boID='" + sourceBoID + "'");
            int size = coll.size();
            IAttachment iAttach = AttachmentFactory.getLocalInstance((Context)ctx);
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    SHRAttachmentExtInfo shrAttchExt = coll.get(i);
                    AttachmentCollection atCollection = iAttach.getAttachmentCollection(" where id='" + shrAttchExt.getAttachment().getId().toString() + "'");
                    if (atCollection.size() <= 0) continue;
                    AttachmentInfo attachInfo = atCollection.get(0);
                    AttachmentInfo attachmentInfo = new AttachmentInfo();
                    attachmentInfo.setFile(attachInfo.getFile());
                    attachmentInfo.setName(attachInfo.getName());
                    attachmentInfo.setSimpleName(attachInfo.getSimpleName());
                    attachmentInfo.setSize(attachInfo.getSize());
                    attachmentInfo.setSizeInByte(attachInfo.getSizeInByte());
                    attachmentInfo.setAttachID("" + System.currentTimeMillis());
                    attachmentInfo.setStorageType(AttachmentStorageTypeEnum.DATABASE);
                    iAttachment.addnew(attachmentInfo);
                    SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
                    attchExt.setAttachment(attachmentInfo);
                    attchExt.setName(attachmentInfo.getName());
                    attchExt.setPropertyName("null0");
                    attchExt.setType(AttachmentTypeEnum.FORM);
                    attchExt.setState(AttachmentState.SAVE);
                    attchExt.setBoID(targetBoID);
                    SHRAttachmentExtFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)attchExt);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

