/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.bos.BOSException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static Logger logger = LoggerFactory.getLogger(DateUtil.class);
    public static final String DATE_YMD = "yyyy-MM-dd";
    public static final String DATE_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    private DateUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getCurTimeOfFirstDay() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_YMD);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        return sdf.format(calendar.getTime());
    }

    public static String getCurTimeOfLastDay() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_YMD);
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, calendar.getActualMaximum(5));
        return sdf.format(calendar.getTime());
    }

    public static String getDateStr(Timestamp timestamp) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_YMDHMS);
        return sdf.format(calendar.getTime());
    }

    public static String[] getDate(Date date) {
        String[] dateString = new String[3];
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_YMD);
        String str = sdf.format(date);
        String[] temp = str.split("-");
        dateString[0] = temp[0];
        dateString[1] = temp[1];
        dateString[2] = temp[2];
        return dateString;
    }

    public static String getTime() {
        Date date = new Date();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, 2);
        date = calendar.getTime();
        SimpleDateFormat df = new SimpleDateFormat(DATE_YMDHMS);
        return df.format(date);
    }

    public static Timestamp getDateTimeStamp(String date) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        String[] split = date.split("-");
        calendar.set(1, Integer.parseInt(split[0]));
        calendar.set(2, Integer.parseInt(split[1]) - 1);
        calendar.set(5, Integer.parseInt(split[2]));
        return new Timestamp(calendar.getTime().getTime());
    }

    public static Timestamp strToTimeStamp(String dateStr) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_YMDHMS);
            Date date = sdf.parse(dateStr);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Date getEndDate(String dataType, String endDate) throws BOSException {
        Date endDateTime = DateUtil.getSqlDate(endDate, DATE_YMD);
        if ("Date".equals(dataType)) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDateTime);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            endDateTime = calendar.getTime();
        }
        return endDateTime;
    }

    public static Date getSqlDate(String dateString, String parten) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        Date date = null;
        try {
            date = new Date(sdf.parse(dateString).getTime());
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }
}

