/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.shr.recuritment.app.util.StreamReleaseUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public final class FileToZip {
    private static Logger logger = Logger.getLogger(FileToZip.class);

    private FileToZip() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean fileToZip(String sourceFilePath, String zipFilePath, String fileName) {
        ZipOutputStream zos;
        FileOutputStream fos;
        BufferedInputStream bis;
        FileInputStream fis;
        boolean flag;
        block11: {
            flag = false;
            File sourceFile = new File(sourceFilePath);
            if (!sourceFile.exists()) {
                logger.info((Object)("\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff1a" + sourceFilePath + "\u4e0d\u5b58\u5728."));
                return flag;
            }
            fis = null;
            bis = null;
            fos = null;
            zos = null;
            try {
                File zipFile = new File(zipFilePath + File.separator + fileName + ".zip");
                if (zipFile.exists()) {
                    logger.info((Object)(zipFilePath + "\u76ee\u5f55\u4e0b\u5b58\u5728\u540d\u5b57\u4e3a:" + fileName + ".zip\u6253\u5305\u6587\u4ef6."));
                    break block11;
                }
                File[] sourceFiles = sourceFile.listFiles();
                if (null == sourceFiles || sourceFiles.length < 1) {
                    logger.info((Object)("\u5f85\u538b\u7f29\u7684\u6587\u4ef6\u76ee\u5f55\uff1a" + sourceFilePath + "\u91cc\u9762\u4e0d\u5b58\u5728\u6587\u4ef6\uff0c\u65e0\u9700\u538b\u7f29."));
                } else {
                    fos = new FileOutputStream(zipFile);
                    zos = new ZipOutputStream((OutputStream)new BufferedOutputStream(fos));
                    zos.setEncoding("gbk");
                    byte[] bufs = new byte[10240];
                    for (int i = 0; i < sourceFiles.length; ++i) {
                        ZipEntry zipEntry = new ZipEntry(sourceFiles[i].getName());
                        logger.info((Object)sourceFiles[i].getName());
                        zos.putNextEntry(zipEntry);
                        fis = new FileInputStream(sourceFiles[i]);
                        bis = new BufferedInputStream(fis, 10240);
                        int read = 0;
                        while ((read = bis.read(bufs, 0, 10240)) != -1) {
                            zos.write(bufs, 0, read);
                        }
                        bis.close();
                        fis.close();
                    }
                    flag = true;
                }
            }
            catch (FileNotFoundException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                    catch (IOException e2) {
                        logger.error((Object)e2.getMessage(), (Throwable)e2);
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    StreamReleaseUtil.safeClose(bis);
                    StreamReleaseUtil.safeClose(zos);
                    StreamReleaseUtil.safeClose(fis);
                    StreamReleaseUtil.safeClose(fos);
                    throw throwable;
                }
            }
        }
        StreamReleaseUtil.safeClose(bis);
        StreamReleaseUtil.safeClose(zos);
        StreamReleaseUtil.safeClose(fis);
        StreamReleaseUtil.safeClose(fos);
        return flag;
    }
}

