/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.bos.util.backport.Collections;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.recuritment.app.util.EncodingDetect;
import com.kingdee.shr.recuritment.app.util.StreamReleaseUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FileUtil {
    private static Logger logger = Logger.getLogger(FileUtil.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_DEPLOY_PATH = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "shr_web.war" + File.separator;
    public static final String RESUME_FILE_PATH = DEFAULT_DEPLOY_PATH + "tmp" + File.separator + "resumes" + File.separator;
    public static final String ARCHIVE_FILE_PATH = DEFAULT_DEPLOY_PATH + "tmp" + File.separator + "archives" + File.separator;
    public static final String OFFER_FILE_PATH = DEFAULT_DEPLOY_PATH + "tmp" + File.separator + "offer" + File.separator;
    public static final String EVALUATE_FILE_PATH = DEFAULT_DEPLOY_PATH + "tmp" + File.separator + "evaluate" + File.separator;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]+");

    public static String convertFileToBase64Str(String filePath) throws IOException {
        File file = new File(filePath);
        return FileUtil.convertFileToBase64Str(file);
    }

    public static String convertFileToBase64Str(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is null...");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("file is not exists...");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("this is not a file...");
        }
        byte[] bty = FileUtil.getBytesFromFile(file);
        return new BASE64Encoder().encode(bty);
    }

    public static String convertFileToBase64Str(byte[] file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is null...");
        }
        return new BASE64Encoder().encode(file);
    }

    public static String getContent(String file_name, String charset) {
        File file = new File(file_name);
        return FileUtil.getContent(file, charset);
    }

    public static String getContent(String file_name) {
        File file = new File(file_name);
        return FileUtil.getContent(file);
    }

    public static String getContent(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        String charset = FileUtil.getFileCharset(file);
        return FileUtil.getContent(file, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getContent(File file, String charset) {
        String content = null;
        if (file.isFile() && file.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                content = FileUtil.getContent(fileInputStream, charset);
                fileInputStream.close();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                StreamReleaseUtil.safeClose(fileInputStream);
            }
            catch (IOException e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        StreamReleaseUtil.safeClose(fileInputStream);
                        throw throwable;
                    }
                }
                StreamReleaseUtil.safeClose(fileInputStream);
            }
            StreamReleaseUtil.safeClose(fileInputStream);
        }
        return content;
    }

    public static String getContent(byte[] file) {
        String content = null;
        if (file != null) {
            content = FileUtil.getContent(new ByteArrayInputStream(file), FileUtil.getFileCharset(file));
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getContent(InputStream in, String charset) {
        StringBuilder resume = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, charset));
            String lineTXT = null;
            while ((lineTXT = reader.readLine()) != null) {
                resume.append(lineTXT.toString().trim());
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return resume.toString();
    }

    public static byte[] getBytesFromFile(String filePath) throws IOException {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new IllegalArgumentException("filePath is empty...");
        }
        File file = new File(filePath);
        return FileUtil.getBytesFromFile(file);
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is null...");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("file is not found...");
        }
        byte[] data = null;
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new FileInputStream(file);
            out = new ByteArrayOutputStream(4096);
            byte[] b = new byte[4096];
            int n = -1;
            while ((n = in.read(b)) != -1) {
                out.write(b, 0, n);
            }
            data = out.toByteArray();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return data;
    }

    public static String getFileCode(String fileName) {
        File file = new File(fileName);
        return FileUtil.getFileCharset(file);
    }

    public static String getFileCharset(byte[] file) {
        if (file == null) {
            throw new NullPointerException("file is null");
        }
        return EncodingDetect.getJavaEncode(file);
    }

    private static String getFileCharset(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return null;
        }
        return EncodingDetect.getJavaEncode(file);
    }

    public static List<File> getFiles(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        if (!file.isDirectory()) {
            fileList.add(file);
        } else {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.isDirectory()) continue;
                fileList.add(f);
            }
        }
        return fileList;
    }

    public static List<String> getDirAllFillNames(String path) {
        File rootDir = new File(path);
        return FileUtil.getDirAllFillNames(rootDir);
    }

    public static List<String> getDirAllFillNames(File file) {
        ArrayList<String> fileNames = new ArrayList<String>();
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    if (f.isDirectory()) {
                        fileNames.addAll(FileUtil.getDirAllFillNames(file));
                        continue;
                    }
                    fileNames.add(f.getName());
                }
            } else {
                fileNames.add(file.getName());
            }
        }
        return fileNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContentToFile(String filePath, String content) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        try (BufferedWriter output = null;){
            output = new BufferedWriter(new FileWriter(file));
            output.write(content);
        }
    }

    public static void writeStreamToFile(InputStream input, String filePath) throws IOException {
        if (input == null || StringUtils.isEmpty((CharSequence)filePath)) {
            return;
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(new File(filePath));
            byte[] buf = new byte[10240];
            int len = -1;
            while ((len = input.read(buf, 0, 8192)) != -1) {
                output.write(buf, 0, len);
            }
            output.flush();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static byte[] getFileBytes(String filePath) throws IOException {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new NullPointerException("filePath can not null...");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        return FileUtil.getFileBytes(file);
    }

    public static byte[] getFileBytes(File file) throws IOException {
        byte[] buffer = null;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            int n = -1;
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            buffer = bos.toByteArray();
            bos.flush();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return buffer;
    }

    public static String rechristenFileName(String fileName, String fileDirPath) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException("fileName can not null\uff1a" + fileName);
        }
        if (StringUtils.isEmpty((CharSequence)fileDirPath)) {
            return fileName;
        }
        File dir = new File(fileDirPath);
        if (!dir.exists() || !dir.isDirectory()) {
            return fileName;
        }
        String prefixName = FileUtil.getFilePrefixName(fileName);
        if (prefixName == null) {
            prefixName = "";
        }
        String preName = FileUtil.getFileNameNotWithNumber(prefixName);
        String fileExt = FileUtil.getExtension(fileName);
        if (fileExt == null) {
            fileExt = "";
        }
        File[] files = dir.listFiles();
        boolean existsFileName = false;
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            String pn;
            String ext;
            if (file.isDirectory()) continue;
            String name = FileUtil.decodeFileFullName(file.getName());
            String prefix = FileUtil.getFilePrefixName(name);
            if (prefix == null) {
                prefix = "";
            }
            if ((ext = FileUtil.getExtension(name)) == null) {
                ext = "";
            }
            if (!fileExt.equalsIgnoreCase(ext)) continue;
            if (prefixName.equalsIgnoreCase(prefix)) {
                existsFileName = true;
            }
            if (!preName.equalsIgnoreCase(pn = FileUtil.getFileNameNotWithNumber(prefix))) continue;
            fileNames.add(prefix);
        }
        if (existsFileName) {
            Collections.sort(fileNames, (Comparator)new Comparator<String>(){

                @Override
                public int compare(String name1, String name2) {
                    String number1 = FileUtil.getFileNameNumber(name1);
                    String number2 = FileUtil.getFileNameNumber(name2);
                    if (StringUtils.isEmpty((CharSequence)number1)) {
                        return -1;
                    }
                    if (StringUtils.isEmpty((CharSequence)number2)) {
                        return 1;
                    }
                    int n1 = Integer.parseInt(number1);
                    int n2 = Integer.parseInt(number2);
                    return n1 - n2;
                }
            });
            String maxFile = (String)fileNames.get(fileNames.size() - 1);
            String maxNumber = FileUtil.getFileNameNumber(maxFile);
            if (StringUtils.isEmpty((CharSequence)maxNumber)) {
                maxNumber = "0";
            }
            return preName + "(" + (Integer.parseInt(maxNumber) + 1) + ")." + fileExt;
        }
        return fileName;
    }

    private static String getFileNameNumber(String prefixName) {
        int preIndex = prefixName.lastIndexOf("(");
        int surIndex = prefixName.lastIndexOf(")");
        return FileUtil.getFileNameNumber(prefixName, preIndex, surIndex);
    }

    private static String getFileNameNumber(String prefixName, int preIndex, int surIndex) {
        String number;
        if (preIndex != -1 && surIndex != -1 && preIndex < surIndex - 1 && !StringUtils.isEmpty((CharSequence)(number = prefixName.substring(preIndex + 1, surIndex))) && number.matches("^\\d+$")) {
            return number;
        }
        return null;
    }

    private static String getFileNameNotWithNumber(String prefixName) {
        int surIndex;
        int preIndex = prefixName.lastIndexOf("(");
        String number = FileUtil.getFileNameNumber(prefixName, preIndex, surIndex = prefixName.lastIndexOf(")"));
        if (!StringUtils.isEmpty((CharSequence)number)) {
            return prefixName.substring(0, preIndex);
        }
        return prefixName;
    }

    private static String getFilePrefixName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            throw new IllegalArgumentException("fileName can not null\uff1a" + fileName);
        }
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            return fileName.substring(0, index);
        }
        return null;
    }

    public static String getExtension(String filename) {
        int i;
        String ext = null;
        if (!StringUtils.isEmpty((CharSequence)filename) && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            ext = filename.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String encodeFileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        BASE64Encoder encoder = new BASE64Encoder();
        String str = null;
        try {
            String encoderStr = encoder.encode(fileName.getBytes());
            str = URLEncoder.encode(encoderStr, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return str;
    }

    public static String encodeFileFullName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        String prefix = FileUtil.getFilePrefixName(fileName);
        String suffix = FileUtil.getExtension(fileName);
        return FileUtil.encodeFileName(prefix) + "." + suffix;
    }

    public static String decodeFileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        String str = null;
        try {
            String urlDecoderStr = URLDecoder.decode(fileName, DEFAULT_CHARSET);
            str = new String(decoder.decodeBuffer(urlDecoderStr), DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            str = fileName;
        }
        return str;
    }

    public static String decodeFileFullName(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return null;
        }
        String prefix = FileUtil.getFilePrefixName(fileName);
        String suffix = FileUtil.getExtension(fileName);
        return FileUtil.decodeFileName(prefix) + "." + suffix;
    }

    public static void delFile(String filePath) {
        File file = new File(filePath);
        FileUtil.delFile(file);
    }

    public static void delFile(File file) {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                FileUtil.deleteDir(file);
            } else {
                file.delete();
            }
        }
    }

    public static void delDir(String dirPath) {
        File dir = new File(dirPath);
        FileUtil.deleteDir(dir);
    }

    public static void deleteDir(File dir) {
        if (dir == null || !dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            File[] files;
            for (File f : files = dir.listFiles()) {
                FileUtil.deleteDir(f);
            }
        }
        dir.delete();
    }

    public static int getNumByString(String fileName) {
        int num = 0;
        Pattern p = NUMBER_PATTERN;
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            int pIndex = fileName.lastIndexOf(".");
            String name = fileName.substring(0, pIndex);
            for (int i = 0; i < name.length(); ++i) {
                char tempChar = name.charAt(i);
                if (p.matcher(String.valueOf(tempChar)).find()) {
                    num += 2;
                    continue;
                }
                ++num;
            }
        }
        return num;
    }

    public static byte[] getFileFromBase64(String base64_string) {
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] bytes = decoder.decodeBuffer(base64_string);
            return bytes;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static {
        File resumeDir = new File(SHRCheck.checkFilePath((String)RESUME_FILE_PATH));
        if (!resumeDir.exists()) {
            resumeDir.mkdirs();
        }
        if (!(resumeDir = new File(SHRCheck.checkFilePath((String)ARCHIVE_FILE_PATH))).exists()) {
            resumeDir.mkdirs();
        }
        if (!(resumeDir = new File(SHRCheck.checkFilePath((String)EVALUATE_FILE_PATH))).exists()) {
            resumeDir.mkdirs();
        }
    }
}

