/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.shr.recuritment.app.util.QRCodeUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;

public class GraphicsUtils {
    private static final Logger logger = Logger.getLogger((String)QRCodeUtil.class.getName());
    public static final String IMAGE_SUFFIX = "png";

    public static BufferedImage drawPoster(byte[] qrCodeImage, byte[] headImage, byte[] posterImage, String nameText, String posterText) throws Exception {
        BufferedImage bgBufImage = new BufferedImage(620, 1000, 1);
        GraphicsUtils.setBackGroup(bgBufImage, "#FFFFFF");
        if (posterImage != null && posterImage.length > 0) {
            GraphicsUtils.drawImage(bgBufImage, posterImage, 0, 0, 620, 826);
        }
        if (qrCodeImage != null && qrCodeImage.length > 0) {
            GraphicsUtils.drawImage(bgBufImage, qrCodeImage, 420, 848, 140, 140);
        }
        if (headImage != null && headImage.length > 0) {
            GraphicsUtils.drawImage(bgBufImage, GraphicsUtils.getRoundImage(headImage, -1, -1), 32, 910, 80, 80);
            Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 24);
            GraphicsUtils.drawText(bgBufImage, nameText, 120, 955, "#000000", font, 1.2);
        }
        Font font_01 = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18);
        GraphicsUtils.drawTextNewLine(bgBufImage, posterText, 200, 860, 30, 200, "#000000", font_01, 2, 400, 1.2);
        return bgBufImage;
    }

    public static Color fromStrToARGB(String str) {
        String str1 = str.substring(1, 3);
        String str2 = str.substring(3, 5);
        String str3 = str.substring(5, 7);
        int red = Integer.parseInt(str1, 16);
        int green = Integer.parseInt(str2, 16);
        int blue = Integer.parseInt(str3, 16);
        if (str.length() == 9) {
            String str4 = str.substring(7, 9);
            int alpha = Integer.parseInt(str4, 16);
            return new Color(red, green, blue, alpha);
        }
        return new Color(red, green, blue);
    }

    public static Graphics2D createG2D(BufferedImage bgBufImage) {
        Graphics2D bgBufImageGraphics = bgBufImage.createGraphics();
        bgBufImageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        bgBufImageGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return bgBufImageGraphics;
    }

    public static void setBackGroup(BufferedImage bgBufImage, String color) {
        Graphics2D bgBufImageGraphics = GraphicsUtils.createG2D(bgBufImage);
        bgBufImageGraphics.setBackground(GraphicsUtils.fromStrToARGB(color));
        bgBufImageGraphics.clearRect(0, 0, bgBufImage.getWidth(), bgBufImage.getHeight());
        bgBufImageGraphics.dispose();
    }

    public static void drawText(BufferedImage basebBI, String text, int x, int y, String color, Font font, double rate) {
        if (font == null) {
            font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 32);
        }
        Graphics2D g2D = GraphicsUtils.createG2D(basebBI);
        g2D.setFont(font);
        g2D.setPaint(new Color(0, 0, 0, 64));
        GraphicsUtils.MyDrawString(text, x, y, rate, g2D);
        g2D.setPaint(GraphicsUtils.fromStrToARGB(color));
        GraphicsUtils.MyDrawString(text, x, y, rate, g2D);
        g2D.dispose();
    }

    public static void MyDrawString(String str, int x, int y, double rate, Graphics2D g) {
        String tempStr = new String();
        int tempx = x;
        int tempy = y;
        while (str.length() > 0) {
            tempStr = str.substring(0, 1);
            str = str.substring(1, str.length());
            g.drawString(tempStr, tempx, tempy);
            double tempWight = (double)g.getFontMetrics().stringWidth(tempStr) * rate;
            tempx = (int)((double)tempx + tempWight);
        }
    }

    public static void drawTextNewLine(BufferedImage basebBI, String text, int x, int y, int lineHeight, int lineWidth, String color, Font font, int limitLineNum, int backgroundWidth, double rate) {
        double width;
        Graphics2D graphics = GraphicsUtils.createG2D(basebBI);
        if (font == null) {
            font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 32);
        }
        graphics.setFont(font);
        graphics.setPaint(GraphicsUtils.fromStrToARGB(color));
        FontRenderContext frc = graphics.getFontRenderContext();
        ArrayList<String> lineList = new ArrayList<String>();
        int textWidth = (int)font.getStringBounds(text, frc).getWidth();
        if (textWidth > lineWidth) {
            textWidth = lineWidth;
        }
        if (backgroundWidth > 0) {
            x = (backgroundWidth + lineWidth - textWidth) / 2;
        }
        int stringIndex = 0;
        StringBuilder tmpLineString = new StringBuilder("");
        while (stringIndex < text.length()) {
            String tmp_char = text.substring(stringIndex, stringIndex + 1);
            Rectangle2D tempStringBounds = font.getStringBounds(tmpLineString + tmp_char, frc);
            width = tempStringBounds.getWidth();
            if (width > (double)lineWidth) {
                lineList.add(tmpLineString.toString());
                tmpLineString = new StringBuilder("");
            }
            tmpLineString = tmpLineString.append(tmp_char);
            if (++stringIndex != text.length()) continue;
            lineList.add(tmpLineString.toString());
        }
        graphics.setPaint(GraphicsUtils.fromStrToARGB(color));
        if (lineHeight == 0) {
            lineHeight = 35;
        }
        for (int i = 0; i < lineList.size(); ++i) {
            String lineStr = (String)lineList.get(i);
            width = font.getStringBounds(lineStr, frc).getWidth();
            double diffWidth = font.getStringBounds("...", frc).getWidth();
            if (i > limitLineNum - 1) break;
            if (i == limitLineNum - 1 && (double)lineWidth - width < diffWidth) {
                lineStr = lineStr.substring(0, lineStr.length() - 2) + "...";
            }
            graphics.drawString(lineStr, x, y + (i + 1) * lineHeight);
        }
        graphics.dispose();
    }

    public static void drawImage(BufferedImage basebBI, String path, int x, int y, int width, int height) throws Exception {
        BufferedImage qrCodeImage = ImageIO.read(new File(path));
        GraphicsUtils.drawImage(basebBI, qrCodeImage, x, y, width, height);
    }

    public static void drawImage(BufferedImage basebBI, byte[] file, int x, int y, int width, int height) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(file);
        BufferedImage qrCodeImage = ImageIO.read(in);
        GraphicsUtils.drawImage(basebBI, qrCodeImage, x, y, width, height);
    }

    public static void drawImage(BufferedImage basebBI, BufferedImage imageBI, int x, int y, int width, int height) {
        Graphics2D g2D = GraphicsUtils.createG2D(basebBI);
        if (width == -1) {
            width = imageBI.getWidth();
        }
        if (height == -1) {
            height = imageBI.getHeight();
        }
        g2D.drawImage(imageBI.getScaledInstance(width, height, 4), x, y, null);
        g2D.dispose();
    }

    public static BufferedImage getRoundImage(byte[] file, int ratioWith, int ratioHeith) throws Exception {
        BufferedImage qrCodeImage = ImageIO.read(new ByteArrayInputStream(file));
        BufferedImage image = new BufferedImage(qrCodeImage.getWidth(), qrCodeImage.getHeight(), 2);
        Graphics2D image2D = GraphicsUtils.createG2D(image);
        if (ratioWith <= -1) {
            ratioWith = qrCodeImage.getWidth();
        }
        if (ratioHeith <= -1) {
            ratioHeith = qrCodeImage.getHeight();
        }
        image2D.fillRoundRect(0, 0, qrCodeImage.getWidth(), qrCodeImage.getHeight(), ratioWith, ratioHeith);
        image2D.setComposite(AlphaComposite.SrcIn);
        image2D.drawImage(qrCodeImage, 0, 0, qrCodeImage.getWidth(), qrCodeImage.getHeight(), null);
        image2D.dispose();
        return image;
    }

    public static BufferedImage getRoundImage(String path, int ratioWith, int ratioHeith) throws Exception {
        BufferedImage qrCodeImage = ImageIO.read(new File(path));
        BufferedImage image = new BufferedImage(qrCodeImage.getWidth(), qrCodeImage.getHeight(), 2);
        Graphics2D image2D = GraphicsUtils.createG2D(image);
        if (ratioWith <= -1) {
            ratioWith = qrCodeImage.getWidth();
        }
        if (ratioHeith <= -1) {
            ratioHeith = qrCodeImage.getHeight();
        }
        image2D.fillRoundRect(0, 0, qrCodeImage.getWidth(), qrCodeImage.getHeight(), ratioWith, ratioHeith);
        image2D.setComposite(AlphaComposite.SrcIn);
        image2D.drawImage(qrCodeImage, 0, 0, qrCodeImage.getWidth(), qrCodeImage.getHeight(), null);
        image2D.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImage(BufferedImage bgBufImage, String path) throws Exception {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        ImageOutputStream imgOut = ImageIO.createImageOutputStream(bs);
        ImageIO.write((RenderedImage)bgBufImage, IMAGE_SUFFIX, imgOut);
        ByteArrayInputStream is = new ByteArrayInputStream(bs.toByteArray());
        FileOutputStream out = new FileOutputStream(path);
        try {
            byte[] flush = new byte[10240];
            int len = -1;
            while ((len = is.read(flush)) != -1) {
                out.write(flush, 0, len);
            }
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (is != null) {
                ((InputStream)is).close();
            }
        }
    }
}

