/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.recuritment.app.util.ssl.MySecureProtocolSocketFactory;
import com.kingdee.shr.recuritment.utils.CloudServiceUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class HttpUtil {
    private static final Logger logger = Logger.getLogger(HttpUtil.class);
    public static final String DEFAULT_CHARSET = "utf-8";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_SO_TIMEOUT = 30000;

    private static HttpClient createHttpClient() {
        HttpClient httpClient = HttpUtil.createHttpClient(10000, 30000);
        return httpClient;
    }

    private static HttpClient createHttpClient(int connectionTimeout, int soTimeout) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(soTimeout);
        return httpClient;
    }

    public static String get(Context ctx, String url) {
        return HttpUtil.get(ctx, url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(Context ctx, String url, String queryString) {
        HttpClient client = HttpUtil.createHttpClient();
        String result = null;
        GetMethod method = new GetMethod(url);
        try {
            if (!StringUtils.isEmpty((CharSequence)queryString)) {
                method.setQueryString(URIUtil.encodeQuery((String)queryString));
            }
            HttpUtil.setSafeHeader(ctx, method);
            result = HttpUtil.executeMethod(client, (HttpMethod)method);
        }
        catch (URIException e) {
            logger.error((Object)("\u6267\u884cHTTP Get\u8bf7\u6c42\u65f6\uff0c\u8bbe\u7f6e\u67e5\u8be2\u5b57\u7b26\u4e32   " + queryString + " \u5f02\u5e38\uff01"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("\u6267\u884cHTTP Get\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    public static void setSafeHeader(Context ctx, PostMethod method) {
        try {
            CloudServiceConfigInfo info = CloudServiceUtil.getCloudServiceConfig(ctx);
            if (info != null) {
                method.addRequestHeader("SHR_SAFE_VERSION", "V1");
                method.addRequestHeader("SHR_SAFE_TOKEN", info.getAccessToken());
                method.addRequestHeader("SHR_APPID", info.getServiceID());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"setSafeHeader");
                }
                for (Header header : method.getRequestHeaders()) {
                    logger.error((Object)header);
                }
                logger.error((Object)"httpUtil\u5df2\u7ecf\u8bbe\u7f6eheader");
            } else if (logger.isDebugEnabled()) {
                logger.error((Object)"\u83b7\u53d6\u4e91\u670d\u52a1\u6ce8\u518c\u4fe1\u606f\u5931\u8d25,\u65e0\u6cd5\u8bbe\u7f6eHTTP\u8bf7\u6c42\u5b89\u5168\u5934");
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u8bf7\u6c42\u4e91\u670d\u52a1\u65f6\uff0c\u83b7\u53d6shr\u7684\u4e91\u670d\u52a1\u6ce8\u518ctoken\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public static void setSafeHeader(Context ctx, GetMethod method) {
        try {
            CloudServiceConfigInfo info = CloudServiceUtil.getCloudServiceConfig(ctx);
            if (info != null) {
                method.addRequestHeader("SHR_SAFE_VERSION", "V1");
                method.addRequestHeader("SHR_SAFE_TOKEN", info.getAccessToken());
                method.addRequestHeader("SHR_APPID", info.getServiceID());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"setSafeHeader");
                }
                for (Header header : method.getRequestHeaders()) {
                    logger.error((Object)header);
                }
                logger.error((Object)"httpUtil\u5df2\u7ecf\u8bbe\u7f6eheader");
            } else if (logger.isDebugEnabled()) {
                logger.error((Object)"\u83b7\u53d6\u4e91\u670d\u52a1\u6ce8\u518c\u4fe1\u606f\u5931\u8d25,\u65e0\u6cd5\u8bbe\u7f6eHTTP\u8bf7\u6c42\u5b89\u5168\u5934");
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u8bf7\u6c42\u4e91\u670d\u52a1\u65f6\uff0c\u83b7\u53d6shr\u7684\u4e91\u670d\u52a1\u6ce8\u518ctoken\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tspget(Context ctx, String url, String queryString, String sessionId) {
        HttpClient client = HttpUtil.createHttpClient();
        String result = null;
        GetMethod method = new GetMethod(url);
        try {
            if (!StringUtils.isEmpty((CharSequence)queryString)) {
                method.setQueryString(URIUtil.encodeQuery((String)queryString));
            }
            if (!StringUtils.isEmpty((CharSequence)sessionId)) {
                method.setRequestHeader("Cookie", sessionId);
            }
            result = HttpUtil.executeMethod(client, (HttpMethod)method);
        }
        catch (URIException e) {
            logger.error((Object)("\u6267\u884cHTTP Get\u8bf7\u6c42\u65f6\uff0c\u8bbe\u7f6e\u67e5\u8be2\u5b57\u7b26\u4e32   " + queryString + " \u5f02\u5e38\uff01"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("\u6267\u884cHTTP Get\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    public static String post(Context ctx, String url, Map<String, String> param) {
        return HttpUtil.post(ctx, url, param, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(Context ctx, String url, Map<String, String> param, String charset) {
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        HttpClient client = HttpUtil.createHttpClient();
        client.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        PostMethod postMethod = new PostMethod(url);
        if (param != null && param.size() > 0) {
            NameValuePair[] datas = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                datas[index++] = new NameValuePair(key, param.get(key));
            }
            postMethod.setRequestBody(datas);
        }
        HttpUtil.setSafeHeader(ctx, postMethod);
        String result = null;
        try {
            result = HttpUtil.executeMethod(client, (HttpMethod)postMethod);
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tspPost(Context ctx, String url, Map<String, String> param, String charset, String sessionId) {
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        logger.info((Object)("post\u6253\u5370\u51fa\u7684ctx\u5167\u5bb9=" + ctx.toString()));
        HttpClient client = HttpUtil.createHttpClient();
        client.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        PostMethod postMethod = new PostMethod(url);
        if (param != null && param.size() > 0) {
            NameValuePair[] datas = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                datas[index++] = new NameValuePair(key, param.get(key));
            }
            postMethod.setRequestBody(datas);
        }
        if (!StringUtils.isEmpty((CharSequence)sessionId)) {
            postMethod.setRequestHeader("Cookie", sessionId);
        }
        String result = null;
        try {
            result = HttpUtil.executeMethod(client, (HttpMethod)postMethod);
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    private static String executeMethod(HttpClient client, HttpMethod method) throws IOException {
        String result = null;
        try {
            MySecureProtocolSocketFactory fcty = new MySecureProtocolSocketFactory();
            Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)fcty, 443));
            int statusCode = client.executeMethod(method);
            if (statusCode == 200) {
                result = method.getResponseBodyAsString();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u8bf7\u6c42\u672a\u6210\u529f\uff0cresponse status:" + statusCode));
                }
                if (statusCode == 302) {
                    Header redirectHeader = method.getResponseHeader("location");
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("\u8bf7\u6c42\u88ab\u91cd\u5b9a\u5411\u5730\u5740:" + redirectHeader.getValue()));
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u8bf7\u6c42\u672a\u6210\u529f\uff0cresponse body content:" + method.getResponseBodyAsString()));
                }
            }
        }
        catch (HttpException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String evaluatepost(String url, Map<String, String> param, String charset) throws UnsupportedEncodingException {
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u8bf7\u6c42\u53d1\u9001\uff0c\u8bf7\u6c42\u53c2\u6570:" + param.get("uuid")));
            logger.debug((Object)("\u8bf7\u6c42\u53d1\u9001\uff0c\u8bf7\u6c42url:" + url));
        }
        Gson gson = new Gson();
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        PostMethod postMethod = new PostMethod(url);
        StringRequestEntity requestEntity = new StringRequestEntity(gson.toJson(param), "application/json", "UTF-8");
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        postMethod.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
        String result = null;
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                result = postMethod.getResponseBodyAsString();
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("HttpClient\uff1ahttp response status is:" + statusCode));
                logger.debug((Object)("HttpClient\uff1acontent:" + postMethod.getResponseBodyAsString()));
            }
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    public static String sendTspLoginPost(String url, Map<String, Object> param) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
        httpClient.getParams().setContentCharset(DEFAULT_CHARSET);
        PostMethod postMethod = new PostMethod(url);
        postMethod.getParams().setSoTimeout(30000);
        postMethod.getParams().setParameter("Content-Type", (Object)"application/json;charset=UTF-8");
        if (param != null && param.size() > 0) {
            NameValuePair[] responseBody = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                responseBody[index] = new NameValuePair(key, param.get(key).toString());
                ++index;
            }
            postMethod.setRequestBody(responseBody);
        }
        String sessionId = "";
        InputStream inputStream = null;
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                Header sessionid = postMethod.getResponseHeader("Set-Cookie");
                String str = sessionid.getValue();
                sessionId = str.substring(0, str.indexOf(";"));
                String result = "";
                inputStream = postMethod.getResponseBodyAsStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader reader = new BufferedReader(inputStreamReader);
                StringBuffer sb = new StringBuffer();
                while ((result = reader.readLine()) != null) {
                    sb.append(result);
                }
                reader.close();
                inputStreamReader.close();
                inputStream.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u8c03\u7528tsp\u767b\u5f55\u673a\u5236\u7ed3\u679c\u8fd4\u56de:" + sb.toString()));
                }
                return sessionId;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u8bf7\u6c42\u672a\u6210\u529f\uff0cstatusCode:" + statusCode + "responseBody :" + postMethod.getResponseBodyAsString()));
            }
            if (statusCode == 302 && logger.isDebugEnabled()) {
                logger.debug((Object)("\u91cd\u5b9a\u5411\u5230\u4e86:" + postMethod.getResponseHeader("location").getValue()));
            }
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url:" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u8c03\u7528tsp\u767b\u5f55\u673a\u5236\u83b7\u53d6sessionId:" + sessionId));
        }
        return sessionId;
    }

    static {
        MySecureProtocolSocketFactory fcty = new MySecureProtocolSocketFactory();
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)fcty, 443));
    }
}

