/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ParamUtil {
    private static Logger logger = Logger.getLogger(ParamUtil.class);
    private static Pattern MINUTE_PATTERN = Pattern.compile("\u63d0\u524d(\\w+)\u5206\u949f");
    private static Pattern HOUR_PATTERN = Pattern.compile("\u63d0\u524d(\\w+)\u5c0f\u65f6");
    private static Pattern DAY_PATTERN = Pattern.compile("\u63d0\u524d(\\w+)\u5929");
    private static Pattern MINUTElATER_PATTERN = Pattern.compile("(\\w+)\u5206\u949f\u540e");
    private static Pattern HOURLATE_PATTERN = Pattern.compile("(\\w+)\u5c0f\u65f6\u540e");
    private static Pattern DAYLATER_PATTERN = Pattern.compile("(\\w+)\u5929\u540e");

    private ParamUtil() {
    }

    public static ParamUtil getInstance() {
        return ParamUtilHolder.service;
    }

    public int getInterviewRemindTime(Context ctx) {
        int time = 60;
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return time;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"shr_rec_001", (String)hrOrgID);
            if (paramItem == null) {
                return time;
            }
            String interviewRemindTime = paramItem.getValueAlias();
            if (interviewRemindTime.contains("\u5206\u949f")) {
                Pattern p = MINUTE_PATTERN;
                Matcher m = p.matcher(interviewRemindTime);
                while (m.find()) {
                    time = Integer.parseInt(m.group(1));
                }
            } else if (interviewRemindTime.contains("\u5c0f\u65f6")) {
                Pattern p = HOUR_PATTERN;
                Matcher m = p.matcher(interviewRemindTime);
                while (m.find()) {
                    time = Integer.parseInt(m.group(1)) * 60;
                }
            } else if (interviewRemindTime.contains("\u5929")) {
                Pattern p = DAY_PATTERN;
                Matcher m = p.matcher(interviewRemindTime);
                while (m.find()) {
                    time = Integer.parseInt(m.group(1)) * 24 * 60;
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return time;
    }

    public int getInterviewResultRemindTime(Context ctx) {
        int time = 1;
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return time;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"shr_rec_002", (String)hrOrgID);
            if (paramItem == null) {
                return 1;
            }
            String interviewRemindTime = paramItem.getValueAlias();
            time = Integer.parseInt(interviewRemindTime);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return time;
    }

    public boolean getGroupResumeClipControl(Context ctx) {
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return false;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"shr_rec_003", (String)hrOrgID);
            if (paramItem == null) {
                return false;
            }
            String result = paramItem.getValueAlias();
            if ("\u9ed8\u8ba4\u8fdb\u5165\u96c6\u56e2\u7b80\u5386\u5939".equals(result)) {
                return true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public int getRecDemandControl(Context ctx) {
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return 0;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"shr_rec_004", (String)hrOrgID);
            if (paramItem == null) {
                return 0;
            }
            String result = paramItem.getValueAlias();
            if ("\u7b80\u5386\u53ef\u8fdb\u5165\u5e76\u80fd\u5e94\u8058\uff0c\u4f46\u9700\u6c42\u8fbe\u6210\u53ef\u8d85\u8fc7100%".equals(result)) {
                return 0;
            }
            if ("\u7b80\u5386\u53ef\u8fdb\u5165\u5e76\u80fd\u5e94\u8058\uff0c\u4f46\u9700\u6c42\u8fbe\u6210\u6700\u9ad8100%\uff08\u5165\u804c\u4eba\u6570\u81ea\u52a8\u6dfb\u52a0\u5230\u9700\u6c42\u4eba\u6570\u4e0a\uff09".equals(result)) {
                return 1;
            }
            if ("\u7b80\u5386\u4e0d\u53ef\u8fdb\u5165\uff0c\u5e76\u4e14\u4e0d\u80fd\u7ee7\u7eed\u5e94\u8058".equals(result)) {
                return 2;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public int getRecIDCardControl(Context ctx) {
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return 0;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"shr_rec_005", (String)hrOrgID);
            if (paramItem == null) {
                return 0;
            }
            String result = paramItem.getValueAlias();
            if ("\u9762\u8bd5\u9636\u6bb5\u5fc5\u586b".equals(result)) {
                return 0;
            }
            if ("\u5f55\u7528\u62a5\u6279\u9636\u6bb5\u5fc5\u586b".equals(result)) {
                return 1;
            }
            if ("offer\u9636\u6bb5\u5fc5\u586b".equals(result)) {
                return 2;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public Integer getOfferRoute(Context ctx) {
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return 0;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"ONLINEOFFER_CONTROL", (String)hrOrgID);
            if (paramItem == null) {
                return 0;
            }
            String result = paramItem.getValue(ctx.getLocale());
            return Integer.parseInt(result);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public Integer getRecRegisterEditWay(Context ctx) {
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return 0;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"REC_REGISTEREDIT_CONTROL", (String)hrOrgID);
            if (paramItem == null) {
                return 0;
            }
            String result = paramItem.getValue(ctx.getLocale());
            return Integer.parseInt(result);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public Integer getRecRegisterWriteResumeControl(Context ctx) {
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return 0;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"REC_REGISTERWRITERESUME_CONTROL", (String)hrOrgID);
            if (paramItem == null) {
                return 0;
            }
            String result = paramItem.getValue(ctx.getLocale());
            return Integer.parseInt(result);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return 0;
    }

    public String getHideEntryResume(Context ctx) {
        String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
        String HideEntryResume = "";
        ParamItemInfo paramItem = null;
        try {
            paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"ENTRYRESUME_CONTROL", (String)hrOrgID);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (paramItem == null) {
            return "0";
        }
        return paramItem.getValue(ctx.getLocale());
    }

    public String getStaffingControl(Context ctx) {
        String staffingControl = "";
        try {
            String sql = "SELECT FValue_L2 FROM T_BAS_ParamItem WHERE FKeyID = 'gaW+ra7ArE+90MAVXLWmn6iB8+c='";
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, sql, new Object[0]);
            if (datas != null && datas.size() > 0) {
                staffingControl = (String)datas.get(0)[0];
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return staffingControl;
    }

    public int getApprovalStaffControl(Context ctx) {
        int paramVal = 3;
        try {
            paramVal = Integer.parseInt(ParamManager.getParamValueIgnoreGroupControl((Context)ctx, (String)"APPROVAL_STAFF_CONTROL", (IObjectPK)null, (boolean)false));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return paramVal;
    }

    public int getResumeApproverRemindTime(Context ctx) {
        int time = 24;
        try {
            String hrOrgID = HRFilterUtils.getCurrentHROID((Context)ctx);
            if (StringUtils.isEmpty((String)hrOrgID)) {
                return time;
            }
            ParamItemInfo paramItem = ParamManager.getParamItemInfoByNumberAndOrg((Context)ctx, (String)"REC_RESUMEAPPROVER_CONTROL", (String)hrOrgID);
            if (paramItem == null) {
                return time;
            }
            String resumeApproverRemindTime = paramItem.getValueAlias();
            time = Integer.parseInt(resumeApproverRemindTime);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return time;
    }

    private static class ParamUtilHolder {
        private static ParamUtil service = new ParamUtil();

        private ParamUtilHolder() {
        }
    }
}

