/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.kingdee.bos.BOSException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class QRCodeUtil {
    private static final Logger logger = Logger.getLogger((String)QRCodeUtil.class.getName());
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private static final int WIDTH = 300;
    private static final int HEIGHT = 300;
    private static final String FORMAT = "png";

    public static byte[] getQRCodeBytes(String content) throws BOSException {
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 300, 300, hints);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int[] rec = bitMatrix.getEnclosingRectangle();
            int resWidth = rec[2] + 1;
            int resHeight = rec[3] + 1;
            BitMatrix resMatrix = new BitMatrix(resWidth, resHeight);
            resMatrix.clear();
            for (int i = 0; i < resWidth; ++i) {
                for (int j = 0; j < resHeight; ++j) {
                    if (!bitMatrix.get(i + rec[0], j + rec[1])) continue;
                    resMatrix.set(i, j);
                }
            }
            int width1 = resMatrix.getWidth();
            int height1 = resMatrix.getHeight();
            BufferedImage img = new BufferedImage(width1, height1, 12);
            for (int x = 0; x < width1; ++x) {
                for (int y = 0; y < height1; ++y) {
                    img.setRGB(x, y, resMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            ImageIO.write((RenderedImage)img, FORMAT, stream);
            byte[] byteArray = stream.toByteArray();
            return byteArray;
        }
        catch (WriterException e1) {
            logger.error((Object)"ImageIO write fail!");
            throw new BOSException((Throwable)e1);
        }
        catch (IOException e) {
            logger.error((Object)"ImageIO write fail!");
            throw new BOSException((Throwable)e);
        }
    }

    public static byte[] downWordQRCode(byte[] qRCode, ArrayList<String> texts) throws BOSException {
        try {
            XWPFDocument document = new XWPFDocument();
            XWPFParagraph firstParagraph = document.createParagraph();
            firstParagraph.setAlignment(ParagraphAlignment.CENTER);
            XWPFRun run = firstParagraph.createRun();
            ByteArrayInputStream is = new ByteArrayInputStream(qRCode);
            run.addBreak();
            run.addPicture((InputStream)is, 5, "QRCode.png", Units.toEMU((double)200.0), Units.toEMU((double)200.0));
            ((InputStream)is).close();
            for (String text : texts) {
                XWPFParagraph paragraph2 = document.createParagraph();
                paragraph2.setAlignment(ParagraphAlignment.CENTER);
                XWPFRun run2 = paragraph2.createRun();
                run2.setText(text);
                run2.setColor("696969");
                run2.setFontSize(14);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.write((OutputStream)baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InvalidFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static byte[] downWordQRCodes(ArrayList<Map<String, Object>> list) throws BOSException {
        try {
            XWPFDocument document = new XWPFDocument();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Map<String, Object> map = list.get(i);
                byte[] qRCode = (byte[])map.get("fileContent");
                ArrayList texts = (ArrayList)map.get("texts");
                XWPFParagraph firstParagraph = document.createParagraph();
                firstParagraph.setAlignment(ParagraphAlignment.CENTER);
                XWPFRun run = firstParagraph.createRun();
                ByteArrayInputStream is = new ByteArrayInputStream(qRCode);
                run.addBreak();
                run.addPicture((InputStream)is, 5, "QRCode_" + i + ".png", Units.toEMU((double)200.0), Units.toEMU((double)200.0));
                ((InputStream)is).close();
                for (String text : texts) {
                    XWPFParagraph paragraph2 = document.createParagraph();
                    paragraph2.setAlignment(ParagraphAlignment.CENTER);
                    XWPFRun run2 = paragraph2.createRun();
                    run2.setText(text);
                    run2.setColor("696969");
                    run2.setFontSize(14);
                }
                firstParagraph.setPageBreak(true);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            document.write((OutputStream)baos);
            baos.flush();
            return baos.toByteArray();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (InvalidFormatException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

