/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.recuritment.InterviewPlanFactory;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.utils.RecBaseUtils;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecNoticeUtil {
    private static Logger logger = Logger.getLogger(RecNoticeUtil.class);

    public static void generateInterviewMessage(String content, String userId, Context ctx, String reportDefID, String templateId) {
        SenderAgent senderAgent;
        Message message = MessageFactory.newMessage();
        message.setBooleanHeader("isSendCommon", Boolean.TRUE.booleanValue());
        message.setLocaleStringHeader("sender", "\u4eba\u529b\u8d44\u6e90\u7cfb\u7edf", ctx.getLocale());
        message.setLocaleStringHeader("initiatorName", "\u4eba\u529b\u8d44\u6e90\u7cfb\u7edf", ctx.getLocale());
        message.setLocaleStringHeader("title", content, ctx.getLocale());
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 70);
        message.setIntHeader("priority", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setLocaleStringHeader("body", content, ctx.getLocale());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("receiver", userId);
        message.setStringHeader("senderId", userId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("userId====" + userId));
            logger.debug((Object)("userId====" + userId + ";databaseCenter:" + ctx.getAIS() + ";solution:" + ctx.getSolution() + ";content:" + content));
        }
        if ((senderAgent = DirectSenderAgent.getSenderAgent()).getState() != 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"senderAgent state not running");
            }
            senderAgent.start();
        }
        if (senderAgent.getState() == 1) {
            senderAgent.sendMessage(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("userId====" + userId + "\u6d88\u606f\u7ed3\u675f"));
        }
    }

    public static void generatePCMsg(Context ctx, String userId, String content, String url) {
        SenderAgent senderAgent;
        Message message = MessageFactory.newMessage();
        message.setBooleanHeader("isSendCommon", Boolean.TRUE.booleanValue());
        message.setLocaleStringHeader("sender", "\u4eba\u529b\u8d44\u6e90\u7cfb\u7edf", ctx.getLocale());
        message.setLocaleStringHeader("initiatorName", "\u4eba\u529b\u8d44\u6e90\u7cfb\u7edf", ctx.getLocale());
        message.setLocaleStringHeader("title", content, ctx.getLocale());
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 70);
        message.setIntHeader("priority", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setLocaleStringHeader("body", content, ctx.getLocale());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("receiver", userId);
        message.setStringHeader("senderId", userId);
        message.setStringHeader("url", url);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("userId====" + userId + ";databaseCenter:" + ctx.getAIS() + ";solution:" + ctx.getSolution() + ";content:" + content));
        }
        if ((senderAgent = DirectSenderAgent.getSenderAgent()).getState() != 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"senderAgent state not running");
            }
            senderAgent.start();
        }
        if (senderAgent.getState() == 1) {
            senderAgent.sendMessage(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("userId====" + userId + "\u6d88\u606f\u7ed3\u675f"));
        }
    }

    public static void sendInterviewEvaluateMsg(Context ctx, String userIds, String content, String interviewPlanId) {
        try {
            String[] userArray = userIds.split(";");
            InterviewPlanInfo info = InterviewPlanFactory.getLocalInstance(ctx).getInterviewPlanInfo("Select interview.id where id = '" + interviewPlanId + "'");
            String interviewId = info.getInterview().getId().toString();
            for (String userId : userArray) {
                StringBuilder sb = new StringBuilder();
                String personId = RecNoticeUtil.getUserRelativePersonInfo(ctx, userId);
                sb.append("/shr/dynamic.do?uipk=com.kingdee.shr.recuritment.app.myNewInterviewResult&method=edit&inFrame=true");
                sb.append("&billId=").append(URLEncoder.encode(interviewId, "UTF-8"));
                sb.append("&interviewerId=").append(URLEncoder.encode(personId, "UTF-8"));
                sb.append("&interviewPlanId=").append(URLEncoder.encode(interviewPlanId, "UTF-8"));
                RecNoticeUtil.generatePCMsg(ctx, userId, content, sb.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void sendSelfUploadResume(Context ctx, String personId, ResumeBaseRecInfo resume) {
        try {
            String userId = RecDBUtils.getUserId(ctx, personId);
            logger.error((Object)("userId:" + userId));
            PersonInfo currentPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            StringBuffer content = new StringBuffer();
            if (currentPerson != null) {
                AdminOrgUnitInfo userPersonDepInfo;
                content.append(currentPerson.getName());
                if (currentPerson.getId() != null && (userPersonDepInfo = RecBaseUtils.getCurrentUserPersonDepInfo(ctx, currentPerson.getId().toString())) != null) {
                    content.append("(");
                    content.append(userPersonDepInfo.getName());
                    content.append(")");
                }
            }
            content.append("\u4e0a\u4f20\u4e86\u5e94\u8058\u7b80\u5386");
            content.append("(" + resume.getName() + ")");
            content.append("\u5230");
            content.append(resume.getRecuritmentDemand().getPositionName());
            content.append("(");
            content.append(resume.getRecuritmentDemand().getDepartment().getName());
            content.append(")\uff0c\u8bf7\u67e5\u770b\uff08\u4e0a\u4f20\u7b80\u5386\u4e3a\u9700\u6c42\u8d1f\u8d23\u4eba\u79c1\u6709\uff09\uff01");
            StringBuilder sb = new StringBuilder();
            sb.append("/shr/dynamic.do?uipk=hr.rec.resume.main&inFrame=true&billId=" + resume.getId().toString() + "&method=view&from=ResumeScreening");
            logger.error((Object)("\u53d1\u9001\u5c0f\u94c3\u94db\u6d88\u606f:" + content));
            logger.error((Object)("\u53d1\u9001\u5c0f\u94c3\u94db\u6d88\u606f:" + sb.toString()));
            RecNoticeUtil.generatePCMsg(ctx, userId, content.toString(), sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void sendPushResumeForApproversMsg(Context ctx, String userId, String content, String url) {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        RecNoticeUtil.generatePCMsg(ctx, userId, content, sb.toString());
    }

    public static void sendPushResumeForPusherMsg(Context ctx, String userId, String content, String billId) {
        StringBuilder sb = new StringBuilder();
        sb.append("/shr/dynamic.do?uipk=com.kingdee.shr.recuritment.app.ResumeBaseRec.editPushResume.form&inFrame=true");
        sb.append("&billId=").append(billId);
        sb.append("&method=edit");
        RecNoticeUtil.generatePCMsg(ctx, userId, content, sb.toString());
    }

    public static String getUserRelativePersonInfo(Context ctx, String userId) throws BOSException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            return null;
        }
        String sql = "SELECT FPersonId FROM T_PM_User WHERE FId = ?";
        List<Object[]> datas = null;
        try {
            datas = RecDBUtils.getQueryData(ctx, sql, new Object[]{userId});
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u5173\u8054\u5458\u5de5\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (Throwable)e);
        }
        if (datas == null) {
            return null;
        }
        return (String)datas.get(0)[0];
    }

    public static void sendSelfUploadResume(Context ctx, ResumeBaseRecInfo resume) {
        try {
            String userId = RecDBUtils.getUserId(ctx, resume.getUploader().getId().toString());
            PersonInfo currentPerson = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            StringBuffer content = new StringBuffer();
            content.append("\u60a8\u4e0a\u4f20\u7684\u5e94\u8058\u7b80\u5386\uff1a");
            content.append(resume.getName());
            if (currentPerson != null) {
                content.append("\uff0cHR\uff1a");
                content.append(currentPerson.getName());
            }
            content.append("\u5df2\u7b5b\u9009\u901a\u8fc7\uff01\uff08\u53ef\u7ee7\u7eed\u63a8\u9001\u7ed9\u4e1a\u52a1\u90e8\u95e8\u7b5b\u9009\uff0c\u6216\u8005\u8fdb\u5165\u9762\u8bd5\u7b49\u540e\u7eed\u9636\u6bb5\u5e94\u8058\uff09");
            StringBuilder sb = new StringBuilder();
            sb.append("/shr/dynamic.do?uipk=hr.rec.resume.main&inFrame=true&billId=" + resume.getId().toString() + "&method=view&from=ResumeScreening");
            RecNoticeUtil.generatePCMsg(ctx, userId, content.toString(), sb.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

