/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.emp.PersonPhotoCollection;
import com.kingdee.eas.hr.emp.PersonPhotoFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.recuritment.app.util.FileUtil;
import com.kingdee.shr.recuritment.app.util.constant.RecOsfReturnCode;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecOsfUtil {
    private static final Logger logger = Logger.getLogger(RecOsfUtil.class);

    public static Map<String, Object> createReturnSuccess(Object data, Class cls, Map param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", RecOsfReturnCode.SUCCESS);
        resultMap.put("msg", "ok");
        resultMap.put("data", data);
        logger.info((Object)("*******************OSF\u63a5\u53e3\uff08" + cls.getName() + "\uff09\u6210\u529f***********************"));
        logger.info((Object)("OSF\u63a5\u53e3\u53c2\u6570\u4e3a\uff1a" + param));
        logger.info((Object)("********************" + cls.getName() + " \u63a5\u53e3\u8c03\u7528\u7ed3\u675f********************"));
        return resultMap;
    }

    public static Map<String, Object> createReturnSuccessForIntegrate(Object data, Class cls, Map param) {
        JSONObject resultObject = new JSONObject();
        resultObject.put("code", (Object)RecOsfReturnCode.SUCCESS);
        resultObject.put("msg", (Object)"ok");
        resultObject.put("data", data);
        logger.info((Object)("*******************OSF\u63a5\u53e3\uff08" + cls.getName() + "\uff09\u6210\u529f***********************"));
        logger.info((Object)("OSF\u63a5\u53e3\u53c2\u6570\u4e3a\uff1a" + param));
        logger.info((Object)("OSF\u6267\u884c\u7ed3\u679c\u4e3a\uff1a" + data));
        logger.info((Object)("********************" + cls.getName() + " \u63a5\u53e3\u8c03\u7528\u7ed3\u675f********************"));
        return resultObject;
    }

    public static Map<String, Object> createReturnError(int errCode, String errMsg, Class cls, Map param) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", errCode);
        resultMap.put("msg", errMsg);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("*******************OSF\u63a5\u53e3\uff08" + cls.getName() + "\uff09\u62a5\u9519***********************"));
            logger.debug((Object)("OSF\u63a5\u53e3\u53c2\u6570\u4e3a\uff1a" + param));
            logger.debug((Object)("OSF\u6267\u884c\u7ed3\u679c\u4e3a\uff1a" + resultMap));
        }
        logger.info((Object)("********************" + cls.getName() + " \u63a5\u53e3\u8c03\u7528\u7ed3\u675f********************"));
        return resultMap;
    }

    public static String getPersonIDByOpenID(Context ctx, String openID) throws BOSException {
        String personID = "";
        if (!StringUtils.isEmpty((CharSequence)openID)) {
            String querySql = "SELECT FPersonId as PERSONID,FUserId as USERID FROM t_pm_easxtusermap WHERE FXtId = ? and FStatus = 1 ";
            IRowSet rs = null;
            try {
                String id;
                rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{openID});
                if (rs != null && rs.next() && !StringUtils.isEmpty((CharSequence)(id = rs.getString("PERSONID")))) {
                    personID = id;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (StringUtils.isEmpty((CharSequence)personID)) {
            personID = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        return personID;
    }

    public static String getOpenIDByPersonID(Context ctx, String personID) throws BOSException {
        String openID = "";
        if (!StringUtils.isEmpty((CharSequence)personID)) {
            String querySql = "SELECT FXtId FROM t_pm_easxtusermap WHERE FPersonId = ? and FUSERID  IS NOT NULL";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{personID});
                while (rs != null && rs.next()) {
                    String id = rs.getString("FXtId");
                    if (StringUtils.isEmpty((CharSequence)id)) continue;
                    openID = id;
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return openID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getOpenIDsByPersonID(Context ctx, String personIds) {
        ArrayList<String> openIDs = new ArrayList<String>();
        if (StringUtils.isEmpty((CharSequence)personIds)) {
            return openIDs;
        }
        String[] persons = personIds.split(";|,");
        StringBuilder ids = new StringBuilder();
        int size = persons.length;
        for (int i = 0; i < size; ++i) {
            ids.append("'").append(persons[i]).append("'").append(",");
        }
        if (!StringUtils.isEmpty((CharSequence)ids.toString())) {
            personIds = ids.substring(0, ids.length() - 1).toString();
        }
        String querySql = "SELECT FXtId FROM t_pm_easxtusermap WHERE FPersonId in (" + personIds + ") and FUSERID IS NOT NULL";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[0]);
            while (rs != null && rs.next()) {
                String fXtId = rs.getString("FXtId");
                if (StringUtils.isEmpty((CharSequence)fXtId)) continue;
                openIDs.add(fXtId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return openIDs;
    }

    public static Map<String, Object> getPersonInfo(Context ctx, String personId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        java.util.Date effdt = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        String queryEmpSql = "select person.FID as personId,person.FName_L2 as personName,person.FNumber as personNumber, person.FEmail as email,person.FCell as cell,position.FID as positionId,position.FName_l2 as positionName, org.FID as departmentId,org.FName_l2 as departmentName,org.FLongNumber as departmentLongNumber,org.FDisplayName_l2 as departmentDisplayName  from T_HR_EmpOrgRelation R  left join T_BD_Person person on person.FID = R.FPersonId  left join T_ORG_Position position on position.FID = R.FPositionID  left join T_ORG_Admin org on org.FID = R.FAdminOrgID  where R.FPersonId = ? and R.FAssignType = 1 and R.FEFFDT<=? and  R.FLEFFDT >=? ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryEmpSql, (Object[])new Object[]{personId, new Date(effdt.getTime()), new Date(effdt.getTime())});
            if (rs != null && rs.next()) {
                map.put("personID", rs.getString("personId"));
                map.put("personName", rs.getString("personName"));
                map.put("personNumber", rs.getString("personNumber"));
                map.put("cell", rs.getString("cell"));
                map.put("email", rs.getString("email"));
                map.put("positionId", rs.getString("positionId"));
                map.put("positionName", rs.getString("positionName"));
                map.put("departmentId", rs.getString("departmentId"));
                map.put("departmentName", rs.getString("departmentName"));
                map.put("departmentLongNumber", rs.getString("departmentLongNumber"));
                map.put("departmentDisplayName", rs.getString("departmentDisplayName"));
                map.put("organizationName", RecOsfUtil.getOrganizationName(rs.getString("DEPARTMENTDISPLAYNAME")));
                map.putAll(RecOsfUtil.getEmpDegreeInfo(ctx, personId));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        return map;
    }

    public static List<Map<String, Object>> getAllPositionByPersonId(Context ctx, String personId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = null;
        java.util.Date effdt = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        String queryEmpSql = "select person.FID as personId,person.FName_L2 as personName,person.FNumber as personNumber, person.FEmail as email,person.FCell as cell,position.FID as positionId,position.FName_l2 as positionName, org.FID as departmentId,org.FName_l2 as departmentName,org.FLongNumber as departmentLongNumber,org.FDisplayName_l2 as departmentDisplayName  from T_HR_EmpOrgRelation R  left join T_BD_Person person on person.FID = R.FPersonId  left join T_ORG_Position position on position.FID = R.FPositionID  left join T_ORG_Admin org on org.FID = R.FAdminOrgID  where R.FPersonId = ? and R.FEFFDT<=? and  R.FLEFFDT >=? order by R.FAssignType desc";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryEmpSql, (Object[])new Object[]{personId, new Date(effdt.getTime()), new Date(effdt.getTime())});
            if (rs != null) {
                while (rs.next()) {
                    map = new HashMap<String, String>();
                    map.put("personID", rs.getString("personId"));
                    map.put("personName", rs.getString("personName"));
                    map.put("cell", rs.getString("cell"));
                    map.put("email", rs.getString("email"));
                    map.put("positionId", rs.getString("positionId"));
                    map.put("positionName", rs.getString("positionName"));
                    map.put("departmentId", rs.getString("departmentId"));
                    map.put("departmentName", rs.getString("departmentName"));
                    map.put("departmentLongNumber", rs.getString("departmentLongNumber"));
                    map.put("departmentDisplayName", rs.getString("departmentDisplayName"));
                    map.put("organizationName", RecOsfUtil.getOrganizationName(rs.getString("DEPARTMENTDISPLAYNAME")));
                    list.add(map);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public static List<String> getAllDeptLongNumber(Context ctx, String personId) {
        ArrayList<String> list = new ArrayList<String>();
        List<Map<String, Object>> mapList = RecOsfUtil.getAllPositionByPersonId(ctx, personId);
        if (mapList != null && mapList.size() > 0) {
            for (Map<String, Object> map : mapList) {
                if (map.get("departmentLongNumber") == null) continue;
                String longNumber = (String)map.get("departmentLongNumber");
                list.add(longNumber);
            }
        }
        return list;
    }

    public static Map<String, Object> getEmpDegreeInfo(Context ctx, String personId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String queryDegreeSql = "select PD.FDegree as degree,dip.FID as diplomaId,DIP.FName_l2 as diplomaName,DIP.FNumber as diplomaNumber, PD.FSpecialty as specialty,PD.FGraduateSchool as graduateSchool  from T_HR_PersonDegree PD  left join T_BD_HRDiploma Dip on dip.FID = PD.FDiploma  where PD.FisHighest = 1 and PD.FPersonId = ?  order by PD.FgraduateDate desc ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryDegreeSql, (Object[])new Object[]{personId});
            if (rs != null && rs.next()) {
                resultMap.put("highestDegree", rs.getString("degree"));
                resultMap.put("diploma", rs.getString("diplomaName"));
                resultMap.put("major", rs.getString("specialty"));
                resultMap.put("school", rs.getString("graduateSchool"));
            } else {
                resultMap.put("highestDegree", "");
                resultMap.put("diploma", "");
                resultMap.put("major", "");
                resultMap.put("school", "");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    public static Map<String, Object> getDepartmentInfo(Context ctx, String departmentID) {
        String sql = "select department.FID AS DEPARTMENTID,company.FID as COMPANYID,org.FID as ORGID, department.FName_l2 as DEPARTMENTNAME,company.FName_l2 as COMPANYNAME,org.FName_l2 as ORGNAME  from T_ORG_ADMIN department left join T_ORG_ADMIN company on company.FID = department.FCompanyID  left join T_ORG_ADMIN org on org.FID = department.FDepartmentID  where department.FID = ? ";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{departmentID});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            if (rs != null && rs.next()) {
                map.put("departmentId", rs.getString("DEPARTMENTID"));
                map.put("departmentName", rs.getString("DEPARTMENTNAME"));
                map.put("companyId", rs.getString("COMPANYID"));
                map.put("companyName", rs.getString("COMPANYNAME"));
                map.put("organizationId", rs.getString("ORGID"));
                map.put("organizationName", rs.getString("ORGNAME"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static String getOrganizationName(String displayName) {
        String organizationName = displayName;
        if (displayName != null) {
            int startIndex = displayName.indexOf("_") + 1;
            int endIndex = displayName.lastIndexOf("_");
            if (endIndex > startIndex) {
                organizationName = displayName.substring(displayName.indexOf("_") + 1, displayName.lastIndexOf("_"));
            }
        }
        return organizationName;
    }

    public static Map<String, String> getPersonCompanyOrgId(Context ctx, String personId) {
        java.util.Date effdt = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        HashMap<String, String> map = new HashMap<String, String>();
        String queryEmpSql = " Select org.FID as ID , org.FName_l2 as NAME  from T_BD_Person person  left join  T_HR_EmpOrgRelation R on person.FID = R.FPersonId  left join T_ORG_Admin org on org.FID = R.FCompanyID  where R.FPersonId = ? and R.FAssignType = 1 and R.FEFFDT<=? and  R.FLEFFDT >=?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryEmpSql, (Object[])new Object[]{personId, new Date(effdt.getTime()), new Date(effdt.getTime())});
            if (rs != null && rs.next()) {
                map.put("id", rs.getString("ID"));
                map.put("name", rs.getString("NAME"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        return map;
    }

    public static Map<String, String> getPersonGroupOrgId(Context ctx, String personId) {
        java.util.Date effdt = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        HashMap<String, String> map = new HashMap<String, String>();
        String queryEmpSql = "select top 1 a.fid AS ID , a.FName_l2 as NAME  from T_ORG_Admin a  where CHARINDEX(a.FLONGNUMBER,  (select org.FLONGNUMBER  FROM T_BD_Person person  left join  T_HR_EmpOrgRelation R on person.FID = R.FPersonId  left join T_ORG_Admin org on org.FID = R.FAdminOrgID  where R.FPersonId = ? and R.FAssignType = 1 and R.FEFFDT<=? and  R.FLEFFDT >=? )) = 1  and a.FLAYERTYPEID = '00000000-0000-0000-0000-00000000000162824988'  order by length(a.FLONGNUMBER) desc;";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryEmpSql, (Object[])new Object[]{personId, new Date(effdt.getTime()), new Date(effdt.getTime())});
            if (rs != null && rs.next()) {
                map.put("id", rs.getString("ID"));
                map.put("name", rs.getString("NAME"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        return map;
    }

    public static byte[] getHeadImage(Context ctx, String personID) {
        byte[] headImage = null;
        try {
            PersonPhotoCollection personPhotoCollection = PersonPhotoFactory.getLocalInstance((Context)ctx).getPersonPhotoCollection("select imageData where person = '" + personID + "'");
            if (personPhotoCollection.size() > 0) {
                headImage = personPhotoCollection.get(0).getImageData();
            } else {
                String headUrl = SHRSyssettingUtil.getShrWebWarPath() + "/images/default_headsmall.png";
                headImage = FileUtil.getBytesFromFile(headUrl);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("--------------->get headImage error\uff1a" + e.getMessage()));
        }
        return headImage;
    }

    public static Object createReturnFailForIntegrate(Integer code, String judgeSqlInject) {
        JSONObject resultObject = new JSONObject();
        resultObject.put("code", (Object)code);
        resultObject.put("msg", (Object)judgeSqlInject);
        return resultObject;
    }
}

