/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util;

import com.kingdee.bos.BOSException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class XmlUtil {
    private static final Logger logger = Logger.getLogger(XmlUtil.class);

    public static List<Element> getElementsByName(String xml, String name) {
        String rootxml = "<?xml version='1.0' encoding='UTF-8' ?><root>";
        rootxml = rootxml + xml;
        rootxml = rootxml + "</root>";
        SAXBuilder builder = new SAXBuilder();
        XmlUtil.setReaderFeature(builder);
        List<Element> output = new ArrayList<Element>();
        Document dom = null;
        try {
            dom = DocumentHelper.parseText((String)rootxml);
        }
        catch (DocumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (dom != null) {
            Element root = dom.getRootElement();
            output = XmlUtil.getChildElement(root, name);
        }
        return output;
    }

    public static Document getRootDocument(String xml) {
        String rootxml = "<?xml version='1.0' encoding='UTF-8' ?><root>";
        rootxml = rootxml + xml;
        rootxml = rootxml + "</root>";
        SAXBuilder builder = new SAXBuilder();
        XmlUtil.setReaderFeature(builder);
        Document dom = null;
        try {
            dom = DocumentHelper.parseText((String)rootxml);
        }
        catch (DocumentException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return dom;
    }

    public static List<Element> getChildElement(Element input, String name) {
        ArrayList<Element> output = new ArrayList<Element>();
        List list = input.elements();
        if (list != null && list.size() > 0) {
            for (Element e : list) {
                if (e.getName() != null && e.getName().equals(name)) {
                    output.add(e);
                    continue;
                }
                output.addAll(XmlUtil.getChildElement(e, name));
            }
        }
        return output;
    }

    public static org.jdom2.Document parseXML(String xml) throws BOSException {
        SAXBuilder builder = new SAXBuilder();
        XmlUtil.setReaderFeature(builder);
        org.jdom2.Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return doc;
    }

    public static void setReaderFeature(SAXBuilder reader) {
        if (null == reader) {
            return;
        }
        reader.setExpandEntities(false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }
}

