/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.convert;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DateConvertUtil {
    private static final Logger logger = Logger.getLogger(DateConvertUtil.class);
    private static final String NOW = "\u81f3\u4eca";

    public static Date convertStrToDate(String strDate) {
        if (StringUtils.isEmpty((CharSequence)strDate) || NOW.equals(strDate)) {
            return null;
        }
        Date date = null;
        SimpleDateFormat format = null;
        if (strDate.matches("^\\d{1,4}-\\d{1,2}-\\d{1,2}$")) {
            try {
                format = new SimpleDateFormat("yyyy-MM-dd");
                date = format.parse(strDate);
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (strDate.matches("^\\d{1,4}-\\d{1,2}$")) {
            try {
                format = new SimpleDateFormat("yyyy-MM");
                date = format.parse(strDate);
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else if (strDate.matches("^\\d{1,4}")) {
            try {
                format = new SimpleDateFormat("yyyy");
                date = format.parse(strDate);
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return date;
    }

    public static String getSqlDate(Date date) {
        String parten = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        String sqlDate = sdf.format(date);
        return "{ts'" + sqlDate + "'}";
    }
}

