/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.convert;

import com.kingdee.shr.recuritment.CurrentWorkingStatusEnum;
import com.kingdee.shr.recuritment.ExperienceOverseaEnum;
import com.kingdee.shr.recuritment.JobNatureEnum;
import com.kingdee.shr.recuritment.ProficiencyEnum;
import com.kingdee.shr.recuritment.SchoolTypeEnum;
import com.kingdee.shr.recuritment.SexEnum;

public class EnumConvertUtil {
    public static final int LOW_AGE = 16;
    public static final int HIGH_AGE = 80;
    public static final String WOMAN_CHINESE = "\u5973";
    public static final String WOMAN_EN = "WOMAN";
    public static final String MAN_CHINESE = "\u7537";
    public static final String MAN_EN = "MAN";
    public static final String FULL_CHINESE = "\u5168\u804c";
    public static final String FULL_EN = "FULL";
    public static final String PART_CHINESE = "\u517c\u804c";
    public static final String PART_EN = "PART";
    public static final String OUT_CHINESE = "\u5916\u6d3e";
    public static final String OUT_EN = "OUT";
    public static final String INTERN_CHINESE = "\u5b9e\u4e60";
    public static final String INTERN_EN = "INTERN";
    public static final String NO_LIMIT_CHINESE = "\u4e0d\u9650";
    public static final String NO_LIMIT_EN = "NO_LIMIT";
    public static final String PROFICIENT_CHINESE = "\u7cbe\u901a";
    public static final String PROFICIENT_EN = "PROFICIENT";
    public static final String SKILLED_CHINESE = "\u719f\u7ec3";
    public static final String LIANGHAO = "\u826f\u597d";
    public static final String SKILLED_EN = "SKILLED";
    public static final String GENERAL_CHINESE = "\u4e00\u822c";
    public static final String LIAOJIE = "\u4e86\u89e3";
    public static final String GENERAL_EN = "GENERAL";
    public static final String ON_DUTY_CHINESE = "\u5728\u804c";
    public static final String ON_DUTY_EN = "ON_DUTY";
    public static final String POST_WAITING_CHINESE = "\u79bb\u804c";
    public static final String POST_WAITING_EN = "POST_WAITING";
    public static final String NO_CHINESE = "\u65e0";
    public static final String NO_EN = "NO";
    public static final String YES_CHINESE = "\u6709";
    public static final String YES_EN = "YES";
    public static final int NORMAL_VALUE = 1;
    public static final int SCHOOL_211_VALUE = 2;
    public static final int SCHOOL_985_VALUE = 3;
    public static final int BOTH_211_985_VALUE = 4;
    public static final int FOREIGN_SCHOOL_VALUE = 5;

    public static ExperienceOverseaEnum getExpOverSea(String str) {
        if (NO_CHINESE.equals(str)) {
            return ExperienceOverseaEnum.NO;
        }
        if (YES_CHINESE.equals(str)) {
            return ExperienceOverseaEnum.YES;
        }
        return null;
    }

    public static CurrentWorkingStatusEnum getCurrentWorkingStatus(String workState) {
        if (ON_DUTY_CHINESE.equals(workState)) {
            return CurrentWorkingStatusEnum.ON_DUTY;
        }
        if (POST_WAITING_CHINESE.equals(workState)) {
            return CurrentWorkingStatusEnum.POST_WAITING;
        }
        return null;
    }

    public static ProficiencyEnum getProficiency(String lan) {
        if (PROFICIENT_CHINESE.equals(lan)) {
            return ProficiencyEnum.PROFICIENT;
        }
        if (SKILLED_CHINESE.equals(lan) || LIANGHAO.equals(lan)) {
            return ProficiencyEnum.SKILLED;
        }
        if (GENERAL_CHINESE.equals(lan) || LIAOJIE.equals(lan)) {
            return ProficiencyEnum.GENERAL;
        }
        return null;
    }

    public static JobNatureEnum getJobNature(String jobNature) {
        if (NO_LIMIT_CHINESE.equals(jobNature)) {
            return JobNatureEnum.NO_LIMIT;
        }
        if (FULL_CHINESE.equals(jobNature)) {
            return JobNatureEnum.FULL;
        }
        if (PART_CHINESE.equals(jobNature)) {
            return JobNatureEnum.PART;
        }
        return null;
    }

    public static SexEnum getSex(String sex) {
        return WOMAN_CHINESE.equals(sex) ? SexEnum.WOMAN : (MAN_CHINESE.equals(sex) ? SexEnum.MAN : null);
    }

    public static SchoolTypeEnum getSchoolType(int intType) {
        if (1 == ++intType) {
            return SchoolTypeEnum.NORMAL;
        }
        if (2 == intType) {
            return SchoolTypeEnum.SCHOOL_211;
        }
        if (3 == intType) {
            return SchoolTypeEnum.SCHOOL_985;
        }
        if (4 == intType) {
            return SchoolTypeEnum.BOTH_211_985;
        }
        if (5 == intType) {
            return SchoolTypeEnum.FOREIGN_SCHOOL;
        }
        return null;
    }
}

