/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.convert;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.DiplomaFactory;
import com.kingdee.eas.basedata.hraux.DiplomaInfo;
import com.kingdee.eas.basedata.hraux.IDiploma;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IPersonBlackList;
import com.kingdee.eas.hr.base.IPersonBlackListHis;
import com.kingdee.eas.hr.base.PersonBlackListCollection;
import com.kingdee.eas.hr.base.PersonBlackListFactory;
import com.kingdee.eas.hr.base.PersonBlackListHisCollection;
import com.kingdee.eas.hr.base.PersonBlackListHisFactory;
import com.kingdee.eas.hr.base.PersonBlackListHisInfo;
import com.kingdee.eas.hr.base.PersonBlackListInfo;
import com.kingdee.eas.hr.base.SourceEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.preentry.PreEntryPersonFactory;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.recuritment.EnterpriseArchivesCollection;
import com.kingdee.shr.recuritment.EnterpriseArchivesFactory;
import com.kingdee.shr.recuritment.EnterpriseArchivesInfo;
import com.kingdee.shr.recuritment.FilterCriteriaInfo;
import com.kingdee.shr.recuritment.IResumeSource;
import com.kingdee.shr.recuritment.IsOrNotEnum;
import com.kingdee.shr.recuritment.RecRegisterFactory;
import com.kingdee.shr.recuritment.RecRegisterInfo;
import com.kingdee.shr.recuritment.RecRegisterStateEnum;
import com.kingdee.shr.recuritment.RecuritmentDemandCollection;
import com.kingdee.shr.recuritment.RecuritmentDemandFactory;
import com.kingdee.shr.recuritment.RecuritmentDemandInfo;
import com.kingdee.shr.recuritment.RecuritmentHeadFactory;
import com.kingdee.shr.recuritment.RecuritmentHeadInfo;
import com.kingdee.shr.recuritment.ResumeBaseRecCollection;
import com.kingdee.shr.recuritment.ResumeBaseRecFactory;
import com.kingdee.shr.recuritment.ResumeBaseRecInfo;
import com.kingdee.shr.recuritment.ResumeSourceCollection;
import com.kingdee.shr.recuritment.ResumeSourceFactory;
import com.kingdee.shr.recuritment.ResumeSourceInfo;
import com.kingdee.shr.recuritment.SelectionResultEnum;
import com.kingdee.shr.recuritment.SimilarPersonType;
import com.kingdee.shr.recuritment.WorkAgeEnum;
import com.kingdee.shr.recuritment.WorkYearEnum;
import com.kingdee.shr.recuritment.app.service.ResumeSyncToPEPersonService;
import com.kingdee.shr.recuritment.app.service.similarPerson.AddSimilarResultService;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ResumeConvertUtil {
    private static final Logger logger = Logger.getLogger(ResumeConvertUtil.class);
    private static final Object archiveNumberLock = new Object();
    public static final String RESUME_SOURCE_ZHILIAN = "ZhiLian";
    public static final String RESUME_SOURCE_GANJI = "GanJi";
    public static final String RESUME_SOURCE_JOB51 = "Job51";
    public static final String RESUME_SOURCE_WOSHOU = "WoShou";
    public static final String RESUME_SOURCE_LIEPIN = "LiePin";
    public static final String RESUME_SOURCE_BOSS = "Boss";
    public static final String RESUME_SOURCE_SMARTIMPORT = "smartImport";
    public static final String RESUME_ANALYSIS = "resume_analysis";
    private static final Pattern number = Pattern.compile("^(\\+)?\\d+(\\.\\d+)?$");

    public static boolean compareDate(Timestamp date1, Timestamp date2) {
        return date1.getTime() > date2.getTime();
    }

    public static String getWorkSeniority(Date time) {
        Calendar from = Calendar.getInstance();
        from.setTime(time);
        Calendar to = Calendar.getInstance();
        to.setTime(new Date());
        int fromYear = from.get(1);
        int fromMonth = from.get(2);
        int toYear = to.get(1);
        int toMonth = to.get(2);
        int year = toYear - fromYear;
        int month = toMonth - fromMonth;
        return String.format("%.1f", (double)year + (double)month / 12.0);
    }

    public static int getAgeByBirthday(Date birthday) {
        if (birthday == null) {
            throw new NullPointerException();
        }
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthday)) {
            throw new IllegalArgumentException("The birthDay is not before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2) + 1;
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthday);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2) + 1;
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static int getAge(String age) {
        if (age == null) {
            throw new NullPointerException();
        }
        if ("".equals(age = age.replaceAll("\\D", "").trim()) || age.length() > 3) {
            throw new IllegalArgumentException("\u975e\u6cd5\u5e74\u9f84\u53c2\u6570\uff01\u53c2\u6570\u4e3a:" + age);
        }
        return Integer.parseInt(age);
    }

    public static ResumeSourceInfo getResumeFrom(Context ctx, String resume_from) {
        String resumeFrom = null;
        if (RESUME_SOURCE_ZHILIAN.equals(resume_from)) {
            resumeFrom = "9AX9WYChT/ekQITtsQGtdAMifAw=";
        } else if (RESUME_SOURCE_GANJI.equals(resume_from)) {
            resumeFrom = "Ikg55g6hRkm+ldOYmcWf/gMifAw=";
        } else if (RESUME_SOURCE_JOB51.equalsIgnoreCase(resume_from)) {
            resumeFrom = "x35TvIOKR4K3GQGbMbEa+gMifAw=";
        } else if (RESUME_SOURCE_WOSHOU.equals(resume_from)) {
            resumeFrom = "5vKIPFYTToCND/gQzmutxwMifAw=";
        } else if (RESUME_SOURCE_LIEPIN.equals(resume_from)) {
            resumeFrom = "h+pga/PbTUerLKv1zf+KlwMifAw=";
        } else if (RESUME_SOURCE_BOSS.equals(resume_from)) {
            resumeFrom = "AcqwhavwfEuZ0JMHLi50LgMifAw=";
        } else if (RESUME_SOURCE_SMARTIMPORT.equals(resume_from)) {
            resumeFrom = "8r0AAAAJO1cDInwM";
        }
        if (resumeFrom == null) {
            try {
                IResumeSource iResumeSource = ResumeSourceFactory.getLocalInstance(ctx);
                ResumeSourceCollection resumeSourceCollection = iResumeSource.getResumeSourceCollection("where name like '%" + resume_from + "%'");
                if (null != resumeSourceCollection && resumeSourceCollection.size() > 0) {
                    ResumeSourceInfo resumeSourceInfo = resumeSourceCollection.get(0);
                    resumeFrom = resumeSourceInfo.getId().toString();
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (resumeFrom == null) {
            resumeFrom = "mRygJobOQICqYY2Ida4TLwMifAw=";
        }
        try {
            ResumeSourceCollection resumeSourceCol = ResumeSourceFactory.getLocalInstance(ctx).getResumeSourceCollection("select id,name where id = '" + resumeFrom + "'");
            if (resumeSourceCol.size() > 0) {
                ResumeSourceInfo resumeSourceInfo = resumeSourceCol.get(0);
                return resumeSourceInfo;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static int getTall(String tallStr) {
        int strInt = 0;
        String intString = "";
        if (tallStr != null && !"".equals(tallStr)) {
            for (int i = 0; i < tallStr.length() && tallStr.charAt(i) >= '0' && tallStr.charAt(i) <= '9'; ++i) {
                intString = intString + tallStr.charAt(i);
            }
            strInt = "".equals(intString) ? 0 : Integer.parseInt(intString);
        }
        return strInt;
    }

    public static String getSimplePersonFlag() {
        String s = UUID.randomUUID().toString();
        return s.replace("-", "");
    }

    public static void checkResumeIsInPersonBlackList(Context ctx, ResumeBaseRecInfo resume) throws BOSException {
        IPersonBlackList ipBlack;
        PersonBlackListCollection personBlackListColl;
        String passport;
        String idCard = resume.getIdentityCardNo();
        PersonBlackListCollection personBlackListCollection = ResumeConvertUtil.checkResumeIsInPersonBlackList(ctx, idCard, passport = resume.getPassportNo(), resume.getMobilePhone(), resume.getName());
        if (!RecDBUtils.isEmpty((IObjectCollection)personBlackListCollection)) {
            PersonBlackListInfo personInfo = personBlackListCollection.get(0);
            int source = personInfo.getSource().getValue();
            if (source == 6 || source == 3) {
                resume.setIsBlackList(IsOrNotEnum.REMOVE);
            } else {
                resume.setIsBlackList(IsOrNotEnum.YES);
            }
            resume.setToBlackListReason(personInfo.getJoinReason());
            resume.setJoinBlackComment(personInfo.getRema());
            resume.setJoinBlackDate(personInfo.getJoinDate());
            resume.setAddPersonName(personInfo.getAddPersonName());
            resume.put("repeatBlackListInfo", personInfo);
            personBlackListCollection.clear();
            personBlackListCollection.add(personInfo);
            AddSimilarResultService.getInstance().addBlacklistResult(ctx, personBlackListCollection, resume, SimilarPersonType.REPEATBLACKLIST);
        } else {
            PersonBlackListHisCollection personBlackListHisCollection = ResumeConvertUtil.checkResumeIsInPersonBlackListHis(ctx, idCard, passport, resume.getMobilePhone(), resume.getName(), "2");
            if (!RecDBUtils.isEmpty((IObjectCollection)personBlackListHisCollection)) {
                PersonBlackListHisInfo personHisInfo = personBlackListHisCollection.get(0);
                resume.setIsBlackList(IsOrNotEnum.REMOVE);
                resume.setOutBlackPerson(personHisInfo.getPersonName());
                resume.setOutBlackComment(personHisInfo.getRema());
                resume.setOutBlackDate(personHisInfo.getOpDate());
            } else {
                resume.setIsBlackList(IsOrNotEnum.NO);
            }
        }
        if (resume.getIsBlackList().getValue() == 0 && resume.getId() != null && (personBlackListColl = (ipBlack = PersonBlackListFactory.getLocalInstance((Context)ctx)).getPersonBlackListCollection("where resumeNumber = '" + resume.getId().toString() + "' and source = 5")).size() > 0) {
            resume.setIsBlackList(IsOrNotEnum.YES);
        }
    }

    public static void checkResumeIsInPersonBlackList(Context ctx, EnterpriseArchivesInfo resume) throws BOSException {
        String passport;
        String idCard = resume.getIdentityCardNo();
        PersonBlackListCollection personBlackListCollection = ResumeConvertUtil.checkResumeIsInPersonBlackList(ctx, idCard, passport = resume.getPassportNo(), resume.getMobilePhone(), resume.getName());
        if (!RecDBUtils.isEmpty((IObjectCollection)personBlackListCollection)) {
            PersonBlackListInfo personInfo = personBlackListCollection.get(0);
            int source = personInfo.getSource().getValue();
            if (source == 6 || source == 3) {
                resume.setIsBlackList(IsOrNotEnum.REMOVE);
            } else {
                resume.setIsBlackList(IsOrNotEnum.YES);
            }
            resume.setToBlackListReason(personInfo.getJoinReason());
            resume.setJoinBlackListRema(personInfo.getRema());
            resume.setJoinBlackDate(personInfo.getJoinDate());
            resume.setAddPersonName(personInfo.getAddPersonName());
            resume.put("repeatBlackListInfo", personInfo);
            if (personInfo.getSource() != SourceEnum.RECURITMENT_ADD) {
                personBlackListCollection.clear();
                personBlackListCollection.add(personInfo);
                AddSimilarResultService.getInstance().addBlacklistResult(ctx, personBlackListCollection, resume, SimilarPersonType.REPEATBLACKLIST);
            }
        } else {
            PersonBlackListHisCollection personBlackListHisCollection = ResumeConvertUtil.checkResumeIsInPersonBlackListHis(ctx, idCard, passport, resume.getMobilePhone(), resume.getName(), "2");
            if (!RecDBUtils.isEmpty((IObjectCollection)personBlackListHisCollection)) {
                PersonBlackListHisInfo personHisInfo = personBlackListHisCollection.get(0);
                resume.setIsBlackList(IsOrNotEnum.REMOVE);
                resume.setRemvoeBlackReason(personHisInfo.getRema());
                resume.setOutBlackDate(personHisInfo.getOpDate());
            } else {
                resume.setIsBlackList(IsOrNotEnum.NO);
            }
        }
    }

    @Deprecated
    private static PersonBlackListInfo checkResumeIsInPersonBlackList(Context ctx, String idCard, String passport) throws BOSException {
        StringBuilder filterCondition = new StringBuilder();
        if (!RecDBUtils.isEmpty(idCard)) {
            filterCondition.append("idCardNO = '" + idCard + "'");
        }
        if (!RecDBUtils.isEmpty(passport)) {
            if (filterCondition.length() > 0) {
                filterCondition.append(" OR ");
            }
            filterCondition.append("passportNO = '" + passport + "'");
        }
        if (filterCondition.length() <= 0) {
            return null;
        }
        PersonBlackListCollection personColl = PersonBlackListFactory.getLocalInstance((Context)ctx).getPersonBlackListCollection("where " + filterCondition.toString());
        if (!RecDBUtils.isEmpty((IObjectCollection)personColl)) {
            return personColl.get(0);
        }
        return null;
    }

    public static PersonBlackListCollection checkResumeIsInPersonBlackList(Context ctx, String idCard, String passport, String mobile, String name) throws BOSException {
        StringBuilder filterCondition = new StringBuilder();
        IPersonBlackList iPersonBlackList = PersonBlackListFactory.getLocalInstance((Context)ctx);
        if (!RecDBUtils.isEmpty(idCard)) {
            filterCondition.append("idCardNO = '" + idCard + "'");
        }
        if (!RecDBUtils.isEmpty(passport)) {
            if (filterCondition.length() > 0) {
                filterCondition.append(" OR ");
            }
            filterCondition.append("passportNO = '" + passport + "'");
        }
        if (!RecDBUtils.isEmpty(mobile) && !RecDBUtils.isEmpty(name)) {
            if (filterCondition.length() > 0) {
                filterCondition.append(" OR ");
            }
            filterCondition.append("(mobile = '" + mobile + "' and personName ='" + name + "')");
        }
        if (filterCondition.length() <= 0) {
            return null;
        }
        filterCondition.append(" order by createTime desc ");
        PersonBlackListCollection personColl = iPersonBlackList.getPersonBlackListCollection("where " + filterCondition.toString());
        return personColl;
    }

    public static PersonBlackListHisCollection checkResumeIsInPersonBlackListHis(Context ctx, String idCard, String passport, String mobile, String name, String value) throws BOSException {
        IPersonBlackListHis iPersonBlackListHis = PersonBlackListHisFactory.getLocalInstance((Context)ctx);
        StringBuilder filterCondition = new StringBuilder();
        if (!RecDBUtils.isEmpty(idCard)) {
            filterCondition.append("idCardNO = '" + idCard + "'");
        }
        if (!RecDBUtils.isEmpty(passport)) {
            if (filterCondition.length() > 0) {
                filterCondition.append(" OR ");
            }
            filterCondition.append("passportNO = '" + passport + "'");
        }
        if (!RecDBUtils.isEmpty(mobile) && !RecDBUtils.isEmpty(name)) {
            if (filterCondition.length() > 0) {
                filterCondition.append(" OR ");
            }
            filterCondition.append("(mobile = '" + mobile + "' and blackName ='" + name + "')");
        }
        if (filterCondition.length() <= 0) {
            return null;
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            filterCondition.append(" AND opType = '2'");
        }
        filterCondition.append(" order by createTime desc ");
        PersonBlackListHisCollection perHisCollection = iPersonBlackListHis.getPersonBlackListHisCollection("where " + filterCondition.toString());
        return perHisCollection;
    }

    public static PersonBlackListCollection findBlackListByUniqueId(Context ctx, String uuid) throws BOSException {
        PersonBlackListCollection personCollection = null;
        IPersonBlackList ipBlack = PersonBlackListFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((CharSequence)uuid)) {
            String sql_01 = "SELECT FIdentityCardNo from  T_REC_ResumeBaseRec WHERE  (FIfSimplePerson = '" + uuid + "' and FIdentityCardNo is not null) union SELECT FIdentityCardNo from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FIdentityCardNo is not null and FState = '1')";
            String sql_02 = "SELECT FPassportNo from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FPassportNo is not null union SELECT FPassportNo from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FPassportNo is not null and FState = '1')";
            String sql_03 = "SELECT FID from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "'union SELECT FID from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FState = '1')";
            String sql_04 = "SELECT FMobilePhone from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FMobilePhone is not null union SELECT FMobilePhone from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FMobilePhone is not null and FState = '1')";
            String sql_05 = "SELECT FName from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FName is not null union SELECT FName from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FName is not null and FState = '1')";
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("idCardNo", (Object)sql_01, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("passPortNo", (Object)sql_02, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("resumeNumber", (Object)sql_03, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("mobile", (Object)sql_04, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("personName", (Object)sql_05, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("source", (Object)6, CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("source", (Object)3, CompareType.NOTEQUALS));
            filter.setMaskString("(#0 OR #1 OR #2 OR (#3 AND #4)) AND #5 AND #6");
            entityViewInfo.setFilter(filter);
            SorterItemCollection sortColl = entityViewInfo.getSorter();
            SorterItemInfo sortInfo = new SorterItemInfo("createTime");
            sortInfo.setSortType(SortType.DESCEND);
            sortColl.add(sortInfo);
            SelectorItemCollection sic = entityViewInfo.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("joinReason.name"));
            personCollection = ipBlack.getPersonBlackListCollection(entityViewInfo);
        }
        return personCollection;
    }

    public static PersonBlackListHisCollection findBlackListHisByUniqueId(Context ctx, String uuid) throws BOSException {
        PersonBlackListHisCollection personHisCollection = null;
        IPersonBlackListHis ipBlack = PersonBlackListHisFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((CharSequence)uuid)) {
            String sql_01 = "SELECT FIdentityCardNo from  T_REC_ResumeBaseRec WHERE  (FIfSimplePerson = '" + uuid + "' and FIdentityCardNo is not null) union SELECT FIdentityCardNo from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FIdentityCardNo is not null and FState = '1')";
            String sql_02 = "SELECT FPassportNo from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FPassportNo is not null union SELECT FPassportNo from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FPassportNo is not null and FState = '1')";
            String sql_03 = "SELECT FID from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "'union SELECT FID from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FState = '1')";
            String sql_04 = "SELECT FMobilePhone from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FMobilePhone is not null union SELECT FMobilePhone from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FMobilePhone is not null and FState = '1')";
            String sql_05 = "SELECT FName from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FName is not null union SELECT FName from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FName is not null and FState = '1')";
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("idCardNo", (Object)sql_01, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("passPortNo", (Object)sql_02, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("resumeNumber", (Object)sql_03, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("mobile", (Object)sql_04, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("blackName", (Object)sql_05, CompareType.INNER));
            filter.setMaskString("#0 OR #1 OR #2 OR (#3 AND #4)");
            entityViewInfo.setFilter(filter);
            SorterItemCollection sortColl = entityViewInfo.getSorter();
            SorterItemInfo sortInfo = new SorterItemInfo("createTime");
            sortInfo.setSortType(SortType.ASCEND);
            sortColl.add(sortInfo);
            SelectorItemCollection sic = entityViewInfo.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("joinReason.name"));
            personHisCollection = ipBlack.getPersonBlackListHisCollection(entityViewInfo);
        }
        return personHisCollection;
    }

    public static PersonBlackListHisCollection findBlackListHisByUniqueId(Context ctx, String uuid, String value) throws BOSException {
        PersonBlackListHisCollection personHisCollection = null;
        IPersonBlackListHis ipBlack = PersonBlackListHisFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((CharSequence)uuid)) {
            String sql_01 = "SELECT FIdentityCardNo from  T_REC_ResumeBaseRec WHERE  (FIfSimplePerson = '" + uuid + "' and FIdentityCardNo is not null) union SELECT FIdentityCardNo from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FIdentityCardNo is not null and FState = '1')";
            String sql_02 = "SELECT FPassportNo from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FPassportNo is not null union SELECT FPassportNo from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FPassportNo is not null and FState = '1')";
            String sql_03 = "SELECT FID from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "'union SELECT FID from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FState = '1')";
            String sql_04 = "SELECT FMobilePhone from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FMobilePhone is not null union SELECT FMobilePhone from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FMobilePhone is not null and FState = '1')";
            String sql_05 = "SELECT FName from  T_REC_ResumeBaseRec WHERE FIfSimplePerson = '" + uuid + "' and FName is not null union SELECT FName from  T_REC_EnterpriseArchives  WHERE  (FUniqId = '" + uuid + "' and FName is not null and FState = '1')";
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("idCardNo", (Object)sql_01, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("passPortNo", (Object)sql_02, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("resumeNumber", (Object)sql_03, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("mobile", (Object)sql_04, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("blackName", (Object)sql_05, CompareType.INNER));
            filter.getFilterItems().add(new FilterItemInfo("opType", (Object)value, CompareType.EQUALS));
            filter.setMaskString("(#0 OR #1 OR #2 OR (#3 AND #4)) AND #5");
            entityViewInfo.setFilter(filter);
            SorterItemCollection sortColl = entityViewInfo.getSorter();
            SorterItemInfo sortInfo = new SorterItemInfo("createTime");
            sortInfo.setSortType(SortType.DESCEND);
            sortColl.add(sortInfo);
            SelectorItemCollection sic = entityViewInfo.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("creator.name"));
            sic.add(new SelectorItemInfo("joinReason.name"));
            personHisCollection = ipBlack.getPersonBlackListHisCollection(entityViewInfo);
        }
        return personHisCollection;
    }

    @Deprecated
    private static PersonBlackListHisInfo checkResumeIsInPersonBlackListHis(Context ctx, String idCard, String passport) throws BOSException {
        StringBuilder filterCondition = new StringBuilder();
        if (!RecDBUtils.isEmpty(idCard)) {
            filterCondition.append("idCardNO = '" + idCard + "'");
        }
        if (!RecDBUtils.isEmpty(passport)) {
            if (filterCondition.length() > 0) {
                filterCondition.append(" OR ");
            }
            filterCondition.append("passportNO = '" + passport + "'");
        }
        if (filterCondition.length() <= 0) {
            return null;
        }
        filterCondition.append(" AND opType = '2'");
        PersonBlackListHisCollection personColl = PersonBlackListHisFactory.getLocalInstance((Context)ctx).getPersonBlackListHisCollection("where " + filterCondition.toString());
        if (!RecDBUtils.isEmpty((IObjectCollection)personColl)) {
            return personColl.get(0);
        }
        return null;
    }

    public static void deleteSimilarPersonRecord(Context ctx, HRBillBaseInfo resume) {
        String sql = "delete from  t_rec_similarPerson  where  FResumeId=? or FArchivesId in  (SELECT archives.FID  FROM T_REC_EnterpriseArchives archives join  T_REC_RESUMEBASEREC resume on resume.FIFSIMPLEPERSON =archives.FUNIQID where archives.FSTATE ='1' and resume.FID =?)";
        Object[] params = new Object[]{resume.getId() == null ? " " : resume.getId().toString(), resume.getId() == null ? " " : resume.getId().toString()};
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private static String makeEnterpriseArchivesInfoNumber(Context ctx) throws BOSException {
        String number = "JL" + new SimpleDateFormat("yyyyMMdd").format(new Date());
        Object object = archiveNumberLock;
        synchronized (object) {
            int maxNumber = 0;
            EnterpriseArchivesCollection archivesColl = null;
            try {
                archivesColl = EnterpriseArchivesFactory.getLocalInstance(ctx).getEnterpriseArchivesCollection("where number like '" + number + "%'");
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            if (!RecDBUtils.isEmpty((IObjectCollection)archivesColl)) {
                Iterator archIter = archivesColl.iterator();
                EnterpriseArchivesInfo archives = null;
                while (archIter.hasNext()) {
                    archives = (EnterpriseArchivesInfo)archIter.next();
                    int archNumber = Integer.parseInt(archives.getNumber().substring(10));
                    if (archNumber <= maxNumber) continue;
                    maxNumber = archNumber;
                }
            }
            number = ++maxNumber < 10 ? number + "0" + maxNumber : number + maxNumber;
        }
        return number;
    }

    public static void smartFiltrate(Context ctx, ResumeBaseRecInfo resume) {
        resume.setArtificialSelectionResult(ResumeConvertUtil.doFiltrate(ctx, resume.getRecuritmentDemand(), resume));
    }

    private static SelectionResultEnum doFiltrate(Context ctx, RecuritmentDemandInfo demand, ResumeBaseRecInfo resume) {
        int sex;
        if (demand == null) {
            return SelectionResultEnum.NOTFILTER;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("hDegree"));
        evi.getSelector().add(new SelectorItemInfo("filterCriteria.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)demand.getId().toString(), CompareType.EQUALS));
        evi.setFilter(filter);
        try {
            RecuritmentDemandCollection demandColl = RecuritmentDemandFactory.getLocalInstance(ctx).getRecuritmentDemandCollection(evi);
            if (!RecDBUtils.isEmpty((IObjectCollection)demandColl)) {
                demand = demandColl.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return SelectionResultEnum.NOTFILTER;
        }
        FilterCriteriaInfo info = demand.getFilterCriteria();
        if (info == null) {
            return SelectionResultEnum.NOTFILTER;
        }
        boolean isNoFilter = false;
        if (info.getLowAge() != null || info.getHighAge() != null) {
            int resumeAge = resume.getAge();
            if (resumeAge > 0) {
                if (info.getLowAge() != null) {
                    int lowAge;
                    int n = lowAge = info.getLowAge().getValue() <= 0 ? 16 : info.getLowAge().getValue();
                    if (lowAge > resumeAge) {
                        return SelectionResultEnum.NOTPASS;
                    }
                }
                if (info.getHighAge() != null) {
                    int highAge;
                    int n = highAge = info.getHighAge().getValue() <= 0 ? 80 : info.getHighAge().getValue();
                    if (highAge < resumeAge) {
                        return SelectionResultEnum.NOTPASS;
                    }
                }
            } else if (!(info.getLowAge() == null || info.getHighAge() == null || WorkAgeEnum.NOLIMIT.equals((Object)info.getLowAge()) && WorkAgeEnum.NOLIMIT.equals((Object)info.getHighAge()))) {
                isNoFilter = true;
            }
        }
        if (0 != (sex = info.getSex().getValue())) {
            if (resume.getGender() == null) {
                isNoFilter = true;
            } else {
                int resumeSex = resume.getGender().getValue();
                if (resumeSex != sex) {
                    return SelectionResultEnum.NOTPASS;
                }
            }
        }
        if (info.getLowWorkYears() != null || info.getHighWorkYears() != null) {
            String workSeniority = resume.getWorkSeniority();
            if (!StringUtils.isEmpty((CharSequence)workSeniority) && number.matcher(workSeniority).matches()) {
                int highWork;
                int lowWork;
                double resumeExp = Double.parseDouble(workSeniority);
                if (info.getLowWorkYears() != null && !WorkYearEnum.NOLIMIT.equals((Object)info.getLowWorkYears()) && (double)(lowWork = info.getLowWorkYears().getValue()) - resumeExp > 0.0) {
                    return SelectionResultEnum.NOTPASS;
                }
                if (info.getHighWorkYears() != null && !WorkYearEnum.NOLIMIT.equals((Object)info.getHighWorkYears()) && (double)(highWork = info.getHighWorkYears().getValue()) - resumeExp < 0.0) {
                    return SelectionResultEnum.NOTPASS;
                }
            } else if (!(info.getLowWorkYears() == null || info.getHighWorkYears() == null || WorkYearEnum.NOLIMIT.equals((Object)info.getLowWorkYears()) && WorkYearEnum.NOLIMIT.equals((Object)info.getHighWorkYears()))) {
                isNoFilter = true;
            }
        }
        if ((resume.getHDegree() == null || resume.getHDegree().getId() == null) && resume != null && resume.getId() != null) {
            evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("hDegree.id"));
            evi.getSelector().add(new SelectorItemInfo("hDegree.name"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)resume.getId().toString(), CompareType.EQUALS));
            evi.setFilter(filter);
            try {
                ResumeBaseRecCollection resumeBaseRecCollection = ResumeBaseRecFactory.getLocalInstance(ctx).getResumeBaseRecCollection(evi);
                if (!RecDBUtils.isEmpty((IObjectCollection)resumeBaseRecCollection)) {
                    resume = resumeBaseRecCollection.get(0);
                }
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        }
        if ((info.isDegreeNoLimit() || demand.getHDegree() == null) && !isNoFilter) {
            return SelectionResultEnum.PASS;
        }
        if (demand.getHDegree() == null || demand.getHDegree().getId() == null || resume.getHDegree() == null || resume.getHDegree().getId() == null) {
            isNoFilter = true;
        } else {
            DiplomaInfo demandDiploma = null;
            DiplomaInfo resumeDiploma = null;
            try {
                IDiploma iDiploma = DiplomaFactory.getLocalInstance((Context)ctx);
                demandDiploma = iDiploma.getDiplomaInfo("where id = '" + demand.getHDegree().getId().toString() + "'");
                resumeDiploma = iDiploma.getDiplomaInfo("where id = '" + resume.getHDegree().getId().toString() + "'");
                int i = resumeDiploma.getLevelCode() - demandDiploma.getLevelCode();
                if (info.isDegreeAbove() && i < 0) {
                    return SelectionResultEnum.NOTPASS;
                }
                if (!info.isDegreeAbove() && i != 0) {
                    return SelectionResultEnum.NOTPASS;
                }
                isNoFilter = false;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return SelectionResultEnum.NOTFILTER;
            }
        }
        if (isNoFilter) {
            return SelectionResultEnum.NOTFILTER;
        }
        return SelectionResultEnum.PASS;
    }

    public static void addRecRegisterByResume(Context ctx, ResumeBaseRecInfo resume) throws BOSException {
        RecRegisterInfo newRecRegister = new RecRegisterInfo();
        PreEntryPersonInfo personInfo = new PreEntryPersonInfo();
        personInfo.setName(resume.getName());
        personInfo.setIdCardNO(resume.getIdentityCardNo());
        personInfo.setPassportNO(resume.getPassportNo());
        personInfo.setBirthday(resume.getBirthday());
        personInfo.setGender(resume.getGender());
        personInfo.setNativePlace(resume.getNativePlace());
        personInfo.setHighestDegree(resume.getHDegree());
        personInfo.setNationality(resume.getNational());
        personInfo.setFolk(resume.getFolk());
        personInfo.setWed(resume.getWed());
        personInfo.setPoliticalFace(resume.getPoliticalFace());
        personInfo.setJobStartDate(resume.getWorkDate());
        PersonInfo person = new PersonInfo();
        String personId = BOSUuid.create((BOSObjectType)person.getBOSType()).toString();
        person.setId(BOSUuid.read((String)personId));
        personInfo.setPerson(person);
        try {
            IObjectPK personPK = PreEntryPersonFactory.getLocalInstance((Context)ctx).addnew(personInfo);
            personInfo.setId(BOSUuid.read((String)personPK.toString()));
            String cellPhone = resume.getMobilePhone();
            String email = resume.getEmail();
            newRecRegister.setCellPhone(cellPhone);
            newRecRegister.setEmail(email);
            newRecRegister.setTalent(personInfo);
            newRecRegister.setRecRegisterState(RecRegisterStateEnum.NOREGISTER);
            newRecRegister.setName(resume.getName());
            BOSUuid id = BOSUuid.create((BOSObjectType)new RecRegisterInfo().getBOSType());
            newRecRegister.setId(id);
            newRecRegister.setResumeBaseRec(resume);
            newRecRegister.setIsLatest(true);
            newRecRegister.setIsSendLogin(false);
            newRecRegister.setNeedSendEmail(false);
            newRecRegister.setNeedSendSms(false);
            newRecRegister.setNumber(System.currentTimeMillis() + "");
            newRecRegister.setRecRegisterState(RecRegisterStateEnum.NOREGISTER);
            RecRegisterFactory.getLocalInstance(ctx).addnew(newRecRegister);
            new ResumeSyncToPEPersonService().syncResumeToPEPerson(ctx, newRecRegister.getTalent(), resume);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException(e.getMessage());
        }
    }

    public static RecuritmentHeadInfo getRecuritmentHead(Context ctx) {
        try {
            RecuritmentHeadInfo info = new RecuritmentHeadInfo();
            PersonInfo person = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()));
            info.setPerson(personInfo);
            info.setName(personInfo.getName());
            info.setMobilePhone(personInfo.getCell());
            info.setEmail(personInfo.getEmail());
            info.setOfficePhone(personInfo.getOfficePhone());
            IObjectPK pk = RecuritmentHeadFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            return info;
        }
        catch (Exception e) {
            logger.error((Object)"****************\u6839\u636e\u5f53\u524d\u7528\u6237\u751f\u6210\u62db\u8058\u8d1f\u8d23\u4eba\u5931\u8d25*********");
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static RecuritmentHeadInfo getRecuritmentHead(Context ctx, PersonInfo person) {
        try {
            RecuritmentHeadInfo info = new RecuritmentHeadInfo();
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(person.getId()));
            info.setPerson(personInfo);
            info.setName(personInfo.getName());
            info.setMobilePhone(personInfo.getCell());
            info.setEmail(personInfo.getEmail());
            info.setOfficePhone(personInfo.getOfficePhone());
            IObjectPK pk = RecuritmentHeadFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
            return info;
        }
        catch (Exception e) {
            logger.error((Object)"****************\u6839\u636e\u5458\u5de5\u751f\u6210\u8d1f\u8d23\u4eba\u751f\u6210\u62db\u8058\u8d1f\u8d23\u4eba\u5931\u8d25*********");
            logger.error((Object)e.getMessage());
            return null;
        }
    }
}

