/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.convert;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.shr.recuritment.app.bo.WxTemplateItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TemplateTransformUtil {
    private static final String leftFlag = "[[";
    private static final String rightFlag = "]]";
    private static final String msgLeftFlag = "{{";
    private static final String msgRightFlag = "}}";

    public static String transformEmailTemplate(Context ctx, String template, Map<String, String> dataMap) {
        if (template == null) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int startIndex = template.indexOf(leftFlag);
        int endIndex = template.indexOf(rightFlag, startIndex + 1);
        while (endIndex > 0 && startIndex >= 0) {
            if (template.indexOf(leftFlag, startIndex + 2) == -1 || endIndex < template.indexOf(leftFlag, startIndex + 1)) {
                String variable = template.substring(startIndex, endIndex + 2);
                String variableVal = TemplateTransformUtil.transformVariable(variable, dataMap);
                if (variable != null && variableVal != null) {
                    map.put(variable, variableVal);
                }
                startIndex = template.indexOf(leftFlag, startIndex + 1);
                endIndex = template.indexOf(rightFlag, startIndex + 1);
                continue;
            }
            startIndex = template.indexOf(leftFlag, startIndex + 1);
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            template = template.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return template;
    }

    public static String transformEmailMainTemplate(Context ctx, String template, Map<String, String> dataMap) {
        if (template == null) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int startIndex = template.indexOf(leftFlag);
        int endIndex = template.indexOf(rightFlag, startIndex + 1);
        while (endIndex > 0) {
            if (template.indexOf(leftFlag, startIndex + 2) == -1 || endIndex < template.indexOf(leftFlag, startIndex + 1)) {
                String variable = template.substring(startIndex, endIndex + 2);
                String variableVal = TemplateTransformUtil.transformVariable(variable, dataMap);
                if (variable != null && variableVal != null) {
                    map.put(variable, variableVal);
                }
                startIndex = template.indexOf(leftFlag, startIndex + 1);
                endIndex = template.indexOf(rightFlag, startIndex + 1);
                continue;
            }
            startIndex = template.indexOf(leftFlag, startIndex + 1);
        }
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            template = template.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return template;
    }

    public static String transformSmsTemplate(Context ctx, String template, Map<String, String> dataMap) {
        if (template == null || "".equals(template.trim())) {
            return "";
        }
        ArrayList<String> variables = new ArrayList<String>();
        int startIndex = template.indexOf(leftFlag);
        int endIndex = template.indexOf(rightFlag);
        String variable = null;
        String variableVal = null;
        while (endIndex > 0 && startIndex > 0) {
            if (template.indexOf(leftFlag, startIndex + 2) == -1 || endIndex < template.indexOf(leftFlag, startIndex + 1)) {
                variable = template.substring(startIndex, endIndex + 2);
                if (!variable.equals(variableVal = TemplateTransformUtil.transformVariable(variable, dataMap))) {
                    if (StringUtils.isEmpty((String)variableVal)) {
                        variableVal = " ";
                    }
                    variables.add(variableVal);
                }
                startIndex = template.indexOf(leftFlag, startIndex + 1);
                endIndex = template.indexOf(rightFlag, startIndex + 1);
                continue;
            }
            startIndex = template.indexOf(leftFlag, startIndex + 1);
        }
        StringBuilder sms = new StringBuilder();
        for (int i = 0; i < variables.size(); ++i) {
            if (i == variables.size() - 1) {
                variables.set(i, "\uff08" + (String)variables.get(i) + "\uff09");
            }
            if (i > 0) {
                sms.append("|");
            }
            sms.append(((String)variables.get(i)).replace("|", " "));
        }
        String context = sms.toString();
        return StringUtils.isEmpty((String)context) ? context : context.replaceAll("&amp;", "&");
    }

    public static String transformVariable(String variable, Map<String, String> dataMap) {
        if (variable == null) {
            return "";
        }
        String value = dataMap.get(variable);
        if (value != null) {
            return value;
        }
        return "";
    }

    public static String transformWXMessageTemplate(Context ctx, String content, Map<String, String> dataMap) {
        if (content == null) {
            return "";
        }
        HashMap<String, WxTemplateItem> map = new HashMap<String, WxTemplateItem>();
        map.put("first", new WxTemplateItem(TemplateTransformUtil.removeHtmlLabel(dataMap.get("first"))));
        int startIndex = content.indexOf(msgLeftFlag);
        int endIndex = content.indexOf(msgRightFlag, startIndex + 1);
        while (endIndex > 0 && startIndex >= 0) {
            if (content.indexOf(msgLeftFlag, startIndex + 2) == -1 || endIndex < content.indexOf(msgLeftFlag, startIndex + 1)) {
                String variable = content.substring(startIndex, endIndex + 2);
                variable = variable.substring(0, variable.indexOf(".")).replace(msgLeftFlag, "");
                String variableVal = TemplateTransformUtil.transformVariable(variable, dataMap);
                if (variable != null && variableVal != null) {
                    map.put(variable, new WxTemplateItem(variableVal));
                }
                startIndex = content.indexOf(msgLeftFlag, startIndex + 1);
                endIndex = content.indexOf(msgRightFlag, startIndex + 1);
                continue;
            }
            startIndex = content.indexOf(msgLeftFlag, startIndex + 1);
        }
        map.put("remark", new WxTemplateItem(TemplateTransformUtil.removeHtmlLabel(dataMap.get("remark"))));
        HashMap<String, Object> data = new HashMap<String, Object>();
        String url = dataMap.get("url");
        if (!StringUtils.isEmpty((String)url)) {
            data.put("url", url);
        }
        data.put("data", map);
        return JSON.toJSONString(data);
    }

    public static String removeHtmlLabel(String content) {
        if (!StringUtils.isEmpty((String)content)) {
            content = content.replaceAll("<p>", "").replaceAll("</p>", "").replaceAll("&nbsp;", "").replaceAll("<br/>", "").replaceAll(" ", "").trim();
        }
        return content;
    }
}

