/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.db;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.jdbc.rowset.impl.SerialClob;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.recuritment.CloudServiceURLConfigCollection;
import com.kingdee.shr.recuritment.CloudServiceURLConfigFactory;
import com.kingdee.shr.recuritment.DemandWorkAreaCollection;
import com.kingdee.shr.recuritment.DemandWorkAreaFactory;
import com.kingdee.shr.recuritment.DemandWorkAreaInfo;
import com.kingdee.shr.recuritment.RecSyncLockEntityType;
import com.kingdee.shr.recuritment.RecSyncLockFactory;
import com.kingdee.shr.recuritment.app.bo.ObjectBase;
import com.kingdee.shr.recuritment.app.util.FileUtil;
import com.kingdee.shr.recuritment.app.util.HttpUtil;
import com.kingdee.shr.recuritment.app.util.StreamReleaseUtil;
import com.kingdee.shr.recuritment.utils.CloudServiceUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class RecDBUtils {
    private static Logger logger = Logger.getLogger(RecDBUtils.class);
    private static final int MAX_DATA_ROW = 8000;

    public static List<Object[]> getQueryData(IRowSet rs) throws SQLException {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(rs.size());
        if (rs != null) {
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                int count = rsmd.getColumnCount();
                while (rs.next()) {
                    Object[] datas = new Object[count];
                    for (int i = 0; i < count; ++i) {
                        datas[i] = rs.getObject(i + 1);
                    }
                    dataList.add(datas);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                rs.close();
                rs = null;
            }
        }
        return dataList;
    }

    public static List<Object[]> getQueryData(Context ctx, String sql, Object[] params) throws SQLException, BOSException {
        if (RecDBUtils.isEmpty(sql)) {
            throw new NullPointerException("sql is empty or null...");
        }
        IRowSet rs = null;
        rs = params != null ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params) : DbUtil.executeQuery((Context)ctx, (String)sql);
        return RecDBUtils.getQueryData(rs);
    }

    public static List<Object[]> getPagingQueryData(Context ctx, String sql, Object[] params, int page, int rows) throws BOSException, SQLException {
        return RecDBUtils.getQueryData(ctx, RecDBUtils.convertPageSql(ctx, sql, page, rows), params);
    }

    public static String convertPageSql(Context ctx, String sourceSql, int page, int rows) throws SQLException, BOSException {
        if (RecDBUtils.isEmpty(sourceSql)) {
            throw new NullPointerException("sourceSql is empty or null...");
        }
        sourceSql = sourceSql.toLowerCase();
        String afterPagingSql = "";
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            PagingHelper pageHelper = new PagingHelper();
            int length = rows;
            String countSql = "SELECT COUNT(1) FROM (" + sourceSql + ") AS B";
            List<Object[]> datas = RecDBUtils.getQueryData(ctx, countSql, null);
            Object countObj = datas.get(0)[0];
            int totalCount = 0;
            totalCount = countObj instanceof BigDecimal ? ((BigDecimal)countObj).intValue() : ((Integer)countObj).intValue();
            if (page * rows > totalCount) {
                length = totalCount - (page - 1) * rows;
            }
            sourceSql = sourceSql.replaceFirst("select", "SELECT TOP " + String.valueOf((page - 1) * rows + length));
            afterPagingSql = pageHelper.getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), sourceSql.toString(), (page - 1) * rows, length);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return afterPagingSql.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeBatch(Context ctx, String sql, List<Object[]> paramsList) throws BOSException {
        PreparedStatement stmt;
        Connection conn;
        block9: {
            conn = null;
            stmt = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                if (!RecDBUtils.isEmpty(paramsList)) {
                    int k = 1;
                    boolean flag = false;
                    for (int i = 0; i < paramsList.size(); ++i) {
                        Object[] params = paramsList.get(i);
                        for (int j = 0; j < params.length; ++j) {
                            stmt.setObject(j + 1, params[j]);
                        }
                        stmt.addBatch();
                        if (i == k * 8000) {
                            stmt.executeBatch();
                            flag = true;
                            stmt.clearBatch();
                        }
                        if (i <= k * 8000 || !flag) continue;
                        ++k;
                        flag = false;
                    }
                    if (!flag) {
                        stmt.executeBatch();
                    }
                    break block9;
                }
                stmt.execute(sql);
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(stmt, (Connection)conn);
                    throw throwable;
                }
                SQLUtils.cleanup((Statement)stmt, (Connection)conn);
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    public static String[] parseFieldByLanguage(Context context, String ... fields) {
        int len = fields.length;
        if (len <= 0) {
            throw new IllegalArgumentException("Too few arguments");
        }
        String[] parseFields = new String[len];
        String language = context.getOriginLocale().getLanguage() + "_" + context.getOriginLocale().getCountry();
        for (int i = 0; i < len; ++i) {
            String field = fields[i];
            parseFields[i] = field = RecDBUtils.parseField(language, field);
        }
        return parseFields;
    }

    private static String parseField(String language, String field) {
        field = StringUtils.capitalize((String)field);
        StringBuilder sb = new StringBuilder("F");
        sb.append(field);
        if ("zh_CN".equals(language)) {
            sb.append("_l2");
        } else if ("zh_TW".equals(language)) {
            sb.append("_l3");
        } else {
            sb.append("_l1");
        }
        return sb.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialBlobToByteAry(SerialBlob blob) throws IOException, SQLException {
        InputStream fileStream;
        byte[] byteAry;
        block8: {
            if (blob == null) {
                return null;
            }
            byteAry = null;
            fileStream = null;
            ByteArrayOutputStream bos = null;
            try {
                fileStream = blob.getBinaryStream();
                bos = new ByteArrayOutputStream();
                byte[] buf = new byte[10240];
                int len = -1;
                while ((len = fileStream.read(buf)) != -1) {
                    bos.write(buf, 0, len);
                }
                bos.flush();
                byteAry = bos.toByteArray();
                if (bos == null) break block8;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                    catch (IOException e2) {
                        logger.error((Object)e2.getMessage(), (Throwable)e2);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (bos != null) {
                        StreamReleaseUtil.safeClose(bos);
                    }
                    if (fileStream == null) throw throwable;
                    StreamReleaseUtil.safeClose(fileStream);
                    throw throwable;
                }
            }
            StreamReleaseUtil.safeClose(bos);
        }
        if (fileStream == null) return byteAry;
        StreamReleaseUtil.safeClose(fileStream);
        return byteAry;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] serialBlobToByteAry(Blob blob) throws IOException, SQLException {
        InputStream fileStream;
        byte[] byteAry;
        block8: {
            if (blob == null) {
                return null;
            }
            byteAry = null;
            fileStream = null;
            ByteArrayOutputStream bos = null;
            try {
                fileStream = blob.getBinaryStream();
                bos = new ByteArrayOutputStream();
                byte[] buf = new byte[10240];
                int len = -1;
                while ((len = fileStream.read(buf)) != -1) {
                    bos.write(buf, 0, len);
                }
                bos.flush();
                byteAry = bos.toByteArray();
                fileStream.close();
                if (bos == null) break block8;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw e;
                    catch (IOException e2) {
                        logger.error((Object)e2.getMessage(), (Throwable)e2);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (bos != null) {
                        StreamReleaseUtil.safeClose(bos);
                    }
                    if (fileStream == null) throw throwable;
                    StreamReleaseUtil.safeClose(fileStream);
                    throw throwable;
                }
            }
            StreamReleaseUtil.safeClose(bos);
        }
        if (fileStream == null) return byteAry;
        StreamReleaseUtil.safeClose(fileStream);
        return byteAry;
    }

    public static String serialClobToString(SerialClob clob) throws SQLException, IOException {
        if (clob == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Reader clobStream = null;
        try {
            clobStream = clob.getCharacterStream();
            char[] b = new char[10000];
            int i = 0;
            while ((i = clobStream.read(b)) != -1) {
                sb.append(b, 0, i);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (clobStream != null) {
                StreamReleaseUtil.safeClose(clobStream);
            }
        }
        return sb.toString();
    }

    public static String getParamPlaceholder(String filed) {
        if (filed == null) {
            return null;
        }
        int len = filed.split(",").length;
        return RecDBUtils.createParamPlaceHolder(len);
    }

    public static String getParamPlaceholder(Object[] filed) {
        if (filed == null) {
            return null;
        }
        return RecDBUtils.createParamPlaceHolder(filed.length);
    }

    public static String getParamPlaceholder(Collection<?> filed) {
        if (filed == null) {
            return null;
        }
        return RecDBUtils.getParamPlaceholder(filed.toArray(new Object[0]));
    }

    private static String createParamPlaceHolder(int len) {
        StringBuilder fillParam = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                fillParam.append(",");
            }
            fillParam.append("?");
        }
        return fillParam.toString();
    }

    public static String translateUpdateFields(String fields) {
        if (fields == null) {
            return null;
        }
        String[] fieldsAry = fields.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldsAry.length; ++i) {
            sb.append(fieldsAry[i]).append("=?");
            if (i == fieldsAry.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static AdminOrgUnitInfo getRootAdminOrgUnit(Context ctx) throws BOSException {
        IAdminOrgUnit iaou = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection coll = iaou.getAdminOrgUnitCollection("where isSealUp = 0 and parent is null");
        if (coll == null || coll.isEmpty()) {
            throw new BOSException("\u65e0\u6cd5\u83b7\u53d6\u6839\u884c\u653f\u7ec4\u7ec7\u8282\u70b9\uff0c\u83b7\u53d6\u6839\u884c\u653f\u7ec4\u7ec7\u8282\u70b9\u5931\u8d25\uff01");
        }
        AdminOrgUnitInfo aouInfo = coll.get(0);
        return aouInfo;
    }

    public static Set<String> acquireSubOrgIds(Context ctx, String orgId) throws BOSException {
        HashSet<String> orgIds = new HashSet<String>();
        orgIds.add(orgId);
        RecDBUtils.acquireSubOrgIds(ctx, orgId, orgIds);
        return orgIds;
    }

    public static void acquireSubOrgIds(Context ctx, String orgId, Set<String> orgIds) throws BOSException {
        try {
            IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection adminColl = iAdmin.getAdminOrgUnitCollection("where id = '" + orgId + "'");
            AdminOrgUnitInfo info2 = null;
            if (!RecDBUtils.isEmpty((IObjectCollection)adminColl)) {
                info2 = adminColl.get(0);
                String longNumber = info2.getLongNumber() + "!";
                adminColl = iAdmin.getAdminOrgUnitCollection("where isSealUp = 0 and longNumber like '" + longNumber + "%'");
                if (!RecDBUtils.isEmpty((IObjectCollection)adminColl)) {
                    for (AdminOrgUnitInfo info2 : adminColl) {
                        orgIds.add(info2.getId().toString());
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u83b7\u53d6'" + orgId + "'\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u6570\u636e\u5931\u8d25\uff01");
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    public static boolean isEmptyWithTrim(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static boolean isEmpty(IObjectCollection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static java.util.Date getNowUtilDate() {
        Calendar c = Calendar.getInstance();
        c.set(10, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getNowDate() {
        return RecDBUtils.doUtilDateToSqlData(RecDBUtils.getNowUtilDate());
    }

    public static Date doUtilDateToSqlData(java.util.Date date) {
        Date sqlDate = new Date(date.getTime());
        return sqlDate;
    }

    public static ColumnCollection getBOSObjectColumns(BOSObjectType bosType) {
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        DataTableInfo dataTableInfo = objectInfo.getTable();
        return dataTableInfo.getColumns();
    }

    public static int convertStrToInt(String numberStr) {
        if (RecDBUtils.isEmpty(numberStr)) {
            throw new NullPointerException();
        }
        numberStr = numberStr.replaceAll("\\D", "");
        return Integer.parseInt(numberStr);
    }

    public static void saveAttachment(Context ctx, String filePath, String boID) throws IOException, BOSException {
        if (StringUtils.isBlank((String)filePath) || StringUtils.isBlank((String)boID)) {
            logger.error((Object)("****************filePath\uff1a" + filePath + "\uff0cboID\uff1a" + boID + "\u4e3a\u7a7a*****************"));
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            logger.error((Object)("*********\u4e0d\u5b58\u5728\u9644\u4ef6********\uff1a" + filePath));
            return;
        }
        RecDBUtils.saveAttachment(ctx, file, boID);
    }

    public static void saveAttachment(Context ctx, File file, String boID) throws IOException, BOSException {
        if (file == null || !file.exists() || file.length() <= 0L) {
            logger.error((Object)"*********\u4e0d\u5b58\u5728\u9644\u4ef6********");
            return;
        }
        RecDBUtils.saveAttachment(ctx, file.getName(), FileUtil.getFileBytes(file), file.length(), boID);
    }

    public static void saveAttachment(Context ctx, String fileName, byte[] attach, long fileSize, String boID) throws BOSException {
        AttachmentInfo attachmentInfo = new AttachmentInfo();
        attachmentInfo.setFile(attach);
        String realFileName = fileName.substring(0, fileName.lastIndexOf("."));
        attachmentInfo.setName(realFileName, LocaleUtils.locale_l2);
        attachmentInfo.setSimpleName(fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()));
        if (fileSize < 1024L) {
            attachmentInfo.setSize(fileSize + "B");
        } else {
            attachmentInfo.setSize(fileSize / 1024L + "KB");
        }
        attachmentInfo.setSizeInByte((int)fileSize);
        attachmentInfo.setAttachID(String.valueOf(System.currentTimeMillis()));
        attachmentInfo.setStorageType(AttachmentStorageTypeEnum.DATABASE);
        IObjectPK attchId = null;
        try {
            attchId = AttachmentFactory.getLocalInstance((Context)ctx).addnew(attachmentInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        attachmentInfo.setId(BOSUuid.read((String)attchId.toString()));
        SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
        attchExt.setAttachment(attachmentInfo);
        attchExt.setName(attachmentInfo.getName());
        attchExt.setPropertyName("null0");
        attchExt.setType(AttachmentTypeEnum.FORM);
        attchExt.setState(AttachmentState.SAVE);
        attchExt.setBoID(boID);
        try {
            SHRAttachmentExtFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)attchExt);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static CoreBaseCollection entityCollectionToCoreBaseCollection(IObjectCollection coll) {
        CoreBaseCollection coreColl = new CoreBaseCollection();
        if (!RecDBUtils.isEmpty(coll)) {
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                coreColl.add((CoreBaseInfo)iter.next());
            }
        }
        return coreColl;
    }

    public static ObjectBase getObjectBase(Context ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return new ObjectBase(ctx);
    }

    public static boolean syncLock(Context ctx, RecSyncLockEntityType entityType) {
        boolean lockSuccess = false;
        if (entityType != null) {
            try {
                RecSyncLockFactory.getLocalInstance(ctx).lock(entityType);
                lockSuccess = true;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return lockSuccess;
    }

    public static boolean syncRowLoc(Context ctx, RecSyncLockEntityType entityType, IObjectPK entityBosId) {
        boolean lockSuccess = false;
        if (entityType != null && entityBosId != null) {
            try {
                RecSyncLockFactory.getLocalInstance(ctx).rowLock(entityType, entityBosId);
                lockSuccess = true;
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return lockSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getOpenIDByPersonID(Context ctx, String personIds) {
        ArrayList<String> openIDs = new ArrayList<String>();
        if (StringUtils.isEmpty((String)personIds)) {
            return openIDs;
        }
        String[] persons = personIds.split(";|,");
        StringBuilder ids = new StringBuilder();
        int size = persons.length;
        for (int i = 0; i < size; ++i) {
            ids.append("'").append(persons[i]).append("'").append(",");
        }
        if (!StringUtils.isEmpty((String)ids.toString())) {
            personIds = ids.substring(0, ids.length() - 1).toString();
        }
        String querySql = "SELECT FXtId FROM t_pm_easxtusermap WHERE FPersonId in (" + personIds + ") and FUSERID IS NOT NULL";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[0]);
            while (rs != null && rs.next()) {
                String fXtId = rs.getString("FXtId");
                if (StringUtils.isEmpty((String)fXtId)) continue;
                openIDs.add(fXtId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return openIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonPost(String url, JSONObject jsonObject, String charset) {
        if (charset == null) {
            charset = "utf-8";
        }
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)charset);
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestBody(jsonObject.toString());
        postMethod.setRequestHeader("Content-type", "application/json; charset=utf-8");
        String result = null;
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
            if (statusCode == 200) {
                result = postMethod.getResponseBodyAsString();
            } else {
                logger.error((Object)("HttpClient\uff1ahttp response status is\uff1a" + statusCode));
                logger.error((Object)("HttpClient\uff1acontent\uff1a" + postMethod.getResponseBodyAsString()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)("Http\u9519\u8bef\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> param) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        PostMethod postMethod = new PostMethod(url);
        if (param != null && param.size() > 0) {
            NameValuePair[] datas = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                datas[index++] = new NameValuePair(key, param.get(key));
            }
            postMethod.setRequestBody(datas);
        }
        String result = null;
        try {
            result = RecDBUtils.executeMethod(httpClient, (HttpMethod)postMethod);
        }
        catch (IOException e) {
            logger.error((Object)("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    public static String get(String url) {
        return RecDBUtils.get(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String queryString) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(30000);
        httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        String result = null;
        GetMethod method = new GetMethod(url);
        try {
            if (!StringUtils.isEmpty((String)queryString)) {
                method.setQueryString(URIUtil.encodeQuery((String)queryString));
            }
            result = RecDBUtils.executeMethod(httpClient, (HttpMethod)method);
        }
        catch (URIException e) {
            logger.error((Object)("\u6267\u884cHTTP Get\u8bf7\u6c42\u65f6\uff0c\u8bbe\u7f6e\u67e5\u8be2\u5b57\u7b26\u4e32   " + queryString + " \u5f02\u5e38\uff01"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("\u6267\u884cHTTP Get\u8bf7\u6c42" + url + "\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01"));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return result;
    }

    private static String executeMethod(HttpClient client, HttpMethod method) throws IOException {
        String result = null;
        try {
            int statusCode = client.executeMethod(method);
            if (statusCode == 200) {
                result = method.getResponseBodyAsString();
            } else {
                logger.error((Object)("\u8bf7\u6c42\u672a\u6210\u529f\uff0cresponse status\uff1a" + statusCode));
                if (statusCode == 302) {
                    Header redirectHeader = method.getResponseHeader("location");
                    logger.error((Object)("\u8bf7\u6c42\u88ab\u91cd\u5b9a\u5411\u5730\u5740\uff1a" + redirectHeader.getValue()));
                }
                logger.error((Object)("\u8bf7\u6c42\u672a\u6210\u529f\uff0cresponse body content\uff1a" + method.getResponseBodyAsString()));
            }
        }
        catch (HttpException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }

    public static void cleanDbConnection(Context ctx) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (Exception exc) {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public static String convertLongUrlToShortUrl(Context ctx, String originalUrl) {
        try {
            String serviceUrl = CloudServiceUtil.getServiceUrl(ctx, "102");
            return RecDBUtils.convertLongUrlToShortUrl(ctx, serviceUrl, originalUrl);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u94fe\u63a5\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
            return originalUrl;
        }
    }

    public static String convertLongUrlToShortUrl(Context ctx, String SERVERURL, String originalUrl) {
        try {
            JSONObject retObject;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("originalUrl", originalUrl);
            if (logger.isDebugEnabled()) {
                logger.error((Object)("\u8f6c\u957f\u94fe\u4e3a\u77ed\u94fe:" + SERVERURL));
            }
            String ret = HttpUtil.post(ctx, SERVERURL, param);
            if (logger.isDebugEnabled()) {
                logger.error((Object)("\u8f6c\u957f\u94fe\u4e3a\u77ed\u94fe\u7ed3\u679c:" + ret));
            }
            if ((retObject = new JSONObject(ret)).getInt("code") == 0) {
                return retObject.getString("data");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u94fe\u63a5\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        return originalUrl;
    }

    public static String getServiceUrl(Context ctx, String serviceType) throws BOSException {
        String serviceURL = "";
        try {
            CloudServiceURLConfigCollection urlColl = CloudServiceURLConfigFactory.getLocalInstance(ctx).getCloudServiceURLConfigCollection(" where state='1' and serviceType='" + serviceType + "'");
            if (urlColl != null && !urlColl.isEmpty()) {
                serviceURL = urlColl.get(0).getServiceURL();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isBlank((String)serviceURL)) {
            throw new BOSException("\u9884\u7f6e\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38\uff0cserviceType\uff1a" + serviceType + "\u5bf9\u5e94serviceURL\u4e22\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u4fee\u590d\uff01");
        }
        return serviceURL.trim();
    }

    public static Map batchRequestObjIDForUpdate(Context ctx, List idList) throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map map = mutexService.batchRequestObjIDForUpdate(idList);
        return map;
    }

    public static void batchReleaseObjIDForUpdate(Context ctx, List<String> dataList) throws BOSException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexService.batchReleaseObjIDForUpdate(dataList);
    }

    public static String getDemandBenefits(Context ctx, String billId) throws BOSException {
        String benefits = "";
        String sql = "SELECT BENEFITS.FID as fid,BENEFITS.FName as fname FROM T_REC_Benefits BENEFITS JOIN T_REC_RecDemandLinkBenefits LINK ON (BENEFITS.FID = LINK.FBenefitsID) WHERE BENEFITS.FState = 1 AND LINK.FDemandID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
        if (rs != null) {
            try {
                while (rs.next()) {
                    benefits = benefits + rs.getString("fname") + " ";
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return benefits;
    }

    public static String getDemandWorkArea(Context ctx, String billId) throws BOSException {
        String result = "";
        DemandWorkAreaCollection collection = DemandWorkAreaFactory.getLocalInstance(ctx).getDemandWorkAreaCollection("where recuritmentDemand='" + billId + "'");
        if (collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                DemandWorkAreaInfo areaInfo = collection.get(i);
                if (StringUtils.isNotEmpty((String)areaInfo.getProvinceName())) {
                    result = result + areaInfo.getProvinceName() + " ";
                }
                if (StringUtils.isNotEmpty((String)areaInfo.getCityName())) {
                    result = result + areaInfo.getCityName() + " ";
                }
                if (StringUtils.isNotEmpty((String)areaInfo.getCountryName())) {
                    result = result + areaInfo.getCountryName() + " ";
                }
                if (StringUtils.isNotEmpty((String)areaInfo.getDetailArea())) {
                    result = result + areaInfo.getDetailArea() + " ";
                }
                result = result + "\n";
            }
        }
        return result;
    }

    public static String getUserId(Context ctx, String personid) {
        List<Object> pdatas = new ArrayList();
        String alluserId = "";
        String psql = "select fid from T_PM_User where fpersonid='" + personid + "' and FISDELETE =0";
        try {
            pdatas = RecDBUtils.getQueryData(ctx, psql, null);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        for (int k = 0; k < pdatas.size(); ++k) {
            Object[] user = (Object[])pdatas.get(k);
            if (user.length <= 0) continue;
            alluserId = String.valueOf(user[0]);
        }
        return alluserId;
    }
}

