/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.job;

import com.kingdee.shr.recuritment.app.util.PropertiesLoaderUtil;
import com.kingdee.util.StringUtils;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RecSyncTaskThreadPool {
    private static Logger logger = Logger.getLogger(RecSyncTaskThreadPool.class);
    private int corePoolSize;
    private int maximumPoolSize;
    private BlockingQueue<Runnable> workQueue;
    private ExecutorService threadPool;

    private RecSyncTaskThreadPool() {
        this.maximumPoolSize = this.corePoolSize = 5;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"**************\u62db\u8058\u4efb\u52a1\u7ebf\u7a0b\u6c60\u521d\u59cb\u5316\u5f00\u59cb*************");
        }
        try {
            Properties props = PropertiesLoaderUtil.getProperties("resumeAnalysisConfig.properties");
            if (props != null) {
                Pattern pattern = Pattern.compile("[0-9]*");
                if (!StringUtils.isEmpty((String)props.getProperty("maximumPoolSize")) && pattern.matcher(props.getProperty("maximumPoolSize")).matches()) {
                    this.maximumPoolSize = Integer.parseInt(props.getProperty("maximumPoolSize"));
                }
                if (this.maximumPoolSize >= 20) {
                    this.maximumPoolSize = 20;
                }
                if (!StringUtils.isEmpty((String)props.getProperty("corePoolSize")) && pattern.matcher(props.getProperty("corePoolSize")).matches()) {
                    this.corePoolSize = Integer.parseInt(props.getProperty("corePoolSize"));
                }
                if (this.corePoolSize >= 10) {
                    this.corePoolSize = 10;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("**************\u62db\u8058\u4efb\u52a1\u7ebf\u7a0b\u6c60\u521d\u59cb\u5316\u5f02\u5e38*************" + e.getMessage()));
        }
        this.workQueue = new LinkedBlockingQueue<Runnable>();
        this.threadPool = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, 0L, TimeUnit.MILLISECONDS, this.workQueue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"**************\u62db\u8058\u4efb\u52a1\u7ebf\u7a0b\u6c60\u5b8c\u6210**************");
        }
    }

    private ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public static RecSyncTaskThreadPool getInstance() {
        return RecSyncTaskThreadPoolHolder.service;
    }

    public void submitAsyncTask(Callable callable) {
        final FutureTask future = new FutureTask(callable);
        this.getThreadPool().submit(future);
        this.getThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                block4: {
                    while (!future.isDone()) {
                    }
                    String result = null;
                    try {
                        result = (String)future.get();
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("RecSyncTaskThreadPool thread name:" + Thread.currentThread().getName() + "======result:" + result));
                }
            }
        });
    }

    public Future submitAsyncTask(Runnable runnable) {
        return this.getThreadPool().submit(runnable);
    }

    public String submitWaitTask(Callable callable) {
        FutureTask future = new FutureTask(callable);
        this.getThreadPool().submit(future);
        String result = null;
        try {
            result = (String)future.get();
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RecSyncTaskThreadPool thread name:" + Thread.currentThread().getName() + "======result:" + result));
        }
        return result;
    }

    private static class RecSyncTaskThreadPoolHolder {
        private static final RecSyncTaskThreadPool service = new RecSyncTaskThreadPool();

        private RecSyncTaskThreadPoolHolder() {
        }
    }
}

