/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.job;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.recuritment.app.service.interviewGo.WaitHandlerMsgService;
import com.kingdee.shr.recuritment.utils.RecCloudHubUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendPushResumeMsgRunnable
implements Runnable {
    Logger logger = LoggerFactory.getLogger(SendPushResumeMsgRunnable.class);
    public final SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm\u5206");
    public static final String interviewGo = "interGo";
    public static final String DELMSG = "DeleteMessage";
    private Context ctx;
    private String relationId;
    private String title;
    private String MessageTem;
    private String url;
    private UserCollection users;
    private String oper;
    private boolean sendSchedule = false;

    @Override
    public void run() {
        if (StringUtils.isEmpty((CharSequence)this.url)) {
            this.doSendMessage(this.ctx, this.relationId, this.title, this.MessageTem, this.users);
        } else {
            this.doSendMessage(this.ctx, this.relationId, this.title, this.MessageTem, this.url, this.users);
        }
    }

    public SendPushResumeMsgRunnable(Context ctx, String resumeApproverId, String title, String MessageTem, UserCollection users) {
        this.ctx = ctx;
        this.relationId = resumeApproverId;
        this.title = title;
        this.MessageTem = MessageTem;
        this.users = users;
    }

    public SendPushResumeMsgRunnable(Context ctx, String resumeApproverId, String title, String MessageTem, UserCollection users, String oper) {
        this.ctx = ctx;
        this.relationId = resumeApproverId;
        this.title = title;
        this.MessageTem = MessageTem;
        this.users = users;
        this.oper = oper;
    }

    public SendPushResumeMsgRunnable(Context ctx, String resumeApproverId, String title, String MessageTem, int tabIndex, UserCollection users) {
        this.ctx = ctx;
        this.relationId = resumeApproverId;
        this.title = title;
        this.MessageTem = MessageTem;
        this.url = this.getScreenResumeUrl(ctx, tabIndex, interviewGo);
        this.users = users;
    }

    public SendPushResumeMsgRunnable(Context ctx, String resumeApproverId, String title, String MessageTem, int tabIndex, UserCollection users, boolean sendSchedule) {
        this.ctx = ctx;
        this.relationId = resumeApproverId;
        this.title = title;
        this.MessageTem = MessageTem;
        this.url = this.getScreenResumeUrl(ctx, tabIndex, interviewGo);
        this.users = users;
        this.sendSchedule = sendSchedule;
    }

    private void doSendMessage(Context ctx, String relationId, String title, String MessageTem, String url, UserCollection users) {
        this.logger.error("\u62db\u8058go\u53d1\u9001\u5e26\u94fe\u63a5\u7684\u63a8\u9001\u7b80\u5386\u7b5b\u9009\u79fb\u52a8\u6d88\u606f\u5f00\u59cb.....");
        try {
            Date now = new Date();
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            boolean isPrivate = RecCloudHubUtil.isPrivateServer();
            if (users != null && users.size() > 0) {
                this.logger.error("\u53d1\u9001\u63a8\u9001\u7b80\u5386\u7b5b\u9009\u6d88\u606f\u53d1\u9001:pubaccName=interGo,users=" + users.toString() + ",title=" + title + ",message=" + MessageTem + ",url=" + url);
                this.logger.error("\u53d1\u9001\u63a8\u9001\u7b80\u5386\u7b5b\u9009\u53d1\u9001:appId=" + appId + ",isPrivate=" + isPrivate);
                HttpResultVo result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextTypeSetMessageToUser(MessageTem, appId, url, title, this.sdf.format(now), users, interviewGo, isPrivate);
                this.logger.error("\u53d1\u9001\u63a8\u9001\u7b80\u5386\u7b5b\u9009\u6d88\u606f\u53d1\u9001:result={status:" + result.getStatus() + ";data:" + result.getData() + ";}");
                String createId = HRFilterUtils.getCurrentPersonId((Context)ctx);
                this.logger.error("\u4ee3\u529e\u6d88\u606f\u53c2\u6570createId\uff1a" + createId + ",users:" + users + ",message:" + MessageTem + ",url:" + url + ",relationId:" + relationId);
                WaitHandlerMsgService.getInstance().sendMsg(ctx, users, MessageTem, createId, relationId, url, this.sendSchedule);
            }
        }
        catch (EASBizException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("\u63a8\u9001\u7b80\u5386\u7b5b\u9009\u79fb\u52a8\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002" + e.getMessage());
        }
        catch (BOSException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("\u63a8\u9001\u7b80\u5386\u7b5b\u9009\u79fb\u52a8\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002" + e.getMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("\u63a8\u9001\u7b80\u5386\u7b5b\u9009\u79fb\u52a8\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002" + e.getMessage());
        }
    }

    private void doSendMessage(Context ctx, String relationId, String title, String MessageTem, UserCollection users) {
        this.logger.info("\u62db\u8058go\u53d1\u9001\u4e0d\u5e26\u94fe\u63a5\u7684\u63a8\u9001\u6d88\u606f\u5f00\u59cb.....");
        this.logger.info("\u53c2\u6570 relationId\uff1a" + relationId + " title: " + title + " MessageTem: " + MessageTem + " users:" + users + "");
        try {
            boolean isPrivate = RecCloudHubUtil.isPrivateServer();
            if (users != null && users.size() > 0) {
                this.logger.info("\u63a8\u9001\u6d88\u606f\u53d1\u9001:pubaccName=interGo,users=" + users.toString() + ",title=" + title + ",message=" + MessageTem);
                HttpResultVo result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextMessageToUser(MessageTem, users, interviewGo, isPrivate);
                this.logger.info("\u63a8\u9001\u6d88\u606f\u53d1\u9001:result={status:" + result.getStatus() + ";data:" + result.getData() + ";}");
                String createId = HRFilterUtils.getCurrentPersonId((Context)ctx);
                if (DELMSG.equals(this.oper)) {
                    WaitHandlerMsgService.getInstance().deleteMsg(ctx, relationId, users);
                } else {
                    WaitHandlerMsgService.getInstance().sendMsg(ctx, users, MessageTem, createId, relationId, this.url, this.sendSchedule);
                }
            }
        }
        catch (EASBizException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("\u63a8\u9001\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002" + e.getMessage());
        }
        catch (BOSException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("\u63a8\u9001\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002" + e.getMessage());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.error("\u63a8\u9001\u6d88\u606f\u53d1\u9001\u5931\u8d25\u3002" + e.getMessage());
        }
    }

    public String getScreenResumeUrl(Context ctx, int tabIndex, String interviewGo) {
        String cloudHubServerUrl = RecCloudHubUtil.getCloudHubServerUrl(ctx);
        StringBuilder url = new StringBuilder(cloudHubServerUrl);
        try {
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String storeEid = RecCloudHubUtil.getStoreEid(eid, interviewGo);
            if (!StringUtils.isEmpty((CharSequence)storeEid)) {
                url.append("storeEid=").append(storeEid).append("&");
            }
            if (RecCloudHubUtil.isPrivateServer()) {
                eid = RecCloudHubUtil.getDbInfoEid();
            }
            url.append("appid=").append(appId).append("&eid=").append(eid).append("&path=interGo" + RecCloudHubUtil.getCloudHubAppVersion(ctx) + "&name=01.navui&tabIndex=" + tabIndex + "&pageType=resumeScreening");
        }
        catch (Exception e) {
            this.logger.error("\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u672a\u4e0e\u4e91\u4e4b\u5bb6\u96c6\u6210\uff0c\u8bf7\u914d\u7f6e", (Throwable)e);
        }
        return url.toString();
    }
}

