/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.app.util.job;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.recuritment.IPInterviewersCollection;
import com.kingdee.shr.recuritment.IPInterviewersFactory;
import com.kingdee.shr.recuritment.ITimeHelper;
import com.kingdee.shr.recuritment.InterviewPlanInfo;
import com.kingdee.shr.recuritment.TimeHelperCollection;
import com.kingdee.shr.recuritment.TimeHelperFactory;
import com.kingdee.shr.recuritment.TimeHelperInfo;
import com.kingdee.shr.recuritment.app.util.ParamUtil;
import com.kingdee.shr.recuritment.app.util.RecOsfUtil;
import com.kingdee.shr.recuritment.app.util.db.RecDBUtils;
import com.kingdee.shr.recuritment.utils.RecCloudHubUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class TimeHelperRunnable
implements Runnable {
    private static Logger logger = Logger.getLogger(TimeHelperRunnable.class);
    public static String SERVERURL = "http://yunzhijia.com";
    public static String GETTOKENAPIURL = "/gateway/oauth2/token/getAccessToken";
    public static String CREATESCHEDULE = "/gateway/cloudwork/newwork/create";
    public static String UPDATESCHEDULE = "/gateway/cloudwork/newwork/modify";
    public static final String DEFAULT_CHARSET = "utf-8";
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SO_TIMEOUT = 30000;
    public static final String interviewGo = "interGo";
    public static final String ADD = "add";
    public static final String UPDATE = "UPDATE";
    private Context ctx;
    private String interviewPlanId;
    private String oper;

    @Override
    public void run() {
        if (this.oper.equals(ADD)) {
            this.doInterviewPlanByHR(this.ctx, this.interviewPlanId);
        } else if (this.oper.equals(UPDATE)) {
            this.updateInterviewPlanByHR(this.ctx, this.interviewPlanId);
        }
    }

    public TimeHelperRunnable(Context ctx, String interviewPlanId, String oper) {
        this.ctx = ctx;
        this.interviewPlanId = interviewPlanId;
        this.oper = oper;
    }

    public void doInterviewPlanByHR(Context ctx, String interviewPlanId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u7ed9\u9762\u8bd5\u5b98\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u63d0\u9192\u5f00\u59cb.....");
            logger.debug((Object)("\u53c2\u6570 interviewPlanId\uff1a" + interviewPlanId));
        }
        try {
            String workId;
            ITimeHelper iTimeHelper = TimeHelperFactory.getLocalInstance(ctx);
            TimeHelperCollection timeHelperColl = iTimeHelper.getTimeHelperCollection("where interviewPlan.id = '" + interviewPlanId + "'");
            if (timeHelperColl != null && timeHelperColl.size() > 0) {
                this.updateInterviewPlanByHR(ctx, interviewPlanId);
                return;
            }
            Date interviewTime = null;
            java.util.Date now = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm\u5206");
            String contacterName = "";
            String resuemName = "";
            String positionName = "";
            String jobName = "";
            String message = "";
            String url = "";
            String videoInterview = "";
            String querySql = "select IP.FInterviewTime as interviewTime, BPERSON.FName_l2  as contacterName,RB.FName as resumeName, AD.FName_l2 as departmentName, PO.FName_l2 as positionName, JOB.FName_l2 as jobName,VIR.FID as videoInterview  from T_REC_InterviewPlan IP inner join T_REC_InterviewResult IR on IR.FID = IP.FInterviewID inner join T_REC_ResumeBaseRec RB on RB.FID = IR.FResumeBaseRecID inner join T_REC_RecuritmentDemand RD on RD.FID = RB.FRecuritmentDemandID left  join T_ORG_Admin AD on AD.FID = RD.FDepartmentID left  join T_ORG_Position PO on PO.FID = RD.FRecuritPositionID left  join T_HR_HRJob JOB  on JOB.FID = RD.FHrJobID LEFT JOIN  T_PM_User PUSER ON (PUSER.FID  = IP.FLastUpdateUserID) LEFT JOIN  T_BD_Person BPERSON ON (BPERSON.FID  = PUSER.FPersonId) LEFT JOIN  T_REC_VideoInterviewRecord VIR ON (VIR.FID  = IP.FVideoInterRecordID) where IP.FID = ? ";
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{interviewPlanId});
            if (rs1 != null) {
                while (rs1.next()) {
                    interviewTime = rs1.getDate("interviewTime");
                    contacterName = rs1.getString("contacterName");
                    resuemName = rs1.getString("resumeName");
                    positionName = rs1.getString("positionName");
                    jobName = rs1.getString("jobName");
                    videoInterview = rs1.getString("videoInterview");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("\u6839\u636e\u9762\u8bd5\u73af\u8282Id:{0}\u67e5\u627e\u4e0d\u5230\u6570\u636e\uff0c\u6d88\u606f\u53d1\u9001\u5931\u8d25", interviewPlanId));
                }
                return;
            }
            if (StringUtils.isEmpty((CharSequence)positionName) && !StringUtils.isEmpty((CharSequence)jobName)) {
                positionName = jobName;
            }
            if (now.before(interviewTime)) {
                message = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u88ab{0}\u5b89\u6392\u4e3a\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u524d\u5f80\u62db\u8058go\u67e5\u770b\uff01 ";
                url = this.getInterviewPageUrl(ctx, interviewPlanId);
            } else {
                message = "\u3010\u62db\u8058go\u3011 \u8bf7\u60a8\u53ca\u65f6\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff01\uff08\u5458\u5de5\u81ea\u52a9-\u62db\u8058go\uff09 ";
                url = this.getEvaluatePageUrl(ctx, interviewPlanId);
            }
            message = MessageFormat.format(message, contacterName, resuemName, positionName, sdf.format(interviewTime) + (StringUtils.isEmpty((CharSequence)videoInterview) ? "" : "\u89c6\u9891\u9762\u8bd5"));
            message = message + url;
            String createId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            StringBuilder personIds = new StringBuilder();
            IPInterviewersCollection interviewers = IPInterviewersFactory.getLocalInstance(ctx).getIPInterviewersCollection("where interviewPlanId = '" + interviewPlanId + "'");
            int size = interviewers.size();
            for (int i = 0; i < size; ++i) {
                personIds.append(interviewers.get(i).getInterviewerId()).append(";");
            }
            if (!StringUtils.isEmpty((CharSequence)personIds.toString())) {
                personIds = new StringBuilder(personIds.substring(0, personIds.length() - 1));
            }
            if (!StringUtils.isEmpty((CharSequence)(workId = this.createSchedule(ctx, personIds.toString(), createId, message, interviewTime)))) {
                TimeHelperInfo timeHelper = new TimeHelperInfo();
                timeHelper.setWorkId(workId);
                timeHelper.setActors(personIds.toString());
                timeHelper.setOpenid(createId);
                timeHelper.setStartDate(interviewTime);
                InterviewPlanInfo interviewPlan = new InterviewPlanInfo();
                interviewPlan.setId(BOSUuid.read((String)interviewPlanId));
                timeHelper.setInterviewPlan(interviewPlan);
                iTimeHelper.save((CoreBaseInfo)timeHelper);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u7ed9\u9762\u8bd5\u5b98\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u63d0\u9192\u5931\u8d25: " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u7ed9\u9762\u8bd5\u5b98\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u63d0\u9192\u5931\u8d25: " + e.getMessage()), (Throwable)e);
        }
    }

    public void updateInterviewPlanByHR(Context ctx, String interviewPlanId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\u7ed9\u9762\u8bd5\u5b98\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u63d0\u9192\u5f00\u59cb.....");
        }
        if (StringUtils.isEmpty((CharSequence)interviewPlanId)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u6570\u636e\u5f02\u5e38\uff0cinterviewPlanId\u4e3a\u7a7a");
            }
            return;
        }
        try {
            ITimeHelper iTimeHelper = TimeHelperFactory.getLocalInstance(ctx);
            TimeHelperCollection timeHelperColl = iTimeHelper.getTimeHelperCollection("select *,interviewPlan.* where interviewPlan.id = '" + interviewPlanId + "'");
            if (timeHelperColl == null || timeHelperColl.size() <= 0) {
                return;
            }
            TimeHelperInfo timeHelperInfo = timeHelperColl.get(0);
            String workId = timeHelperInfo.getWorkId();
            if (StringUtils.isEmpty((CharSequence)interviewPlanId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u6570\u636e\u5f02\u5e38\uff0cinterviewPlanId\u4e3a" + interviewPlanId + "\u7684\u9762\u8bd5\u73af\u8282workId\u4e3a\u7a7a"));
                }
                return;
            }
            String content = timeHelperInfo.getContent();
            String actors = timeHelperInfo.getActors();
            String creatorId = timeHelperInfo.getOpenid();
            java.util.Date startDate = timeHelperInfo.getStartDate();
            ArrayList existPersonIds = new ArrayList();
            CollectionUtils.addAll(existPersonIds, (Object[])actors.split(";|,"));
            StringBuilder addPersonIds = new StringBuilder();
            StringBuilder delPersonIds = new StringBuilder();
            IPInterviewersCollection interviewers = IPInterviewersFactory.getLocalInstance(ctx).getIPInterviewersCollection("where interviewPlanId = '" + interviewPlanId + "'");
            if (interviewers == null || interviewers.size() <= 0) {
                delPersonIds.append(actors).append(";");
                actors = "";
            } else if (existPersonIds.size() <= 0) {
                int size = interviewers.size();
                for (int i = 0; i < size; ++i) {
                    addPersonIds.append(interviewers.get(i).getId().toString()).append(";");
                }
                actors = addPersonIds.toString();
            } else {
                int i;
                String personId = "";
                StringBuilder personIds = new StringBuilder();
                int size = interviewers.size();
                for (i = 0; i < size; ++i) {
                    personId = interviewers.get(i).getInterviewerId();
                    if (existPersonIds.contains(personId)) {
                        existPersonIds.remove(personId);
                    } else {
                        addPersonIds.append(personId).append(";");
                        existPersonIds.remove(personId);
                    }
                    personIds.append(personId).append(";");
                }
                size = existPersonIds.size();
                for (i = 0; i < size; ++i) {
                    delPersonIds.append((String)existPersonIds.get(i)).append(";");
                }
                actors = personIds.toString();
            }
            if (!StringUtils.isEmpty((CharSequence)addPersonIds.toString())) {
                addPersonIds = new StringBuilder(addPersonIds.substring(0, addPersonIds.length() - 1));
            }
            if (!StringUtils.isEmpty((CharSequence)delPersonIds.toString())) {
                delPersonIds = new StringBuilder(delPersonIds.substring(0, delPersonIds.length() - 1));
            }
            if (!StringUtils.isEmpty((CharSequence)actors)) {
                actors = actors.substring(0, actors.length() - 1);
            }
            java.util.Date now = new java.util.Date();
            startDate = timeHelperInfo.getInterviewPlan().getInterviewTime();
            Date interviewTime = null;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm\u5206");
            String contacterName = "";
            String resuemName = "";
            String positionName = "";
            String jobName = "";
            String url = "";
            String videoInterview = "";
            String querySql = "select IP.FInterviewTime as interviewTime, BPERSON.FName_l2 as contacterName,RB.FName as resumeName, AD.FName_l2 as departmentName, PO.FName_l2 as positionName, JOB.FName_l2 as jobName,VIR.FID as videoInterview  from T_REC_InterviewPlan IP inner join T_REC_InterviewResult IR on IR.FID = IP.FInterviewID inner join T_REC_ResumeBaseRec RB on RB.FID = IR.FResumeBaseRecID inner join T_REC_RecuritmentDemand RD on RD.FID = RB.FRecuritmentDemandID left  join T_ORG_Admin AD on AD.FID = RD.FDepartmentID left  join T_ORG_Position PO on PO.FID = RD.FRecuritPositionID left  join T_HR_HRJob JOB  on JOB.FID = RD.FHrJobID LEFT JOIN  T_PM_User PUSER ON (PUSER.FID  = IP.FLastUpdateUserID) LEFT JOIN  T_BD_Person BPERSON ON (BPERSON.FID  = PUSER.FPersonId) LEFT JOIN  T_REC_VideoInterviewRecord VIR ON (VIR.FID  = IP.FVideoInterRecordID) where IP.FID = ? ";
            IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{interviewPlanId});
            if (rs1 != null) {
                while (rs1.next()) {
                    interviewTime = rs1.getDate("interviewTime");
                    contacterName = rs1.getString("contacterName");
                    resuemName = rs1.getString("resumeName");
                    positionName = rs1.getString("positionName");
                    jobName = rs1.getString("jobName");
                    videoInterview = rs1.getString("videoInterview");
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("\u6839\u636e\u9762\u8bd5\u73af\u8282Id:{0}\u67e5\u627e\u4e0d\u5230\u6570\u636e\uff0c\u6d88\u606f\u53d1\u9001\u5931\u8d25", interviewPlanId));
                }
                return;
            }
            if (StringUtils.isEmpty((CharSequence)positionName) && !StringUtils.isEmpty((CharSequence)jobName)) {
                positionName = jobName;
            }
            if (now.before(interviewTime)) {
                content = "\u3010\u62db\u8058go\u3011\u60a8\u5df2\u88ab{0}\u5b89\u6392\u4e3a\u5019\u9009\u4eba{1}\uff08{2} {3}\uff09\u7684\u9762\u8bd5\u5b98\uff0c\u8bf7\u524d\u5f80\u62db\u8058go\u67e5\u770b\uff01 ";
                url = this.getInterviewPageUrl(ctx, interviewPlanId);
            } else {
                content = "\u3010\u62db\u8058go\u3011 \u8bf7\u60a8\u53ca\u65f6\u53cd\u9988\u5019\u9009\u4eba{1}\uff08{2}\uff09\u7684\u9762\u8bd5\u7ed3\u679c\uff01\uff08\u5458\u5de5\u81ea\u52a9-\u62db\u8058go\uff09 ";
                url = this.getEvaluatePageUrl(ctx, interviewPlanId);
            }
            content = MessageFormat.format(content, contacterName, resuemName, positionName, sdf.format(interviewTime) + (StringUtils.isEmpty((CharSequence)videoInterview) ? "" : "\u89c6\u9891\u9762\u8bd5"));
            content = content + url;
            boolean result = this.updateSchedule(ctx, workId, addPersonIds.toString(), delPersonIds.toString(), content, creatorId, startDate);
            if (result) {
                timeHelperInfo.setActors(actors);
                timeHelperInfo.setStartDate(startDate);
                iTimeHelper.update((IObjectPK)new ObjectUuidPK(timeHelperInfo.getId().toString()), timeHelperInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("\u7ed9\u9762\u8bd5\u5b98\u4fee\u6539\u65f6\u95f4\u52a9\u624b\u63d0\u9192\u5931\u8d25: " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("\u7ed9\u9762\u8bd5\u5b98\u4fee\u6539\u65f6\u95f4\u52a9\u624b\u63d0\u9192\u5931\u8d25: " + e.getMessage()), (Throwable)e);
        }
    }

    public String createSchedule(Context ctx, String personIds, String createID, String content, java.util.Date interviewTime) {
        try {
            JSONObject tokenJson;
            int errcode;
            String accessToken = this.getAccessToken(ctx);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken");
            }
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                return null;
            }
            String apiUrl = RecCloudHubUtil.getServerUrl() + CREATESCHEDULE + "?accessToken=" + accessToken;
            JSONObject param = new JSONObject();
            JSONArray array = new JSONArray();
            ArrayList<String> openIDs = RecOsfUtil.getOpenIDsByPersonID(ctx, personIds);
            for (String openID : openIDs) {
                array.put((Object)openID);
            }
            param.put("actors", (Object)array);
            param.put("content", (Object)content);
            param.put("openid", (Object)RecOsfUtil.getOpenIDByPersonID(ctx, createID));
            param.put("startDate", interviewTime.getTime());
            param.put("endDate", interviewTime.getTime() + 3600000L);
            param.put("topState", 1);
            param.put("noticeTime", ParamUtil.getInstance().getInterviewRemindTime(ctx));
            param.put("submitExperience", false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b");
            }
            String tokenResult = RecDBUtils.jsonPost(apiUrl, param, DEFAULT_CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b\u8fd4\u56de\u503c" + tokenResult));
            }
            if ((errcode = (tokenJson = new JSONObject(tokenResult)).getInt("errorCode")) == 0) {
                JSONObject data = tokenJson.getJSONObject("data");
                String workId = data.getString("workId");
                return workId;
            }
            logger.error((Object)("\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u5931\u8d25\uff1a" + tokenResult));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)("\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b\u5931\u8d25\uff1a" + e.getMessage()));
        }
        return null;
    }

    public boolean updateSchedule(Context ctx, String workId, String addPersonIds, String delPersonIds, String content, String creatorId, java.util.Date interviewTime) {
        try {
            JSONObject tokenJson;
            int errcode;
            String accessToken = this.getAccessToken(ctx);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken");
            }
            if (StringUtils.isEmpty((CharSequence)accessToken)) {
                return false;
            }
            String apiUrl = RecCloudHubUtil.getServerUrl() + UPDATESCHEDULE + "?accessToken=" + accessToken;
            JSONObject param = new JSONObject();
            JSONArray array_01 = new JSONArray();
            ArrayList<String> addOpenIDs = RecOsfUtil.getOpenIDsByPersonID(ctx, addPersonIds);
            for (String openID : addOpenIDs) {
                array_01.put((Object)openID);
            }
            param.put("addActors", (Object)array_01);
            JSONArray array_02 = new JSONArray();
            ArrayList<String> delOpenIDs = RecOsfUtil.getOpenIDsByPersonID(ctx, delPersonIds);
            for (String openID : delOpenIDs) {
                array_02.put((Object)openID);
            }
            param.put("delActors", (Object)array_02);
            param.put("content", (Object)content);
            param.put("openid", (Object)RecOsfUtil.getOpenIDByPersonID(ctx, creatorId));
            param.put("id", (Object)workId);
            param.put("startDate", interviewTime.getTime());
            param.put("endDate", interviewTime.getTime() + 3600000L);
            param.put("topState", 1);
            param.put("noticeTime", ParamUtil.getInstance().getInterviewRemindTime(ctx));
            param.put("submitExperience", false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b ");
            }
            String tokenResult = RecDBUtils.jsonPost(apiUrl, param, DEFAULT_CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b\u8fd4\u56de\u503c" + tokenResult));
            }
            if ((errcode = (tokenJson = new JSONObject(tokenResult)).getInt("errorCode")) == 0) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u521b\u5efa\u65f6\u95f4\u52a9\u624b\u65e5\u7a0b\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        return false;
    }

    private String getAccessToken(Context ctx) {
        try {
            JSONObject tokenJson;
            int errcode;
            JSONObject param = new JSONObject();
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String secret = RecCloudHubUtil.getTimeHelperSecret(eid, interviewGo);
            if (StringUtils.isEmpty((CharSequence)secret)) {
                logger.error((Object)"\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684secret\u5931\u8d25\uff0c\u672a\u914d\u7f6e\u65f6\u95f4\u52a9\u624b\u79d8\u94a5");
                return null;
            }
            param.put("eid", (Object)eid);
            param.put("secret", (Object)secret);
            param.put("timestamp", System.currentTimeMillis());
            param.put("scope", (Object)"resGroupSecret");
            String tokenResult = RecDBUtils.jsonPost(RecCloudHubUtil.getServerUrl() + GETTOKENAPIURL, param, DEFAULT_CHARSET);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken\u8fd4\u56de\u503c\uff1a" + tokenResult));
            }
            if ((errcode = (tokenJson = new JSONObject(tokenResult)).getInt("errorCode")) == 0) {
                JSONObject data = tokenJson.getJSONObject("data");
                String access_token = data.getString("accessToken");
                return access_token;
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u65f6\u95f4\u52a9\u624b\u7684AccessToken\u5931\u8d25\uff1a" + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private String getInterviewPageUrl(Context ctx, String billId) {
        StringBuilder url = new StringBuilder(RecCloudHubUtil.getCloudHubServerUrl(ctx));
        try {
            billId = URLEncoder.encode(billId, DEFAULT_CHARSET);
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String storeEid = RecCloudHubUtil.getStoreEid(eid, interviewGo);
            if (!StringUtils.isEmpty((CharSequence)storeEid)) {
                url.append("storeEid=").append(storeEid).append("&");
            }
            if (RecCloudHubUtil.isPrivateServer()) {
                eid = RecCloudHubUtil.getDbInfoEid();
            }
            url.append("appid=").append(appId).append("&eid=").append(eid).append("&path=interGo").append(RecCloudHubUtil.getCloudHubAppVersion(ctx)).append("&name=00.custom#/resume_detail?recordId=").append(billId);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url.toString();
    }

    private String getEvaluatePageUrl(Context ctx, String billId) {
        StringBuilder url = new StringBuilder(RecCloudHubUtil.getCloudHubServerUrl(ctx));
        try {
            billId = URLEncoder.encode(billId, DEFAULT_CHARSET);
            String eid = RecCloudHubUtil.getCloudHubEid(ctx);
            if (logger.isDebugEnabled()) {
                logger.error((Object)("getEvaluatePageUrl eid\uff1a" + eid));
            }
            if (RecCloudHubUtil.isPrivateServer()) {
                eid = RecCloudHubUtil.getDbInfoEid();
            }
            String appId = RecCloudHubUtil.getAppId(eid, interviewGo);
            String storeEid = RecCloudHubUtil.getStoreEid(eid, interviewGo);
            if (!StringUtils.isEmpty((CharSequence)storeEid)) {
                url.append("storeEid=").append(storeEid).append("&");
            }
            if (RecCloudHubUtil.isPrivateServer()) {
                eid = RecCloudHubUtil.getDbInfoEid();
            }
            url.append("appid=").append(appId).append("&eid=").append(eid).append("&path=interGo").append(RecCloudHubUtil.getCloudHubAppVersion(ctx)).append("&name=00.custom#/judge_page?recordId=").append(billId);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url.toString();
    }
}

