/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.recuritment.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.recuritment.app.util.FileUtil;
import java.lang.reflect.Constructor;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RecBaseUtils {
    private static final Logger logger = Logger.getLogger(RecBaseUtils.class);
    public static final String DEFAULT_DEPLOY_PATH = FileUtil.DEFAULT_DEPLOY_PATH;
    public static final String USER_NOT_RELATIVE_PERSON_MESG = "\u8be5\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u4eba\u5458\uff0c\u65e0\u6cd5\u64cd\u4f5c\u7cfb\u7edf\u4e1a\u52a1\uff01";
    public static final String ERROR_MESG = "\u670d\u52a1\u5668\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01";
    private static Pattern EMAIL_REGEX = Pattern.compile("^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$");

    public static String subSurname(String fullName, String gender) {
        if (gender == null || fullName == null) {
            return fullName;
        }
        return RecBaseUtils.subSurname(fullName, Integer.parseInt(gender));
    }

    public static String subSurname(String fullName, int gender) {
        String[] hyphenated = new String[]{"\u6b27\u9633", "\u592a\u53f2", "\u7aef\u6728", "\u4e0a\u5b98", "\u53f8\u9a6c", "\u4e1c\u65b9", "\u72ec\u5b64", "\u5357\u5bab", "\u4e07\u4fdf", "\u95fb\u4eba", "\u590f\u4faf", "\u8bf8\u845b", "\u5c09\u8fdf", "\u516c\u7f8a", "\u8d6b\u8fde", "\u6fb9\u53f0", "\u7687\u752b", "\u4e93\u5b98", "\u5b97\u653f", "\u6fee\u9633", "\u516c\u51b6", "\u592a\u53d4", "\u7533\u5c60", "\u516c\u5b59", "\u6155\u5bb9", "\u4ef2\u5b59", "\u949f\u79bb", "\u957f\u5b59", "\u5b87\u6587", "\u57ce\u6c60", "\u53f8\u5f92", "\u9c9c\u4e8e", "\u53f8\u7a7a", "\u6c5d\u5ae3", "\u95fe\u4e18", "\u5b50\u8f66", "\u53f8\u5bc7", "\u5deb\u9a6c", "\u516c\u897f", "\u989b\u5b59", "\u58e4\u9a77", "\u516c\u826f", "\u6f06\u96d5", "\u4e50\u6b63", "\u5bb0\u7236", "\u8c37\u6881", "\u62d3\u8dcb", "\u5939\u8c37", "\u8f69\u8f95", "\u4ee4\u72d0", "\u6bb5\u5e72", "\u767e\u91cc", "\u547c\u5ef6", "\u4e1c\u90ed", "\u7f8a\u820c", "\u5fae\u751f", "\u516c\u6237", "\u516c\u7389", "\u516c\u4eea", "\u6881\u4e18", "\u516c\u4ef2", "\u516c\u4e0a", "\u516c\u95e8", "\u516c\u5c71", "\u516c\u575a", "\u5de6\u4e18", "\u516c\u4f2f", "\u897f\u95e8", "\u516c\u7956", "\u7b2c\u4e94", "\u516c\u4e58", "\u8d2f\u4e18", "\u5357\u8363", "\u4e1c\u91cc", "\u4e1c\u5bab", "\u4ef2\u957f", "\u5b50\u4e66", "\u5b50\u6851", "\u5373\u58a8", "\u8fbe\u595a", "\u891a\u5e08", "\u5357\u95e8", "\u516c\u7699"};
        int vLen = fullName.length();
        String surname = null;
        if (vLen > 2) {
            surname = fullName.substring(0, 2);
            if (!RecBaseUtils.inArray(hyphenated, surname)) {
                surname = fullName.substring(0, 1);
            }
        } else {
            surname = fullName.substring(0, 1);
        }
        if (1 == gender) {
            return surname + "\u5148\u751f";
        }
        if (2 == gender) {
            return surname + "\u5973\u58eb";
        }
        return fullName;
    }

    private static boolean inArray(String[] array, String val) {
        for (String v : array) {
            if (!v.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static AdminOrgUnitInfo getCurrentUserRefAdminOrgUnitInfo(Context ctx) {
        return ContextUtil.getCurrentAdminUnit((Context)ctx);
    }

    public static PersonInfo getPersonInfo(Context ctx, String personId) {
        if (RecBaseUtils.isEmpty(personId)) {
            return null;
        }
        PersonInfo currentPerson = null;
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection coll = iPerson.getPersonCollection("where id = '" + personId + "'");
            if (coll != null && coll.size() > 0) {
                currentPerson = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return currentPerson;
    }

    public static UserInfo getUserInfoByPersonId(Context ctx, String personId) {
        UserInfo userInfo;
        UserCollection userColl = null;
        try {
            userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person = '" + personId + "'");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (userColl != null && userColl.size() > 0 && (userInfo = userColl.get(0)) != null) {
            return userInfo;
        }
        return null;
    }

    public static boolean validEmail(String mail) {
        Matcher matcher;
        boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)mail) && (matcher = EMAIL_REGEX.matcher(mail)).matches()) {
            flag = true;
        }
        return flag;
    }

    public static boolean validPhone(String phone) {
        String reg;
        boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)phone) && phone.matches(reg = "^((13|14|15|16|17|18|19)[0-9]{9})|(\\+[1-9]\\d{0,2}-\\d{1,14})$")) {
            flag = true;
        }
        return flag;
    }

    public static boolean validIdCard(String idCard) {
        boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)idCard)) {
            try {
                new IDCardCommonUtil(idCard);
                flag = true;
            }
            catch (BaseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return flag;
    }

    public static boolean validFixedPhone(String phone) {
        String reg;
        boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)phone) && phone.matches(reg = "^(0[0-9]{2,3}\\-)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?$")) {
            flag = true;
        }
        return flag;
    }

    public static boolean validQQNumber(String phone) {
        String reg;
        boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)phone) && phone.matches(reg = "^[1-9]\\d{4,15}$")) {
            flag = true;
        }
        return flag;
    }

    public static boolean validWeChatNumber(String phone) {
        String reg;
        boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)phone) && phone.matches(reg = "^[0-9a-zA-z.]+$")) {
            flag = true;
        }
        return flag;
    }

    public static ColumnCollection getBOSObjectColumns(BOSObjectType bosType) {
        EntityObjectInfo objectInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        DataTableInfo dataTableInfo = objectInfo.getTable();
        return dataTableInfo.getColumns();
    }

    public static Date getNowDate() {
        Calendar c = Calendar.getInstance();
        c.set(10, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    public static boolean isEmptyWithTrim(String str) {
        return str == null || str.trim().length() <= 0;
    }

    public static boolean isEmpty(IObjectCollection coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static String getObjectPk(Context ctx, BOSObjectType bosType) {
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        return Utils.createObjectPK((EntityObjectInfo)entity).toString();
    }

    public static Map getEmployeeInfo(Context ctx, String idNumber, String personName, String tel) throws BOSException {
        String serviceName = "getPersonInfoForRecuritment";
        Map datas = new HashMap();
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("idNumber", idNumber);
            param.put("name", personName);
            param.put("telephone", tel);
            datas = (Map)OSFAppUtil.callService((Context)ctx, (String)serviceName, param);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return datas;
    }

    public static boolean mobilePhoneGlobalRoaming(String mobilePhone) {
        boolean flag = false;
        if (!StringUtils.isEmpty((CharSequence)mobilePhone)) {
            String reg = "^(\\+[1-9]\\d{0,4}-\\d{1,14})$";
            return mobilePhone.matches(reg);
        }
        return flag;
    }

    public static CoreBaseInfo newCorebaseInfo(EntityObjectInfo relateEntityObject) throws BOSException {
        CoreBaseInfo info = null;
        try {
            String valueClassName = relateEntityObject.getObjectValueClass();
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(new Class[0]);
            info = (CoreBaseInfo)cst.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException();
        }
        return info;
    }

    public static AdminOrgUnitInfo getCurrentUserPersonDepInfo(Context ctx, String personId) {
        if (StringUtils.isEmpty((CharSequence)personId)) {
            return null;
        }
        try {
            PersonPositionCollection collection = PersonPositionFactory.getLocalInstance((Context)ctx).getPersonPositionCollection("select personDep.id,personDep.name,personDep.displayName  where person.id='" + personId + "'");
            if (collection != null && collection.size() > 0) {
                return collection.get(0).getPersonDep();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

