/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ctrl.semantic.model.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemanticDataType {
    private static final Map ForLoad = new HashMap();
    private static final List ForShow = new ArrayList();
    private static final int TYPE_STRING = 1;
    private static final int TYPE_BIN = 2;
    private static final int TYPE_NUMBER = 4;
    private static final int TYPE_DATE = 8;
    public static final SemanticDataType Unsure = new SemanticDataType("NULL", "0", 0);
    public static final SemanticDataType CHAR = new SemanticDataType("CHAR", "1", 1);
    public static final SemanticDataType VARCHAR = new SemanticDataType("VARCHAR", "2", 1);
    public static final SemanticDataType NCHAR = new SemanticDataType("NCHAR", "3", 1);
    public static final SemanticDataType NVARCHAR = new SemanticDataType("NVARCHAR", "4", 1);
    public static final SemanticDataType BINARY = new SemanticDataType("BINARY", "5", 2);
    public static final SemanticDataType VARBINARY = new SemanticDataType("VARBINARY", "6", 2);
    public static final SemanticDataType BLOB = new SemanticDataType("BLOB", "7", 2);
    public static final SemanticDataType CLOB = new SemanticDataType("CLOB", "8", 1);
    public static final SemanticDataType NCLOB = new SemanticDataType("NCLOB", "9", 1);
    public static final SemanticDataType INT = new SemanticDataType("INT", "a", 4);
    public static final SemanticDataType DECIMAL = new SemanticDataType("DECIMAL", "b", 4);
    public static final SemanticDataType DATE = new SemanticDataType("DATE", "c", 8);
    public static final SemanticDataType TIME = new SemanticDataType("TIME", "d", 8);
    public static final SemanticDataType DATETIME = new SemanticDataType("DATETIME", "e", 8);
    private String _name;
    private String _shortForSave;
    private int _type;

    private SemanticDataType(String name, String shortForSave, int type) {
        this._type = type;
        this._name = name;
        this._shortForSave = shortForSave;
        if (ForLoad.containsKey(shortForSave)) {
            throw new RuntimeException("You must modify code.");
        }
        ForLoad.put(shortForSave, this);
        if (!"NULL".equals(name)) {
            ForShow.add(this);
        }
    }

    public String getSaveString() {
        return this._shortForSave;
    }

    public String toString() {
        return this._name;
    }

    public boolean typeEquals(SemanticDataType another) {
        return this._type == another._type;
    }

    public static SemanticDataType getInst(String shortForSave) {
        SemanticDataType inst = (SemanticDataType)ForLoad.get(shortForSave);
        if (inst == null) {
            return Unsure;
        }
        return inst;
    }

    public static SemanticDataType[] getAll() {
        return ForShow.toArray(new SemanticDataType[0]);
    }
}

