/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ctrl.semantic.use.exception;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.shr.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.shr.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.shr.ctrl.semantic.use.exception.SemanticUsedException;
import java.util.ArrayList;

public class RelationsNotFoundException
extends SemanticUsedException {
    private ArrayList _descriptions = new ArrayList();

    public RelationsNotFoundException(SemanticRelation relation) {
        super("Relation not found.");
        this.addRelation(relation);
    }

    public RelationsNotFoundException() {
        super("Relations not found.");
    }

    public void addRelation(SemanticRelation relation) {
        this._descriptions.add(relation);
    }

    public SemanticRelation getRelation(int idx) {
        return (SemanticRelation)this._descriptions.get(idx);
    }

    public int getCount() {
        return this._descriptions.size();
    }

    public String getPrompt() {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < this.getCount(); ++k) {
            if (k > 0) {
                sb.append(StringUtil.RETURN);
            }
            SemanticRelation relation = this.getRelation(k);
            AbstractSemanticEntity clientEntity = relation.getClient();
            sb.append("\u3000");
            sb.append(clientEntity.getLogicalName());
            sb.append(": ");
            String desc = relation.getDescription();
            if (StringUtil.isEmptyString((String)desc)) {
                if (relation.isCustomExpr()) {
                    sb.append(((SemanticRelation.CustomExpr)relation.getCondition(0)).getExpr());
                    continue;
                }
                for (int i = 0; i < relation.getConditionCount(); ++i) {
                    if (i > 0) {
                        sb.append(" and ");
                    }
                    sb.append(clientEntity.getPhysicalName());
                    sb.append(".");
                    sb.append(((SemanticRelation.JoinLine)relation.getCondition(0)).getClientField());
                    sb.append(" = ");
                    sb.append(relation.getSupplier().getPhysicalName());
                    sb.append(".");
                    sb.append(((SemanticRelation.JoinLine)relation.getCondition(0)).getSupplierField());
                }
                continue;
            }
            sb.append(desc);
        }
        return sb.toString();
    }
}

