/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.rpts.ctrlsqldesign.param.IJavaDataSet;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.secrity.SecrityTableAndFieldCheckUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.report.util.ReportPermissionTranslate;
import com.kingdee.shr.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.shr.rpts.ctrlreport.osf.OSFDataSet;
import com.kingdee.shr.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.shr.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.shr.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.shr.rpts.ctrlsqldesign.data.InOutputParamVO;
import com.kingdee.shr.rpts.ctrlsqldesign.data.JavaModel;
import com.kingdee.shr.rpts.ctrlsqldesign.data.ProcedureModel;
import com.kingdee.shr.rpts.ctrlsqldesign.data.ProcedureParamData;
import com.kingdee.shr.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.shr.rpts.ctrlsqldesign.factory.FacadeFactory;
import com.kingdee.shr.rpts.ctrlsqldesign.model.BindParam;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignCommonQuery;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignKsqlSolver;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.model.ExtDBUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.model.SqlWhereParser;
import com.kingdee.shr.rpts.snapshot.ds.model.ShrSqlModel;
import java.awt.Window;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CtrlDesignDataExecutor {
    private static String calTableAlias = "cmp_CTB";
    public static final Logger log = LogUtil.getPackageLogger(CtrlDesignDataExecutor.class);
    private static Pattern REGULAR_EXPRESSION_1 = Pattern.compile("select\\s+top\\s+\\d+\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_2 = Pattern.compile("\\s*select\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_3 = Pattern.compile("\\s+rownum\\s*<{1}={0,1}\\s*\\d+\\s*", 2);
    private static Pattern REGULAR_EXPRESSION_4 = Pattern.compile("\\s+where\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_5 = Pattern.compile("select\\s+top\\s+\\d+\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_6 = Pattern.compile("\\s*select\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_7 = Pattern.compile("\\s+fetch\\s+first\\s+\\d+\\s+rows\\s+only\\s*", 2);
    private static Pattern REGULAR_EXPRESSION_8 = Pattern.compile("\\s*\\z", 2);
    private static Pattern REGULAR_EXPRESSION_9 = Pattern.compile("select\\s+top\\s+\\d+\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_10 = Pattern.compile("\\s*select\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_11 = Pattern.compile("\\s+rownum\\s*<{1}={0,1}\\s*\\d+\\s*", 2);
    private static Pattern REGULAR_EXPRESSION_12 = Pattern.compile("\\s+where\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_13 = Pattern.compile("select\\s+top\\s+\\d+\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_14 = Pattern.compile("\\s*select\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_15 = Pattern.compile("\\s+fetch\\s+first\\s+\\d+\\s+rows\\s+only\\s*", 2);
    private static Pattern REGULAR_EXPRESSION_16 = Pattern.compile("\\s*\\z", 2);
    private static Pattern REGULAR_EXPRESSION_17 = Pattern.compile("\\s*select\\s+top\\s+\\d+\\s+distinct\\s+", 2);
    private static Pattern REGULAR_EXPRESSION_18 = Pattern.compile("\\s+\\d+\\s+");
    private static Pattern REGULAR_EXPRESSION_19 = Pattern.compile("\\s*select\\s+distinct\\s+top\\s+\\d+\\s+top\\s+\\d+\\s+", 2);

    public static Map execute(Context ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap, int start, int rows, boolean isRun, Window parent) throws CtrlReportException {
        CtrlDesignCommonQuery commonQuery;
        String customType;
        if (logMap == null) {
            logMap = new HashMap<String, String>();
        }
        logMap.clear();
        if (mapDesignParam == null) {
            mapDesignParam = new HashMap();
        }
        if ((customType = CtrlReportUtil.getObjectString((commonQuery = model.getCommonQuery()).getProperties().get(CtrlDesignUtil.CustomType))).equals(String.valueOf(2))) {
            return CtrlDesignDataExecutor.callProcedure(ctx, model, mapDesignParam, logMap, start, rows);
        }
        if (customType.equals(String.valueOf(3)) || customType.equals(String.valueOf(7)) || customType.equals(String.valueOf(8))) {
            return CtrlDesignDataExecutor.executeJavaCode(ctx, model, mapDesignParam, logMap, start, rows, parent);
        }
        IQuery query = model.getQuery();
        String sql = null;
        try {
            if (customType.equals(String.valueOf(5))) {
                sql = model.getQuery().getContent();
            } else if (Integer.valueOf(model.getCommonQuery().getProperty(CtrlDesignUtil.CustomType).toString()) > 10) {
                CtrlDesignKsqlQuery ksqlQuery;
                sql = model.getQuery().getContent();
                if ((sql == null || "".equals(sql)) && (ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery()).isRegular()) {
                    sql = ShrSqlModel.makeShrSql(ctx, (ShrSqlModel)model);
                    ksqlQuery.setContent(sql);
                }
            } else {
                sql = CtrlDesignQueryModel.makeSQL(ctx, model);
            }
            sql = sql.trim();
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            sql = ReportPermissionTranslate.translate(ctx, sql, mapDesignParam);
            while (sql.indexOf("?") != -1) {
                String realName = SqlWhereParser.getRealParamNameMacro(sql);
                if (!realName.equals("")) {
                    if (mapDesignParam.containsKey(realName)) {
                        DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(realName));
                        String value = CtrlReportUtil.getObjectString(p.getCurentValue());
                        if (value.equals("")) {
                            throw new CtrlReportException(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"design_param_null", (Context)ctx) + ":" + realName);
                        }
                        sql = ExtStringUtil.replaceFirst(sql, "?" + realName, value);
                        continue;
                    }
                    throw new CtrlReportException(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"not_found_design_param", (Context)ctx) + ":" + realName);
                }
                sql = ExtStringUtil.replaceFirst(sql, "?", "0x1x2x3x4x");
            }
            sql = ExtStringUtil.replace(sql, "0x1x2x3x4x", "?");
        }
        catch (BOSException e) {
            throw new CtrlReportException(MessageUtil.getMsgInfo("label258") + e.getMessage());
        }
        catch (EASBizException e) {
            throw new CtrlReportException(MessageUtil.getMsgInfo("label258") + e.getMessage());
        }
        boolean isDialect = false;
        String sqllc = sql.toLowerCase();
        if (sql.substring(0, 11).equalsIgnoreCase("/*dialect*/")) {
            isDialect = true;
        }
        String sqlNoRN = null;
        sqlNoRN = ExtStringUtil.replace(sqllc, "\r", " ");
        sqlNoRN = ExtStringUtil.replace(sqlNoRN, "\n", " ");
        sqlNoRN = CtrlReportUtil.trimStr(sqlNoRN);
        if (!isRun) {
            if (sqlNoRN.indexOf("insert into ") != -1) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label243"));
            }
            if (sqlNoRN.startsWith("update ")) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label244"));
            }
        }
        int dbType = -1;
        if (!isDialect) {
            CtrlDesignKsqlQuery ksqlQuery;
            String outDB;
            int intYear = 10000;
            int intHour = 24;
            HashMap<String, String> dateTypeMap = new HashMap<String, String>();
            String sqlNoSpace = CtrlReportUtil.removeSpace(sqllc);
            try {
                Iterator it = mapDesignParam.keySet().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
                    if ("@customHrOrg".replace("@", "").equals(p.getName()) || "@customAdminOrg".replace("@", "").equals(p.getName()) || "@customAdminOrgRange".replace("@", "").equals(p.getName()) || "@customHrOrg".equals(p.getName()) || "@customAdminOrg".equals(p.getName()) || "@customAdminOrgRange".equals(p.getName())) continue;
                    String value = CtrlReportUtil.getObjectString(p.getCurentValue());
                    value = CtrlReportUtil.strFilterSQL(value);
                    p.setCurentValue(value);
                    boolean isDateTime = false;
                    int dataType = p.getDesignDataType().intValue();
                    if (dataType == 2) {
                        String msg;
                        boolean isDateToDateTime = false;
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1) {
                            msg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"date_type_param_alert", (Context)ctx), "{TS '@" + name + "'}", "{D '@" + name + "'}");
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            msg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"date_type_param_alert", (Context)ctx), "{TS '@" + name + "'}", "{T '@" + name + "'}");
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            isDateToDateTime = true;
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intYear + "-12-31";
                            if (isDateToDateTime) {
                                value = value + " " + "00:00:00";
                            }
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        } else if (isDateToDateTime) {
                            value = value + " " + "00:00:00";
                            p.setCurentValue(value);
                        }
                    } else if (dataType == 4) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"time_type_param_alert", (Context)ctx), "{TS '@" + name + "'}", "{D '@" + name + "'}");
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intYear + "-12-31 " + "01:02:03";
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        }
                    } else if (dataType == 5) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"datatime_type_param_alert", (Context)ctx);
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intHour + ":04:04";
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        }
                    }
                    if (!isDateTime) continue;
                    String oldvalue = "'@" + name + "'";
                    String newValue = "'" + value + "'";
                    sql = ExtStringUtil.replace(sql, oldvalue, newValue);
                }
            }
            catch (Exception ex) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label251") + ex.getMessage(), ex);
            }
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            try {
                sql = CtrlDesignKsqlSolver.solve(sql, mapDesignParam, dateTypeMap, true);
            }
            catch (CtrlReportException e) {
                throw e;
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label184") + e.getMessage(), e);
            }
            sql = SqlWhereParser.parseKSQLTime(sql, dbType);
            if (!isRun) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_1, sql, " select top " + (dbType == DataCenterDBType.DB2.intValue() ? (rows <= 0 ? 1 : rows) : rows) + " ", REGULAR_EXPRESSION_2);
            }
            if (!(outDB = CtrlReportUtil.getObjectString((ksqlQuery = (CtrlDesignKsqlQuery)query).getOutDB())).equals("")) {
                try {
                    sql = "/*dialect*/" + TransUtil.Translate((String)sql, (int)dbType);
                }
                catch (SqlTranslateException e) {
                    throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label284") + e.getMessage(), e);
                }
            }
        } else {
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            HashMap<String, String> warnMap = new HashMap<String, String>();
            warnMap.put("sqlNoRN", sqlNoRN);
            sql = BindParam.replaceVariantDialect(sql, mapDesignParam, dbType, warnMap);
            String warnMsg = CtrlReportUtil.getObjectString(warnMap.get("warnMsg"));
            if (null == ctx && !warnMsg.equals("") && !isRun) {
                MessageUtil.showInfo(warnMsg, false);
            }
            if (dbType == DataCenterDBType.ORACLE.intValue()) {
                if ((sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_3, sql, " where rownum<=" + rows + " and ", REGULAR_EXPRESSION_4)).endsWith(" and ")) {
                    sql = sql.substring(0, sql.lastIndexOf(" and "));
                }
            } else if (dbType == DataCenterDBType.SQLSERVER.intValue()) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_5, sql, " select top " + rows + " ", REGULAR_EXPRESSION_6);
            } else if (dbType == DataCenterDBType.DB2.intValue()) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_7, sql, " fetch first " + (rows <= 0 ? 1 : rows) + " rows only ", REGULAR_EXPRESSION_8);
            }
        }
        logMap.put("sql", sql);
        logMap.put("dbType", String.valueOf(dbType));
        MiscUtil.log((int)4, (String)sql);
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDBPageSizeInfoBySQL");
        pr.setString("sql", sql);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        CtrlDesignDataExecutor.setOutDBToPR(pr, query);
        RptParams ps_r = null;
        try {
            long startTime = CtrlReportUtil.getSystemTime();
            ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
            logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + MessageUtil.getMsgInfo("label256"));
        }
        catch (BOSException e) {
            String excMsg = "";
            Throwable t = e.getCause();
            excMsg = null != t ? CtrlReportUtil.getObjectString(t.getMessage()) : e.getMessage();
            String msg1 = MessageUtil.getMsgInfo("label185");
            throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
        }
        IRowSet irs = (IRowSet)ps_r.getObject("object");
        HashMap<String, IRowSet> mapResult = new HashMap<String, IRowSet>();
        mapResult.put("6xx8xxRowset", irs);
        return mapResult;
    }

    public static String buildModelSQL(Context ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap, int start, int rows, boolean isRun, Window parent) throws CtrlReportException {
        CtrlDesignCommonQuery commonQuery;
        String customType;
        if (logMap == null) {
            logMap = new HashMap<String, String>();
        }
        logMap.clear();
        if (mapDesignParam == null) {
            mapDesignParam = new HashMap();
        }
        if ((customType = CtrlReportUtil.getObjectString((commonQuery = model.getCommonQuery()).getProperties().get(CtrlDesignUtil.CustomType))).equals(String.valueOf(2))) {
            return null;
        }
        if (customType.equals(String.valueOf(3)) || customType.equals(String.valueOf(7)) || customType.equals(String.valueOf(8))) {
            return null;
        }
        IQuery query = model.getQuery();
        String sql = null;
        try {
            if (customType.equals(String.valueOf(5))) {
                sql = model.getQuery().getContent();
                SecrityTableAndFieldCheckUtil.checkPrivateInSQL((Context)ctx, (String)sql);
            } else if (Integer.valueOf(model.getCommonQuery().getProperty(CtrlDesignUtil.CustomType).toString()) > 10) {
                CtrlDesignKsqlQuery ksqlQuery;
                sql = model.getQuery().getContent();
                if ((sql == null || "".equals(sql)) && (ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery()).isRegular()) {
                    sql = ShrSqlModel.makeShrSql(ctx, (ShrSqlModel)model);
                    ksqlQuery.setContent(sql);
                }
            } else {
                sql = CtrlDesignQueryModel.makeSQL(ctx, model);
            }
            sql = ReportPermissionTranslate.translate(ctx, sql, mapDesignParam);
            if (Integer.valueOf(model.getCommonQuery().getProperty(CtrlDesignUtil.CustomType).toString()) == 14 && "002".equalsIgnoreCase(((ShrSqlModel)model).getScheme())) {
                String startDate = "";
                if (model.getCommonQuery().getProperty("startDate") != null) {
                    startDate = (String)model.getCommonQuery().getProperty("startDate");
                }
                String endDate = "";
                if (model.getCommonQuery().getProperty("endDate") != null) {
                    endDate = (String)model.getCommonQuery().getProperty("endDate");
                }
                HashMap<String, Object> pam = new HashMap<String, Object>();
                pam.put("calTableAlias", calTableAlias);
                pam.put("isKsql", false);
                pam.put("startDate", startDate);
                pam.put("endDate", endDate);
                List parameters = model.getCommonQuery().getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    DesignParameter designParam = (DesignParameter)((Object)parameters.get(i));
                    if ("adminOrg".equals(designParam.getName()) && mapDesignParam.containsKey("adminOrg")) {
                        pam.put("longNumber", ((DesignParameter)((Object)mapDesignParam.get("adminOrg"))).getCurentValue());
                        continue;
                    }
                    pam.put(designParam.getName(), designParam.getCurentValue());
                }
                Object cmpDecodeTable = OSFExecutor.executeOSF(ctx, pam, "cmpDecodeTable");
                String temptable = "T_HR_SCmpCalTable";
                if (null != cmpDecodeTable) {
                    temptable = cmpDecodeTable.toString();
                }
                if (sql != null && !"".equals(sql)) {
                    sql = sql.replaceAll("(?i)T_HR_SCmpCalTable", temptable);
                }
            }
            if ((sql = sql.trim()).endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            while (sql.indexOf("?") != -1) {
                String realName = SqlWhereParser.getRealParamNameMacro(sql);
                if (!realName.equals("")) {
                    if (mapDesignParam.containsKey(realName)) {
                        DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(realName));
                        String value = CtrlReportUtil.getObjectString(p.getCurentValue());
                        if (value.equals("")) {
                            throw new CtrlReportException(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"design_param_null", (Context)ctx) + ":" + realName);
                        }
                        sql = ExtStringUtil.replaceFirst(sql, "?" + realName, value);
                        continue;
                    }
                    throw new CtrlReportException(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"not_found_design_param", (Context)ctx) + ":" + realName);
                }
                sql = ExtStringUtil.replaceFirst(sql, "?", "0x1x2x3x4x");
            }
            sql = ExtStringUtil.replace(sql, "0x1x2x3x4x", "?");
        }
        catch (BOSException e) {
            throw new CtrlReportException(MessageUtil.getMsgInfo("label258") + e.getMessage());
        }
        catch (EASBizException e) {
            throw new CtrlReportException(e.getMessage(), e.getCause());
        }
        boolean isDialect = false;
        String sqllc = sql.toLowerCase();
        if (sql.substring(0, 11).equalsIgnoreCase("/*dialect*/")) {
            isDialect = true;
        }
        String sqlNoRN = null;
        sqlNoRN = ExtStringUtil.replace(sqllc, "\r", " ");
        sqlNoRN = ExtStringUtil.replace(sqlNoRN, "\n", " ");
        sqlNoRN = CtrlReportUtil.trimStr(sqlNoRN);
        if (!isRun) {
            if (sqlNoRN.indexOf("insert into ") != -1) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label243"));
            }
            if (sqlNoRN.startsWith("update ")) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label244"));
            }
        }
        int dbType = -1;
        if (!isDialect) {
            CtrlDesignKsqlQuery ksqlQuery;
            String outDB;
            int intYear = 10000;
            int intHour = 24;
            HashMap<String, String> dateTypeMap = new HashMap<String, String>();
            String sqlNoSpace = CtrlReportUtil.removeSpace(sqllc);
            try {
                Iterator it = mapDesignParam.keySet().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
                    if ("@customHrOrg".replace("@", "").equals(p.getName()) || "@customAdminOrg".replace("@", "").equals(p.getName()) || "@customAdminOrgRange".replace("@", "").equals(p.getName()) || "@customHrOrg".equals(p.getName()) || "@customAdminOrg".equals(p.getName()) || "@customAdminOrgRange".equals(p.getName())) continue;
                    String value = CtrlReportUtil.getObjectString(p.getCurentValue());
                    value = CtrlReportUtil.strFilterSQL(value);
                    p.setCurentValue(value);
                    boolean isDateTime = false;
                    int dataType = p.getDesignDataType().intValue();
                    if (dataType == 2) {
                        String msg;
                        boolean isDateToDateTime = false;
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1) {
                            msg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"date_type_param_alert", (Context)ctx), "{TS '@" + name + "'}", "{D '@" + name + "'}");
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            msg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"date_type_param_alert", (Context)ctx), "{TS '@" + name + "'}", "{T '@" + name + "'}");
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        } else if (sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            isDateToDateTime = true;
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intYear + "-12-31";
                            if (isDateToDateTime) {
                                value = value + " " + "00:00:00";
                            }
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        } else if (isDateToDateTime) {
                            value = value + " " + "00:00:00";
                            p.setCurentValue(value);
                        }
                    } else if (dataType == 4) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{t'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"time_type_param_alert", (Context)ctx), "{TS '@" + name + "'}", "{D '@" + name + "'}");
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intYear + "-12-31 " + "01:02:03";
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        }
                    } else if (dataType == 5) {
                        if (sqlNoSpace.indexOf("{d'@" + name.toLowerCase() + "'}") != -1 || sqlNoSpace.indexOf("{ts'@" + name.toLowerCase() + "'}") != -1) {
                            String msg = SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"datatime_type_param_alert", (Context)ctx);
                            MiscUtil.log((int)4, (String)msg);
                            log.debug((Object)msg);
                        }
                        isDateTime = true;
                        if (value.equals("")) {
                            value = --intHour + ":04:04";
                            p.setCurentValue(value);
                            dateTypeMap.put(name, value);
                        }
                    }
                    if (!isDateTime) continue;
                    String oldvalue = "'@" + name + "'";
                    String newValue = "'" + value + "'";
                    sql = ExtStringUtil.replace(sql, oldvalue, newValue);
                }
            }
            catch (Exception ex) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label251") + ex.getMessage(), ex);
            }
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            try {
                sql = CtrlDesignKsqlSolver.solve(sql, mapDesignParam, dateTypeMap, true);
            }
            catch (CtrlReportException e) {
                throw e;
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label184") + e.getMessage(), e);
            }
            sql = SqlWhereParser.parseKSQLTime(sql, dbType);
            if (!isRun) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_9, sql, " select top " + (dbType == DataCenterDBType.DB2.intValue() ? (rows <= 0 ? 1 : rows) : rows) + " ", REGULAR_EXPRESSION_10);
            }
            if (!(outDB = CtrlReportUtil.getObjectString((ksqlQuery = (CtrlDesignKsqlQuery)query).getOutDB())).equals("")) {
                try {
                    sql = "/*dialect*/" + TransUtil.Translate((String)sql, (int)dbType);
                }
                catch (SqlTranslateException e) {
                    throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label284") + e.getMessage(), e);
                }
            }
        } else {
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, query);
            dbType = Integer.parseInt(arr[0]);
            HashMap<String, String> warnMap = new HashMap<String, String>();
            warnMap.put("sqlNoRN", sqlNoRN);
            sql = BindParam.replaceVariantDialect(sql, mapDesignParam, dbType, warnMap);
            String warnMsg = CtrlReportUtil.getObjectString(warnMap.get("warnMsg"));
            if (null == ctx && !warnMsg.equals("") && !isRun) {
                MessageUtil.showInfo(warnMsg, false);
            }
            if (dbType == DataCenterDBType.ORACLE.intValue()) {
                if ((sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_11, sql, " where rownum<=" + rows + " and ", REGULAR_EXPRESSION_12)).endsWith(" and ")) {
                    sql = sql.substring(0, sql.lastIndexOf(" and "));
                }
            } else if (dbType == DataCenterDBType.SQLSERVER.intValue()) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_13, sql, " select top " + rows + " ", REGULAR_EXPRESSION_14);
            } else if (dbType == DataCenterDBType.DB2.intValue()) {
                sql = CtrlDesignDataExecutor.buildDialectTopNSQL(REGULAR_EXPRESSION_15, sql, " fetch first " + (rows <= 0 ? 1 : rows) + " rows only ", REGULAR_EXPRESSION_16);
            }
        }
        logMap.put("sql", sql);
        return sql;
    }

    private static String buildDialectTopNSQL(Pattern topNFinder, String sql, String topNReplaceMement, Pattern insertPlaceFinder) {
        StringBuffer sb = new StringBuffer();
        Matcher m = topNFinder.matcher(sql);
        boolean found = false;
        int lastEnd = 0;
        while (m.find()) {
            found = true;
            m.group();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(topNReplaceMement);
            lastEnd = m.end();
        }
        if (found) {
            sb.append(sql.substring(lastEnd));
        }
        if (!found) {
            m = insertPlaceFinder.matcher(sql);
            if (m.find()) {
                m.group();
                found = true;
                sb.append(sql.substring(lastEnd, m.start()));
                sb.append(topNReplaceMement);
                lastEnd = m.end();
            }
            if (!found) {
                sb.append(sql);
            } else {
                sb.append(sql.substring(lastEnd));
            }
        }
        sql = sb.toString();
        sb = new StringBuffer();
        found = false;
        lastEnd = 0;
        Pattern distinctFinder = REGULAR_EXPRESSION_17;
        m = distinctFinder.matcher(sql);
        Pattern numberFinder = REGULAR_EXPRESSION_18;
        while (m.find()) {
            found = true;
            String group = m.group();
            Matcher t = numberFinder.matcher(group);
            t.find();
            sb.append(sql.substring(lastEnd, m.start()));
            sb.append(" select distinct top " + t.group() + " ");
            lastEnd = m.end();
        }
        if (!found) {
            sb.append(sql);
        } else {
            sb.append(sql.substring(lastEnd));
            found = false;
            lastEnd = 0;
            Pattern doubleTopFinder = REGULAR_EXPRESSION_19;
            sql = sb.toString();
            sb = new StringBuffer();
            m = doubleTopFinder.matcher(sql);
            while (m.find()) {
                found = true;
                String group = m.group();
                Matcher t = numberFinder.matcher(group);
                t.find();
                sb.append(sql.substring(lastEnd, m.start()));
                sb.append(" select distinct top " + t.group() + " ");
                lastEnd = m.end();
            }
            if (found) {
                sb.append(sql.substring(lastEnd));
                sql = sb.toString();
            } else {
                sb.append(sql);
            }
        }
        sql = sb.toString();
        return sql;
    }

    public static IRowSet preview(CtrlDesignQueryModel model, Map mapDesignParam, Map logMap) throws Exception {
        Map mapResult = CtrlDesignDataExecutor.execute(null, model, mapDesignParam, logMap, 0, 0, false, null);
        IRowSet irs = (IRowSet)mapResult.get("6xx8xxRowset");
        return irs;
    }

    public static String[] getDBType(Context ctx, IQuery query) throws CtrlReportException {
        String[] arr = new String[2];
        int ret = CtrlDesignDataExecutor.getOutDBType(ctx, query);
        if (ret != -1) {
            DataCenterDBType dbType = DataCenterDBType.getDBType((int)ret);
            arr[0] = String.valueOf(dbType.intValue());
            arr[1] = dbType.getName();
        } else {
            int dbType = ExtDBUtil.getDBType(ctx);
            arr[0] = String.valueOf(dbType);
            switch (dbType) {
                case 1: {
                    arr[1] = "DB2";
                }
                case 2: {
                    arr[1] = "Oracle";
                }
                case 5: {
                    arr[1] = "PostgresSQL";
                }
                case 3: {
                    arr[1] = "SqlServer";
                }
                case 12: {
                    arr[1] = "Kingbase";
                }
            }
        }
        return arr;
    }

    private static int getOutDBType(Context ctx, IQuery query) throws CtrlReportException {
        int ret = -1;
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        if (outDB.equals("")) {
            return ret;
        }
        RptParams pr = new RptParams();
        pr.setString("MethodName", "getDataCenterVo");
        pr.setObject("outDB", (Object)outDB);
        try {
            RptParams ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
            Object obj = ps_r.getObject("getDataCenterVo");
            if (obj == null) {
                throw new CtrlReportException(outDB + "\uff1a" + MessageUtil.getMsgInfo("label283"));
            }
            DataCenterInfo vo = (DataCenterInfo)obj;
            return vo.getDbType();
        }
        catch (Exception e) {
            throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label283"), e);
        }
    }

    private static final void setOutDBToPR(RptParams pr, IQuery query) {
        CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)query;
        String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
        if (!outDB.equals("")) {
            pr.setObject("outDB", (Object)outDB);
        }
    }

    public static Map callProcedure(Context ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap, int start, int rows) throws CtrlReportException {
        ProcedureModel pm = model.getCommonQuery().getProcedureModel();
        ArrayList<InOutputParamVO> procedureVOList = new ArrayList<InOutputParamVO>();
        StringBuffer logProcedureParam = new StringBuffer();
        ArrayList paramList = pm.getParamList();
        if (paramList != null && !paramList.isEmpty()) {
            int size = paramList.size();
            for (int i = 0; i < size; ++i) {
                ProcedureParamData pmd = (ProcedureParamData)((Object)paramList.get(i));
                String name = pmd.getName();
                int ioType = pmd.getIoType().intValue();
                int dataType = pmd.getDataType().intValue();
                Object objValue = null;
                if (ioType == 0) {
                    objValue = CtrlDesignDataExecutor.getProcedureValue(pmd, mapDesignParam, ctx);
                }
                InOutputParamVO vo = new InOutputParamVO();
                vo.setName(name);
                vo.setIoType(ioType);
                vo.setDataType(dataType);
                vo.setValue(objValue);
                procedureVOList.add(vo);
                logProcedureParam.append(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"store_procedure_param", (Context)ctx) + ":").append(name).append(", value =").append(objValue);
                logProcedureParam.append(", ioType = ").append(pmd.getIoType()).append(", DataType = ").append(pmd.getDataType()).append("\r\n");
            }
        }
        String resultNumberName = null;
        resultNumberName = pm.getDbType() == 2 ? pm.getResultCursor() : String.valueOf(pm.getResultNumber());
        RptParams pr = new RptParams();
        pr.setString("MethodName", "callProcedure");
        pr.setString("procedureName", pm.getName());
        pr.setInt("dbType", pm.getDbType());
        pr.setString("resultNumberName", resultNumberName);
        pr.setObject("paramList", procedureVOList);
        pr.setInt("start", start);
        pr.setInt("rows", rows);
        CtrlDesignDataExecutor.setOutDBToPR(pr, model.getQuery());
        RptParams ps_r = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("start call storeProcedure: " + pm.getName()));
                String paramLog = logProcedureParam.toString();
                log.debug((Object)("\r\n" + paramLog));
            }
            MiscUtil.log((int)4, (String)("start call storeProcedure: " + pm.getName()));
            MiscUtil.log((int)4, (String)("\r\n" + logProcedureParam.toString()));
            long startTime = CtrlReportUtil.getSystemTime();
            ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
            logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + MessageUtil.getMsgInfo("label256"));
        }
        catch (BOSException e) {
            String excMsg = "";
            Throwable t = e.getCause();
            excMsg = null != t ? CtrlReportUtil.getObjectString(t.getMessage()) : e.getMessage();
            throw CtrlReportException.makeException(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"exe_store_procedure_fails", (Context)ctx) + ":\r\n" + excMsg, e);
        }
        HashMap mapResult = (HashMap)ps_r.getObject("object");
        return mapResult;
    }

    private static Map executeJavaCode(Context ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap, int start, int rows, Window parent) throws CtrlReportException {
        HashMap<String, Object> toJavaMap = new HashMap<String, Object>();
        toJavaMap.put("CtrlDesignQueryModel", model);
        StringBuffer logParamSystem = new StringBuffer();
        StringBuffer logParamCustom = new StringBuffer();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            toJavaMap.put(p.getName(), CtrlReportUtil.getObjectString(p.getCurentValue()));
            if (name.startsWith("ExtRpt")) {
                logParamSystem.append(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"builtin_param", (Context)ctx) + ":").append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
                continue;
            }
            logParamCustom.append(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"custommade_param", (Context)ctx) + ":").append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
        }
        StringBuffer logParam = new StringBuffer();
        logParam.append("\r\n").append(logParamCustom).append(logParamSystem);
        if (log.isDebugEnabled()) {
            String paramLog = logParam.toString();
            log.debug((Object)paramLog);
        }
        MiscUtil.log((int)4, (String)logParam.toString());
        JavaModel jm = model.getCommonQuery().getJavaModel();
        int interfaceType = jm.getInterfaceType();
        int executeType = jm.getExecuteType();
        IJavaDataSet iJavaDataSet = null;
        String customSQL = "";
        IRowSet irs = null;
        HashMap<String, Object> mapResult = new HashMap<String, Object>();
        if (jm.getFullname().startsWith("OSF")) {
            irs = OSFDataSet.getCustomRowSet(ctx, jm.getFullname(), toJavaMap);
            mapResult.put("6xx8xxRowset", irs);
        } else {
            String strFullName = jm.getFullname();
            if (strFullName.equals("")) {
                throw new CtrlReportException(MessageUtil.getMsgInfo("label349"));
            }
            try {
                iJavaDataSet = (IJavaDataSet)Class.forName(strFullName).newInstance();
                iJavaDataSet.setFilterParam(toJavaMap);
                iJavaDataSet.setContext(ctx);
                if (interfaceType == 0) {
                    customSQL = iJavaDataSet.getCustomSQL(parent);
                }
            }
            catch (Exception e) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label350") + e.getMessage(), e);
            }
            catch (Throwable t) {
                throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label350") + t.getMessage(), t);
            }
            String[] arr = CtrlDesignDataExecutor.getDBType(ctx, model.getQuery());
            int dbType = Integer.parseInt(arr[0]);
            logMap.put("sql", customSQL);
            logMap.put("dbType", String.valueOf(dbType));
            MiscUtil.log((int)4, (String)customSQL);
            if (interfaceType == 0) {
                RptParams pr = new RptParams();
                pr.setString("MethodName", "getDBPageSizeInfoBySQL");
                pr.setString("sql", customSQL);
                pr.setInt("start", start);
                pr.setInt("rows", rows);
                CtrlDesignDataExecutor.setOutDBToPR(pr, model.getQuery());
                RptParams ps_r = null;
                try {
                    long startTime = CtrlReportUtil.getSystemTime();
                    ps_r = FacadeFactory.commonExecuteNever(ctx, pr);
                    logMap.put("useTime", CtrlReportUtil.getSystemTime() - startTime + " " + MessageUtil.getMsgInfo("label256"));
                }
                catch (BOSException e) {
                    String excMsg = "";
                    Throwable t = e.getCause();
                    if (null != t) {
                        excMsg = CtrlReportUtil.getObjectString(t.getMessage());
                    }
                    String msg1 = MessageUtil.getMsgInfo("label185");
                    throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
                }
                irs = (IRowSet)ps_r.getObject("object");
            } else {
                CtrlDesignKsqlQuery ksqlQuery = (CtrlDesignKsqlQuery)model.getQuery();
                String outDB = CtrlReportUtil.getObjectString(ksqlQuery.getOutDB());
                try {
                    IRowSet[] iRowSets = iJavaDataSet.getCustomRowSet(parent, outDB);
                    irs = iRowSets[0];
                }
                catch (Exception e) {
                    String excMsg = "";
                    Throwable t = e.getCause();
                    if (null != t) {
                        excMsg = CtrlReportUtil.getObjectString(t.getMessage());
                    }
                    String msg1 = MessageUtil.getMsgInfo("label351");
                    throw CtrlReportException.makeException(msg1 + "\r\n" + excMsg, e);
                }
            }
            mapResult.put("6xx8xxRowset", irs);
            StringBuffer logProcedureParam = new StringBuffer();
            try {
                Map mapFromJava = iJavaDataSet.getOutputParam();
                ArrayList paramList = jm.getParamList();
                if (paramList != null && !paramList.isEmpty()) {
                    int size = paramList.size();
                    for (int i = 0; i < size; ++i) {
                        ProcedureParamData pmd = (ProcedureParamData)((Object)paramList.get(i));
                        String name = pmd.getName();
                        String value = CtrlReportUtil.getObjectString(mapFromJava.get(name));
                        InOutputParamVO vo = new InOutputParamVO();
                        vo.setName(name);
                        vo.setDataType(pmd.getDataType().intValue());
                        vo.setValue(value);
                        mapResult.put(name, vo);
                        logProcedureParam.append(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"output_param", (Context)ctx) + ":").append(name).append(", value =").append(value);
                        logProcedureParam.append(", DataType = ").append(pmd.getDataType()).append("\r\n");
                    }
                }
                String paramLog = logProcedureParam.toString();
                log.debug((Object)("\r\n" + paramLog));
                MiscUtil.log((int)4, (String)("\r\n" + logProcedureParam.toString()));
            }
            catch (Throwable t) {
                log.debug((Object)"Error fetching output parameters", t);
                MiscUtil.log((Throwable)t);
            }
        }
        return mapResult;
    }

    private static Object getProcedureValue(ProcedureParamData pmd, Map mapDesignParam, Context ctx) throws CtrlReportException {
        String bindFilterParamName = CtrlReportUtil.getObjectString(pmd.getBindFilterParamName());
        int dataType = pmd.getDataType().intValue();
        String value = null;
        if (bindFilterParamName.equals("") || !mapDesignParam.containsKey(bindFilterParamName)) {
            value = pmd.getDefaultValue();
            String errorMsg = MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"unbind_filter_param", (Context)ctx), bindFilterParamName);
            log.debug((Object)errorMsg);
            MiscUtil.log((int)4, (String)errorMsg);
        } else {
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(bindFilterParamName));
            value = CtrlReportUtil.getObjectString(p.getCurentValue());
            if (value.equals("")) {
                value = pmd.getDefaultValue();
            }
        }
        try {
            switch (dataType) {
                case 0: {
                    return value;
                }
                case 1: {
                    return new Integer(value);
                }
                case 2: {
                    return new BigDecimal(value);
                }
                case 3: {
                    long longDate = new SimpleDateFormat("yyyy-MM-dd").parse(value).getTime();
                    return new Date(longDate);
                }
                case 4: {
                    return new Timestamp(CtrlReportUtil.getDateLong(value));
                }
                case 5: {
                    return new Time(CtrlReportUtil.getTimeLong(value));
                }
            }
            return null;
        }
        catch (Exception e) {
            String msg = SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"storeproced_inputparam_error", (Context)ctx) + "\r\n" + MessageFormat.format(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"param_names", (Context)ctx), pmd.getName() + "\r\n", pmd.getDataType() + "\r\n", value + "\r\n", e.getMessage());
            throw CtrlReportException.makeException(msg, e);
        }
    }
}

