/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.datacenter.DataCenterDBType;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.shr.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.shr.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.shr.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.data.DesignDataType;
import com.kingdee.shr.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.shr.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.shr.rpts.ctrlsqldesign.model.DateUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.model.SqlParamParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class SqlWhereParser {
    public static final Logger log = LogUtil.getPackageLogger(SqlWhereParser.class);
    public static final String EX_LIST = "EX_LIST";
    public static final String EX_DATETIME = "EX_DATETIME";
    private static final String Formula_String = "Formula_String";
    private static final String Field_String = "Field_String";
    private static final String Operator_String = "Operator_String";
    private static final String Param_String = "Param_String";
    private static final String RealParamName = "realParamName";
    public static final String BEGIN0xx1xx = "BEGIN0XX1XX";
    public static final String END0xx1xx = " OR (END0XX1XX IS NULL)";
    public static final String DateTimeEnd = "01:02:03";
    public static final String ZERO = "00:00:00";

    private static final int indexOf(String source, String target, int n) {
        int index = 0;
        int i = 0;
        int fromIndex = 0;
        while ((index = source.indexOf(target, fromIndex)) != -1) {
            if (++i == n) {
                return index;
            }
            fromIndex = index + 1;
        }
        return index;
    }

    public static final String parseList(String sql, ArrayList lstParam) {
        HashMap mapFormula = SqlWhereParser.splitEX(sql, EX_LIST);
        if (null == mapFormula) {
            return sql;
        }
        String formula_list = mapFormula.get(Formula_String).toString();
        String field = mapFormula.get(Field_String).toString();
        String operator = mapFormula.get(Operator_String).toString();
        String paramString = mapFormula.get(Param_String).toString();
        String realParamName = mapFormula.get(RealParamName).toString();
        ArrayList<DesignParameter> lstNewAddParam = new ArrayList<DesignParameter>();
        StringBuffer newWhere = new StringBuffer();
        for (DesignParameter p : lstParam) {
            String currentName = p.getName();
            if (!realParamName.equalsIgnoreCase(currentName)) continue;
            String[] values = p.getCurentValueArr();
            if (null != values && values.length > 1) {
                int length = values.length;
                String newParamName = currentName + String.valueOf(CtrlReportUtil.getSystemTime());
                if (operator.equals("IN") || operator.equals("NOT IN")) {
                    newWhere.append(field).append(" ").append(operator).append(" (");
                } else {
                    newWhere.append("(");
                }
                for (int n = 0; n < length; ++n) {
                    String currentNewParamName = newParamName + "_" + n;
                    String newParamNameTemp = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentNewParamName, false, false);
                    if (operator.equals("IN") || operator.equals("NOT IN")) {
                        newWhere.append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(", ");
                        }
                    } else {
                        newWhere.append(field).append(" ").append(operator).append(" ").append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(" OR ");
                        }
                    }
                    DesignParameter pNew = new DesignParameter();
                    pNew.setName(currentNewParamName);
                    pNew.setDesignDataType(p.getDesignDataType());
                    pNew.setCurentValue(values[n]);
                    lstNewAddParam.add(pNew);
                }
                newWhere.append(")");
                break;
            }
            paramString = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentName, false, false);
            if (operator.equals("IN") || operator.equals("NOT IN")) {
                newWhere.append(field).append(" ").append(operator).append(" (").append(paramString).append(")");
                break;
            }
            newWhere.append("(").append(field).append(" ").append(operator).append(" ").append(paramString).append(")");
            break;
        }
        lstParam.addAll(lstNewAddParam);
        sql = ExtStringUtil.replace(sql, formula_list, newWhere.toString(), false, false);
        return SqlWhereParser.parseList(sql, lstParam);
    }

    public static final String getRealParamName(String source) {
        String s;
        int start = source.indexOf("@");
        if (start == -1) {
            return null;
        }
        source = source.substring(start + 1);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < source.length() && !SqlParamParser.isErrorParamName(s = source.substring(i, i + 1)); ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static final String getRealParamNameMacro(String source) {
        String s;
        int start = source.indexOf("?");
        if (start == -1) {
            return null;
        }
        source = source.substring(start + 1);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < source.length() && !SqlParamParser.isErrorParamName(s = source.substring(i, i + 1)); ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static final String parseDialectDateTime(String sql, Map mapDesignParam, int tempParamSize, int DBType) {
        try {
            HashMap mapFormula = SqlWhereParser.splitEXSimple(sql, EX_DATETIME);
            if (null == mapFormula) {
                return sql;
            }
            String formula_string = mapFormula.get(Formula_String).toString();
            String field = mapFormula.get(Field_String).toString();
            String operator = mapFormula.get(Operator_String).toString();
            String paramString = mapFormula.get(Param_String).toString();
            String realParamName = mapFormula.get(RealParamName).toString();
            StringBuffer newWhere = new StringBuffer();
            paramString = ExtStringUtil.replace(paramString, "'", "");
            String subStr = "@" + realParamName;
            if (!mapDesignParam.containsKey(realParamName)) {
                return sql;
            }
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(realParamName));
            String currentName = p.getName();
            String valueDate = p.getCurentValue();
            int dataType = p.getDesignDataType().intValue();
            String newParamName = currentName + String.valueOf(CtrlReportUtil.getSystemTime()) + "_" + ++tempParamSize;
            boolean isUserNewParamName = false;
            String newValueDate = "";
            String replaceOldName = currentName;
            String replaceNewName = newParamName;
            if (dataType == 2) {
                if (DBType == DataCenterDBType.ORACLE.intValue()) {
                    replaceOldName = "TO_DATE('@" + currentName + " 00:00:00', 'YYYY-MM-DD HH24:MI:SS')";
                    replaceNewName = "TO_DATE('@" + replaceNewName + " 00:00:00', 'YYYY-MM-DD HH24:MI:SS')";
                } else {
                    replaceOldName = "'@" + currentName + " 00:00:00'";
                    replaceNewName = "'@" + replaceNewName + " 00:00:00'";
                }
                if (valueDate.length() > 0) {
                    newValueDate = DateUtil.tuneDate(valueDate, 1);
                }
            } else if (dataType == 4) {
                if (DBType == DataCenterDBType.ORACLE.intValue()) {
                    replaceOldName = "TO_DATE('@" + currentName + "', 'YYYY-MM-DD HH24:MI:SS')";
                    replaceNewName = "TO_DATE('@" + replaceNewName + "', 'YYYY-MM-DD HH24:MI:SS')";
                } else {
                    replaceOldName = "'@" + currentName + "'";
                    replaceNewName = "'@" + replaceNewName + "'";
                }
                if (valueDate.length() > 0) {
                    newValueDate = DateUtil.tuneSecond(valueDate, 1);
                }
            } else if (dataType == 5) {
                replaceOldName = "'@" + currentName + "'";
                if (DBType == 3) {
                    newWhere.append("CONVERT(varchar(12), ").append(field).append(", 108) ").append(operator).append(" ").append(replaceOldName);
                } else if (DBType == 2) {
                    newWhere.append("TO_CHAR(").append(field).append(", 'HH24:MI:SS') ").append(operator).append(" ").append(replaceOldName);
                } else if (DBType == 1) {
                    newWhere.append("SUBSTR(TO_CHAR(").append(field).append(", 'YYYY-MM-DD HH24:MI:SS'), 12, 8) ").append(operator).append(" ").append(replaceOldName);
                }
            } else {
                log.error((Object)"Unsupported data type conversion, please use another method");
                return sql;
            }
            if (dataType != 5) {
                String paramString_end;
                String paramString_star;
                newWhere.append("(");
                if (operator.equals("=")) {
                    newWhere.append(field).append(" >= ");
                    paramString_star = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_star);
                    newWhere.append(" AND ");
                    newWhere.append(field).append(" < ");
                    String paramString_end2 = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end2);
                    isUserNewParamName = true;
                } else if (operator.equals(">")) {
                    newWhere.append(field).append(" >= ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end);
                    isUserNewParamName = true;
                } else if (operator.equals(">=")) {
                    newWhere.append(field).append(" >= ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_end);
                } else if (operator.equals("<")) {
                    newWhere.append(field).append(" < ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_end);
                } else if (operator.equals("<=")) {
                    newWhere.append(field).append(" < ");
                    paramString_end = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end);
                    isUserNewParamName = true;
                } else if (operator.equals("<>")) {
                    newWhere.append(field).append(" < ");
                    paramString_star = ExtStringUtil.replaceFirst(paramString, subStr, replaceOldName);
                    newWhere.append(paramString_star);
                    newWhere.append(" AND ");
                    newWhere.append(field).append(" >= ");
                    String paramString_end3 = ExtStringUtil.replaceFirst(paramString, subStr, replaceNewName);
                    newWhere.append(paramString_end3);
                    isUserNewParamName = true;
                }
                newWhere.append(")");
            }
            if (isUserNewParamName) {
                DesignParameter pNew = new DesignParameter();
                pNew.setName(newParamName);
                pNew.setDesignDataType(p.getDesignDataType());
                pNew.setCurentValue(newValueDate);
                mapDesignParam.put(newParamName, pNew);
            }
            sql = ExtStringUtil.replaceFirst(sql, formula_string, newWhere.toString());
            return SqlWhereParser.parseDialectDateTime(sql, mapDesignParam, tempParamSize, DBType);
        }
        catch (Exception e) {
            log.error((Object)"parseDialectDateTime error", (Throwable)e);
            return sql;
        }
    }

    public static final String parseKSQLList(String whereString, String field, String operator, String paramString, Map mapDesignParam, Map mapParam) {
        String realParamName;
        boolean isComma = false;
        String tempFlag = "";
        tempFlag = operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN") ? "('" + paramString : "'" + paramString;
        if (whereString.toLowerCase().indexOf(tempFlag.toLowerCase()) != -1) {
            isComma = true;
        }
        if ((realParamName = SqlWhereParser.getRealParamName(paramString)) == null) {
            log.debug((Object)(paramString + " No parameter ID @"));
            return null;
        }
        HashMap<String, DesignParameter> mapDesignParamNew = new HashMap<String, DesignParameter>();
        StringBuffer newWhere = new StringBuffer();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            String currentName = p.getName();
            DesignDataType ddt = p.getDesignDataType();
            if (!realParamName.equalsIgnoreCase(currentName)) continue;
            String[] values = null;
            String value = p.getCurentValue();
            if (value.indexOf("0xx1xx") != -1) {
                values = value.split("0xx1xx");
            }
            if (null != values && values.length > 1) {
                int length = values.length;
                String newParamName = currentName + String.valueOf(CtrlReportUtil.getSystemTime());
                if (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN")) {
                    newWhere.append(field).append(" ").append(operator).append(" (");
                } else {
                    newWhere.append("(");
                }
                for (int n = 0; n < length; ++n) {
                    String currentNewParamName = newParamName + "_" + n;
                    String newParamNameTemp = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentNewParamName, false, false);
                    if (isComma) {
                        newParamNameTemp = "'" + newParamNameTemp + "'";
                    }
                    if (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN")) {
                        newWhere.append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(", ");
                        }
                    } else {
                        newWhere.append(field).append(" ").append(operator).append(" ").append(newParamNameTemp);
                        if (n < length - 1) {
                            newWhere.append(" or ");
                        }
                    }
                    DesignParameter pNew = new DesignParameter();
                    pNew.setName(currentNewParamName);
                    pNew.setDesignDataType(p.getDesignDataType());
                    pNew.setCurentValue(values[n]);
                    mapDesignParamNew.put(currentNewParamName, pNew);
                    mapParam.put(currentNewParamName, values[n]);
                }
                newWhere.append(")");
                break;
            }
            paramString = ExtStringUtil.replace(paramString, "@" + currentName, "@" + currentName, false, false);
            if (isComma) {
                paramString = "'" + paramString + "'";
            }
            if (operator.equalsIgnoreCase("IN") || operator.equalsIgnoreCase("NOT IN")) {
                newWhere.append(field).append(" ").append(operator).append(" (").append(paramString).append(")");
                break;
            }
            newWhere.append("(").append(field).append(" ").append(operator).append(" ").append(paramString).append(")");
            break;
        }
        mapDesignParam.putAll(mapDesignParamNew);
        return newWhere.toString();
    }

    public static final String parseKSQLDateTime(String field, String operator, String paramString) {
        int start = paramString.indexOf("{TS '");
        int end = paramString.indexOf("'}");
        String dateTimeString = paramString.substring(start + 5, end);
        if (paramString.indexOf("{TS") != -1) {
            String[] arr = dateTimeString.split(" ");
            String strDate = arr[0];
            String strTime = arr[1];
            if (strTime.equals(DateTimeEnd)) {
                return SqlWhereParser.chgDate(field, operator, strDate);
            }
            return SqlWhereParser.chgDateTime(field, operator, dateTimeString);
        }
        if (paramString.indexOf("{T") != -1) {
            return SqlWhereParser.chgTime(field, operator, dateTimeString);
        }
        return null;
    }

    private static final String chgDate(String field, String operator, String strDate) {
        StringBuffer where = new StringBuffer();
        if (operator.equals("=")) {
            String dateAdd = DateUtil.tuneDate(strDate, 1);
            where.append("(");
            where.append(field).append(" >= ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
            where.append(" and ");
            where.append(field).append(" < ").append("{TS '").append(dateAdd).append(" ").append(ZERO).append("'}");
            where.append(")");
        } else if (operator.equals(">")) {
            String dateAdd = DateUtil.tuneDate(strDate, 1);
            where.append(field).append(" >= ").append("{TS '").append(dateAdd).append(" ").append(ZERO).append("'}");
        } else if (operator.equals(">=")) {
            where.append(field).append(" >= ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
        } else if (operator.equals("<")) {
            where.append(field).append(" < ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
        } else if (operator.equals("<=")) {
            where.append(field).append(" <= ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
        } else if (operator.equals("<>")) {
            String dateAdd = DateUtil.tuneDate(strDate, 1);
            where.append("(");
            where.append(field).append(" < ").append("{TS '").append(strDate).append(" ").append(ZERO).append("'}");
            where.append(" or ");
            where.append(field).append(" >= ").append("{TS '").append(dateAdd).append(" ").append(ZERO).append("'}");
            where.append(")");
        }
        return where.toString();
    }

    private static final String chgDateTime(String field, String operator, String strDateTime) {
        StringBuffer where = new StringBuffer();
        if (operator.equals("=")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append("(");
            where.append(field).append(" >= ").append("{TS '").append(strDateTime).append("'}");
            where.append(" and ");
            where.append(field).append(" < ").append("{TS '").append(newDateTime).append("'}");
            where.append(")");
        } else if (operator.equals(">")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append(field).append(" >= ").append("{TS '").append(newDateTime).append("'}");
        } else if (operator.equals(">=")) {
            where.append(field).append(" >= ").append("{TS '").append(strDateTime).append("'}");
        } else if (operator.equals("<")) {
            where.append(field).append(" < ").append("{TS '").append(strDateTime).append("'}");
        } else if (operator.equals("<=")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append(field).append(" < ").append("{TS '").append(newDateTime).append("'}");
        } else if (operator.equals("<>")) {
            String newDateTime = DateUtil.tuneSecond(strDateTime, 1);
            where.append("(");
            where.append(field).append(" < ").append("{TS '").append(strDateTime).append("'}");
            where.append(" or ");
            where.append(field).append(" >= ").append("{TS '").append(newDateTime).append("'}");
            where.append(")");
        }
        return where.toString();
    }

    private static final String getTimeString(String dateTimeString) {
        String[] arr = dateTimeString.split(" ");
        String strTime = arr[1];
        return strTime;
    }

    private static final String chgTime(String field, String operator, String strTime) {
        StringBuffer where = new StringBuffer();
        if (field.startsWith("\"")) {
            field = field.substring(1);
            where.append("\"");
        }
        where.append(BEGIN0xx1xx).append(field).append(" ").append(operator).append(" {T '").append(strTime).append("'}").append(END0xx1xx);
        return where.toString();
    }

    public static final String parseKSQLTime(String sql, int dbType) throws CtrlReportException {
        int begin = sql.indexOf(BEGIN0xx1xx);
        if (begin == -1) {
            return sql;
        }
        try {
            sql = "/*dialect*/" + TransUtil.Translate((String)sql, (int)dbType);
        }
        catch (SqlTranslateException e) {
            throw CtrlReportException.makeException("KSQL" + EASResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"translate_fails") + e.getMessage(), e);
        }
        begin = sql.indexOf(BEGIN0xx1xx);
        while (begin != -1) {
            StringBuffer where = new StringBuffer();
            int end = sql.indexOf(END0xx1xx);
            String temp = sql.substring(begin, end).trim();
            String sourceReplace = sql.substring(begin, end + END0xx1xx.length());
            String[] arr = temp.split(" ");
            String field = arr[0];
            if (field.indexOf("\".") != -1) {
                temp = sql.substring(begin - 1, end).trim();
                sourceReplace = sql.substring(begin - 1, end + END0xx1xx.length());
            }
            arr = temp.split(" ");
            field = arr[0];
            field = ExtStringUtil.replaceFirst(field, BEGIN0xx1xx, "");
            String operator = arr[1];
            String filterValue = arr[2];
            if (dbType == 3) {
                where.append("CONVERT(varchar(12), ").append(field).append(", 108) ").append(operator).append(" ").append(filterValue);
            } else if (dbType == 2) {
                sourceReplace = "(" + sourceReplace;
                filterValue = ExtStringUtil.replace(filterValue, "TO_DATE(", "", false, false);
                filterValue = ExtStringUtil.replace(filterValue, ",", "", false, false);
                where.append("TO_CHAR(").append(field).append(", 'HH24:MI:SS') ").append(operator).append(" ").append(filterValue);
            } else if (dbType == 1) {
                where.append("SUBSTR(TO_CHAR(").append(field).append(", 'YYYY-MM-DD HH24:MI:SS'), 12, 8) ").append(operator).append(" ").append(filterValue);
            }
            sql = ExtStringUtil.replaceFirst(sql, sourceReplace, where.toString());
            begin = sql.indexOf(BEGIN0xx1xx);
        }
        return sql;
    }

    public static final String parseDialect(String source, Map mapDesignParam, Map warnMap) throws Exception {
        String sqlNoRN;
        String warnMsg;
        StringBuffer sbSql = new StringBuffer();
        int start = source.indexOf("@");
        String sqlBefore = source.substring(0, start);
        String sqlAfter = source.substring(start + 1);
        String paramName = SqlWhereParser.getRealParamName("@" + sqlAfter);
        String parmaValue = "";
        DesignDataType parmaType = DesignDataType.TXT;
        boolean isAllowNull = true;
        if (mapDesignParam.containsKey(paramName)) {
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(paramName));
            parmaValue = CtrlReportUtil.getObjectString(p.getCurentValue());
            parmaType = p.getDesignDataType();
            isAllowNull = p.isAllowNull();
        }
        sbSql.append(sqlBefore);
        boolean isFindWH = false;
        int wh = sqlAfter.indexOf("?");
        int art = sqlAfter.indexOf("@");
        if (wh != -1 && art != -1 && wh < art) {
            isFindWH = true;
        } else if (wh != -1 && art == -1) {
            isFindWH = true;
        }
        if (!isFindWH && isAllowNull && (warnMsg = CtrlReportUtil.getObjectString(warnMap.get("warnMsg"))).equals("") && (sqlNoRN = (String)warnMap.get("sqlNoRN")).indexOf("? is null") == -1) {
            warnMap.put("warnMsg", MessageUtil.getMsgInfo("label340") + "\r\n" + MessageUtil.getMsgInfo("label341"));
        }
        if (null == parmaValue) {
            parmaValue = "";
        }
        parmaValue = CtrlReportUtil.strFilterSQL(parmaValue);
        boolean isIcom = false;
        if (sqlAfter.indexOf(paramName + "'") != -1 || sqlAfter.indexOf(paramName + "%") != -1 || sqlAfter.indexOf(paramName + " " + ZERO) != -1) {
            isIcom = true;
        }
        String valueSplit = "";
        String[] values = parmaValue.split("0xx1xx");
        if (null != values && values.length > 1) {
            for (String currentValue : values) {
                valueSplit = isIcom ? valueSplit + currentValue + "', '" : valueSplit + currentValue + ", ";
            }
            if (isIcom) {
                if (valueSplit.length() > 0) {
                    valueSplit = valueSplit.substring(0, valueSplit.length() - 4);
                }
            } else if (valueSplit.length() > 0) {
                valueSplit = valueSplit.substring(0, valueSplit.length() - 2);
            }
        } else {
            valueSplit = parmaValue;
            if (valueSplit.length() == 0) {
                if (isIcom) {
                    if (parmaType.equals(DesignDataType.DATE)) {
                        valueSplit = "9999-12-31";
                    } else if (parmaType.equals(DesignDataType.DATETIME)) {
                        valueSplit = "9999-12-31 01:02:03";
                    } else if (parmaType.equals(DesignDataType.TIME)) {
                        valueSplit = DateTimeEnd;
                    }
                } else {
                    valueSplit = "1234567890";
                }
            }
        }
        if (isFindWH) {
            sqlAfter = parmaValue.length() == 0 ? ExtStringUtil.replaceFirst(sqlAfter, " ? ", " null ") : ExtStringUtil.replaceFirst(sqlAfter, " ? ", " 0 ");
        }
        valueSplit = CtrlReportUtil.artToExart(valueSplit);
        sqlAfter = ExtStringUtil.replaceFirst("@" + sqlAfter, "@" + paramName, valueSplit);
        sbSql.append(sqlAfter);
        return sbSql.toString();
    }

    private static final boolean checkSelectParam(StringBuffer sqlNoRN, String paramName) {
        int start = sqlNoRN.indexOf("@" + paramName);
        String sqlAfter = sqlNoRN.substring(start);
        boolean isFindFrom = false;
        int from = sqlAfter.indexOf(" from ");
        int where = sqlAfter.indexOf(" where ");
        if (from != -1 && where != -1 && from < where) {
            isFindFrom = true;
        } else if (from != -1 && where == -1) {
            isFindFrom = true;
        }
        sqlAfter = ExtStringUtil.replaceFirst(sqlAfter, "@" + paramName, "0x1x2x3x");
        sqlNoRN.setLength(0);
        sqlNoRN.append(sqlAfter);
        return isFindFrom;
    }

    public static final String getOperator(int op) {
        String operator = null;
        switch (op) {
            case 10: {
                operator = "=";
                break;
            }
            case 11: {
                operator = ">";
                break;
            }
            case 12: {
                operator = ">=";
                break;
            }
            case 14: {
                operator = "<";
                break;
            }
            case 15: {
                operator = "<=";
                break;
            }
            case 16: {
                operator = "<>";
                break;
            }
            case 18: {
                operator = "like";
                break;
            }
            case 40: {
                operator = "not like";
                break;
            }
        }
        return operator;
    }

    public static final HashMap splitEX(String sql, String ex_formula) {
        int param_end_location;
        HashMap<String, String> map = new HashMap<String, String>();
        String source = sql.toUpperCase();
        int iList = source.indexOf(ex_formula);
        if (iList == -1) {
            log.error((Object)("not have:" + ex_formula));
            return null;
        }
        String ex_list_star = source.substring(iList);
        int last_b_bk = SqlWhereParser.indexOf(ex_list_star, "}", 3);
        if (last_b_bk == -1) {
            log.error((Object)"Error separating formula, no last brace");
            return null;
        }
        String b_bk_star = ex_list_star.substring(last_b_bk);
        int last_l_bk = SqlWhereParser.indexOf(b_bk_star, ")", 1);
        if (last_l_bk == -1) {
            log.error((Object)"Error separating formula, no last parenthesis");
            return null;
        }
        int end_location = last_b_bk + last_l_bk + 1;
        String formula_list = ex_list_star.substring(0, end_location);
        int field_star_location = SqlWhereParser.indexOf(formula_list, "{", 1);
        int field_end_location = SqlWhereParser.indexOf(formula_list, "}", 1);
        String field = formula_list.substring(field_star_location + 1, field_end_location);
        int operator_star_location = SqlWhereParser.indexOf(formula_list, "{", 2);
        int operator_end_location = SqlWhereParser.indexOf(formula_list, "}", 2);
        String operator = formula_list.substring(operator_star_location + 1, operator_end_location);
        operator = CtrlReportUtil.trimStr(operator);
        int param_star_location = SqlWhereParser.indexOf(formula_list, "{", 3);
        String paramString = formula_list.substring(param_star_location + 1, param_end_location = SqlWhereParser.indexOf(formula_list, "}", 3));
        String realParamName = SqlWhereParser.getRealParamName(paramString);
        if (realParamName == null) {
            log.error((Object)(paramString + " No parameter ID @"));
            return null;
        }
        map.put(Formula_String, formula_list);
        map.put(Field_String, field);
        map.put(Operator_String, operator);
        map.put(Param_String, paramString);
        map.put(RealParamName, realParamName);
        return map;
    }

    public static final HashMap splitEXSimple(String sql, String ex_formula) {
        HashMap<String, String> map = new HashMap<String, String>();
        String source = sql.toUpperCase();
        int iList = source.indexOf(ex_formula);
        if (iList == -1) {
            log.error((Object)("not have:" + ex_formula));
            return null;
        }
        String ex_list_star = sql.substring(iList);
        int last_b_bk = SqlWhereParser.indexOf(ex_list_star, ")", 1);
        if (last_b_bk == -1) {
            log.error((Object)"Error separating formula, no last bracket");
            return null;
        }
        String formula_string = sql.substring(iList, iList + last_b_bk + 1);
        String temp = ExtStringUtil.replace(formula_string, ex_formula, "", false, false);
        temp = ExtStringUtil.replaceFirst(temp, "(", "");
        temp = ExtStringUtil.replaceFirst(temp, ")", "");
        temp = temp.trim();
        String[] arr = temp.split(",");
        String field = arr[0].trim();
        String operator = arr[1].trim();
        String paramString = arr[2].trim();
        String realParamName = SqlWhereParser.getRealParamName(paramString);
        if (realParamName == null) {
            log.error((Object)(paramString + " No parameter ID @"));
            return null;
        }
        map.put(Formula_String, formula_string);
        map.put(Field_String, field);
        map.put(Operator_String, operator);
        map.put(Param_String, paramString);
        map.put(RealParamName, realParamName);
        return map;
    }

    public static void testList(boolean flag) {
        if (!flag) {
            return;
        }
        String str = "select * from table where ex_list({\"AllPersonQuery\".\"gender\"}, {like}, {substring('@gender', 1, 3)}) and 1=10 and ex_list({\"AllPersonQuery\".\"sex\"}, {in}, {'%@gender'})";
        DesignParameter p = new DesignParameter();
        p.setName("gender");
        p.setDesignDataType(DesignDataType.TXT);
        p.setCurentValueArr(new String[]{"aaa", "bbb", "ccc"});
        ArrayList<DesignParameter> lstParam = new ArrayList<DesignParameter>();
        lstParam.add(p);
        String sql = SqlWhereParser.parseList(str, lstParam);
        System.out.println(sql);
    }

    public static void testDateTime(boolean flag) {
        if (!flag) {
            return;
        }
        String str = "select * from table where ex_datetime(birthday, >=, '@dateFrom') and ex_datetime(birthday, <=, '@dateFrom')";
        DesignParameter p = new DesignParameter();
        p.setName("dateFrom");
        p.setDesignDataType(DesignDataType.DATETIME);
        p.setCurentValue("2008-08-08 12:05:19");
        HashMap<String, DesignParameter> map = new HashMap<String, DesignParameter>();
        map.put(p.getName(), p);
        String sql = SqlWhereParser.parseDialectDateTime(str, map, 0, 2);
        System.out.println(sql);
    }

    public static void main(String[] ars) {
        SqlWhereParser.testList(false);
        SqlWhereParser.testDateTime(true);
    }
}

