/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.snapshot.ds.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.shr.rpts.ctrlreport.osf.JsonObjectUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.model.DateUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryFilterUtil {
    public static FilterInfo getComplexQueryFilter(Context ctx, String filters) {
        FilterInfo effetFilter = new FilterInfo();
        List filterList = (List)JsonObjectUtil.convertJsonToObject(ctx, filters, List.class);
        if (filterList == null || filterList.size() == 0) {
            return effetFilter;
        }
        FilterInfo filter = QueryFilterUtil.getQueryFilter(filterList);
        return filter;
    }

    public static FilterInfo getQueryFilter(List<List<Map<String, String>>> filterList) {
        Map<String, String> filterMap = null;
        List<Map<String, String>> eachListFilter = null;
        FilterInfo filter = new FilterInfo();
        if (filterList == null) {
            return filter;
        }
        for (int k = 0; k < filterList.size(); ++k) {
            eachListFilter = filterList.get(k);
            String prop_field = null;
            String prop_op = null;
            String prop_value = null;
            String field_type = null;
            Object value = null;
            FilterInfo filterInfo = new FilterInfo();
            for (int i = 0; i < eachListFilter.size(); ++i) {
                filterMap = eachListFilter.get(i);
                prop_field = filterMap.get("prop_field");
                prop_op = filterMap.get("prop_op");
                prop_value = filterMap.get("prop_value");
                field_type = filterMap.get("field_type");
                try {
                    value = QueryFilterUtil.convertData(prop_value, field_type);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                CompareType compareType = CompareType.getEnum((String)prop_op);
                if (value != null && value instanceof Set) {
                    if (compareType.equals((Object)CompareType.LIKE)) {
                        compareType = CompareType.INCLUDE;
                    } else if (compareType.equals((Object)CompareType.NOTLIKE)) {
                        compareType = CompareType.NOTINCLUDE;
                    }
                }
                if ((compareType.equals((Object)CompareType.LIKE) || compareType.equals((Object)CompareType.NOTLIKE)) && (field_type == null || field_type.equals("String"))) {
                    value = value + "%";
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(prop_field, value, compareType));
            }
            if (filterList.size() == 1) {
                return filterInfo;
            }
            try {
                filter.mergeFilter(filterInfo, "or");
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    public static Object convertData(String value, String dataType) {
        if (value.indexOf(",") > -1 || value.indexOf("\uff0c") > -1) {
            String[] str = value.split(",");
            if (str.length == 1) {
                str = value.split("\uff0c");
            }
            HashSet set = new HashSet();
            Collections.addAll(set, str);
            return set;
        }
        if ("String".equalsIgnoreCase(dataType) || "StringEnum".equalsIgnoreCase(dataType)) {
            return value;
        }
        if ("Date".equalsIgnoreCase(dataType)) {
            if (QueryFilterUtil.isParam(value)) {
                return value;
            }
            Date dateValue = null;
            try {
                dateValue = DateUtil.parseDate(value, "yyyy-MM-dd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            return dateValue;
        }
        if ("Boolean".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("Integer".equalsIgnoreCase(dataType) || "IntEnum".equalsIgnoreCase(dataType)) {
            return Integer.parseInt(value);
        }
        if ("BigDecimal".equalsIgnoreCase(dataType)) {
            return new BigDecimal(value);
        }
        return value;
    }

    public static boolean isParam(String value) {
        return value != null && value.indexOf("@") >= 0;
    }
}

