/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.self.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.shr.self.app.AbstractHRManagerConfigFacadeControllerBean;
import com.kingdee.shr.self.cache.SelfCacheHelper;
import com.kingdee.shr.self.model.ConfigData;
import com.kingdee.shr.self.util.HRConfigUtil;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class HRManagerConfigFacadeControllerBean
extends AbstractHRManagerConfigFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.self.app.HRManagerConfigFacadeControllerBean");

    @Override
    protected Map _getManagerConfig(Context ctx, String belongElement, Map param) throws BOSException, EASBizException {
        ConfigData managerConfigData = SelfCacheHelper.getConfigData(ctx, belongElement);
        String templateUrl = managerConfigData.getTemplateUrl();
        String errorTemplateUrl = managerConfigData.getErrorTemplateUrl();
        String serviceName = managerConfigData.getServiceName();
        String externalDataClass = managerConfigData.getExternalDataClass();
        String defaultParam = managerConfigData.getParam();
        Map defaultParamMap = HRConfigUtil.convertJSONObjectToMap(defaultParam);
        if (defaultParamMap != null && defaultParamMap.size() > 0) {
            for (Map.Entry entry : defaultParamMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                param.put(key, value);
            }
        }
        Object result = null;
        try {
            if (!StringUtils.isEmpty((String)serviceName)) {
                result = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(serviceName, param);
            } else if (!StringUtils.isEmpty((String)externalDataClass)) {
                result = HRManagerUtil.getExternalData((String)externalDataClass, (Map)param);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            String message = null;
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                if (cause instanceof EASBizException) {
                    message = cause.getMessage();
                    break;
                }
                if (!(cause instanceof BOSException)) continue;
                message = cause.getMessage();
            }
            if (message == null) {
                message = e.getMessage();
            }
            result = message;
            templateUrl = errorTemplateUrl;
        }
        Map configData = HRManagerUtil.convertObjectToMap((Object)managerConfigData);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("templateUrl", templateUrl);
        resultMap.put("result", result);
        resultMap.put("configData", configData);
        return resultMap;
    }
}

