/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.self.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.self.HRManagerException;
import com.kingdee.shr.self.ManagerConfigExtCollection;
import com.kingdee.shr.self.ManagerConfigExtFactory;
import com.kingdee.shr.self.ManagerConfigExtInfo;
import com.kingdee.shr.self.ManagerConfigInfo;
import com.kingdee.shr.self.app.AbstractManagerConfigControllerBean;
import com.kingdee.shr.self.cache.SelfCacheHelper;
import com.kingdee.shr.self.util.HRConfigUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ManagerConfigControllerBean
extends AbstractManagerConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.self.app.ManagerConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManagerConfigInfo info = (ManagerConfigInfo)model;
        this.trimValue(info);
        this.checkConfig(ctx, info);
        this.checkConfigNameDup(ctx, info);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        SelfCacheHelper.removeByKey(info.getBelongElement());
        return pk;
    }

    public IObjectPK[] delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] pks = super.delete(ctx, filter);
        SelfCacheHelper.removeAll();
        return pks;
    }

    public IObjectPK[] delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] pks = super.delete(ctx, oql);
        SelfCacheHelper.removeAll();
        return pks;
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.delete(ctx, pk);
        SelfCacheHelper.removeAll();
    }

    private void trimValue(ManagerConfigInfo info) {
        if (info.getConfigName() != null) {
            info.setConfigName(info.getConfigName().trim());
        }
        if (info.getBelongElement() != null) {
            info.setBelongElement(info.getBelongElement().trim());
        }
    }

    private void checkConfig(Context ctx, ManagerConfigInfo info) throws BOSException, EASBizException {
        String config = info.getConfig();
        this.checkXML(ctx, config);
        String extend = info.getExtend();
        this.checkXML(ctx, extend);
    }

    private void checkXML(Context ctx, String config) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)config)) {
            SAXBuilder builder = new SAXBuilder();
            try {
                builder.build((Reader)new StringReader(config));
            }
            catch (JDOMException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                String message = HRConfigUtil.escape(e.getMessage());
                throw new HRManagerException(HRManagerException.CONFIG_ERROR, new Object[]{"<br>" + message});
            }
            catch (IOException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkConfigNameDup(Context ctx, ManagerConfigInfo info) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("configName", (Object)info.getConfigName()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        if (super._exists(ctx, filterInfo)) {
            throw new HRManagerException(HRManagerException.CONFIG_EXIST);
        }
    }

    private void checkBelongElement(Context ctx, ManagerConfigInfo info) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("belongElement", (Object)info.getBelongElement()));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("state = 1"));
        if (super._exists(ctx, filterInfo)) {
            throw new HRManagerException(HRManagerException.BELONGELEMENT_EXIST);
        }
    }

    @Override
    protected IObjectPK _extendSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManagerConfigInfo info = (ManagerConfigInfo)model;
        IObjectPK pk = this._save(ctx, (IObjectValue)info);
        info.setId(BOSUuid.read((String)pk.toString()));
        ManagerConfigExtInfo extInfo = this.assembleExtInfo(ctx, info);
        ManagerConfigExtFactory.getLocalInstance(ctx).save((CoreBaseInfo)extInfo);
        SelfCacheHelper.removeByKey(info.getBelongElement());
        return pk;
    }

    private ManagerConfigExtInfo assembleExtInfo(Context ctx, ManagerConfigInfo info) throws BOSException, EASBizException {
        ManagerConfigExtInfo extInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        ManagerConfigExtCollection collection = ManagerConfigExtFactory.getLocalInstance(ctx).getManagerConfigExtCollection(viewInfo);
        extInfo = collection != null && !collection.isEmpty() ? collection.get(0) : new ManagerConfigExtInfo();
        extInfo.setParent(info);
        extInfo.setConfigName(info.getConfigName());
        extInfo.setConfig(info.getExtend());
        return extInfo;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ManagerConfigInfo info = (ManagerConfigInfo)super._getValue(ctx, pk);
        return this._mergeExtInfo(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        ManagerConfigInfo info = (ManagerConfigInfo)super._getValue(ctx, pk, selector);
        return this._mergeExtInfo(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectValue _mergeExtInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManagerConfigInfo info = (ManagerConfigInfo)model;
        if (info == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("config"));
        ManagerConfigExtCollection collection = ManagerConfigExtFactory.getLocalInstance(ctx).getManagerConfigExtCollection(viewInfo);
        if (collection != null && !collection.isEmpty()) {
            ManagerConfigExtInfo extInfo = collection.get(0);
            info.setExtend(extInfo.getConfig());
        }
        return info;
    }

    @Override
    protected void _enable(Context ctx, String billId) throws BOSException, EASBizException {
        String sql = "update T_MGR_ManagerConfig set fstate = 1 where fid = '" + billId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        SelfCacheHelper.removeAll();
    }

    @Override
    protected void _disable(Context ctx, String billId) throws BOSException, EASBizException {
        String sql = "update T_MGR_ManagerConfig set fstate = 2 where fid = '" + billId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        SelfCacheHelper.removeAll();
    }

    @Override
    protected String _getInnerConfig(Context ctx, String billId) throws BOSException, EASBizException {
        StringBuffer result = new StringBuffer("");
        String[] ids = null;
        try {
            ids = billId.split(",");
            StringBuffer sql = new StringBuffer("select fnumber from T_MGR_ManagerConfig where fisinner = 1 and fid in (");
            int length = ids.length;
            for (int i = 0; i < length; ++i) {
                sql.append("'").append(ids[i]).append("',");
            }
            sql.delete(sql.length() - 1, sql.length());
            sql.append(")");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.size() > 0) {
                while (rowSet.next()) {
                    result.append(rowSet.getString("fnumber")).append(",");
                }
            }
            if ((length = result.length()) > 0) {
                result.delete(length - 1, length);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result.toString();
    }
}

