/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.shareservice.app.AbstractAssembleRuleFacadeControllerBean;
import com.kingdee.shr.shareservice.app.SSCTaskReultException;
import com.kingdee.shr.shareservice.util.AssembleUtils;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleRuleFacadeControllerBean
extends AbstractAssembleRuleFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(AssembleRuleFacadeControllerBean.class);
    private static final Map<String, String> SHARE_CENRTR = new ConcurrentHashMap<String, String>();
    private static final String PRE_SHARE_CENTER = "00000000-0000-0000-0000-000000000000CCE7AED4";

    @Override
    protected Map _assembleRules(Context ctx, BOSUuid billID, String bussAttrNum) throws BOSException {
        Map<Object, Object> result = new HashMap();
        if (billID == null || StringUtils.isEmpty((String)bussAttrNum)) {
            return result;
        }
        try {
            Map<String, Map<String, Object>> assemDatas = SSCTaskAppUtil.assembleDYValues(ctx, billID.toString(), bussAttrNum);
            result = assemDatas.get(billID.toString());
        }
        catch (Exception e) {
            logger.error("_assembleRules:" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    protected void _updateRuleVals(Context ctx, String billTypeNumber, boolean isGetHis) throws BOSException {
        if (StringUtils.isEmpty((String)billTypeNumber)) {
            throw new BOSException("billTypeNumber is null!");
        }
        this.dealCommon(ctx, billTypeNumber, false, isGetHis);
    }

    @Override
    protected void _hisDataPush(Context ctx) throws BOSException {
        String billTypeNumber = "SSC_CertificationBill,SSC_ContractChangeBizBill,SSC_EmpAuditBizBill,SSC_EmpHireBizBill,SSC_FluctuationBizBill,SSC_OtherContractSignBill,SSC_PreEntryBill,SSC_PreSignConBill,SSC_ReContractBill,SSC_ResignBill,SSC_SignContractBill";
        this.dealCommon(ctx, billTypeNumber, true, true);
    }

    @Override
    protected void _backDataPush(Context ctx, Map params) throws BOSException {
        logger.info("_backDataPush params:" + params);
        String billIDs = (String)params.get("billIDs");
        String billType = (String)params.get("billType");
        Boolean isGetHis = (Boolean)params.get("isGetHis");
        if (StringUtils.isEmpty((String)billIDs) || StringUtils.isEmpty((String)billType)) {
            return;
        }
        String[] ids = billIDs.split(",");
        HashMap<String, String> idsMap = new HashMap<String, String>();
        for (String id : ids) {
            String bostype;
            String bosBillIds = (String)idsMap.get(bostype = BOSUuid.read((String)id).getType().toString());
            idsMap.put(bostype, StringUtils.isEmpty((String)bosBillIds) ? id : bosBillIds + "," + id);
        }
        try {
            for (String key : idsMap.keySet()) {
                String idkey = (String)idsMap.get(key);
                HashMap<String, Object> paramsMap = new HashMap<String, Object>();
                paramsMap.put("billIDS", idkey);
                paramsMap.put("billType", billType);
                paramsMap.put("isGetHis", isGetHis);
                paramsMap.put("isFromBack", true);
                this.dealRuleData(ctx, params);
            }
        }
        catch (Exception e) {
            logger.error("_backDataPush dealRuleData :" + e.getMessage(), (Throwable)e);
        }
    }

    private void dealCommon(Context ctx, String billTypeNumber, boolean isFromBack, boolean isGetHis) throws BOSException {
        String[] billtypes = billTypeNumber.split(",");
        for (int k = 0; k < billtypes.length; ++k) {
            String billType = billtypes[k];
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("billTypeNumber", billType);
            paramMap.put("isGetHis", isGetHis);
            try {
                long firstlog = System.currentTimeMillis();
                JsonObject resultJson = SSCTaskAppUtil.operateTaskAll(ctx, "GETBILLIDSBYBILLTYPE", paramMap);
                long firstendlog = System.currentTimeMillis();
                logger.info("GET_BILLID_BY_BILLTYPE Cost:" + (firstendlog - firstlog) / 1000L + "s");
                String billIDS = resultJson.get("data").getAsString();
                if (StringUtils.isEmpty((String)billIDS)) {
                    logger.error("_updateRuleVals:" + billIDS);
                    continue;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("billIDS", billIDS);
                params.put("billType", billType);
                params.put("isGetHis", isGetHis);
                params.put("isFromBack", isFromBack);
                this.dealRuleData(ctx, params);
                continue;
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void dealRuleData(Context ctx, Map params) throws BOSException, EASBizException {
        JsonObject busstrRule;
        String billIDS = (String)params.get("billIDS");
        String billType = (String)params.get("billType");
        Boolean isGetHis = (Boolean)params.get("isGetHis");
        Boolean isFromBack = (Boolean)params.get("isFromBack");
        String[] billids = billIDS.split(",");
        int len = billids.length;
        ArrayList<String> splitList = new ArrayList<String>();
        if (len > 2000) {
            int splitlen = len / 2000;
            int startIndex = 0;
            for (int j = 0; j < splitlen + 1; ++j) {
                if (j == splitlen) {
                    splitList.add(billIDS.substring(startIndex));
                    continue;
                }
                int endIndex = billIDS.indexOf(billids[(j + 1) * 2000]);
                splitList.add(billIDS.substring(startIndex, endIndex - 1));
                startIndex = endIndex;
            }
        } else {
            splitList.add(billIDS);
        }
        HashMap<String, Object> dyparam = new HashMap<String, Object>();
        dyparam.put("billTypeNumber", billType);
        String shareCenterId = this._getShareCenter(ctx);
        if (StringUtils.isEmpty((String)shareCenterId)) {
            return;
        }
        dyparam.put("shareCenterId", shareCenterId);
        logger.info("shareCenterId params:" + shareCenterId);
        long secondlog = System.currentTimeMillis();
        JsonObject ruleFields = SSCTaskAppUtil.operateTaskAll(ctx, "GETDYNAMICATTRIBUTE", dyparam);
        long secondendlog = System.currentTimeMillis();
        logger.info("DY_ATT_OPT_NAME Cost:" + (secondendlog - secondlog) / 1000L + "s");
        if (ruleFields != null && (busstrRule = ruleFields.get(billType).getAsJsonObject()) != null) {
            for (int colsize = 0; colsize < splitList.size(); ++colsize) {
                String realBillId = (String)splitList.get(colsize);
                JSONObject dyValues = new JSONObject();
                HashMap<String, Object> moduleMap = new HashMap<String, Object>();
                HashMap<String, Object> ownDef = new HashMap<String, Object>();
                for (Map.Entry entry : busstrRule.entrySet()) {
                    boolean isFromBill;
                    JsonObject rule;
                    JsonElement fromBillEle;
                    JsonElement ruleElement = (JsonElement)entry.getValue();
                    if (ruleElement == null || (fromBillEle = (rule = ruleElement.getAsJsonObject()).get("fromBill")) == null) continue;
                    boolean bl = isFromBill = "1".equals(fromBillEle.getAsString());
                    if (isFromBill) {
                        moduleMap.put((String)entry.getKey(), null);
                        continue;
                    }
                    ownDef.put((String)entry.getKey(), null);
                }
                Map<String, Map<String, Object>> assmoduleMap = AssembleUtils.assembleModule(ctx, moduleMap, realBillId);
                Map<String, Map<String, Object>> assownDef = AssembleUtils.assembleOwnDef(ctx, ownDef, realBillId);
                String[] ids = realBillId.split(",");
                for (int i = 0; i < ids.length; ++i) {
                    String id = ids[i];
                    if (assmoduleMap != null && assmoduleMap.get(id) != null) {
                        Map<String, Object> resultMap = assmoduleMap.get(id);
                        if (null != assownDef && null != assownDef.get(id)) {
                            resultMap.putAll(assownDef.get(id));
                        }
                        dyValues.put(id, (Object)new JSONObject(resultMap));
                        continue;
                    }
                    if (assownDef == null || assownDef.get(id) == null) continue;
                    dyValues.put(id, (Object)new JSONObject(assownDef.get(id)));
                }
                HashMap<String, Object> taskParam = new HashMap<String, Object>();
                taskParam.put("mapValue", dyValues);
                taskParam.put("isUpdateHis", isGetHis);
                long thirdlog = System.currentTimeMillis();
                JsonObject updateResult = SSCTaskAppUtil.operateTaskAll(ctx, "UPDATEDYNAMICVALUE", taskParam);
                long thirdendlog = System.currentTimeMillis();
                logger.info("DV_UPT_OPT_NAME Cost:" + (thirdendlog - thirdlog) / 1000L + "s");
                logger.info("_updateRuleVals:DV_UPT_OPT_NAME" + updateResult);
            }
        }
    }

    private JsonObject getBillRuleInShareCenter(Context ctx, String billType, String billId) throws SSCTaskReultException, BOSException {
        String shareCenterId = this._getShareCenter(ctx);
        if (StringUtils.isEmpty((String)shareCenterId)) {
            return null;
        }
        HashMap<String, Object> dyparam = new HashMap<String, Object>();
        dyparam.put("billTypeNumber", billType);
        dyparam.put("shareCenterId", shareCenterId);
        logger.info("getBillRuleInShareCenter params:" + dyparam);
        JsonObject ruleFields = null;
        try {
            ruleFields = SSCTaskAppUtil.operateTaskAll(ctx, "GETDYNAMICATTRIBUTE", dyparam);
        }
        catch (Exception e) {
            logger.error("getBillRuleInShareCenter operateTaskAll:" + e.getMessage(), (Throwable)e);
        }
        return ruleFields;
    }

    private String getShareCenterId(Context ctx, String billId) throws SSCTaskReultException {
        String sharecenId = SHARE_CENRTR.get("shareCenterId");
        if (StringUtils.isEmpty((String)sharecenId)) {
            HashMap<String, Object> serviceParam = new HashMap<String, Object>();
            serviceParam.put("billId", billId);
            serviceParam.put("type", "2");
            serviceParam.put("selector", "shareCenterID.id");
            JsonObject result = null;
            try {
                result = SSCTaskAppUtil.operateTaskAll(ctx, "GETJOBINFOBYBILLID", serviceParam);
            }
            catch (Exception e) {
                logger.error("getShareCenterId" + e.getMessage(), (Throwable)e);
            }
            if (null != result) {
                JsonObject shareCenterID;
                JsonArray dataJson = result.get("data").getAsJsonArray();
                JsonObject jsonObject = shareCenterID = dataJson.get(0) == null ? null : dataJson.get(0).getAsJsonObject().get("shareCenterID").getAsJsonObject();
                if (null == shareCenterID) {
                    return "";
                }
                sharecenId = shareCenterID.get("id").getAsString();
                SHARE_CENRTR.put("shareCenterId", sharecenId);
            }
        }
        return sharecenId;
    }

    @Override
    protected String _getShareCenter(Context ctx) throws BOSException {
        return PRE_SHARE_CENTER;
    }

    @Override
    protected void _runDataPush(Context ctx) throws BOSException {
        String billTypeNumber = "SSC_CertificationBill,SSC_ContractChangeBizBill,SSC_EmpAuditBizBill,SSC_EmpHireBizBill,SSC_FluctuationBizBill,SSC_OtherContractSignBill,SSC_PreEntryBill,SSC_PreSignConBill,SSC_ReContractBill,SSC_ResignBill,SSC_SignContractBill";
        this.dealCommon(ctx, billTypeNumber, true, false);
    }
}

