/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.shr.shareservice.EmailSendRecordCollection;
import com.kingdee.shr.shareservice.EmailSendRecordFactory;
import com.kingdee.shr.shareservice.EmailSendRecordInfo;
import com.kingdee.shr.shareservice.EmailSendStatus;
import com.kingdee.shr.shareservice.EmailSystemConfigCollection;
import com.kingdee.shr.shareservice.EmailSystemConfigFactory;
import com.kingdee.shr.shareservice.IEmailSendRecord;
import com.kingdee.shr.shareservice.app.AbstractEmailSystemFacadeControllerBean;
import com.kingdee.shr.shareservice.app.SendEmailException;
import com.kingdee.shr.shareservice.strategy.SendEmailInterface;
import com.kingdee.shr.shareservice.util.SendEmailType;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSystemFacadeControllerBean
extends AbstractEmailSystemFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(EmailSystemFacadeControllerBean.class);

    private String getDownloadUrl(Context ctx, String signNO) throws BOSException, EASBizException, BOSException {
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "electronicLaborRefreshLocalService");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("contractNo", signNO);
        param.put("isDefault", "1");
        JSONObject resData = (JSONObject)imsf.process(ctx, param);
        if (resData != null && resData.containsKey((Object)"code")) {
            JSONArray data;
            String code = resData.getString("code");
            logger.info("imsf process the electronicLaborRefreshLocalService succeed, return code: " + code);
            if (code.equals("0") && (data = resData.getJSONArray("data")).size() > 0) {
                JSONObject first = (JSONObject)data.get(0);
                JSONObject sealInfo = first.getJSONObject("sealInfo");
                String downloadUrl = sealInfo.getString("downloadUrl");
                return downloadUrl;
            }
        }
        return null;
    }

    @Override
    protected void _sendEmail(Context ctx, String subject, String content, String toEmailAddr, String signNO, String bizType, String bizIdentifyId, String toEmailPersonName, String fileName) throws BOSException, EASBizException {
        block14: {
            this.checkSystemEmail(ctx);
            if (StringUtils.isEmpty((String)toEmailAddr)) {
                throw new EASBizException(SendEmailException.EMAIL_IS_NULL);
            }
            String finalFilePath = "";
            String dir = SHRSyssettingUtil.getShrWebWarPath();
            try {
                String downloadUrl = this.getDownloadUrl(ctx, signNO);
                if (downloadUrl == null) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    downloadUrl = this.getDownloadUrl(ctx, signNO);
                }
                if (downloadUrl != null) {
                    String filePath = dir + "/tmp/";
                    logger.info("EmailSystemFacadeControllerBean start to download the file: ");
                    if (bizType.contains("CER")) {
                        // empty if block
                    }
                    if ((finalFilePath = EmailSystemFacadeControllerBean.download(downloadUrl, filePath, fileName)) != null) {
                        IHRMsfService imsf2 = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "sendMailService");
                        HashMap<String, String> param2 = new HashMap<String, String>();
                        param2.put("subject", subject);
                        param2.put("content", content);
                        param2.put("toEmailAddr", toEmailAddr);
                        param2.put("filePath", finalFilePath);
                        param2.put("bizType", bizType);
                        param2.put("bizIdentifyId", bizIdentifyId);
                        param2.put("toEmailPersonName", toEmailPersonName);
                        HashMap resData2 = (HashMap)imsf2.process(ctx, param2);
                        if (resData2 == null || !resData2.containsKey("msgCode")) break block14;
                        String msgCode = resData2.get("msgCode").toString();
                        if (msgCode.equals("0")) {
                            logger.info("EmailSystemFacadeControllerBean send email to " + toEmailPersonName + " succeed! bizIdentifyId is " + bizIdentifyId);
                            break block14;
                        }
                        logger.error("EmailSystemFacadeControllerBean send email to " + toEmailPersonName + " failed due to " + resData2.get("errorMsg") + ". bizIdentifyId is " + bizIdentifyId);
                        throw new EASBizException(SendEmailException.SEND_EMAIL_FAILED);
                    }
                    logger.error("failed to download the file from the url:" + downloadUrl);
                    throw new EASBizException(SendEmailException.DOWNLOAD_FILE_FAILED);
                }
                throw new EASBizException(SendEmailException.GET_FILE_URL_FAILED);
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                EmailSystemFacadeControllerBean.deleteFile(finalFilePath);
            }
        }
    }

    private void checkSystemEmail(Context ctx) throws BOSException {
        EmailSystemConfigCollection emailColl = EmailSystemConfigFactory.getLocalInstance(ctx).getEmailSystemConfigCollection();
        if (emailColl.size() == 0) {
            String label176 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShareServiceResource", (String)"label176", (Context)ctx);
            throw new BOSException(label176);
        }
    }

    @Override
    protected void _autoSendEmail(Context ctx, String billId) throws BOSException, EASBizException {
        try {
            String toEmailAddr;
            String content;
            String subject;
            SendEmailType sendEmailType = SendEmailType.getBillType(ctx, billId);
            SendEmailInterface sendEmailInterface = sendEmailType.getSendEmailInterface();
            HashMap<String, Object> map = sendEmailInterface.getEmailMsg(ctx, billId);
            logger.error("EmailSystemFacadeControllerBean start to auto send email, billId = " + billId);
            if (map != null) {
                subject = (String)map.get("subject");
                content = (String)map.get("content");
                toEmailAddr = "";
                if (map.get("toEmailAddr") != null) {
                    toEmailAddr = map.get("toEmailAddr").toString();
                }
            } else {
                throw new EASBizException(SendEmailException.GET_FILE_URL_FAILED);
            }
            String signNO = (String)map.get("signNO");
            String bizType = (String)map.get("bizType");
            String bizIdentifyId = (String)map.get("bizIdentifyId");
            String toEmailPersonName = (String)map.get("toEmailPersonName");
            String fileName = (String)map.get("fileName");
            this._sendEmail(ctx, subject, content, toEmailAddr, signNO, bizType, bizIdentifyId, toEmailPersonName, fileName);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String download(String url, String filepath, String defaultName) {
        String fileName = defaultName;
        String filePreFix = "";
        OutputStream fileout = null;
        InputStream is = null;
        try {
            CloseableHttpClient client = HttpClients.createDefault();
            HttpGet get = new HttpGet(url);
            HttpResponse response = client.execute((HttpUriRequest)get);
            try {
                filePreFix = fileName.substring(0, fileName.length() - 4);
                Base64 base64 = new Base64();
                filePreFix = base64.encodeToString(filePreFix.getBytes("UTF-8"));
                filePreFix = URLEncoder.encode(filePreFix, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.toString());
            }
            HttpEntity entity = response.getEntity();
            is = entity.getContent();
            String finalFileName = filepath + filePreFix + ".pdf";
            File file = new File(finalFileName);
            file.getParentFile().mkdirs();
            fileout = new FileOutputStream(file);
            byte[] buffer = new byte[0x100000];
            int ch = 0;
            while ((ch = is.read(buffer)) != -1) {
                ((FileOutputStream)fileout).write(buffer, 0, ch);
            }
            String string = finalFileName;
            return string;
        }
        catch (IOException e) {
            logger.error("download the electronic file failed. " + e.getMessage());
            String string = null;
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
            try {
                if (fileout != null) {
                    fileout.flush();
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
            try {
                if (fileout != null) {
                    ((FileOutputStream)fileout).close();
                }
            }
            catch (IOException e) {
                logger.error(e.toString());
            }
        }
    }

    private static void deleteFile(String filePath) {
        File file = new File(filePath);
        file.delete();
    }

    @Override
    public void sendEmailFromJob(Context ctx, String params) throws BOSException, EASBizException {
        logger.error("====sendEmailFromJob====start====");
        IEmailSendRecord iEmailSendRecord = EmailSendRecordFactory.getLocalInstance(ctx);
        EntityViewInfo entity = new EntityViewInfo();
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("billId"));
        selectorColl.add(new SelectorItemInfo("times"));
        entity.setSelector(selectorColl);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("sendStatus", (Object)EmailSendStatus.NO_SEND));
        filterInfo.getFilterItems().add(new FilterItemInfo("sendStatus", (Object)EmailSendStatus.SENDING));
        filterInfo.getFilterItems().add(new FilterItemInfo("times", (Object)5, CompareType.LESS));
        filterInfo.setMaskString("(#0 OR #1) AND #2");
        entity.setFilter(filterInfo);
        EmailSendRecordCollection emailSendRecordColl = iEmailSendRecord.getEmailSendRecordCollection(entity);
        int emailSendRecordSize = emailSendRecordColl.size();
        EmailSendRecordInfo emailSendRecordInfo = null;
        for (int i = 0; i < emailSendRecordSize; ++i) {
            emailSendRecordInfo = emailSendRecordColl.get(i);
            SelectorItemCollection selectorUpdate = new SelectorItemCollection();
            selectorUpdate.add(new SelectorItemInfo("times"));
            selectorUpdate.add(new SelectorItemInfo("sendStatus"));
            try {
                this._autoSendEmail(ctx, emailSendRecordInfo.getBillId());
                emailSendRecordInfo.setSendStatus(EmailSendStatus.SENT);
                emailSendRecordInfo.setTimes(emailSendRecordInfo.getTimes() + 1);
                iEmailSendRecord.updatePartial(emailSendRecordInfo, selectorUpdate);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                emailSendRecordInfo.setTimes(emailSendRecordInfo.getTimes() + 1);
                emailSendRecordInfo.setSendStatus(EmailSendStatus.SENDING);
                String excepMessage = e.getMessage();
                if (excepMessage.length() > 256) {
                    excepMessage = excepMessage.substring(0, 256);
                }
                emailSendRecordInfo.setResponse(excepMessage);
                selectorUpdate.add(new SelectorItemInfo("response"));
                iEmailSendRecord.updatePartial(emailSendRecordInfo, selectorUpdate);
            }
        }
    }
}

