/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.shareservice.ITemplateCmpItemRef;
import com.kingdee.shr.shareservice.TemplateCmpItemRefFactory;
import com.kingdee.shr.shareservice.TemplateCmpItemRefInfo;
import com.kingdee.shr.shareservice.TemplateFieldConfigInfo;
import com.kingdee.shr.shareservice.TemplateFieldRefCollection;
import com.kingdee.shr.shareservice.TemplateFieldRefFactory;
import com.kingdee.shr.shareservice.app.AbstractTemplateFieldConfigControllerBean;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateFieldConfigControllerBean
extends AbstractTemplateFieldConfigControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(TemplateFieldConfigControllerBean.class);

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TemplateFieldRefCollection coll = TemplateFieldRefFactory.getLocalInstance(ctx).getTemplateFieldRefCollection();
        for (int i = 0; i < coll.size(); ++i) {
            String tableName = coll.get(i).getTableName();
            String fieldName = coll.get(i).getFieldName();
            String sql = "select " + fieldName + " as content from " + tableName;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rowSet.next()) {
                    String content = rowSet.getString("content");
                    if (StringUtils.isEmpty((String)content) || !content.contains(pk.toString())) continue;
                    TemplateFieldConfigInfo templateFieldConfigInfo = this.getTemplateFieldConfigInfo(ctx, pk);
                }
                continue;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        TemplateFieldConfigInfo info = (TemplateFieldConfigInfo)model;
        ITemplateCmpItemRef IRef = TemplateCmpItemRefFactory.getLocalInstance(ctx);
        String cmpItemIdStr = info.getCmpItemIdStr();
        if (cmpItemIdStr == null) {
            if (info.getId() != null) {
                IRef.delete("where parent = '" + info.getId().toString() + "'");
            }
            pk = super._save(ctx, model);
            return pk;
        }
        String newCmpItemIds = cmpItemIdStr.replaceAll(" ", "");
        String[] cmpItemIds = newCmpItemIds.split(",");
        String sql = "select fid id, fname_" + l + " name from T_HR_SCmpItem where fid in " + HRUtilExtend.getStrFromArray((String[])cmpItemIds);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (info.getId() != null) {
                IRef.delete("where parent = '" + info.getId().toString() + "'");
            }
            info.setCmpItemIdStr(null);
            pk = super._save(ctx, model);
            info.setId(BOSUuid.read((String)pk.toString()));
            while (rowSet.next()) {
                TemplateCmpItemRefInfo refInfo = new TemplateCmpItemRefInfo();
                refInfo.setParent(info);
                refInfo.setCmpItemName(rowSet.getString("name"));
                refInfo.setCmpItemId(BOSUuid.read((String)rowSet.getString("id")));
                IRef.addnew(refInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        info.setCmpItemIdStr(null);
        return pk;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        if (dataBaseInfo.getNumber() != null && dataBaseInfo.getNumber().length() > 0) {
            this._checkNumberDup(ctx, (IObjectValue)dataBaseInfo);
        }
        super._update(ctx, pk, model);
    }
}

