/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.alibaba.fastjson.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.ActivityApplyEntryCollection;
import com.kingdee.shr.shareservice.ActivityApplyEntryFactory;
import com.kingdee.shr.shareservice.ActivityBussTypeCollection;
import com.kingdee.shr.shareservice.ActivityBussTypeFactory;
import com.kingdee.shr.shareservice.ActivityBussTypeInfo;
import com.kingdee.shr.shareservice.ActivityCollection;
import com.kingdee.shr.shareservice.ActivityFactory;
import com.kingdee.shr.shareservice.ActivityInfo;
import com.kingdee.shr.shareservice.ActivityJobInfoCollection;
import com.kingdee.shr.shareservice.ActivityJobInfoFactory;
import com.kingdee.shr.shareservice.ActivityJobInfoInfo;
import com.kingdee.shr.shareservice.ActivityRuleEntryInfo;
import com.kingdee.shr.shareservice.ActivitySolutionCollection;
import com.kingdee.shr.shareservice.ActivitySolutionFactory;
import com.kingdee.shr.shareservice.ActivitySolutionInfo;
import com.kingdee.shr.shareservice.ActivityTypeCollection;
import com.kingdee.shr.shareservice.ActivityTypeFactory;
import com.kingdee.shr.shareservice.ActivityTypeInfo;
import com.kingdee.shr.shareservice.CoActivityAssignRuleDetailEntryInfo;
import com.kingdee.shr.shareservice.CoActivityException;
import com.kingdee.shr.shareservice.CoActivityExecutorCollection;
import com.kingdee.shr.shareservice.CoActivityExecutorFactory;
import com.kingdee.shr.shareservice.CoActivityJobCollection;
import com.kingdee.shr.shareservice.CoActivityJobFactory;
import com.kingdee.shr.shareservice.IActivity;
import com.kingdee.shr.shareservice.IActivityJobInfo;
import com.kingdee.shr.shareservice.IActivitySolution;
import com.kingdee.shr.shareservice.PreActivityRelCollection;
import com.kingdee.shr.shareservice.PreActivityRelFactory;
import com.kingdee.shr.shareservice.SHRJobPriorityCollection;
import com.kingdee.shr.shareservice.SHRJobPriorityFactory;
import com.kingdee.shr.shareservice.SHRJobPriorityInfo;
import com.kingdee.shr.shareservice.SSCActivityException;
import com.kingdee.shr.shareservice.SolutionActivityInfoCollection;
import com.kingdee.shr.shareservice.SolutionActivityInfoFactory;
import com.kingdee.shr.shareservice.SolutionActivityInfoInfo;
import com.kingdee.shr.shareservice.WorkflowProceedFacadeFactory;
import com.kingdee.shr.shareservice.api.ActivityJobProcessExecuteLogic;
import com.kingdee.shr.shareservice.app.JobState;
import com.kingdee.shr.shareservice.strategy.ActivitySolutionOperation;
import com.kingdee.shr.shareservice.strategy.JobInnerOperation;
import com.kingdee.shr.shareservice.util.AssembleConfigUtils;
import com.kingdee.shr.shareservice.util.CoActivityOptUtil;
import com.kingdee.shr.shareservice.util.JobUtils;
import com.kingdee.shr.shareservice.util.SHRWorkFlowOtherSysUtil;
import com.kingdee.shr.shareservice.util.SSCShareCenterUtils;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.shr.shareservice.util.XMLDocUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityHelper {
    private static final Logger logger = LoggerFactory.getLogger(ActivityHelper.class);
    private static Map<String, String> bosType2bussNum = new HashMap<String, String>();

    public static ActivitySolutionInfo checkSolution(Context ctx, String number, String billId) throws BOSException, EASBizException {
        ActivitySolutionInfo activitySolutionInfo = null;
        IActivitySolution activitySolution = ActivitySolutionFactory.getLocalInstance(ctx);
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filterInfo.getFilterItems().add(new FilterItemInfo("activityType.bosType", (Object)billBosType));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        ActivitySolutionCollection activitySolutionCollection = activitySolution.getActivitySolutionCollection(entityViewInfo);
        if (activitySolutionCollection.size() <= 0) {
            throw new SSCActivityException(SSCActivityException.NOEXIST_EXCEPTION, new Object[]{number});
        }
        activitySolutionInfo = activitySolution.getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(activitySolutionCollection.get(0).getId()));
        if (BaseItemStateEnum.NEW.equals((Object)activitySolutionInfo.getState())) {
            throw new SSCActivityException(SSCActivityException.SOLUTION_NEW_EXCEPTION, new Object[]{number});
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)activitySolutionInfo.getState())) {
            throw new SSCActivityException(SSCActivityException.SOLUTION_DISABLE_EXCEPTION, new Object[]{number});
        }
        return activitySolutionInfo;
    }

    public static boolean needCreateJob(Context ctx, SolutionActivityInfoInfo solutionActivityInfo, ActivitySolutionInfo activitySolutionInfo, String billId) {
        ActivityInfo activityInfo = solutionActivityInfo.getActivity();
        try {
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
            BOSUuid activityId = activityInfo.getId();
            if (activityId == null) {
                return false;
            }
            if (!iActivityJobInfo.exists("where bill = '" + billId + "' and activity = '" + activityId.toString() + "' and scheme = '" + activitySolutionInfo.getId().toString() + "'")) {
                return false;
            }
            ActivityJobInfoCollection activityJobcoll = iActivityJobInfo.getActivityJobInfoCollection("where bill = '" + billId + "' and activity = '" + activityId.toString() + "' and scheme = '" + activitySolutionInfo.getId().toString() + "'");
            ActivityJobInfoInfo info = activityJobcoll.get(0);
            if (info.isIsDelay() && info.getCreateDate().after(new Date())) {
                return false;
            }
            PreActivityRelCollection coll = PreActivityRelFactory.getLocalInstance(ctx).getPreActivityRelCollection("where activity = '" + activityInfo.getId().toString() + "' and solution = '" + activitySolutionInfo.getId().toString() + "'");
            if (coll.size() > 0) {
                return false;
            }
            StringBuffer activityListSB = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                activityListSB.append("'" + coll.get(i).getPreActivity().getId().toString() + "',");
            }
            if (!StringUtils.isEmpty((String)activityListSB.toString()) && iActivityJobInfo.exists("where bill = '" + billId + "' and activity in (" + activityListSB.deleteCharAt(activityListSB.length() - 1).toString() + ") and jobState <> 2")) {
                return false;
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static Map<String, Object> getParamMap(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("sscNumber", "EAS");
        paramMap.put("jobCreateID", userId);
        paramMap.put("jobPriority", "2");
        paramMap.put("isPhotoCopy", true);
        paramMap.put("level", "1");
        paramMap.put("autoApprove", "false");
        paramMap.put("isLastLevel", "false");
        return paramMap;
    }

    public static String getOrgNumber(Context ctx, HROrgUnitInfo hrOrgUnitInfo, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException {
        String orgNumber;
        block7: {
            orgNumber = null;
            HROrgUnitInfo hrorgUnitInfo = null;
            try {
                if (SSCShareCenterUtils.isShareCenterUseHRO(ctx)) {
                    if (hrOrgUnitInfo != null) {
                        hrorgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnitInfo.getId()));
                        orgNumber = hrorgUnitInfo.getNumber();
                        break block7;
                    }
                    String label10 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label10", (Context)ctx);
                    throw new BOSException(label10);
                }
                if (adminOrgUnitInfo != null) {
                    AdminOrgUnitInfo admin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getId()));
                    orgNumber = admin.getNumber();
                    break block7;
                }
                String label12 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label12", (Context)ctx);
                throw new BOSException(label12);
            }
            catch (EASBizException e) {
                String label14 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label14", (Context)ctx);
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(label14);
            }
            catch (BOSException e) {
                String label14 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label14", (Context)ctx);
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(label14);
            }
            catch (SQLException e) {
                String label14 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label14", (Context)ctx);
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(label14);
            }
        }
        return orgNumber;
    }

    public static void createNextJob(Context ctx, String jobId, String billId, String activityId, boolean isCreateByActivity) throws BOSException, CoActivityException {
        if (isCreateByActivity) {
            return;
        }
        try {
            ActivitySolutionInfo solutionInfo = ActivityHelper.getSolutionByBillId(ctx, jobId, isCreateByActivity);
            SolutionActivityInfoCollection sacc = solutionInfo.getEntrys();
            if (logger.isDebugEnabled()) {
                logger.debug("sacc.size :" + sacc.size());
            }
            String solutionId = solutionInfo.getId().toString();
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
            HashSet<String> includeActivitySet = new HashSet<String>();
            ActivityJobInfoCollection includeColl = iActivityJobInfo.getActivityJobInfoCollection("where bill = '" + billId + "' and scheme = '" + solutionId + "'");
            for (int i = 0; i < includeColl.size(); ++i) {
                includeActivitySet.add(includeColl.get(i).getActivity());
            }
            ActivitySolutionOperation activitySolutionOperation = AssembleConfigUtils.getBillTypeInter(ctx, BOSUuid.read((String)billId).getType().toString());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("activityId", activityId);
            Map<String, Object> paramsMap = activitySolutionOperation.getOrgAndPerson(ctx, billId, params);
            String personName = (String)paramsMap.get("personName");
            String personId = paramsMap.get("personId") == null ? "" : paramsMap.get("personId").toString();
            String talentId = paramsMap.get("talentId") == null ? "" : paramsMap.get("talentId").toString();
            HashMap<String, String> subjectAll = paramsMap.get("subjectAll") == null ? null : (HashMap<String, String>)paramsMap.get("subjectAll");
            HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)paramsMap.get("hrOrgUnit");
            AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)paramsMap.get("adminOrgUnit");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("billId", billId);
            paramMap.put("personId", paramsMap.get("personId"));
            paramMap.put("personName", paramsMap.get("personName"));
            paramMap.put("hrOrgUnitInfo", hrOrgUnitInfo);
            paramMap.put("adminOrgUnitInfo", adminOrgUnitInfo);
            for (int i = 0; i < sacc.size(); ++i) {
                SolutionActivityInfoInfo solutionActivityInfo = sacc.get(i);
                if (!includeActivitySet.contains(solutionActivityInfo.getActivity().getId().toString())) continue;
                ActivityInfo activity = ActivityFactory.getLocalInstance(ctx).getActivityInfo((IObjectPK)new ObjectUuidPK(solutionActivityInfo.getActivity().getId()));
                String nextActivityId = activity.getId().toString();
                boolean needCreateJob = ActivityHelper.needCreateJob(ctx, solutionActivityInfo, solutionInfo, billId, activityId);
                logger.debug("needCreateJob :" + needCreateJob);
                Map<String, Object> activityCreateMap = activitySolutionOperation.needCreateActivityJob(ctx, billId, activity, solutionId, params);
                Object isNeedCreate = activityCreateMap.get("needCreate");
                if (isNeedCreate == null || !((Boolean)isNeedCreate).booleanValue() || !needCreateJob) continue;
                UIViewInfo relationIdInfo = activity.getRelationView();
                JobInnerOperation jobInnerOperation = null;
                jobInnerOperation = JobUtils.getUserUrlImpl(ctx, relationIdInfo.getId().toString());
                if (null != jobInnerOperation) {
                    Map<String, Object> createRuleMap;
                    HashMap<String, String> createRuleParam = new HashMap<String, String>();
                    if (null != talentId) {
                        createRuleParam.put("talentId", talentId);
                    }
                    if ((createRuleMap = jobInnerOperation.checkCreateRule(ctx, billId, nextActivityId, personId, createRuleParam)).get("success") == null || !((Boolean)createRuleMap.get("success")).booleanValue()) {
                        ActivityJobInfoInfo activityJobInfoInfo = iActivityJobInfo.getActivityJobInfoInfo("where activity = '" + nextActivityId + "' and bill = '" + billId + "' and scheme = '" + solutionId + "'");
                        activityJobInfoInfo.setJobState(JobState.notCreate);
                        String label4 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label4", (Context)ctx);
                        activityJobInfoInfo.setOpinion(createRuleMap.get("data") == null ? label4 : createRuleMap.get("data").toString());
                        SelectorItemCollection selector = new SelectorItemCollection();
                        selector.add(new SelectorItemInfo("jobState"));
                        selector.add(new SelectorItemInfo("opinion"));
                        iActivityJobInfo.updatePartial(activityJobInfoInfo, selector);
                        continue;
                    }
                }
                String bussAttrNumber = ActivityHelper.getBussAttrNum(ctx, billId, nextActivityId);
                String realSubject = "";
                realSubject = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(nextActivityId, paramsMap.get("personId").toString(), billId, null, ctx);
                if (StringUtils.isEmpty((String)realSubject)) {
                    String subject = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.CoActivityResource", (String)"subject", (Context)ctx);
                    realSubject = MessageFormat.format(subject, personName, activity.getName());
                }
                if (null == subjectAll) {
                    subjectAll = new HashMap<String, String>();
                    PersonInfo p = null;
                    if (!StringUtils.isEmpty((String)paramsMap.get("personId").toString())) {
                        p = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(paramsMap.get("personId").toString()));
                    }
                    String subjectL1 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(nextActivityId, paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l1"), ctx);
                    String label01 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l1"));
                    if (StringUtils.isEmpty((String)subjectL1)) {
                        subjectL1 = MessageFormat.format(label01, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l1")), activity.getName(LocaleUtils.getLocale((String)"l1")));
                    }
                    subjectAll.put("l1", subjectL1);
                    String subjectL2 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(nextActivityId, paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l2"), ctx);
                    String label02 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l2"));
                    if (StringUtils.isEmpty((String)subjectL2)) {
                        subjectL2 = MessageFormat.format(label02, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l2")), activity.getName(LocaleUtils.getLocale((String)"l2")));
                    }
                    subjectAll.put("l2", subjectL2);
                    String subjectL3 = new ActivityJobProcessExecuteLogic(ctx).assembleJobSubjectBySettingRule(nextActivityId, paramsMap.get("personId").toString(), billId, LocaleUtils.getLocale((String)"l3"), ctx);
                    String label03 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label0", (Locale)LocaleUtils.getLocale((String)"l3"));
                    if (StringUtils.isEmpty((String)subjectL3)) {
                        subjectL3 = MessageFormat.format(label03, p == null ? personName : p.getName(LocaleUtils.getLocale((String)"l3")), activity.getName(LocaleUtils.getLocale((String)"l3")));
                    }
                    subjectAll.put("l3", subjectL3);
                }
                paramMap.put("subject", realSubject);
                paramMap.put("subjectAll", JSONUtils.convertObjectToJson((Context)ctx, subjectAll));
                paramMap.put("bussAttrNum", bussAttrNumber);
                paramMap.put("activityId", nextActivityId);
                if (activity.isIsSSC()) {
                    ActivityHelper.innerCreateSSCJob(ctx, paramMap, activity, iActivityJobInfo, billId, solutionId);
                    continue;
                }
                ActivityHelper.innerCreateCoActivityJob(ctx, paramMap, activity, iActivityJobInfo, billId, solutionId);
            }
        }
        catch (CoActivityException e) {
            throw e;
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected static ActivitySolutionInfo getSolutionByBillId(Context ctx, String jobId, boolean isCreateByActivity) throws BOSException, CoActivityException {
        ActivitySolutionInfo info = null;
        if (isCreateByActivity) {
            return info;
        }
        try {
            ActivityJobInfoCollection coll = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where jobId = '" + jobId + "'");
            if (coll.size() == 0) {
                throw new CoActivityException(CoActivityException.BILL_NOT_SOLUTION);
            }
            if (coll.size() != 1) {
                throw new CoActivityException(CoActivityException.BILL_MUL_SOLUTION);
            }
            info = ActivitySolutionFactory.getLocalInstance(ctx).getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)coll.get(0).getScheme())));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    private static boolean needCreateJob(Context ctx, SolutionActivityInfoInfo solutionActivityInfo, ActivitySolutionInfo activitySolutionInfo, String billId, String passActivityId) throws BOSException, CoActivityException {
        try {
            ActivityInfo activityInfo = solutionActivityInfo.getActivity();
            String currentActId = solutionActivityInfo.getActivity().getId().toString();
            logger.debug("currentActId:" + currentActId + ",passActivityId:" + passActivityId);
            if (currentActId.equals(passActivityId)) {
                return false;
            }
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
            PreActivityRelCollection coll = PreActivityRelFactory.getLocalInstance(ctx).getPreActivityRelCollection("where activity = '" + activityInfo.getId().toString() + "' and solution = '" + activitySolutionInfo.getId().toString() + "'");
            logger.debug("PreActivityRelCollection:" + coll.size());
            if (coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    if (!iActivityJobInfo.exists("where bill = '" + billId + "' and activity in ('" + coll.get(i).getPreActivity().getId().toString() + "') and jobState <> 2")) continue;
                    logger.debug("current activity is\uff1a[" + coll.get(i).getPreActivity().getId().toString() + "] not completed!");
                    return false;
                }
            }
            String solutionId = activitySolutionInfo.getId().toString();
            ActivitySolutionOperation activitySolutionOperation = AssembleConfigUtils.getBillTypeInter(ctx, BOSUuid.read((String)billId).getType().toString());
            Map<String, Object> needToCreateJobInfo = activitySolutionOperation.needCreateActivityJob(ctx, billId, activityInfo, solutionId, null);
            Object isNeedCreate = needToCreateJobInfo.get("needCreate");
            if (isNeedCreate == null || !((Boolean)isNeedCreate).booleanValue()) {
                iActivityJobInfo.delete("where bill = '" + billId + "' and activity = '" + currentActId + "' and scheme = '" + solutionId + "'");
                return false;
            }
            if (iActivityJobInfo.exists("where activity = '" + currentActId + "' and jobState = 0 and bill = '" + billId + "' and scheme = '" + solutionId + "'")) {
                return true;
            }
            logger.error("current activity is \uff1a[" + currentActId + "] processing or processing completed");
            return false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CoActivityException(CoActivityException.COJOB_VERIFY_FAIL);
        }
    }

    private static void innerCreateCoActivityJob(Context ctx, Map<String, Object> paramMap, ActivityInfo activity, IActivityJobInfo iActivityJobInfo, String billId, String solutionId) throws EASBizException, BOSException {
        String resultObj;
        SHRJobPriorityCollection priorityCol;
        if (null != paramMap.get("adminOrgUnitInfo")) {
            paramMap.put("adminOrg", ((AdminOrgUnitInfo)paramMap.get("adminOrgUnitInfo")).getId());
        }
        if (!(priorityCol = SHRJobPriorityFactory.getLocalInstance(ctx).getSHRJobPriorityCollection("select jobPriority where solution = '" + solutionId + "' and billId = '" + billId + "'")).isEmpty()) {
            SHRJobPriorityInfo priorityInfo = priorityCol.get(0);
            paramMap.put("jobPriority", priorityInfo.getJobPriority());
        }
        if (!StringUtils.isEmpty((String)(resultObj = CoActivityOptUtil.createJob(ctx, paramMap, null)))) {
            if (!iActivityJobInfo.exists("where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "'")) {
                logger.debug("======== com.kingdee.shr.shareservice.util.ActivityHelper.innerCreateCoActivityJob where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "' not exists!!!");
                return;
            }
            ActivityJobInfoCollection activityJobInfoColl = iActivityJobInfo.getActivityJobInfoCollection("where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "' and jobState = 0");
            if (activityJobInfoColl.size() > 1) {
                logger.error("======== com.kingdee.shr.shareservice.util.ActivityHelper.innerCreateCoActivityJob activityJobInfoColl more than one ");
            } else if (activityJobInfoColl.size() == 1) {
                ActivityJobInfoInfo activityJobInfoInfo = activityJobInfoColl.get(0);
                if (activityJobInfoInfo.isIsAutoJob()) {
                    activityJobInfoInfo.setJobState(JobState.finish);
                } else {
                    activityJobInfoInfo.setJobState(JobState.process);
                }
                activityJobInfoInfo.setJobId(resultObj);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("jobState"));
                selector.add(new SelectorItemInfo("jobId"));
                iActivityJobInfo.updatePartial(activityJobInfoInfo, selector);
            } else {
                logger.error("======== com.kingdee.shr.shareservice.util.ActivityHelper.innerCreateCoActivityJob activityJobInfoColl less than one ");
            }
        } else {
            throw new CoActivityException(CoActivityException.COJOB_CREATE_FAIL);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void innerCreateSSCJob(Context ctx, Map<String, Object> paramMap, ActivityInfo activity, IActivityJobInfo iActivityJobInfo, String billId, String solutionId) throws BOSException, EASBizException {
        ActivityJobInfoCollection jobInfoColl = iActivityJobInfo.getActivityJobInfoCollection("where bill = '" + billId + "' and scheme = '" + solutionId + "' and activity = '" + activity.getId().toString() + "' and jobId is null");
        String autoApprove = "false";
        if (jobInfoColl.size() > 0) {
            autoApprove = jobInfoColl.get(0).isIsAutoJob() ? "true" : "false";
        }
        String bussAttrNumber = ActivityHelper.getBussAttrNum(ctx, billId, activity.getId().toString());
        String jobPriority = "20";
        SHRJobPriorityCollection coll = SHRJobPriorityFactory.getLocalInstance(ctx).getSHRJobPriorityCollection("where billId = '" + billId + "' and businessAttribute = '" + bussAttrNumber + "' and solution is null");
        if (coll.size() > 0) {
            jobPriority = coll.get(0).getJobPriority();
        } else {
            SHRJobPriorityCollection solutionCol = SHRJobPriorityFactory.getLocalInstance(ctx).getSHRJobPriorityCollection("where billId = '" + billId + "' and solution = '" + solutionId + "'");
            if (null != solutionCol && !solutionCol.isEmpty()) {
                jobPriority = solutionCol.get(0).getJobPriority();
            }
        }
        paramMap.put("sscNumber", "SHR");
        paramMap.put("billofDocumentID", billId);
        String orgNumber = null;
        String label7 = SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource", (String)"label7", (Context)ctx);
        try {
            HROrgUnitInfo hrorgUnitInfo = null;
            if (SSCShareCenterUtils.isShareCenterUseHRO(ctx)) {
                HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)paramMap.get("hrOrgUnitInfo");
                if (hrOrgUnitInfo == null) throw new BOSException(label7);
                hrorgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnitInfo.getId()));
                orgNumber = hrorgUnitInfo.getNumber();
            } else {
                AdminOrgUnitInfo adminOrgUnitInfo = (AdminOrgUnitInfo)paramMap.get("adminOrgUnitInfo");
                if (adminOrgUnitInfo == null) throw new BOSException(label7);
                AdminOrgUnitInfo admin = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getId()));
                orgNumber = admin.getNumber();
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(label7);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(label7);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(label7);
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        paramMap.put("orgNumber", orgNumber);
        paramMap.put("businessAttribute", bussAttrNumber);
        paramMap.put("jobCreateID", userId);
        paramMap.put("jobPriority", jobPriority);
        paramMap.put("isPhotoCopy", true);
        paramMap.put("level", "1");
        paramMap.put("autoApprove", autoApprove);
        paramMap.put("isLastLevel", "false");
        String createArgs = "";
        createArgs = JSONUtils.convertObjectToJson((Context)ctx, paramMap);
        HashMap<String, String> osfparam = new HashMap<String, String>();
        osfparam.put("createArgs", createArgs);
        JsonObject resultObj = new JsonObject();
        resultObj = (JsonObject)OSFAppUtil.callService((Context)ctx, (String)"createJobNewService", osfparam);
        logger.debug("\u521b\u5efa\u4efb\u52a1\u53c2\u6570:" + paramMap);
        logger.debug("\u4efb\u52a1\u521b\u5efa\u63a5\u53e3\u7ed3\u679c:" + String.valueOf(resultObj));
        if (resultObj == null) {
            String label9 = SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource", (String)"label9", (Context)ctx);
            throw new BOSException(label9);
        }
        if (!resultObj.get("success").getAsBoolean()) {
            String label8 = SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource", (String)"label8", (Context)ctx);
            String realLabel8 = MessageFormat.format(label8, String.valueOf(resultObj));
            throw new BOSException(realLabel8);
        }
        if (!iActivityJobInfo.exists("where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "'")) {
            if (!logger.isDebugEnabled()) return;
            logger.debug("======== com.kingdee.shr.shareservice.util.ActivityHelper.innerCreateSSCJob where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "' not exists!!!");
            return;
        }
        ActivityJobInfoCollection activityJobInfoColl = iActivityJobInfo.getActivityJobInfoCollection("where activity = '" + activity.getId().toString() + "' and bill = '" + billId + "' and scheme = '" + solutionId + "' and jobState = 0");
        if (activityJobInfoColl.size() > 1) {
            logger.error("======== com.kingdee.shr.shareservice.util.ActivityHelper.innerCreateSSCJob activityJobInfoColl more than one ");
            return;
        }
        if (activityJobInfoColl.size() != 1) {
            logger.error("======== com.kingdee.shr.shareservice.util.ActivityHelper.innerCreateSSCJob activityJobInfoColl less than one ");
            return;
        }
        BOSUuid activityJobId = activityJobInfoColl.get(0).getId();
        ActivityJobInfoInfo activityJobInfoInfo = iActivityJobInfo.getActivityJobInfoInfo((IObjectPK)new ObjectUuidPK(activityJobId));
        if (activityJobInfoInfo.isIsAutoJob()) {
            activityJobInfoInfo.setJobState(JobState.finish);
        } else {
            activityJobInfoInfo.setJobState(JobState.process);
        }
        activityJobInfoInfo.setJobId(resultObj.get("data").getAsString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("jobState"));
        selector.add(new SelectorItemInfo("jobId"));
        iActivityJobInfo.updatePartial(activityJobInfoInfo, selector);
        if (!activityJobInfoInfo.isIsAutoJob()) return;
        HashMap afterPassMap = new HashMap();
        ActivityHelper.afterPass(ctx, billId, activity.getId().toString(), resultObj.get("data").getAsString(), afterPassMap, false);
    }

    private static void afterPass(Context ctx, String billId, String activityId, String jobId, Map map, boolean isCreateByActivity) throws BOSException, EASBizException {
        logger.debug("====== com.kingdee.shr.shareservice.web.handler.BaseBillTaskEditHandler.afterPass isCreateByActivity: " + isCreateByActivity);
        if (!isCreateByActivity) {
            ActivityHelper.createNextJob(ctx, jobId, billId, activityId, false);
            boolean isFinish = ActivityHelper.checkSolution(ctx, billId, activityId, jobId);
            if (isFinish) {
                logger.debug("====== com.kingdee.shr.shareservice.web.handler.BaseBillTaskEditHandler.afterPass dealWithWorkFlow");
                ActivityHelper.dealWithWorkFlow(ctx, billId, true);
            }
        } else {
            AssignInfo assignInfo = ActivityHelper.getassignInfo(ctx, billId);
            logger.debug("========= com.kingdee.shr.shareservice.web.handler.EmpBillTaskEditHandler.afterPass assignInfo \uff1a " + assignInfo);
            WorkflowProceedFacadeFactory.getLocalInstance(ctx).submitMultipaprove(billId, assignInfo.getAssignID().toString(), map);
        }
    }

    public static void dealWithWorkFlow(Context ctx, String billId, boolean isPass) {
        try {
            boolean hasOtherSysInfo = SHRWorkFlowOtherSysUtil.hasOtherSysInfo(ctx, billId);
            if (hasOtherSysInfo) {
                SHRWorkFlowOtherSysUtil.continueWorkFlow(ctx, billId, "");
            } else {
                WorkflowProceedFacadeFactory.getLocalInstance(ctx).wfproceedTrigger(billId, true);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static AssignInfo getassignInfo(Context ctx, String billId) throws BOSException {
        AssignInfo assignInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bizObjID", (Object)billId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bizFunction", (Object)"MultiApproveUIFunction", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSendMsg", (Object)false, CompareType.EQUALS));
        view.setFilter(filter);
        AssignCollection coll = AssignFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        assignInfo = coll.get(0);
        if (assignInfo.getAssignID() == null) {
            return null;
        }
        return assignInfo;
    }

    private static boolean checkSolution(Context ctx, String billId, String activityId, String solutionId) throws EASBizException, BOSException {
        boolean isFinish = false;
        ActivitySolutionInfo solutionInfo = ActivitySolutionFactory.getLocalInstance(ctx).getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
        SolutionActivityInfoCollection solutionActivityColl = solutionInfo.getEntrys();
        HashSet<String> solutionActivityInfofilterSet = new HashSet<String>();
        for (int i = 0; i < solutionActivityColl.size(); ++i) {
            solutionActivityInfofilterSet.add(solutionActivityColl.get(i).getId().toString());
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo solutionActivityInfofilter = new FilterInfo();
        entity.setFilter(solutionActivityInfofilter);
        solutionActivityInfofilter.getFilterItems().add(new FilterItemInfo("id", solutionActivityInfofilterSet, CompareType.INCLUDE));
        SolutionActivityInfoCollection coll = SolutionActivityInfoFactory.getLocalInstance(ctx).getSolutionActivityInfoCollection(entity);
        HashSet<String> filterSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            filterSet.add(coll.get(i).getActivity().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bill", (Object)billId));
        filter.getFilterItems().add(new FilterItemInfo("activity", filterSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("jobState", (Object)2, CompareType.NOTEQUALS));
        isFinish = !ActivityJobInfoFactory.getLocalInstance(ctx).exists(filter);
        return isFinish;
    }

    public static String getBussAttrNum(Context ctx, String billId, String activityId) throws BOSException {
        String billBosType = BOSUuid.read((String)billId).getType().toString();
        if (null != bosType2bussNum.get(billBosType + "-" + activityId)) {
            return bosType2bussNum.get(billBosType + "-" + activityId);
        }
        ActivityTypeCollection activityTypeColl = ActivityTypeFactory.getLocalInstance(ctx).getActivityTypeCollection("where bosType='" + billBosType + "'");
        if (activityTypeColl.size() > 0) {
            ActivityTypeInfo activityTypeInfo = activityTypeColl.get(0);
            ActivityBussTypeCollection coll = ActivityBussTypeFactory.getLocalInstance(ctx).getActivityBussTypeCollection("where activity='" + activityId + "' and activityType='" + activityTypeInfo.getId().toString() + "'");
            if (coll.size() > 0) {
                String bussAttrNum = coll.get(0).getBussAttrNum();
                bosType2bussNum.put(billBosType + "-" + activityId, bussAttrNum);
                return bussAttrNum;
            }
            return null;
        }
        return null;
    }

    public static String getBussAttrNumByType(Context ctx, String activityTypeId, String activityId) throws BOSException, EASBizException {
        ActivityTypeInfo info = ActivityTypeFactory.getLocalInstance(ctx).getActivityTypeInfo((IObjectPK)new ObjectUuidPK(activityTypeId));
        String billBosType = info.getBosType();
        if (null != bosType2bussNum.get(billBosType + "-" + activityId)) {
            return bosType2bussNum.get(billBosType + "-" + activityId);
        }
        ActivityTypeCollection activityTypeColl = ActivityTypeFactory.getLocalInstance(ctx).getActivityTypeCollection("where bosType='" + billBosType + "'");
        if (activityTypeColl.size() > 0) {
            ActivityTypeInfo activityTypeInfo = activityTypeColl.get(0);
            ActivityBussTypeCollection coll = ActivityBussTypeFactory.getLocalInstance(ctx).getActivityBussTypeCollection("where activity='" + activityId + "' and activityType='" + activityTypeInfo.getId().toString() + "'");
            if (coll.size() > 0) {
                String bussAttrNum = coll.get(0).getBussAttrNum();
                bosType2bussNum.put(billBosType + "-" + activityId, bussAttrNum);
                return bussAttrNum;
            }
            return null;
        }
        return null;
    }

    public static void advanceTranslate(Context ctx, FilterItemInfo info, String translateStr) throws BOSException {
        Object v = info.getCompareValue();
        CompareType t = info.getCompareType();
        if (t.equals((Object)CompareType.INCLUDE)) {
            info.setCompareType(CompareType.INCLUDE);
            ActivityHelper.valueNotNullTranslate(ctx, info, v, translateStr);
        } else if (t.equals((Object)CompareType.NOTINCLUDE)) {
            info.setCompareType(CompareType.NOTINCLUDE);
            ActivityHelper.valueNotNullTranslate(ctx, info, v, translateStr);
        } else if (t.equals((Object)CompareType.EQUALS)) {
            if (null != v) {
                info.setCompareType(CompareType.INCLUDE);
                ActivityHelper.valueNotNullTranslate(ctx, info, v, translateStr);
            } else {
                info.setPropertyName("id");
            }
        } else if (!(t.equals((Object)CompareType.GREATER) || t.equals((Object)CompareType.LESS) || t.equals((Object)CompareType.GREATER_EQUALS) || t.equals((Object)CompareType.LESS_EQUALS))) {
            if (t.equals((Object)CompareType.NOTEQUALS)) {
                if (null != v) {
                    info.setCompareType(CompareType.NOTINCLUDE);
                    ActivityHelper.valueNotNullTranslate(ctx, info, v, translateStr);
                } else {
                    info.setPropertyName("id");
                }
            } else if (t.equals((Object)CompareType.LIKE)) {
                info.setCompareType(CompareType.INCLUDE);
                ActivityHelper.valueNotNullTranslate(ctx, info, v, translateStr);
            } else if (t.equals((Object)CompareType.NOTLIKE)) {
                info.setCompareType(CompareType.NOTINCLUDE);
                ActivityHelper.valueNotNullTranslate(ctx, info, v, translateStr);
            }
        }
    }

    private static void valueNotNullTranslate(Context ctx, FilterItemInfo info, Object v, String translateStr) throws BOSException {
        String value = v.toString();
        String realValueStr = null;
        if (value.indexOf("[") != -1 && value.indexOf("]") != -1) {
            realValueStr = value.replaceAll("\\[", "").replaceAll("\\]", "");
        }
        ActivityApplyEntryCollection aaeColl = ActivityApplyEntryFactory.getLocalInstance(ctx).getActivityApplyEntryCollection("select activity where activityType = '" + realValueStr + "'");
        HashSet<String> realValue = new HashSet<String>();
        for (int k = 0; k < aaeColl.size(); ++k) {
            realValue.add(aaeColl.get(k).getActivity().getId().toString());
        }
        info.setCompareValue(realValue);
        info.setPropertyName(translateStr);
    }

    public static void updateInnerBillId(Context ctx, String jobId, String billId) throws BOSException, EASBizException {
        ActivityJobInfoCollection activityJobInfoColl = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where jobId = '" + jobId + "'");
        if (activityJobInfoColl.size() != 1) {
            logger.error("====com.kingdee.shr.shareservice.util.ActivityHelper.updateInnerBillId jobId:" + jobId);
            throw new SSCActivityException(SSCActivityException.JOB_ID_ERROR);
        }
        ActivityJobInfoInfo info = activityJobInfoColl.get(0);
        info.setInnerBillId(billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("innerBillId"));
        ActivityJobInfoFactory.getLocalInstance(ctx).updatePartial(info, selector);
    }

    public static void updateInnerSaved(Context ctx, String jobId, String billId) throws BOSException, EASBizException {
        ActivityJobInfoCollection activityJobInfoColl = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where jobId = '" + jobId + "'");
        if (activityJobInfoColl.size() != 1) {
            logger.error("====com.kingdee.shr.shareservice.util.ActivityHelper.updateInnerBillId jobId:" + jobId);
            throw new SSCActivityException(SSCActivityException.JOB_ID_ERROR);
        }
        ActivityJobInfoInfo info = activityJobInfoColl.get(0);
        info.setInnerBillId(billId);
        info.setIsSaved(true);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("innerBillId"));
        selector.add(new SelectorItemInfo("isSaved"));
        ActivityJobInfoFactory.getLocalInstance(ctx).updatePartial(info, selector);
    }

    public static Object getRuleValOnRuleDetailEntry(Context ctx, CoActivityAssignRuleDetailEntryInfo detailEntryInfo) {
        String ruleVal;
        block4: {
            ruleVal = detailEntryInfo.getRuleVal();
            try {
                if (BOSUuid.isValid((String)ruleVal, (boolean)false)) {
                    BOSUuid idBosUuid = BOSUuid.read((String)ruleVal);
                    String bostype = idBosUuid.getType().toString();
                    if ("6A45086F".equals(bostype)) {
                        ActivityTypeInfo activityTypeInfo = ActivityTypeFactory.getLocalInstance(ctx).getActivityTypeInfo((IObjectPK)new ObjectUuidPK(idBosUuid));
                        return activityTypeInfo.getBosType();
                    }
                    break block4;
                }
                return ruleVal;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return ruleVal;
    }

    public static Object getRuleValOnActivityRuleEntryInfo(Context ctx, ActivityRuleEntryInfo ruleEntryInfo) {
        String ruleVal;
        block4: {
            ruleVal = ruleEntryInfo.getRuleVal();
            try {
                if (BOSUuid.isValid((String)ruleVal, (boolean)false)) {
                    BOSUuid idBosUuid = BOSUuid.read((String)ruleVal);
                    String bostype = idBosUuid.getType().toString();
                    if ("6A45086F".equals(bostype)) {
                        ActivityTypeInfo activityTypeInfo = ActivityTypeFactory.getLocalInstance(ctx).getActivityTypeInfo((IObjectPK)new ObjectUuidPK(idBosUuid));
                        return activityTypeInfo.getBosType();
                    }
                    break block4;
                }
                return ruleVal;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return ruleVal;
    }

    public static Map<String, Integer> getActivityNodeJobCountOnCurrentUser(Context ctx, ActivityCollection activityCollection, String activityTypeId, String solutionId) throws BOSException, EASBizException {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        ArrayList<String> jobIdList = new ArrayList<String>();
        ArrayList<String> coJobIdList = new ArrayList<String>();
        if (activityCollection.size() > 0) {
            for (int dex = 0; dex < activityCollection.size(); ++dex) {
                ActivityInfo activityInfo = activityCollection.get(dex);
                String activityId = activityInfo.getId().toString();
                if (activityInfo.isIsSSC()) {
                    jobIdList.add(activityId);
                } else {
                    coJobIdList.add(activityId);
                }
                resultMap.put(activityId, 0);
            }
        }
        try {
            Map jobCountInfo = ActivityHelper.getJobCountInfo(ctx, jobIdList, activityTypeId, solutionId);
            Map sscJObCount = (Map)jobCountInfo.get("jobCountMap");
            if (sscJObCount != null) {
                for (Map.Entry entry : sscJObCount.entrySet()) {
                    resultMap.put((String)entry.getKey(), (Integer)entry.getValue());
                }
            }
        }
        catch (Exception e) {
            logger.error(activityTypeId + " getJobCountInfo error:" + e.getMessage(), (Throwable)e);
        }
        Map coJobCountInfo = ActivityHelper.getCoJobCountInfo(ctx, coJobIdList, solutionId);
        Map coJObCount = (Map)coJobCountInfo.get("jobCountMap");
        if (coJObCount != null) {
            for (Map.Entry entry : coJObCount.entrySet()) {
                resultMap.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        return resultMap;
    }

    public static Map<String, Integer> getActivityNodeJobCountOnCurrentUser(Context ctx, List<String> activityIdList, String activityTypeId, String solutionId) throws BOSException, EASBizException {
        IActivity iActivity = ActivityFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setFilter(filter);
        view.setSelector(selector);
        ActivityCollection activityCollection = new ActivityCollection();
        if (activityIdList == null || activityIdList.size() <= 0) {
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("entrys.id"));
            selector.add(new SelectorItemInfo("entrys.activity.id"));
            selector.add(new SelectorItemInfo("entrys.activity.isSSC"));
            ActivitySolutionInfo solutionColl = ActivitySolutionFactory.getLocalInstance(ctx).getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId), selector);
            SolutionActivityInfoCollection activityInfoCollection = solutionColl.getEntrys();
            for (int dex = 0; dex < activityInfoCollection.size(); ++dex) {
                SolutionActivityInfoInfo solutionActivityInfoInfo = activityInfoCollection.get(dex);
                activityCollection.add(solutionActivityInfoInfo.getActivity());
            }
        } else {
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("isSSC"));
            HashSet<String> activityIdSet = new HashSet<String>();
            for (int i = 0; i < activityIdList.size(); ++i) {
                activityIdSet.add(activityIdList.get(i));
            }
            filter.getFilterItems().add(new FilterItemInfo("id", activityIdSet, CompareType.INCLUDE));
            activityCollection = iActivity.getActivityCollection(view);
        }
        return ActivityHelper.getActivityNodeJobCountOnCurrentUser(ctx, activityCollection, activityTypeId, solutionId);
    }

    public static Map getJobCountInfo(Context ctx, List<String> activityIdList, String activityTypeId, String solutionId) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        if (activityIdList == null || activityIdList.size() == 0) {
            return resultMap;
        }
        HashMap<String, Integer> jobCountMap = new HashMap<String, Integer>();
        HashMap<String, String> firstJobMap = new HashMap<String, String>();
        resultMap.put("jobCountMap", jobCountMap);
        resultMap.put("firstJobMap", firstJobMap);
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        conditionMap.put("queryPKStr", "com.kingdee.eas.base.ssc.app.JobQuery");
        conditionMap.put("columnModelStr", "bussAttrID.id,id,remainderTime");
        conditionMap.put("sidxStr", "");
        conditionMap.put("sordStr", "");
        FilterInfo filterInfo = new FilterInfo();
        HashSet bussAttrIdSet = new HashSet();
        HashSet<String> activityIdSet = new HashSet<String>();
        ActivityBussTypeCollection coll = ActivityBussTypeFactory.getLocalInstance(ctx).getActivityBussTypeCollection("select activity.id, bussAttrId where activityType = '" + activityTypeId + "'");
        HashMap<String, String> activityBussMap = new HashMap<String, String>();
        HashMap<String, String> bussActivityMap = new HashMap<String, String>();
        if (coll.size() > 0) {
            int i;
            for (i = 0; i < coll.size(); ++i) {
                ActivityBussTypeInfo info = coll.get(i);
                activityBussMap.put(info.getActivity().getId().toString(), info.getBussAttrId());
                bussActivityMap.put(info.getBussAttrId(), info.getActivity().getId().toString());
            }
            for (i = 0; i < activityIdList.size(); ++i) {
                String activityId = activityIdList.get(i);
                activityIdSet.add(activityId);
                if (!StringUtils.isEmpty((String)((String)activityBussMap.get(activityId)))) {
                    bussAttrIdSet.add(activityBussMap.get(activityId));
                }
                jobCountMap.put(activityId, 0);
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("bussAttrID.id", bussAttrIdSet, CompareType.INCLUDE));
        conditionMap.put("filterItemsStr", filterInfo.toString());
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortInfo = new SorterItemInfo("remainderTime");
        sortInfo.setSortType(SortType.ASCEND);
        sortColl.add(sortInfo);
        conditionMap.put("sorterItemsStr", sortColl.toString());
        conditionMap.put("selector", "id,jobState");
        conditionMap.put("rowsInt", 8000);
        conditionMap.put("pageInt", 1);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        conditionMap.put("userIdStr", userInfo.getId().toString());
        String queryCondition = XMLDocUtil.getQueryCondition(conditionMap);
        JsonObject queryJabList = SSCTaskAppUtil.queryJabList(ctx, queryCondition);
        String jobInfosStr = queryJabList.toString();
        ArrayList datas = new ArrayList();
        if (jobInfosStr == null || jobInfosStr.isEmpty()) {
            // empty if block
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("activity", activityIdSet, CompareType.INCLUDE));
        if ("noSolution".equals(solutionId)) {
            filter.getFilterItems().add(new FilterItemInfo("scheme", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("scheme", (Object)solutionId));
        }
        view.setFilter(filter);
        logger.debug(" ====== com.kingdee.shr.shareservice.util.ActivityHelper.getCoJobCountInfo view:" + view.toString());
        ActivityJobInfoCollection jobInfoColl = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection(view);
        HashSet<String> allJobSet = new HashSet<String>();
        for (int i = 0; i < jobInfoColl.size(); ++i) {
            allJobSet.add(jobInfoColl.get(i).getJobId());
        }
        Map resultObject = (Map)JSON.parseObject((String)jobInfosStr, Map.class);
        if (resultObject != null && resultObject.get("rows") != null) {
            List resultList = (List)resultObject.get("rows");
            for (int i = 0; i < resultList.size(); ++i) {
                String jobId;
                Map jobMap = (Map)resultList.get(i);
                String bussAttrId = (String)jobMap.get("bussAttrID.id");
                String activityId = (String)bussActivityMap.get(bussAttrId);
                if (StringUtils.isEmpty((String)activityId) || !allJobSet.contains(jobId = (String)jobMap.get("id"))) continue;
                if (jobCountMap.get(activityId) != null) {
                    jobCountMap.put(activityId, (Integer)jobCountMap.get(activityId) + 1);
                }
                if (jobMap.get("jobState") == null || ((Map)jobMap.get("jobState")).get("value") == null || firstJobMap.size() != 0 || Double.valueOf(Double.parseDouble(((Map)jobMap.get("jobState")).get("value").toString())).intValue() != 2) continue;
                firstJobMap.put(activityId, jobId);
            }
        }
        return resultMap;
    }

    public static Map getCoJobCountInfo(Context ctx, List<String> activityIdList, String solutionId) throws BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap resultMap = new HashMap();
        HashMap<String, Integer> jobCountMap = new HashMap<String, Integer>();
        HashMap<String, String> firstJobMap = new HashMap<String, String>();
        resultMap.put("jobCountMap", jobCountMap);
        resultMap.put("firstJobMap", firstJobMap);
        HashSet<String> activityIdSet = new HashSet<String>();
        for (int i = 0; i < activityIdList.size(); ++i) {
            String activityId = activityIdList.get(i);
            activityIdSet.add(activityId);
            jobCountMap.put(activityId, 0);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if ("noSolution".equals(solutionId)) {
            filter.getFilterItems().add(new FilterItemInfo("scheme", null));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("scheme", (Object)solutionId));
        }
        filter.getFilterItems().add(new FilterItemInfo("activity", activityIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("jobState", (Object)1));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("jobId"));
        view.setFilter(filter);
        view.setSelector(selector);
        logger.debug(" ====== com.kingdee.shr.shareservice.util.ActivityHelper.getCoJobCountInfo view:" + view.toString());
        ActivityJobInfoCollection activityJobInfoCollection = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection(view);
        HashSet<String> jobIdSet = new HashSet<String>();
        for (int dex = 0; dex < activityJobInfoCollection.size(); ++dex) {
            jobIdSet.add(activityJobInfoCollection.get(dex).getJobId());
        }
        if (!jobIdSet.isEmpty()) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            SorterItemCollection sorter = new SorterItemCollection();
            filter.getFilterItems().add(new FilterItemInfo("coActivity.id", jobIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("user", (Object)userInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)"0"));
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("coActivity.id"));
            selector.add(new SelectorItemInfo("coActivity.bussAttrID.id"));
            SorterItemInfo sortInfo = new SorterItemInfo("reminderTime");
            sortInfo.setSortType(SortType.ASCEND);
            sorter.add(sortInfo);
            view.setFilter(filter);
            view.setSelector(selector);
            view.setSorter(sorter);
            CoActivityExecutorCollection coll = CoActivityExecutorFactory.getLocalInstance(ctx).getCoActivityExecutorCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                String activityId = coll.get(i).getCoActivity().getBussAttrID().getId().toString();
                if (jobCountMap.get(activityId) != null) {
                    jobCountMap.put(activityId, (Integer)jobCountMap.get(activityId) + 1);
                } else {
                    jobCountMap.put(activityId, 1);
                }
                if (firstJobMap.size() != 0) continue;
                firstJobMap.put(activityId, coll.get(0).getCoActivity().getId().toString());
            }
        }
        return resultMap;
    }

    public static List<String> getNextJobList(Context ctx, String billId, String activityId, String solutionId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("preActivity.id", (Object)activityId));
        filterInfo.getFilterItems().add(new FilterItemInfo("solution.id", (Object)solutionId));
        SelectorItemCollection seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("activity.id"));
        view.setFilter(filterInfo);
        view.setSelector(seletor);
        PreActivityRelCollection nextColl = PreActivityRelFactory.getLocalInstance(ctx).getPreActivityRelCollection(view);
        HashSet<String> nextActivitySet = new HashSet<String>();
        for (int i = 0; i < nextColl.size(); ++i) {
            nextActivitySet.add(nextColl.get(i).getActivity().getId().toString());
        }
        view = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("activity", nextActivitySet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("bill", (Object)billId));
        filterInfo.getFilterItems().add(new FilterItemInfo("scheme", (Object)solutionId));
        seletor = new SelectorItemCollection();
        seletor.add(new SelectorItemInfo("id"));
        seletor.add(new SelectorItemInfo("jobId"));
        view.setFilter(filterInfo);
        view.setSelector(seletor);
        ActivityJobInfoCollection jobInfoColl = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection(view);
        ArrayList<String> jobIdList = new ArrayList<String>();
        for (int i = 0; i < jobInfoColl.size(); ++i) {
            String jobId = jobInfoColl.get(i).getJobId();
            if (StringUtils.isEmpty((String)jobId)) continue;
            jobIdList.add(jobId);
        }
        return jobIdList;
    }

    public static void allotUser(Context ctx, String jobId, String userId) throws BOSException, EASBizException {
        String bosType = BOSUuid.read((String)jobId).getType().toString();
        if ("88451F0D".equals(bosType)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("userId", userId);
            params.put("jobId", jobId);
            JsonObject dealerJo = SSCTaskAppUtil.operateTaskAll(ctx, "JOBDEALER", params);
            if (dealerJo.get("dataType") != null && "String".equals(dealerJo.get("dataType").getAsString()) && "true".equals(dealerJo.get("data").getAsString())) {
                params.clear();
                params.put("queryPK", "com.kingdee.eas.base.ssc.app.UserQuery");
                FilterInfo queryFilter = new FilterInfo();
                queryFilter.getFilterItems().add(new FilterItemInfo("easUserId", (Object)userId, CompareType.EQUALS));
                params.put("filterItems", queryFilter.toString());
                params.put("columnModel", "id");
                JsonObject sscuser = SSCTaskAppUtil.operateTaskAll(ctx, "GETQUERYDATA", params);
                if (null != sscuser && !sscuser.isJsonNull()) {
                    JsonArray sscuserCol;
                    JsonArray jsonArray = sscuserCol = sscuser.get("rows") == null || sscuser.get("rows").isJsonNull() ? null : sscuser.get("rows").getAsJsonArray();
                    if (null != sscuserCol) {
                        JsonObject sscUserJson = sscuserCol.get(0).getAsJsonObject();
                        String operatorId = sscUserJson.get("id").getAsString();
                        params.clear();
                        params.put("userId", userId);
                        params.put("jobList", jobId);
                        params.put("operatorId", operatorId);
                        SSCTaskAppUtil.operateTaskAll(ctx, "ALLOTPERSON", params);
                    }
                }
            }
        } else if ("DC26015C".equals(bosType)) {
            HashMap params = new HashMap();
            CoActivityJobCollection coJobInfoCol = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobCollection("where id = '" + jobId + "'");
            if (!coJobInfoCol.isEmpty()) {
                ArrayList<String> defaultUser = new ArrayList<String>();
                defaultUser.add(userId);
                params.put("defaultUser", defaultUser);
                CoActivityOptUtil.assignUser(ctx, coJobInfoCol.get(0), null, params);
            }
        }
    }

    public static Map<String, Object> allotUser(Context ctx, String billId, String activityId, String preJobId) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        logger.error("ActivityHelper allotUser...");
        List<String> nextJobIds = null;
        String solutionId = "";
        IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance(ctx);
        ActivityJobInfoCollection infoColl = iActivityJobInfo.getActivityJobInfoCollection("select scheme where jobId = '" + preJobId + "'");
        logger.error("ActivityHelper infoColl : " + infoColl.size());
        if (infoColl.size() == 0) {
            return null;
        }
        solutionId = infoColl.get(0).getScheme();
        logger.error("ActivityHelper solutionId : " + solutionId);
        nextJobIds = ActivityHelper.getNextJobList(ctx, billId, activityId, solutionId);
        logger.error("ActivityHelper nextJobIds : " + nextJobIds);
        if (nextJobIds != null && nextJobIds.size() > 0) {
            for (int i = 0; i < nextJobIds.size(); ++i) {
                logger.error("ActivityHelper nextJobIds.get(i) : " + nextJobIds.get(i));
                ActivityHelper.allotUser(ctx, nextJobIds.get(i), userId);
            }
        }
        ActivityJobInfoCollection coll = ActivityJobInfoFactory.getLocalInstance(ctx).getActivityJobInfoCollection("where bill = '" + billId + "' and jobState = 1 and scheme = '" + solutionId + "' and jobId is not null");
        HashMap<String, Object> urlMap = new HashMap<String, Object>();
        for (int i = 0; i < coll.size(); ++i) {
            ActivityJobInfoInfo activityJobInfoInfo = coll.get(i);
            String jobId = activityJobInfoInfo.getJobId();
            logger.error("ActivityHelper activityJobInfoInfo jobId : " + jobId);
            if (!ActivityHelper.checkJobUser(ctx, jobId, userId).booleanValue()) continue;
            Boolean isCoJob = ActivityHelper.isCoJob(jobId);
            logger.error("ActivityHelper Boolean isCoJob : " + isCoJob);
            if (isCoJob != null && !isCoJob.booleanValue()) {
                String returnActivityId = activityJobInfoInfo.getActivity();
                urlMap.put("activityId", returnActivityId);
                urlMap.put("bizBillId", billId);
                urlMap.put("jobId", jobId);
                urlMap.put("nextCojob", false);
            } else {
                urlMap.put("nextCojob", true);
            }
            urlMap.put("billId", jobId);
            break;
        }
        logger.error("ActivityHelper activityJobInfoInfo urlMap : " + urlMap);
        if (urlMap.size() == 0) {
            String label5 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCActivityResource", (String)"label5", (Context)ctx);
            urlMap.put("errorMsg", label5);
        }
        return urlMap;
    }

    public static Boolean checkJobUser(Context ctx, String jobId, String userId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)userId)) {
            return false;
        }
        String bosType = BOSUuid.read((String)jobId).getType().toString();
        if ("88451F0D".equals(bosType)) {
            JsonObject jobJo = SSCTaskAppUtil.viewJobDetail(ctx, jobId);
            JsonElement personnelJe = jobJo.get("personnelID");
            if (personnelJe == null || personnelJe.isJsonNull()) {
                return false;
            }
            JsonElement easUserIdJe = personnelJe.getAsJsonObject().get("easUserId");
            if (easUserIdJe == null || easUserIdJe.isJsonNull()) {
                return false;
            }
            String jobUserId = easUserIdJe.getAsString();
            if (userId.equals(jobUserId)) {
                return true;
            }
            return false;
        }
        if ("DC26015C".equals(bosType)) {
            return CoActivityExecutorFactory.getLocalInstance(ctx).exists("where coActivity.id = '" + jobId + "' and user ='" + userId + "'");
        }
        return false;
    }

    public static Boolean isCoJob(String jobId) {
        String bosType = BOSUuid.read((String)jobId).getType().toString();
        if ("88451F0D".equals(bosType)) {
            return false;
        }
        if ("DC26015C".equals(bosType)) {
            return true;
        }
        return null;
    }
}

