/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.shareservice.RuleFieldEntryFactory;
import com.kingdee.shr.shareservice.RuleFieldEntryInfo;
import com.kingdee.shr.shareservice.RuleOperator;
import com.kingdee.shr.shareservice.ShareServiceException;
import com.kingdee.shr.shareservice.util.RuleOperatorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngine {
    private static final Logger logger = LoggerFactory.getLogger(RuleEngine.class);
    public static final String NUMBER_REGX = "t\\d+";
    public static final String RELATIONSHIP_REGX = "or|and";
    public static final String BLANK = " ";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String LOGICAL_AND = " && ";
    public static final String LOGICAL_OR = " || ";
    public static final String LEFTBRACKET = "(";
    public static final String RIGHTBRACKET = ")";
    public static final String CN_LEFTBRACKET = "\uff08";
    public static final String CN_RIGHTBRACKET = "\uff09";
    public static final String LOGICAL_RELATIONSHIP = "logicalRelationship";
    public static final String RELATIONSHIP = "relationship";
    public static final String RULELIST = "ruleList";
    public static final String FIELDID = "fieldId";
    public static final String FIELDVAL = "fieldVal";
    public static final String RULEOPT = "ruleOpt";
    public static final String RULEVAL = "ruleVal";
    public static final String NUMBER = "number";
    public static final String TASKTYPE = "taskType";

    public static void check(String expression) throws EASBizException {
        String expr = expression.toLowerCase();
        List<String> numberList = RuleEngine.analyse(expr, NUMBER_REGX);
        List<String> shipList = RuleEngine.analyse(expr, RELATIONSHIP_REGX);
        if (numberList.size() - shipList.size() > 1 || shipList.size() >= numberList.size()) {
            throw new ShareServiceException(ShareServiceException.EXPRESSION_CHECK_ERROR);
        }
        boolean paired = RuleEngine.isPairedBracket(expr = expr.replaceAll(CN_LEFTBRACKET, LEFTBRACKET).replaceAll(CN_RIGHTBRACKET, RIGHTBRACKET));
        if (!paired) {
            throw new ShareServiceException(ShareServiceException.EXPRESSION_CHECK_ERROR);
        }
    }

    public static boolean isPairedBracket(String condition) {
        char[] chars = condition.toCharArray();
        Stack<Character> stack = new Stack<Character>();
        for (char bracket : chars) {
            if (bracket == '(') {
                stack.push(Character.valueOf(bracket));
                continue;
            }
            if (bracket != ')') continue;
            if (stack.empty()) {
                return false;
            }
            Character pop = (Character)stack.pop();
            if (pop.charValue() != bracket) continue;
            return false;
        }
        return stack.isEmpty();
    }

    public static Map<String, Object> match(Context ctx, List<Map<String, Object>> rules, String expression) throws EASBizException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(rules.size());
        for (Map<String, Object> rule : rules) {
            String fieldId = (String)rule.get(FIELDID);
            String actualVal = rule.get(FIELDVAL) == null ? "" : String.valueOf(rule.get(FIELDVAL));
            RuleOperator operator = (RuleOperator)((Object)rule.get(RULEOPT));
            String compareVal = (String)rule.get(RULEVAL);
            String number = (String)rule.get(NUMBER);
            if (logger.isDebugEnabled()) {
                logger.debug("fieldId:" + fieldId + ";actualVal:" + actualVal + ";operator:" + operator.getValue() + ";compareVal:" + compareVal + ";number:" + number);
            }
            boolean simpleJudge = RuleEngine.simpleJudge(ctx, fieldId, actualVal, compareVal, operator.getValue());
            valueMap.put(number.toLowerCase(), simpleJudge);
        }
        return valueMap;
    }

    public static boolean interpreter(String condition, Map<String, Object> match) throws EASBizException {
        boolean result = false;
        String expr = condition.replaceAll(BLANK, "").toLowerCase();
        expr = expr.replaceAll(AND, LOGICAL_AND);
        expr = expr.replaceAll(OR, LOGICAL_OR);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("JavaScript");
        for (Map.Entry<String, Object> entry : match.entrySet()) {
            if (logger.isDebugEnabled()) {
                logger.debug("key = " + entry.getKey() + ", value = " + entry.getValue());
            }
            engine.put(entry.getKey(), entry.getValue());
        }
        try {
            result = (Boolean)engine.eval(expr);
            if (logger.isDebugEnabled()) {
                logger.debug("result = " + result + ", expr = " + expr);
            }
        }
        catch (ScriptException e) {
            logger.error("interpreter:" + e.getMessage(), (Throwable)e);
            throw new ShareServiceException(ShareServiceException.CUSTOM_EXCEPTION, e);
        }
        return result;
    }

    public static List<String> analyse(String expr, String regex) {
        expr = expr.toLowerCase();
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(expr);
        while (matcher.find()) {
            String group = matcher.group();
            result.add(group);
        }
        return result;
    }

    public static boolean judge(Context ctx, Map<String, Object> rules) throws EASBizException {
        boolean compare = false;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("rules:" + new Gson().toJson(rules));
            }
            String condition = String.valueOf(rules.get(RELATIONSHIP));
            List ruleList = (List)rules.get(RULELIST);
            RuleEngine.check(condition);
            Map<String, Object> match = RuleEngine.match(ctx, ruleList, condition);
            if (logger.isDebugEnabled()) {
                logger.debug("match:" + new Gson().toJson(match));
            }
            compare = RuleEngine.interpreter(condition, match);
        }
        catch (Exception e) {
            logger.error("Judge:" + e.getMessage(), (Throwable)e);
            compare = false;
        }
        return compare;
    }

    public static boolean simpleJudge(Context ctx, String fieldId, Object actualVal, Object compareVal, int operator) throws EASBizException {
        boolean compare = false;
        try {
            if (fieldId == null) {
                throw new ShareServiceException(ShareServiceException.ILLEGAL_ARGUMENT_ERROR, new String[]{"simpleJudge", FIELDID});
            }
            String fieldType = RuleEngine.queryFieldType(ctx, fieldId);
            if (logger.isDebugEnabled()) {
                logger.debug("fieldType:" + fieldId + ";actualVal:" + actualVal + ";operator:" + operator + ";compareVal:" + compareVal + ";fieldType:" + fieldType);
            }
            compare = RuleOperatorUtils.compare(fieldType, actualVal, operator, compareVal);
        }
        catch (Exception e) {
            logger.error("simpleJudge:" + e.getMessage(), (Throwable)e);
            compare = false;
        }
        return compare;
    }

    private static String queryFieldType(Context ctx, String fieldId) throws EASBizException {
        String fieldType = "";
        try {
            RuleFieldEntryInfo info = RuleFieldEntryFactory.getLocalInstance(ctx).getRuleFieldEntryInfo("where id ='" + fieldId + "'");
            fieldType = info.getFieldType();
        }
        catch (EASBizException e) {
            logger.error("queryFieldType:" + e.getMessage(), (Throwable)e);
            throw new ShareServiceException(ShareServiceException.CUSTOM_EXCEPTION, e);
        }
        catch (BOSException e) {
            logger.error("queryFieldType:" + e.getMessage(), (Throwable)e);
            throw new ShareServiceException(ShareServiceException.CUSTOM_EXCEPTION, e);
        }
        return fieldType;
    }
}

