/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.shareservice.IWorkFlowOtherSysInfo;
import com.kingdee.shr.shareservice.SSCWorkFlowException;
import com.kingdee.shr.shareservice.WFOtherSysStateEnum;
import com.kingdee.shr.shareservice.WorkFlowOtherSysInfoCollection;
import com.kingdee.shr.shareservice.WorkFlowOtherSysInfoFactory;
import com.kingdee.shr.shareservice.WorkFlowOtherSysInfoInfo;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHRWorkFlowOtherSysUtil {
    private static final Logger logger = LoggerFactory.getLogger(SHRWorkFlowOtherSysUtil.class);

    public static void createOtherSysInfo(Context ctx, String billId) throws BOSException, EASBizException {
        SHRWorkFlowOtherSysUtil.createOtherSysInfo(ctx, billId, null);
    }

    public static void createOtherSysInfo(Context ctx, String billId, String idCode) throws BOSException, EASBizException {
        WorkFlowOtherSysInfoInfo info = new WorkFlowOtherSysInfoInfo();
        String otherSysTaskId = (String)ctx.get((Object)"otherSysTaskId");
        info.setBillId(BOSUuid.read((String)billId));
        info.setOtherSysTaskId(otherSysTaskId);
        info.setIdCode(idCode);
        info.setWfOtherSysState(WFOtherSysStateEnum.RUNNING);
        WorkFlowOtherSysInfoFactory.getLocalInstance(ctx).addnew(info);
    }

    public static boolean hasOtherSysInfo(Context ctx, String billId) throws BOSException, EASBizException {
        return SHRWorkFlowOtherSysUtil.hasOtherSysInfo(ctx, billId, null);
    }

    public static boolean hasOtherSysInfo(Context ctx, String billId, String idCode) throws BOSException, EASBizException {
        boolean isExist = false;
        isExist = StringUtils.isEmpty((String)idCode) ? WorkFlowOtherSysInfoFactory.getLocalInstance(ctx).exists("where billId = '" + billId + "' and wfOtherSysState=1") : WorkFlowOtherSysInfoFactory.getLocalInstance(ctx).exists("where billId = '" + billId + "' and idCode = '" + idCode + "' and wfOtherSysState=1");
        return isExist;
    }

    public static void continueWorkFlow(Context ctx, String billId, String idCode, String result) throws BOSException, EASBizException {
        IWorkFlowOtherSysInfo iWorkFlowOtherSysInfo = WorkFlowOtherSysInfoFactory.getLocalInstance(ctx);
        WorkFlowOtherSysInfoCollection coll = null;
        coll = StringUtils.isEmpty((String)idCode) ? iWorkFlowOtherSysInfo.getWorkFlowOtherSysInfoCollection("where billId = '" + billId + "' and wfOtherSysState=1 order by createTime desc") : iWorkFlowOtherSysInfo.getWorkFlowOtherSysInfoCollection("where billId = '" + billId + "' and idCode = '" + idCode + "' and wfOtherSysState=1 order by createTime desc");
        if (coll == null || coll.size() == 0) {
            logger.error("===== continueWorkFlow coll is null ========");
        } else {
            WorkFlowOtherSysInfoInfo info = coll.get(0);
            try {
                String otherSysTaskId = info.getOtherSysTaskId();
                SHRWorkFlowOtherSysUtil.innerContinueWorkFlow(ctx, otherSysTaskId, result);
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (SecurityException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            info.setWfOtherSysState(WFOtherSysStateEnum.FINISHED);
            iWorkFlowOtherSysInfo.save((CoreBaseInfo)info);
        }
    }

    public static void continueWorkFlow(Context ctx, String otherSysTaskId, String result) throws BOSException, EASBizException {
        try {
            SHRWorkFlowOtherSysUtil.innerContinueWorkFlow(ctx, otherSysTaskId, result);
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private static void innerContinueWorkFlow(Context ctx, String otherSysTaskId, String result) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SSCWorkFlowException, BOSException {
        if (!SHRWorkFlowOtherSysUtil.isRunning(ctx, otherSysTaskId)) {
            throw new SSCWorkFlowException(SSCWorkFlowException.HAS_NO_OTHERTASK, new Object[]{otherSysTaskId});
        }
        Class<?> tClass = Class.forName("com.kingdee.bos.workflow.metas.OtherSysTaskFactory");
        Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
        Object object = tMethod.invoke(null, ctx);
        Method tMethodService = object.getClass().getMethod("callback", String.class, String.class);
        tMethodService.invoke(object, otherSysTaskId, result);
    }

    public static boolean isRunning(Context ctx, String otherSysTaskId) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(otherSysTaskId);
        try {
            Class<?> tClass = Class.forName("com.kingdee.bos.workflow.metas.OtherSysTaskFactory");
            Method tMethod = tClass.getMethod("getLocalInstance", Context.class);
            Object object = tMethod.invoke(null, ctx);
            Method tMethodService = object.getClass().getMethod("getValue", IObjectPK.class);
            PropertyContainer model = (PropertyContainer)tMethodService.invoke(object, pk);
            WfEngine engine = WfEngine.getEngine((Context)ctx);
            WfActivity actInst = engine.getActivityInst(model.getString("actinstId"));
            return "open.not_running.not_started".equals(actInst.state().toLowerCase());
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

