/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.smsplatform.SmsSignFactory;
import com.kingdee.shr.smsplatform.SmsSignInfo;
import com.kingdee.shr.smsplatform.SmsTemplateCollection;
import com.kingdee.shr.smsplatform.SmsTemplateFactory;
import com.kingdee.shr.smsplatform.app.AbstractSmsSignControllerBean;
import com.kingdee.shr.smsplatform.app.SmsException;
import com.kingdee.shr.smsplatform.util.SmsHttpUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SmsSignControllerBean
extends AbstractSmsSignControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.smsplatform.app.SmsSignControllerBean");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo(pk);
        if (smsSignInfo != null && smsSignInfo.getClouduuid() != null && !smsSignInfo.getClouduuid().isEmpty()) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            HashMap<String, String> header = this.getHeader(ctx);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("signNumber", smsSignInfo.getClouduuid());
            params.put("modifier", userInfo.getName());
            String url = SmsHttpUtils.getServiceUrl(ctx) + "/message/smssign/del";
            super.delete(ctx, pk);
            String resp = SmsHttpUtils.post(url, header, params);
            JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
            if (resultJsonObject.containsKey((Object)"code") && resultJsonObject.getString("code").equals("400")) {
                throw new SmsException(SmsException.CLOUD_CONNECT_ERR);
            }
            JSONObject data = JSONObject.parseObject((String)resultJsonObject.getString("data"));
            if (data.containsKey((Object)"errorcode") && data.getIntValue("errorcode") != 0) {
                logger.error((Object)("delete smsSign in cloud failed due to: " + data.getString("errormsg")));
                throw new SmsException(SmsException.DELETE_IN_CLOUD_ERR, new Object[]{data.getString("errormsg")});
            }
            if (!data.containsKey((Object)"errorcode") || data.getIntValue("errorcode") != 0) throw new SmsException(SmsException.CLOUD_ERR_OTHER, new Object[]{"error format data: " + data.toString()});
            logger.info((Object)(smsSignInfo.getName() + "deleted succeeed in cloud service." + resultJsonObject.getString("errormsg")));
            return;
        } else {
            super.delete(ctx, pk);
        }
    }

    public void _enable(Context ctx, String id) throws BOSException, EASBizException {
        SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo((IObjectPK)new ObjectUuidPK(id));
        if (smsSignInfo.getAuditState().getValue() != 1) {
            throw new SmsException(SmsException.AUDIT_NOT_PASS);
        }
        super._enable(ctx, id);
    }

    public void _disable(Context ctx, String id) throws BOSException, EASBizException {
        SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo((IObjectPK)new ObjectUuidPK(id));
        if (smsSignInfo.isIsSysPreset()) {
            throw new SmsException(SmsException.SYSPRESET_NOT_ALLOW_DISABLE);
        }
        ArrayList<String> usedTemplateList = new ArrayList<String>();
        SmsTemplateCollection smsTemplateCollection = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("select id,name where sign = '" + smsSignInfo.getId().toString() + "' and state = 1 and isSysPreset = 0");
        if (smsTemplateCollection.size() > 0) {
            for (int i = 0; i < smsTemplateCollection.size(); ++i) {
                usedTemplateList.add(smsTemplateCollection.get(i).getName());
            }
        }
        if (usedTemplateList.size() > 0) {
            throw new SmsException(SmsException.EXIST_ENABLED_TEMP, new Object[]{"[" + smsSignInfo.getName() + "]", usedTemplateList.toString()});
        }
        super._disable(ctx, id);
    }

    private HashMap<String, String> getHeader(Context ctx) throws EASBizException {
        try {
            ICloudServiceConfig irecConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            HashMap<String, String> header = new HashMap<String, String>();
            CloudServiceConfigCollection coll = irecConfig.getCloudServiceConfigCollection();
            CloudServiceConfigInfo configInfo = null;
            if (coll.size() <= 0) {
                String label0 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label0", (Context)ctx);
                throw new SmsException(SmsException.CLOUD_ERR_OTHER);
            }
            configInfo = coll.get(0);
            header.put("tenantId", configInfo.getServiceID());
            header.put("token", configInfo.getAccessToken());
            return header;
        }
        catch (BOSException e) {
            String label0 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label0", (Context)ctx);
            logger.error((Object)(label0 + e.getMessage()));
            throw new SmsException(SmsException.CLOUD_ERR_OTHER);
        }
    }
}

