/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.util.SysSettingHrOrgUnitUtil;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.smsplatform.SmsSignFactory;
import com.kingdee.shr.smsplatform.SmsSignInfo;
import com.kingdee.shr.smsplatform.SmsTemplateCollection;
import com.kingdee.shr.smsplatform.SmsTemplateFactory;
import com.kingdee.shr.smsplatform.SmsTemplateInfo;
import com.kingdee.shr.smsplatform.SmsTemplateRelHRCollection;
import com.kingdee.shr.smsplatform.SmsTemplateRelHRFactory;
import com.kingdee.shr.smsplatform.app.AbstractSmsTemplateControllerBean;
import com.kingdee.shr.smsplatform.app.SmsException;
import com.kingdee.shr.smsplatform.util.SmsHttpUtils;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SmsTemplateControllerBean
extends AbstractSmsTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.smsplatform.app.SmsTemplateControllerBean");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SmsTemplateInfo smsTemplateInfo = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateInfo(pk);
        if (smsTemplateInfo != null && smsTemplateInfo.getClouduuid() != null && !smsTemplateInfo.getClouduuid().isEmpty()) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            HashMap<String, String> header = this.getHeader(ctx);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tempNumber", smsTemplateInfo.getClouduuid());
            params.put("modifier", userInfo.getName());
            String url = SmsHttpUtils.getServiceUrl(ctx) + "/message/smstemplate/del";
            super.delete(ctx, pk);
            String resp = SmsHttpUtils.post(url, header, params);
            JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
            if (resultJsonObject.containsKey((Object)"code") && resultJsonObject.getString("code").equals("400")) {
                throw new SmsException(SmsException.CLOUD_CONNECT_ERR);
            }
            JSONObject data = JSONObject.parseObject((String)resultJsonObject.getString("data"));
            if (data.containsKey((Object)"errorcode") && data.getIntValue("errorcode") != 0) {
                logger.error((Object)("delete smsTemplate in cloud failed due to: " + data.getString("errormsg")));
                throw new SmsException(SmsException.DELETE_IN_CLOUD_ERR, new Object[]{data.getString("errormsg")});
            }
            if (!data.containsKey((Object)"errorcode") || data.getIntValue("errorcode") != 0) throw new SmsException(SmsException.CLOUD_ERR_OTHER, new Object[]{"error format data: " + data.toString()});
            logger.info((Object)(smsTemplateInfo.getName() + "deleted succeeed in cloud service." + resultJsonObject.getString("errormsg")));
            return;
        } else {
            super.delete(ctx, pk);
        }
    }

    public void _disable(Context ctx, String id) throws BOSException, EASBizException {
        SmsTemplateInfo smsTemplateInfo = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateInfo((IObjectPK)new ObjectUuidPK(id));
        if (smsTemplateInfo.isIsSysPreset()) {
            throw new SmsException(SmsException.SYSPRESET_NOT_ALLOW_DISABLE);
        }
        super._disable(ctx, id);
    }

    public void _enable(Context ctx, String id) throws BOSException, EASBizException {
        SmsTemplateInfo smsTemplateInfo = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateInfo((IObjectPK)new ObjectUuidPK(id));
        SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getSign().getId()));
        if (smsTemplateInfo.getAuditState().getValue() != 1) {
            throw new SmsException(SmsException.AUDIT_NOT_PASS);
        }
        if (smsSignInfo.getState().getValue() != 1) {
            throw new SmsException(SmsException.SIGN_NOT_ENABLE);
        }
        HROrgUnitCollection coll = null;
        if (UsePolicy.GLOBALLY_SHARED.equals((Object)smsTemplateInfo.getUsePolicy())) {
            coll = SysSettingHrOrgUnitUtil.queryHROrgUnitCollection((Context)ctx, (UsePolicy)smsTemplateInfo.getUsePolicy(), null);
        } else if (UsePolicy.DOWN_SHARED.equals((Object)smsTemplateInfo.getUsePolicy())) {
            HashSet<String> hrOrgUnitIds = new HashSet<String>();
            hrOrgUnitIds.add(smsTemplateInfo.getHrOrgUnit().getId().toString());
            SysSettingHrOrgUnitUtil.getHrOrgUnitSets((Context)ctx, (String)smsTemplateInfo.getHrOrgUnit().getId().toString(), hrOrgUnitIds, (boolean)Boolean.TRUE);
            coll = SysSettingHrOrgUnitUtil.queryHROrgUnitCollection((Context)ctx, (UsePolicy)smsTemplateInfo.getUsePolicy(), hrOrgUnitIds);
        } else if (UsePolicy.DISTRIBUTION_SHARED.equals((Object)smsTemplateInfo.getUsePolicy())) {
            coll = new HROrgUnitCollection();
            coll.add(SysSettingHrOrgUnitUtil.getHrOrgUnitInfo((Context)ctx, (String)smsTemplateInfo.getHrOrgUnit().getId().toString()));
        }
        logger.error((Object)("HROrgUnitCollection.size:" + coll.size()));
        if (coll.size() > 0) {
            SmsTemplateCollection smsTemplateCollection = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("select id,name where applyOper = '" + smsTemplateInfo.getApplyOper().getId().toString() + "' and state = 1 and isSysPreset = 0");
            logger.error((Object)("smsTemplateCollection.size:" + smsTemplateCollection.size()));
            logger.error((Object)("smsTemplateCollection:" + smsTemplateCollection.toString()));
            if (smsTemplateCollection.size() > 0) {
                for (int k = 0; k < smsTemplateCollection.size(); ++k) {
                    SmsTemplateInfo smsTemplateInfo1 = smsTemplateCollection.get(k);
                    for (int i = 0; i < coll.size(); ++i) {
                        SmsTemplateRelHRCollection smsTemplateRelHRCollection1 = SmsTemplateRelHRFactory.getLocalInstance(ctx).getSmsTemplateRelHRCollection("select id where state = 100 and baseInfoId = '" + smsTemplateInfo1.getId().toString() + "' and hrOrgUse = '" + coll.get(i).getId().toString() + "'");
                        if (smsTemplateRelHRCollection1.size() <= 0) continue;
                        logger.error((Object)("smsTemplateRelHRCollection1.size:" + smsTemplateRelHRCollection1.size()));
                        HROrgUnitInfo hrOrgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(coll.get(i).getId()));
                        throw new SmsException(SmsException.EXIST_OTHER_TEMPLATE, new Object[]{hrOrgUnitInfo.getName(), smsTemplateInfo1.getName(), smsTemplateInfo1.getName()});
                    }
                }
            }
        }
        super._enable(ctx, id);
    }

    private HashMap<String, String> getHeader(Context ctx) throws EASBizException {
        try {
            ICloudServiceConfig irecConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            HashMap<String, String> header = new HashMap<String, String>();
            CloudServiceConfigCollection coll = irecConfig.getCloudServiceConfigCollection();
            CloudServiceConfigInfo configInfo = null;
            if (coll.size() <= 0) {
                String label0 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label0", (Context)ctx);
                throw new SmsException(SmsException.CLOUD_ERR_OTHER);
            }
            configInfo = coll.get(0);
            header.put("tenantId", configInfo.getServiceID());
            header.put("token", configInfo.getAccessToken());
            return header;
        }
        catch (BOSException e) {
            String label0 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label0", (Context)ctx);
            logger.error((Object)(label0 + e.getMessage()));
            throw new SmsException(SmsException.CLOUD_ERR_OTHER);
        }
    }
}

