/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRInitCollection;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.base.HRInitInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.util.SysSettingHrOrgUnitUtil;
import com.kingdee.shr.cloudservice.CloudServiceConfigCollection;
import com.kingdee.shr.cloudservice.CloudServiceConfigFactory;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.cloudservice.ICloudServiceConfig;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.smsplatform.MessageApplyOperCollection;
import com.kingdee.shr.smsplatform.MessageApplyOperFactory;
import com.kingdee.shr.smsplatform.MessageApplyOperInfo;
import com.kingdee.shr.smsplatform.SMSAuditEntryCollection;
import com.kingdee.shr.smsplatform.SMSAuditEntryFactory;
import com.kingdee.shr.smsplatform.SMSAuditEntryInfo;
import com.kingdee.shr.smsplatform.SMSAuditFactory;
import com.kingdee.shr.smsplatform.SMSAuditInfo;
import com.kingdee.shr.smsplatform.SmsSignCollection;
import com.kingdee.shr.smsplatform.SmsSignFactory;
import com.kingdee.shr.smsplatform.SmsSignInfo;
import com.kingdee.shr.smsplatform.SmsSignRelHRFactory;
import com.kingdee.shr.smsplatform.SmsTemplateCollection;
import com.kingdee.shr.smsplatform.SmsTemplateFactory;
import com.kingdee.shr.smsplatform.SmsTemplateInfo;
import com.kingdee.shr.smsplatform.SmsTemplateRelHRCollection;
import com.kingdee.shr.smsplatform.SmsTemplateRelHRFactory;
import com.kingdee.shr.smsplatform.app.AbstractSmsplatformFacadeControllerBean;
import com.kingdee.shr.smsplatform.app.SMSAuditStateEnum;
import com.kingdee.shr.smsplatform.app.SmsException;
import com.kingdee.shr.smsplatform.app.auditStateEnum;
import com.kingdee.shr.smsplatform.util.SmsHttpUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SmsplatformFacadeControllerBean
extends AbstractSmsplatformFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.smsplatform.app.SmsplatformFacadeControllerBean");

    @Override
    protected void _loadHistoryData(Context ctx) throws BOSException, EASBizException {
        try {
            HRInitCollection hRInitCollection = HRInitFactory.getLocalInstance((Context)ctx).getHRInitCollection("where key = 'load_smsplatform' and value = 'false' ");
            if (hRInitCollection.size() > 0) {
                logger.info((Object)"SmsplatformFacadeControllerBean start to check history data");
                String signHistoryUrl = SmsHttpUtils.getServiceUrl(ctx) + "/message/smscustom/query_sign";
                String tempHistoryUrl = SmsHttpUtils.getServiceUrl(ctx) + "/message/smscustom/query";
                HashMap<String, String> header = this.getHeader(ctx);
                HashMap<String, String> params = new HashMap<String, String>();
                String signResp = SmsHttpUtils.post(signHistoryUrl, header, params);
                logger.error((Object)("SmsplatformFacadeControllerBean signResp:" + signResp));
                JSONObject signResultJsonObject = JSONObject.parseObject((String)signResp);
                if (signResultJsonObject.containsKey((Object)"code") && signResultJsonObject.getString("code").equals("400")) {
                    throw new SmsException(SmsException.CLOUD_CONNECT_ERR);
                }
                JSONObject signData = JSONObject.parseObject((String)signResultJsonObject.getString("data"));
                if (signData.containsKey((Object)"errorcode") && signData.getIntValue("errorcode") == -1) {
                    logger.error((Object)("SmsplatformFacadeControllerBean failed to get signData due to :" + signData.getString("errormsg")));
                    throw new SmsException(SmsException.GET_HISTORY_DATA_FAILED, new Object[]{signData.getString("errormsg")});
                }
                String tempResp = SmsHttpUtils.post(tempHistoryUrl, header, params);
                logger.error((Object)("SmsplatformFacadeControllerBean tempResp:" + tempResp));
                JSONObject tempResultJsonObject = JSONObject.parseObject((String)tempResp);
                if (tempResultJsonObject.containsKey((Object)"code") && tempResultJsonObject.getString("code").equals("400")) {
                    throw new SmsException(SmsException.CLOUD_CONNECT_ERR);
                }
                JSONObject tempData = JSONObject.parseObject((String)tempResultJsonObject.getString("data"));
                if (tempData.containsKey((Object)"errorcode") && tempData.getIntValue("errorcode") == -1) {
                    logger.error((Object)("SmsplatformFacadeControllerBean failed to get tempData due to :" + tempData.getString("errormsg")));
                    throw new SmsException(SmsException.GET_HISTORY_DATA_FAILED, new Object[]{tempData.getString("errormsg")});
                }
                if (signData.containsKey((Object)"errorcode") && signData.getIntValue("errorcode") == 101) {
                    logger.info((Object)"SmsplatformFacadeControllerBean succeed to get signData but not exist history data");
                }
                if (tempData.containsKey((Object)"errorcode") && tempData.getIntValue("errorcode") == 101) {
                    logger.info((Object)"SmsplatformFacadeControllerBean succeed to get tempData but not exist history data");
                }
                if (signData.containsKey((Object)"errorcode") && signData.getIntValue("errorcode") == 0) {
                    SmsSignCollection smsSignCollection;
                    logger.info((Object)"SmsplatformFacadeControllerBean succeed to get signData, start to load.");
                    JSONArray signArray = signData.getJSONArray("data");
                    if (signArray.size() > 0 && (smsSignCollection = SmsSignFactory.getLocalInstance(ctx).getSmsSignCollection("where isSysPreset = 1")).size() > 0) {
                        SmsSignInfo smsSignInfo = smsSignCollection.get(0);
                        for (Object objSign : signArray) {
                            JSONObject signJSON = (JSONObject)objSign;
                            if (signJSON == null || !signJSON.containsKey((Object)"signNumber") || !signJSON.containsKey((Object)"signName")) continue;
                            String signNumber = signJSON.getString("signNumber");
                            String signName = signJSON.getString("signName");
                            smsSignInfo.setId(null);
                            smsSignInfo.setIsSysPreset(false);
                            smsSignInfo.setState(BaseItemStateEnum.NEW);
                            smsSignInfo.setName(signName);
                            smsSignInfo.setName(signName, Locale.SIMPLIFIED_CHINESE);
                            smsSignInfo.setName(signName, Locale.TRADITIONAL_CHINESE);
                            smsSignInfo.setName(signName, Locale.ENGLISH);
                            smsSignInfo.setDescription(" ");
                            smsSignInfo.setDescription(" ", Locale.SIMPLIFIED_CHINESE);
                            smsSignInfo.setDescription(" ", Locale.TRADITIONAL_CHINESE);
                            smsSignInfo.setDescription(" ", Locale.ENGLISH);
                            smsSignInfo.setValidSignName(signName);
                            smsSignInfo.setClouduuid(signNumber);
                            smsSignInfo.setNumber(signNumber);
                            smsSignInfo.setCreateTime(new Timestamp(new Date().getTime()));
                            IObjectPK iObjectPK = SmsSignFactory.getLocalInstance(ctx).addnew(smsSignInfo);
                            SmsSignFactory.getLocalInstance(ctx).enable(iObjectPK.toString());
                        }
                    }
                }
                if (tempData.containsKey((Object)"errorcode") && tempData.getIntValue("errorcode") == 0) {
                    SmsTemplateCollection smsTemplateCollection;
                    logger.info((Object)"SmsplatformFacadeControllerBean succeed to get tempData, start to load.");
                    JSONArray tempArray = tempData.getJSONArray("data");
                    if (tempArray.size() > 0 && (smsTemplateCollection = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("where isSysPreset = 1")).size() > 0) {
                        SmsTemplateInfo smsTemplateInfo = smsTemplateCollection.get(0);
                        for (Object objTemp : tempArray) {
                            JSONObject tempJSON = (JSONObject)objTemp;
                            if (tempJSON == null || !tempJSON.containsKey((Object)"tempNumber") || !tempJSON.containsKey((Object)"tempName") || !tempJSON.containsKey((Object)"tempContent") || !tempJSON.containsKey((Object)"signNumber") || !tempJSON.containsKey((Object)"operTypeNumber") || !tempJSON.containsKey((Object)"tempDisContent")) continue;
                            String tempNumber = tempJSON.getString("tempNumber");
                            String tempName = tempJSON.getString("tempName");
                            String tempContent = tempJSON.getString("tempContent");
                            String signNumber = tempJSON.getString("signNumber");
                            String operTypeNumber = tempJSON.getString("operTypeNumber");
                            String tempDisContent = tempJSON.getString("tempDisContent");
                            int isHistory = tempJSON.getIntValue("isHistory");
                            MessageApplyOperCollection messageApplyOperCollection = MessageApplyOperFactory.getLocalInstance(ctx).getMessageApplyOperCollection("where operTypeNum = '" + operTypeNumber + "'");
                            SmsSignCollection smsSignCollection = SmsSignFactory.getLocalInstance(ctx).getSmsSignCollection("where clouduuid = '" + signNumber + "'");
                            if (messageApplyOperCollection.size() == 0) {
                                logger.error((Object)("SmsplatformFacadeControllerBean can not matching the messageApplyOper:" + operTypeNumber));
                                throw new SmsException(SmsException.GET_HISTORY_DATA_FAILED, new Object[]{" can not matching the messageApplyOper:" + operTypeNumber});
                            }
                            if (smsSignCollection.size() == 0) {
                                logger.error((Object)("SmsplatformFacadeControllerBean can not matching the smsSign:" + signNumber));
                                throw new SmsException(SmsException.GET_HISTORY_DATA_FAILED, new Object[]{" can not matching the smsSign:" + signNumber});
                            }
                            MessageApplyOperInfo messageApplyOperInfo = messageApplyOperCollection.get(0);
                            String readOnlyParams = messageApplyOperInfo.getReadOnlyParams();
                            String presetParams = messageApplyOperInfo.getPresetParams();
                            JSONObject paramslist = new JSONObject();
                            paramslist.put("readOnlyParams", (Object)readOnlyParams);
                            paramslist.put("presetParams", (Object)presetParams);
                            smsTemplateInfo.setRemark(paramslist.toJSONString());
                            smsTemplateInfo.setId(null);
                            smsTemplateInfo.setDescription(" ");
                            smsTemplateInfo.setDescription(" ", Locale.SIMPLIFIED_CHINESE);
                            smsTemplateInfo.setDescription(" ", Locale.TRADITIONAL_CHINESE);
                            smsTemplateInfo.setDescription(" ", Locale.ENGLISH);
                            smsTemplateInfo.setIsSysPreset(false);
                            smsTemplateInfo.setState(BaseItemStateEnum.NEW);
                            smsTemplateInfo.setName(tempName);
                            smsTemplateInfo.setValidTempName(tempName);
                            smsTemplateInfo.setName(tempName, Locale.SIMPLIFIED_CHINESE);
                            smsTemplateInfo.setName(tempName, Locale.TRADITIONAL_CHINESE);
                            smsTemplateInfo.setName(tempName, Locale.ENGLISH);
                            smsTemplateInfo.setClouduuid(tempNumber);
                            smsTemplateInfo.setNumber(tempNumber);
                            smsTemplateInfo.setTempContent(tempContent);
                            smsTemplateInfo.setTempDisplayContent(tempDisContent);
                            smsTemplateInfo.setApplyOper(messageApplyOperInfo);
                            smsTemplateInfo.setSign(smsSignCollection.get(0));
                            smsTemplateInfo.setCreateTime(new Timestamp(new Date().getTime()));
                            if (tempName.contains("[\u7cfb\u7edf\u521b\u5efa]")) {
                                smsTemplateInfo.setCreatedBySign(true);
                            } else {
                                smsTemplateInfo.setCreatedBySign(false);
                            }
                            IObjectPK iObjectPK = SmsTemplateFactory.getLocalInstance(ctx).addnew(smsTemplateInfo);
                            if (isHistory != 1) continue;
                            SmsTemplateFactory.getLocalInstance(ctx).enable(iObjectPK.toString());
                        }
                    }
                }
                HRInitInfo hRInitInfo = hRInitCollection.get(0);
                hRInitInfo.setValue("true");
                HRInitFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(hRInitInfo.getId()), (CoreBaseInfo)hRInitInfo);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("SmsplatformFacadeControllerBean check history data failed! " + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e1) {
            logger.error((Object)("SmsplatformFacadeControllerBean check history data failed! " + e1.getMessage()), (Throwable)e1);
            throw new SmsException(SmsException.GET_HISTORY_DATA_FAILED, new Object[]{e1.getMessage()});
        }
        catch (Exception e2) {
            logger.error((Object)("SmsplatformFacadeControllerBean check history data failed! " + e2.getMessage()), (Throwable)e2);
            throw new SmsException(SmsException.GET_HISTORY_DATA_FAILED, new Object[]{e2.getMessage()});
        }
    }

    private HashMap<String, String> getHeader(Context ctx) throws EASBizException {
        try {
            ICloudServiceConfig irecConfig = CloudServiceConfigFactory.getLocalInstance((Context)ctx);
            HashMap<String, String> header = new HashMap<String, String>();
            CloudServiceConfigCollection coll = irecConfig.getCloudServiceConfigCollection();
            CloudServiceConfigInfo configInfo = null;
            if (coll.size() <= 0) {
                String label0 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label0", (Context)ctx);
                throw new SmsException(SmsException.CLOUD_ERR_OTHER);
            }
            configInfo = coll.get(0);
            header.put("tenantId", configInfo.getServiceID());
            header.put("token", configInfo.getAccessToken());
            return header;
        }
        catch (BOSException e) {
            String label0 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label0", (Context)ctx);
            logger.error((Object)(label0 + e.getMessage()));
            throw new SmsException(SmsException.CLOUD_ERR_OTHER);
        }
    }

    @Override
    protected void _clearCustomData(Context ctx) throws BOSException, EASBizException {
        SmsSignCollection smsSignCollection;
        SmsTemplateCollection smsTemplateCollection = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("select id where isSysPreset = 0");
        if (smsTemplateCollection.size() > 0) {
            for (int i = 0; i < smsTemplateCollection.size(); ++i) {
                try {
                    HashMap<String, String> params;
                    HashMap<String, String> header;
                    SmsTemplateInfo smsTemplateInfo = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateInfo((IObjectPK)new ObjectUuidPK(smsTemplateCollection.get(i).getId()));
                    if (smsTemplateInfo.getClouduuid() == null || smsTemplateInfo.getClouduuid().isEmpty()) continue;
                    if (smsTemplateInfo.getAuditState().getValue() == 1) {
                        String tempContentUploadUrl = SmsHttpUtils.getServiceUrl(ctx) + "/message/smstemplate/upload_content";
                        header = this.getHeader(ctx);
                        params = new HashMap();
                        params.put("shrContent", smsTemplateInfo.getTempContent());
                        params.put("shrDisplayContent", smsTemplateInfo.getTempDisplayContent());
                        params.put("tempNumber", smsTemplateInfo.getClouduuid());
                        String uploadResp = SmsHttpUtils.post(tempContentUploadUrl, header, params);
                        logger.error((Object)("SmsplatformFacadeControllerBean " + smsTemplateInfo.getClouduuid() + " uploadResp:" + uploadResp));
                        continue;
                    }
                    UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                    header = this.getHeader(ctx);
                    params = new HashMap<String, String>();
                    params.put("tempNumber", smsTemplateInfo.getClouduuid());
                    params.put("modifier", userInfo.getName());
                    String url = SmsHttpUtils.getServiceUrl(ctx) + "/message/smstemplate/del";
                    String delTempResp = SmsHttpUtils.post(url, header, params);
                    logger.error((Object)("SmsplatformFacadeControllerBean " + smsTemplateInfo.getClouduuid() + " delTempResp:" + delTempResp));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        if ((smsSignCollection = SmsSignFactory.getLocalInstance(ctx).getSmsSignCollection("select id where isSysPreset = 0")).size() > 0) {
            int i;
            for (i = 0; i < smsSignCollection.size(); ++i) {
                try {
                    SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo((IObjectPK)new ObjectUuidPK(smsSignCollection.get(i).getId()));
                    if (smsSignInfo.getClouduuid() == null || smsSignInfo.getClouduuid().isEmpty() || smsSignInfo.getAuditState().getValue() == 1) continue;
                    UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                    HashMap<String, String> header = this.getHeader(ctx);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("signNumber", smsSignInfo.getClouduuid());
                    params.put("modifier", userInfo.getName());
                    String url = SmsHttpUtils.getServiceUrl(ctx) + "/message/smssign/del";
                    String delSignresp = SmsHttpUtils.post(url, header, params);
                    JSONObject resultJsonObject = JSONObject.parseObject((String)delSignresp);
                    logger.error((Object)("SmsplatformFacadeControllerBean " + smsSignInfo.getClouduuid() + " delSignresp:" + delSignresp));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            for (i = 0; i < smsTemplateCollection.size(); ++i) {
                SmsTemplateRelHRFactory.getLocalInstance(ctx).delete("where baseInfoId = '" + smsTemplateCollection.get(i).getId().toString() + "'");
            }
        }
        if (smsSignCollection.size() > 0) {
            for (int i = 0; i < smsSignCollection.size(); ++i) {
                SmsSignRelHRFactory.getLocalInstance(ctx).delete("where baseInfoId = '" + smsSignCollection.get(i).getId().toString() + "'");
            }
        }
        String delTemplateSQL = "delete from T_HR_SmsTemplate where FIsSysPreset = 0";
        logger.info((Object)("del smsTemplate sql:" + delTemplateSQL));
        DbUtil.execute((Context)ctx, (String)delTemplateSQL);
        String delSignSQL = "delete from T_HR_SmsSign where FIsSysPreset = 0";
        logger.info((Object)("del smsSign sql:" + delSignSQL));
        DbUtil.execute((Context)ctx, (String)delSignSQL);
        HRInitCollection hRInitCollection = HRInitFactory.getLocalInstance((Context)ctx).getHRInitCollection("where key = 'load_smsplatform' and value = 'true' ");
        if (hRInitCollection.size() == 1) {
            HRInitInfo hRInitInfo = hRInitCollection.get(0);
            hRInitInfo.setValue("false");
            HRInitFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(hRInitInfo.getId()), (CoreBaseInfo)hRInitInfo);
        }
    }

    @Override
    protected String _createAuditBill(Context ctx, String smsTemplateId) throws BOSException, EASBizException {
        String[] smsTemplateIds = smsTemplateId.split(",");
        if (smsTemplateIds.length > 0) {
            logger.error((Object)("_createAuditBill.size:" + smsTemplateIds.length));
            ArrayList<String> existAuditBillList = new ArrayList<String>();
            ArrayList<String> existCloudAuditList = new ArrayList<String>();
            for (String tempId : smsTemplateIds) {
                SmsTemplateInfo smsTemplateInfo = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateInfo((IObjectPK)new ObjectUuidPK(tempId));
                SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getSign().getId()));
                logger.error((Object)("_createAuditBill:" + smsTemplateInfo.getName() + "  " + smsSignInfo.getName()));
                if (smsSignInfo.getState().getValue() != 1) {
                    throw new SmsException(SmsException.SIGN_NOT_ENABLE);
                }
                if (smsTemplateInfo.getWorkFlowAuditState().getValue() == 1 || smsTemplateInfo.getWorkFlowAuditState().getValue() == 2) {
                    existAuditBillList.add(smsTemplateInfo.getSmsAuditNumber());
                }
                if (smsTemplateInfo.getAuditState().getValue() != 3) continue;
                existCloudAuditList.add(smsTemplateInfo.getName());
            }
            if (existAuditBillList.size() > 0) {
                throw new SmsException(SmsException.EXIST_AUDITING_BILL, new Object[]{existAuditBillList.toString()});
            }
            if (existCloudAuditList.size() > 0) {
                throw new SmsException(SmsException.EXIST_CLOUD_AUDITING, new Object[]{existCloudAuditList.toString()});
            }
            SMSAuditInfo sMSAuditInfo = new SMSAuditInfo();
            SMSAuditEntryCollection sMSAuditEntryCollection = new SMSAuditEntryCollection();
            for (String tempId : smsTemplateIds) {
                SmsTemplateInfo smsTemplateInfo = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateInfo((IObjectPK)new ObjectUuidPK(tempId));
                SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getSign().getId()));
                MessageApplyOperInfo messageApplyOperInfo = MessageApplyOperFactory.getLocalInstance(ctx).getMessageApplyOperInfo((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getApplyOper().getId()));
                SMSAuditEntryInfo sMSAuditInfoEntry = new SMSAuditEntryInfo();
                sMSAuditInfoEntry.setSmsTemplate(smsTemplateInfo);
                sMSAuditInfoEntry.setTempName(smsTemplateInfo.getName(Locale.SIMPLIFIED_CHINESE));
                sMSAuditInfoEntry.setThenSignName(smsSignInfo.getName(Locale.SIMPLIFIED_CHINESE));
                sMSAuditInfoEntry.setThenTempContent(smsTemplateInfo.getTempDisplayContent());
                sMSAuditInfoEntry.setOperTypeName(messageApplyOperInfo.getOperTypeName());
                sMSAuditInfoEntry.setModuleTypeName(messageApplyOperInfo.getModuleTypeName());
                sMSAuditInfo.setApplyDate(new Date());
                sMSAuditEntryCollection.add(sMSAuditInfoEntry);
            }
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (userInfo.getPerson() == null || userInfo.getPerson().getId() == null) {
                throw new SmsException(SmsException.OTHERS, new Object[]{"\u5f53\u524d\u767b\u5f55\u7528\u6237\u65e0\u5bf9\u5e94\u5173\u8054\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u521b\u5efa\u77ed\u4fe1\u5ba1\u6279\u5355\u636e\uff01"});
            }
            PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(userInfo.getPerson().getId()));
            sMSAuditInfo.setHrOrgUnit(personInfo.getHrOrgUnit());
            String number = "SMS_" + System.currentTimeMillis();
            sMSAuditInfo.put("entrys", (Object)sMSAuditEntryCollection);
            sMSAuditInfo.setNumber(number);
            sMSAuditInfo.setCreateTime(new Timestamp(new Date().getTime()));
            IObjectPK iObjectPK = SMSAuditFactory.getLocalInstance(ctx).save((CoreBaseInfo)sMSAuditInfo);
            if (iObjectPK != null) {
                SMSAuditFactory.getLocalInstance(ctx).setSaved(sMSAuditInfo.getId());
                for (String tempId : smsTemplateIds) {
                    SmsTemplateInfo smsTemplateInfo = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateInfo((IObjectPK)new ObjectUuidPK(tempId));
                    smsTemplateInfo.setSmsAuditNumber(sMSAuditInfo.getNumber());
                    smsTemplateInfo.setWorkFlowAuditState(SMSAuditStateEnum.SAVED);
                    SmsTemplateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getId()), smsTemplateInfo);
                }
            }
            return iObjectPK.toString();
        }
        return null;
    }

    @Override
    protected void _refreshCloudStatus(Context ctx) throws BOSException, EASBizException {
        SmsTemplateInfo smsTemplateInfo;
        int i;
        logger.info((Object)"\u81ea\u52a8\u63d0\u4ea4\u5ba1\u6279\u901a\u8fc7\u4f46\u672a\u81ea\u52a8\u9001\u5ba1\u6216\u5ba1\u6838\u5931\u8d25\u7684\u77ed\u4fe1\u6a21\u677f\uff01");
        SmsTemplateCollection smsTemplateCollection = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("where auditState in (2,4) and workFlowAuditState = 3");
        if (smsTemplateCollection.size() > 0) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            for (i = 0; i < smsTemplateCollection.size(); ++i) {
                try {
                    smsTemplateInfo = smsTemplateCollection.get(i);
                    MessageApplyOperInfo messageApplyOperInfo = MessageApplyOperFactory.getLocalInstance(ctx).getMessageApplyOperInfo((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getApplyOper().getId()));
                    SmsSignInfo smsSignInfo = SmsSignFactory.getLocalInstance(ctx).getSmsSignInfo((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getSign().getId()));
                    if (smsTemplateInfo.getClouduuid() == null || smsTemplateInfo.getClouduuid().isEmpty()) {
                        SMSAuditEntryInfo sMSAuditEntryInfo;
                        SMSAuditEntryCollection sMSAuditEntryCollection;
                        String auditBillNumber;
                        JSONObject data;
                        String version = "";
                        try {
                            IRowSet rowset = null;
                            StringBuilder sql = new StringBuilder();
                            sql.append(" select FMajor,FMinor,FBuild,FBim from T_SYS_DatacenterSHR where FType = 'SHR' ");
                            rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                            while (rowset.next()) {
                                version = rowset.getString("FMajor") + rowset.getString("FMinor") + rowset.getString("FBuild") + rowset.getString("FBim");
                            }
                        }
                        catch (BOSException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        catch (SQLException e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                        }
                        HashMap<String, String> header = this.getHeader(ctx);
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("name", smsTemplateInfo.getName(Locale.SIMPLIFIED_CHINESE));
                        params.put("content", smsTemplateInfo.getTempContent());
                        params.put("signNumber", smsSignInfo.getClouduuid());
                        params.put("operTypeNumber", messageApplyOperInfo.getOperTypeNum());
                        params.put("versionShr", version);
                        params.put("creator", userInfo.getName());
                        String url = SmsHttpUtils.getServiceUrl(ctx) + "/message/smstemplate/create";
                        String resp = SmsHttpUtils.post(url, header, params);
                        JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
                        if (resultJsonObject.containsKey((Object)"code") && resultJsonObject.getString("code").equals("400")) {
                            logger.error((Object)"\u65e0\u6cd5\u8fde\u63a5\u81f3\u4e91\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u914d\u7f6e");
                        }
                        if ((data = JSONObject.parseObject((String)resultJsonObject.getString("data"))).containsKey((Object)"errorcode") && data.getIntValue("errorcode") != 0) {
                            logger.error((Object)(smsTemplateInfo.getName() + "\u77ed\u4fe1\u6a21\u677f\u521b\u5efa\u9001\u5ba1\u5931\u8d25" + data.getString("errormsg")));
                            smsTemplateInfo.setAuditResultDesc(data.getString("errormsg"));
                            smsTemplateInfo.setAuditState(auditStateEnum.reject);
                            SmsTemplateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getId()), smsTemplateInfo);
                            if (smsTemplateInfo.getState().getValue() == 1) {
                                SmsTemplateFactory.getLocalInstance(ctx).disable(smsTemplateInfo.getId().toString());
                            }
                            if ((auditBillNumber = smsTemplateInfo.getSmsAuditNumber()) == null || auditBillNumber.isEmpty() || (sMSAuditEntryCollection = SMSAuditEntryFactory.getLocalInstance(ctx).getSMSAuditEntryCollection("where  bill.number ='" + auditBillNumber + "' and smsTemplate.id = '" + smsTemplateInfo.getId().toString() + "'")).size() <= 0) continue;
                            sMSAuditEntryInfo = sMSAuditEntryCollection.get(0);
                            sMSAuditEntryInfo.setAuditState(smsTemplateInfo.getAuditState());
                            sMSAuditEntryInfo.setAuditResultDesc(smsTemplateInfo.getAuditResultDesc());
                            SMSAuditEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sMSAuditEntryInfo.getId()), (CoreBaseInfo)sMSAuditEntryInfo);
                            continue;
                        }
                        if (!data.containsKey((Object)"errorcode") || data.getIntValue("errorcode") != 0) continue;
                        logger.error((Object)(smsTemplateInfo.getName() + "create succeeed in cloud service." + resultJsonObject.getString("errormsg")));
                        smsTemplateInfo.setAuditState(auditStateEnum.submitted);
                        smsTemplateInfo.setAuditResultDesc("");
                        smsTemplateInfo.setClouduuid(data.getString("data"));
                        SmsTemplateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getId()), smsTemplateInfo);
                        auditBillNumber = smsTemplateInfo.getSmsAuditNumber();
                        if (auditBillNumber == null || auditBillNumber.isEmpty() || (sMSAuditEntryCollection = SMSAuditEntryFactory.getLocalInstance(ctx).getSMSAuditEntryCollection("where  bill.number ='" + auditBillNumber + "' and smsTemplate.id = '" + smsTemplateInfo.getId().toString() + "'")).size() <= 0) continue;
                        sMSAuditEntryInfo = sMSAuditEntryCollection.get(0);
                        sMSAuditEntryInfo.setAuditState(smsTemplateInfo.getAuditState());
                        sMSAuditEntryInfo.setAuditResultDesc(smsTemplateInfo.getAuditResultDesc());
                        SMSAuditEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sMSAuditEntryInfo.getId()), (CoreBaseInfo)sMSAuditEntryInfo);
                        continue;
                    }
                    if (smsTemplateInfo.getAuditState().getValue() == 4 || smsTemplateInfo.getAuditState().getValue() == 2) {
                        SMSAuditEntryInfo sMSAuditEntryInfo;
                        SMSAuditEntryCollection sMSAuditEntryCollection;
                        String auditBillNumber;
                        JSONObject data;
                        HashMap<String, String> header = this.getHeader(ctx);
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("name", smsTemplateInfo.getName(Locale.SIMPLIFIED_CHINESE));
                        params.put("content", smsTemplateInfo.getTempContent());
                        params.put("signNumber", smsSignInfo.getClouduuid());
                        params.put("operTypeNumber", messageApplyOperInfo.getOperTypeNum());
                        params.put("tempNumber", smsTemplateInfo.getClouduuid());
                        params.put("modifier", userInfo.getName());
                        String url = SmsHttpUtils.getServiceUrl(ctx) + "/message/smstemplate/upd";
                        String resp = SmsHttpUtils.post(url, header, params);
                        JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
                        if (resultJsonObject.containsKey((Object)"code") && resultJsonObject.getString("code").equals("400")) {
                            logger.error((Object)"\u65e0\u6cd5\u8fde\u63a5\u81f3\u4e91\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u914d\u7f6e");
                        }
                        if ((data = JSONObject.parseObject((String)resultJsonObject.getString("data"))).containsKey((Object)"errorcode") && data.getIntValue("errorcode") != 0) {
                            logger.error((Object)(smsTemplateInfo.getName() + data.getString("errormsg")));
                            smsTemplateInfo.setAuditState(auditStateEnum.reject);
                            smsTemplateInfo.setAuditResultDesc(data.getString("errormsg"));
                            smsTemplateInfo.setValidTempName("");
                            SmsTemplateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getId()), smsTemplateInfo);
                            if (smsTemplateInfo.getState().getValue() == 1) {
                                SmsTemplateFactory.getLocalInstance(ctx).disable(smsTemplateInfo.getId().toString());
                            }
                            if ((auditBillNumber = smsTemplateInfo.getSmsAuditNumber()) != null && !auditBillNumber.isEmpty() && (sMSAuditEntryCollection = SMSAuditEntryFactory.getLocalInstance(ctx).getSMSAuditEntryCollection("where  bill.number ='" + auditBillNumber + "' and smsTemplate.id = '" + smsTemplateInfo.getId().toString() + "'")).size() > 0) {
                                sMSAuditEntryInfo = sMSAuditEntryCollection.get(0);
                                sMSAuditEntryInfo.setAuditState(smsTemplateInfo.getAuditState());
                                sMSAuditEntryInfo.setAuditResultDesc(smsTemplateInfo.getAuditResultDesc());
                                SMSAuditEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sMSAuditEntryInfo.getId()), (CoreBaseInfo)sMSAuditEntryInfo);
                            }
                            logger.error((Object)data.getString("errormsg"));
                            continue;
                        }
                        if (!data.containsKey((Object)"errorcode") || data.getIntValue("errorcode") != 0) continue;
                        logger.error((Object)(smsTemplateInfo.getName() + "create succeeed in cloud service." + resultJsonObject.getString("errormsg")));
                        smsTemplateInfo.setAuditState(auditStateEnum.submitted);
                        smsTemplateInfo.setAuditResultDesc("");
                        SmsTemplateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getId()), smsTemplateInfo);
                        auditBillNumber = smsTemplateInfo.getSmsAuditNumber();
                        if (auditBillNumber == null || auditBillNumber.isEmpty() || (sMSAuditEntryCollection = SMSAuditEntryFactory.getLocalInstance(ctx).getSMSAuditEntryCollection("where  bill.number ='" + auditBillNumber + "' and smsTemplate.id = '" + smsTemplateInfo.getId().toString() + "'")).size() <= 0) continue;
                        sMSAuditEntryInfo = sMSAuditEntryCollection.get(0);
                        sMSAuditEntryInfo.setAuditState(smsTemplateInfo.getAuditState());
                        sMSAuditEntryInfo.setAuditResultDesc(smsTemplateInfo.getAuditResultDesc());
                        SMSAuditEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sMSAuditEntryInfo.getId()), (CoreBaseInfo)sMSAuditEntryInfo);
                        continue;
                    }
                    if (smsTemplateInfo.getAuditState().getValue() != 3) continue;
                    logger.error((Object)"\u5f53\u524d\u6a21\u677f\u6b63\u5728\u5ba1\u6838\u4e2d\uff0c\u9700\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c\u51fa\u6765\u540e\u518d\u91cd\u65b0\u9001\u5ba1");
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (EASBizException e1) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e1.getMessage()), (Throwable)e1);
                    continue;
                }
                catch (Exception e2) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        logger.info((Object)"\u518d\u5237\u65b0\u4e91\u5e73\u53f0\u5ba1\u6838\u4e2d\u7684\u6a21\u677f\u7684\u5ba1\u6838\u7ed3\u679c\uff01");
        SmsTemplateCollection smsTemplateCollection1 = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("where auditState = 3");
        if (smsTemplateCollection1.size() > 0) {
            for (i = 0; i < smsTemplateCollection1.size(); ++i) {
                try {
                    SMSAuditEntryCollection sMSAuditEntryCollection;
                    JSONObject data;
                    smsTemplateInfo = smsTemplateCollection1.get(i);
                    HashMap<String, String> header = this.getHeader(ctx);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("tempNumber", smsTemplateInfo.getClouduuid());
                    String url = SmsHttpUtils.getServiceUrl(ctx) + "/message/smstemplate/query";
                    String resp = SmsHttpUtils.post(url, header, params);
                    JSONObject resultJsonObject = JSONObject.parseObject((String)resp);
                    if (resultJsonObject.containsKey((Object)"code") && resultJsonObject.getString("code").equals("400")) {
                        logger.error((Object)"\u65e0\u6cd5\u8fde\u63a5\u81f3\u4e91\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u914d\u7f6e");
                    }
                    if ((data = JSONObject.parseObject((String)resultJsonObject.getString("data"))).containsKey((Object)"errorcode") && data.getIntValue("errorcode") != 0) {
                        logger.error((Object)data.getString("errormsg"));
                        continue;
                    }
                    if (!data.containsKey((Object)"errorcode") || data.getIntValue("errorcode") != 0) continue;
                    logger.info((Object)(smsTemplateInfo.getName() + "query succeeed in cloud service." + resultJsonObject.getString("errormsg")));
                    JSONObject auditRes = data.getJSONObject("data");
                    if (auditRes.getIntValue("state") == 1) {
                        smsTemplateInfo.setAuditResultDesc("");
                        smsTemplateInfo.setAuditState(auditStateEnum.submitted);
                    } else if (auditRes.getIntValue("state") == 2) {
                        smsTemplateInfo.setAuditResultDesc("");
                        smsTemplateInfo.setAuditState(auditStateEnum.approved);
                        smsTemplateInfo.setValidTempName(smsTemplateInfo.getName(Locale.SIMPLIFIED_CHINESE));
                    } else if (auditRes.getIntValue("state") == 3) {
                        smsTemplateInfo.setAuditResultDesc(auditRes.getString("approve_desc"));
                        smsTemplateInfo.setAuditState(auditStateEnum.reject);
                        smsTemplateInfo.setValidTempName("");
                        if (smsTemplateInfo.getState().getValue() == 1) {
                            SmsTemplateFactory.getLocalInstance(ctx).disable(smsTemplateInfo.getId().toString());
                        }
                    } else {
                        logger.error((Object)"\u8fd4\u56de\u503c\u8d85\u51fa\u8303\u56f4\uff01\u65e0\u6cd5\u89e3\u6790\uff01");
                    }
                    SmsTemplateFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(smsTemplateInfo.getId()), smsTemplateInfo);
                    String auditBillNumber = smsTemplateInfo.getSmsAuditNumber();
                    if (auditBillNumber == null || auditBillNumber.isEmpty() || (sMSAuditEntryCollection = SMSAuditEntryFactory.getLocalInstance(ctx).getSMSAuditEntryCollection("where  bill.number ='" + auditBillNumber + "' and smsTemplate.id = '" + smsTemplateInfo.getId().toString() + "'")).size() <= 0) continue;
                    SMSAuditEntryInfo sMSAuditEntryInfo = sMSAuditEntryCollection.get(0);
                    sMSAuditEntryInfo.setAuditState(smsTemplateInfo.getAuditState());
                    sMSAuditEntryInfo.setAuditResultDesc(smsTemplateInfo.getAuditResultDesc());
                    SMSAuditEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(sMSAuditEntryInfo.getId()), (CoreBaseInfo)sMSAuditEntryInfo);
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (EASBizException e1) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e1.getMessage()), (Throwable)e1);
                    continue;
                }
                catch (Exception e2) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e2.getMessage()), (Throwable)e2);
                }
            }
        }
        if (smsTemplateCollection1.size() > 0) {
            for (i = 0; i < smsTemplateCollection1.size(); ++i) {
                try {
                    smsTemplateInfo = smsTemplateCollection1.get(i);
                    if (!smsTemplateInfo.isCreatedBySign() || smsTemplateInfo.getAuditState().getValue() != 1) continue;
                    HROrgUnitCollection coll = null;
                    if (UsePolicy.GLOBALLY_SHARED.equals((Object)smsTemplateInfo.getUsePolicy())) {
                        coll = SysSettingHrOrgUnitUtil.queryHROrgUnitCollection((Context)ctx, (UsePolicy)smsTemplateInfo.getUsePolicy(), null);
                    } else if (UsePolicy.DOWN_SHARED.equals((Object)smsTemplateInfo.getUsePolicy())) {
                        HashSet<String> hrOrgUnitIds = new HashSet<String>();
                        hrOrgUnitIds.add(smsTemplateInfo.getHrOrgUnit().getId().toString());
                        SysSettingHrOrgUnitUtil.getHrOrgUnitSets((Context)ctx, (String)smsTemplateInfo.getHrOrgUnit().getId().toString(), hrOrgUnitIds, (boolean)Boolean.TRUE);
                        coll = SysSettingHrOrgUnitUtil.queryHROrgUnitCollection((Context)ctx, (UsePolicy)smsTemplateInfo.getUsePolicy(), hrOrgUnitIds);
                    } else if (UsePolicy.DISTRIBUTION_SHARED.equals((Object)smsTemplateInfo.getUsePolicy())) {
                        coll = new HROrgUnitCollection();
                        coll.add(SysSettingHrOrgUnitUtil.getHrOrgUnitInfo((Context)ctx, (String)smsTemplateInfo.getHrOrgUnit().getId().toString()));
                    }
                    logger.info((Object)("HROrgUnitCollection.size:" + coll.size()));
                    if (coll.size() > 0) {
                        SmsTemplateCollection smsTemplateCollection2 = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("select id,name where applyOper = '" + smsTemplateInfo.getApplyOper().getId().toString() + "' and state = 1 and isSysPreset = 0");
                        logger.info((Object)("smsTemplateCollection.size:" + smsTemplateCollection2.size()));
                        logger.info((Object)("smsTemplateCollection:" + smsTemplateCollection2.toString()));
                        if (smsTemplateCollection2.size() > 0) {
                            for (int k = 0; k < smsTemplateCollection2.size(); ++k) {
                                SmsTemplateInfo smsTemplateInfo1 = smsTemplateCollection2.get(k);
                                for (int l = 0; l < coll.size(); ++l) {
                                    SmsTemplateRelHRCollection smsTemplateRelHRCollection1 = SmsTemplateRelHRFactory.getLocalInstance(ctx).getSmsTemplateRelHRCollection("select id where state = 100 and baseInfoId = '" + smsTemplateInfo1.getId().toString() + "' and hrOrgUse = '" + coll.get(l).getId().toString() + "'");
                                    if (smsTemplateRelHRCollection1.size() <= 0) continue;
                                    logger.info((Object)("smsTemplateRelHRCollection1.size:" + smsTemplateRelHRCollection1.size()));
                                    SmsTemplateFactory.getLocalInstance(ctx).disable(smsTemplateInfo1.getId().toString());
                                }
                            }
                        }
                    }
                    SmsTemplateFactory.getLocalInstance(ctx).enable(smsTemplateInfo.getId().toString());
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (EASBizException e1) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e1.getMessage()), (Throwable)e1);
                    continue;
                }
                catch (Exception e2) {
                    logger.error((Object)("SmsplatformFacadeControllerBean _refreshCloudStatus failed!  " + e2.getMessage()), (Throwable)e2);
                }
            }
        }
    }
}

