/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.enums;

import com.kingdee.bos.BOSException;

public enum SMSSourceTypeEnum {
    QUERY(0, "com.kingdee.shr.smsplatform.service.SMSQuerySourceStrategy"),
    CUSTOM(1, "com.kingdee.shr.smsplatform.service.SMSCustomSourceStrategy"),
    CLOUD(3, "com.kingdee.shr.smsplatform.service.SMSCloudSourceStrategy"),
    QCPC(4, "com.kingdee.shr.smsplatform.service.SMSQCPCSourceStrategy"),
    QCLO(5, "com.kingdee.shr.smsplatform.service.SMSQCLOSourceStrategy"),
    QPCLO(6, "com.kingdee.shr.smsplatform.service.SMSQPCLOSourceStrategy"),
    QUERYNP(7, "com.kingdee.shr.smsplatform.service.SMSQueryNPSourceStrategy");

    private final int operType;
    private final String packagePath;

    private SMSSourceTypeEnum(int value, String packagePath) {
        this.operType = value;
        this.packagePath = packagePath;
    }

    public int operType() {
        return this.operType;
    }

    public String packagePath() {
        return this.packagePath;
    }

    public static SMSSourceTypeEnum getPlatformEnum(int type) throws BOSException {
        for (SMSSourceTypeEnum platformEnum : SMSSourceTypeEnum.values()) {
            if (platformEnum.operType != type) continue;
            return platformEnum;
        }
        throw new BOSException("sms source type not match!");
    }
}

