/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.socialSecurity.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.filter.CmpSchemeFilter;
import com.kingdee.shr.socialSecurity.SocDataPermCollection;
import com.kingdee.shr.socialSecurity.SocDataPermFactory;
import com.kingdee.shr.socialSecurity.SocDataPermInfo;
import java.util.HashMap;

public class SocPermFilter {
    public static String getSocPermSQL(Context ctx, String permItemId, boolean historyMode) {
        StringBuilder sb = new StringBuilder();
        FilterInfo filterInfo = SocPermFilter.getSocPermFilter(ctx, permItemId);
        if (CmpStrUtil.isEmpty((String)filterInfo.toString())) {
            return sb.toString();
        }
        SqlParam sqlParam = new SqlParam();
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        selectMapping.put("person.id", "personId");
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme("008");
        sqlParam.setNewSearch(true);
        sqlParam.setHistoryMode(historyMode);
        try {
            sb.append("select * from(");
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            sb.append(sql);
            sb.append(") as personTemp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getSocPermForImportSQL(Context ctx, String permItemId, boolean historyMode) {
        StringBuilder sb = new StringBuilder();
        String hrOrgField = "soc_hrOrg.id";
        FilterInfo filterInfo = SocPermFilter.getSocPermFilter(ctx, permItemId);
        if (CmpStrUtil.isEmpty((String)filterInfo.toString())) {
            String hrOrgUnitRangeSQL = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
            String filterStr = hrOrgField + " in (" + hrOrgUnitRangeSQL + ")";
            try {
                filterInfo = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        SqlParam sqlParam = new SqlParam();
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        selectMapping.put("person.id", "personId");
        selectMapping.put("soc_hrOrg.id", "hrOrgUnitId");
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filterInfo);
        sqlParam.setScheme("008");
        sqlParam.setNewSearch(true);
        sqlParam.setHistoryMode(historyMode);
        try {
            sb.append("select * from(");
            String sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
            sb.append(sql);
            sb.append(") as personTemp");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String getSocPermFilterByHRO(Context ctx, String permItemId, String hrOrgIdField, String personIdField, boolean historyMode) {
        String sql = null;
        String scheme = "008";
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty((String)personid)) {
            return null;
        }
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and hrOrgUnit.id in (" + hrRange + ")";
        SocDataPermCollection socPermCollection = null;
        try {
            socPermCollection = SocDataPermFactory.getLocalInstance(ctx).getSocDataPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder hrOrgSb = new StringBuilder();
        if (socPermCollection.size() > 0) {
            String filterStr = null;
            String hrOrgId = null;
            String hrOrgField = "soc_hrOrg.id";
            SocDataPermInfo socPermInfo = null;
            FilterInfo filterInfo = null;
            HROrgUnitInfo hrOrgUnitInfo = null;
            SqlParam sqlParam = new SqlParam();
            HashMap<String, String> selectMapping = new HashMap<String, String>();
            selectMapping.put("person.id", "person.id");
            sb.append("(");
            int size = socPermCollection.size();
            for (int i = 0; i < size; ++i) {
                socPermInfo = socPermCollection.get(i);
                filterStr = socPermInfo.getFilter();
                if (CmpStrUtil.isEmpty((String)filterStr)) {
                    return sql;
                }
                hrOrgUnitInfo = socPermInfo.getHrOrgUnit();
                hrOrgId = hrOrgUnitInfo.getId().toString();
                try {
                    filterStr = filterStr + " and " + hrOrgField + "='" + hrOrgId + "'";
                    filterInfo = new FilterInfo(filterStr);
                    hrOrgSb.append("'" + hrOrgId + "', ");
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
                sqlParam.setSelectMapping(selectMapping);
                sqlParam.setFilterInfo(filterInfo);
                sqlParam.setScheme(scheme);
                sqlParam.setNewSearch(true);
                sqlParam.setHistoryMode(historyMode);
                try {
                    sql = FilterUtil.getSql((Context)ctx, (SqlParam)sqlParam);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (i != 0) {
                    sb.append(" or  ");
                }
                sb.append("(" + personIdField + " in (" + sql + ") and " + hrOrgIdField + "='" + hrOrgId + "')");
                if (i != size - 1) continue;
                String hrOrgStr = hrOrgSb.substring(0, hrOrgSb.lastIndexOf(","));
                sb.append(" or  ");
                sb.append(hrOrgIdField + " not in (" + hrOrgStr + ")");
            }
        }
        if (sb.length() > 0) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static FilterInfo getSocPermFilterByHRO(Context ctx, String hrOrgId, boolean historyMode) {
        FilterInfo filter = new FilterInfo();
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty((String)personid)) {
            return filter;
        }
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and hrOrgUnit.id ='" + hrOrgId + "'";
        SocDataPermCollection socPermCollection = null;
        try {
            socPermCollection = SocDataPermFactory.getLocalInstance(ctx).getSocDataPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null != socPermCollection && socPermCollection.size() > 0) {
            SocDataPermInfo socPermInfo = socPermCollection.get(0);
            String filterStr = socPermInfo.getFilter();
            if (CmpStrUtil.isEmpty((String)filterStr)) {
                return filter;
            }
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        return filter;
    }

    public static FilterInfo getSocPermFilter(Context ctx, String permItemId) {
        FilterInfo filter = new FilterInfo();
        String personid = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (CmpStrUtil.isEmpty((String)personid)) {
            return filter;
        }
        String hrRange = CmpSchemeFilter.getHrOrgUnitRangeSQL((Context)ctx, (String)permItemId);
        String oql = "select hrOrgUnit.id,filter where person.id = '" + personid + "' and hrOrgUnit.id in (" + hrRange + ")";
        SocDataPermCollection socPermCollection = null;
        try {
            socPermCollection = SocDataPermFactory.getLocalInstance(ctx).getSocDataPermCollection(oql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (null != socPermCollection && socPermCollection.size() > 0) {
            StringBuilder hrOrgSB = new StringBuilder();
            String filterStr = null;
            String hrOrgId = null;
            String hrOrgField = "soc_hrOrg.id";
            SocDataPermInfo socPermInfo = null;
            FilterInfo filterInfo = null;
            int size = socPermCollection.size();
            for (int i = 0; i < size; ++i) {
                socPermInfo = socPermCollection.get(i);
                filterStr = socPermInfo.getFilter();
                if (CmpStrUtil.isEmpty((String)filterStr)) continue;
                hrOrgId = socPermInfo.getHrOrgUnit().getId().toString();
                try {
                    filterStr = filterStr + " and " + hrOrgField + "='" + hrOrgId + "'";
                    filterInfo = new FilterInfo(filterStr);
                    filter.mergeFilter(filterInfo, "OR");
                    hrOrgSB.append(" '" + hrOrgId + "', ");
                    continue;
                }
                catch (ParserException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (hrOrgSB.length() > 0) {
                String hrOrgStr = hrOrgSB.substring(0, hrOrgSB.lastIndexOf(","));
                try {
                    FilterInfo otherFilter = new FilterInfo(hrOrgField + " not in (" + hrOrgStr + ")");
                    filter.mergeFilter(otherFilter, "OR");
                }
                catch (ParserException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return filter;
    }

    public static String getSocPermQueryFilter(Context ctx, String personId, String hrOrgId) {
        String queryFilter = "";
        String permOql = "select * where person.id = '" + personId + "' and hrOrgUnit.id='" + hrOrgId + "'";
        try {
            SocDataPermCollection socPermCollection = SocDataPermFactory.getLocalInstance(ctx).getSocDataPermCollection(permOql);
            if (socPermCollection != null && socPermCollection.size() > 0) {
                SocDataPermInfo socPermInfo = socPermCollection.get(0);
                queryFilter = socPermInfo.getQueryfilter();
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return queryFilter;
    }
}

