/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.sscaffair.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.EmpAuditBizBillEntryFactory;
import com.kingdee.eas.hr.emp.EmpAuditBizBillEntryInfo;
import com.kingdee.eas.hr.emp.IEmpAuditBizBillEntry;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.ActivityJobInfoCollection;
import com.kingdee.shr.shareservice.ActivityJobInfoFactory;
import com.kingdee.shr.shareservice.ActivityJobInfoInfo;
import com.kingdee.shr.shareservice.ActivitySolutionFactory;
import com.kingdee.shr.shareservice.ActivitySolutionInfo;
import com.kingdee.shr.shareservice.EmpAuBillEnStateCollection;
import com.kingdee.shr.shareservice.EmpAuBillEnStateFactory;
import com.kingdee.shr.shareservice.EmpAuBillEnStateInfo;
import com.kingdee.shr.shareservice.IActivityJobInfo;
import com.kingdee.shr.shareservice.IEmpAuBillEnState;
import com.kingdee.shr.shareservice.SolutionActivityInfoCollection;
import com.kingdee.shr.shareservice.SolutionActivityInfoFactory;
import com.kingdee.shr.shareservice.WorkflowProceedFacadeFactory;
import com.kingdee.shr.shareservice.app.EmpAuBillEnStateEnum;
import com.kingdee.shr.shareservice.app.JobState;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.shr.shareservice.util.XMLDocUtil;
import com.kingdee.shr.sscaffair.app.AbstractSSCEmpAuditBillOptFacadeControllerBean;
import com.kingdee.util.UuidException;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSCEmpAuditBillOptFacadeControllerBean
extends AbstractSSCEmpAuditBillOptFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(SSCEmpAuditBillOptFacadeControllerBean.class);

    @Override
    public void _doSaveOrAudit(Context ctx, HttpServletRequest request, boolean isAudit) throws BOSException {
        String paramJson = request.getParameter("paramJson");
        JSONObject json = JSONObject.parseObject((String)paramJson);
        JSONArray paramArray = json.getJSONArray("paramArray");
        String jobId = json.getString("jobId");
        try {
            IEmpAuditBizBillEntry iEmpAuditBizBillEntry = EmpAuditBizBillEntryFactory.getLocalInstance((Context)ctx);
            IEmpAuBillEnState iEmpAuBillEnState = EmpAuBillEnStateFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < paramArray.size(); ++i) {
                JSONObject param = paramArray.getJSONObject(i);
                EmpAuditBizBillEntryInfo empAuditBizBillEntryInfo = new EmpAuditBizBillEntryInfo();
                empAuditBizBillEntryInfo.setId(BOSUuid.read((String)param.getString("id")));
                EntityViewInfo stateEntityView = new EntityViewInfo();
                FilterInfo stateFilter = new FilterInfo();
                stateFilter.getFilterItems().add(new FilterItemInfo("empAuditBillentryId", (Object)BOSUuid.read((String)param.getString("id"))));
                stateFilter.getFilterItems().add(new FilterItemInfo("jobId", (Object)jobId));
                stateEntityView.setFilter(stateFilter);
                EmpAuBillEnStateCollection empAuBillEnStateCollection = iEmpAuBillEnState.getEmpAuBillEnStateCollection(stateEntityView);
                if (empAuBillEnStateCollection.size() == 0) {
                    throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label0", (Context)ctx));
                }
                SelectorItemCollection sic = new SelectorItemCollection();
                EmpAuBillEnStateInfo empAuBillEnStateInfo = empAuBillEnStateCollection.get(0);
                if (isAudit) {
                    if ("0".equals(param.getString("pass")) && "1".equals(param.getString("unpass"))) {
                        empAuditBizBillEntryInfo.setApproveStatus(1);
                        empAuBillEnStateInfo.setTempState(EmpAuBillEnStateEnum.UNPASS);
                    } else if ("1".equals(param.getString("pass")) && "0".equals(param.getString("unpass"))) {
                        empAuditBizBillEntryInfo.setApproveStatus(0);
                        empAuBillEnStateInfo.setTempState(EmpAuBillEnStateEnum.PASS);
                    } else {
                        throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label1", (Context)ctx));
                    }
                    sic.add(new SelectorItemInfo("approveStatus"));
                } else if ("0".equals(param.getString("pass")) && "1".equals(param.getString("unpass"))) {
                    empAuditBizBillEntryInfo.setApproveStatus(1);
                    empAuBillEnStateInfo.setTempState(EmpAuBillEnStateEnum.UNPASS);
                    sic.add(new SelectorItemInfo("approveStatus"));
                } else if ("1".equals(param.getString("pass")) && "0".equals(param.getString("unpass"))) {
                    empAuditBizBillEntryInfo.setApproveStatus(0);
                    empAuBillEnStateInfo.setTempState(EmpAuBillEnStateEnum.PASS);
                    sic.add(new SelectorItemInfo("approveStatus"));
                } else if ("0".equals(param.getString("pass")) && "0".equals(param.getString("unpass"))) {
                    empAuBillEnStateInfo.setTempState(EmpAuBillEnStateEnum.NO_SAVE);
                } else {
                    throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label1", (Context)ctx));
                }
                JSONObject approveReasonObj = param.getJSONObject("employeeAuditReason");
                String approveReason = approveReasonObj.getString("l2");
                logger.error("employeeAuditReason l2 " + approveReason);
                if (SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label2", (Context)ctx).equals(approveReason)) {
                    approveReason = "";
                    logger.error("employeeAuditReason ======== " + approveReason);
                }
                empAuBillEnStateInfo.setTempReason(approveReason);
                iEmpAuBillEnState.update((IObjectPK)new ObjectUuidPK(empAuBillEnStateInfo.getId().toString()), empAuBillEnStateInfo);
                empAuditBizBillEntryInfo.setApproveReason(approveReason);
                sic.add(new SelectorItemInfo("approveReason"));
                iEmpAuditBizBillEntry.updatePartial((CoreBaseInfo)empAuditBizBillEntryInfo, sic);
            }
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label3", (Context)ctx));
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label3", (Context)ctx));
        }
    }

    @Override
    public void _doEmpAudited(Context ctx, HttpServletRequest request, boolean isAudit) throws BOSException, EASBizException {
        String paramJson = request.getParameter("paramJson");
        JSONObject json = JSONObject.parseObject((String)paramJson);
        String jobId = json.getString("jobId");
        this._doSaveOrAudit(ctx, request, true);
        this.pass(ctx, jobId);
        this.afterPass(ctx, jobId);
        String billId = json.getString("billId");
        String bussAttrNum = json.getString("bussAttrNum");
        SSCTaskAppUtil.taskDoneRuleSyn((Context)ctx, (String)billId, (String)bussAttrNum);
    }

    public void pass(Context ctx, String jobId) throws EASBizException, BOSException {
        String jobClassification = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        String userName = ctx.getUserName();
        JsonObject jo = null;
        try {
            jo = SSCTaskAppUtil.viewJobDetail((Context)ctx, (String)jobId);
            if (jo != null) {
                JsonObject bussAttr = jo.getAsJsonObject("bussAttrID");
                String bussAttrId = bussAttr.get("id").isJsonNull() ? "" : bussAttr.get("id").getAsString();
                String shareCenterID = "";
                shareCenterID = jo.get("shareCenterID") instanceof JsonObject ? (jo.getAsJsonObject("shareCenterID").isJsonNull() ? "" : jo.getAsJsonObject("shareCenterID").get("id").getAsString()) : (jo.get("shareCenterID").isJsonNull() ? "" : jo.get("shareCenterID").getAsString());
                HashMap<String, String> params1 = new HashMap<String, String>();
                params1.put("bussId", bussAttrId);
                params1.put("shareCenterId", shareCenterID);
                String condition = XMLDocUtil.getOperationXml((String)"ALLBASICDATA", params1);
                JsonObject allBasicData = SSCTaskAppUtil.getApprovalBasicData((Context)ctx, (String)condition);
                JsonObject jobClassiJO = allBasicData.getAsJsonObject("jobclassification");
                if (!jobClassiJO.isJsonNull() && !jobClassiJO.getAsJsonObject("jobClassification").isJsonNull()) {
                    jobClassification = jobClassiJO.getAsJsonObject("jobClassification").get("value").getAsString();
                }
            }
            String userId = UserFactory.getLocalInstance((Context)ctx).getUserInfo("where number = '" + userName + "'").getId().toString();
            params.put("jobId", jobId);
            params.put("userId", userId);
            params.put("unpassReaId", "");
            params.put("jobClassification", jobClassification);
            params.put("message", "");
            params.put("mesTitle", "");
            params.put("jobPriority", "");
            params.put("decision", "");
            params.put("decisionId", "");
            params.put("plainText", "");
            params.put("signature", "");
            params.put("innerMsg", "");
            params.put("pullNextJob", false);
            SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"PASS", params);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label4", (Context)ctx));
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label4", (Context)ctx));
        }
        this.updateActivityState(ctx, jobId);
    }

    private void updateActivityState(Context ctx, String jobId) {
        try {
            IActivityJobInfo iActivityJobInfo = ActivityJobInfoFactory.getLocalInstance((Context)ctx);
            ActivityJobInfoCollection coll = ActivityJobInfoFactory.getLocalInstance((Context)ctx).getActivityJobInfoCollection("where jobId ='" + jobId + "'");
            logger.error("updateActivityState: " + coll.size() + ";coll:" + coll.get(0));
            if (coll.size() != 0 && coll.size() == 1) {
                ActivityJobInfoInfo activityJobInfoInfo = coll.get(0);
                activityJobInfoInfo.setJobState(JobState.finish);
                activityJobInfoInfo.setOpinion("");
                iActivityJobInfo.update((IObjectPK)new ObjectUuidPK(activityJobInfoInfo.getId()), activityJobInfoInfo);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void afterPass(Context ctx, String jobId) throws EASBizException, BOSException {
        String activityId = null;
        String billId = null;
        try {
            boolean isFinish;
            ActivityJobInfoCollection coll = ActivityJobInfoFactory.getLocalInstance((Context)ctx).getActivityJobInfoCollection("where jobId = '" + jobId + "'");
            if (coll.size() == 1) {
                ActivityJobInfoInfo activityJobInfoInfo = coll.get(0);
                activityId = activityJobInfoInfo.getActivity();
                billId = activityJobInfoInfo.getBill();
            }
            if (isFinish = this.checkSolution(ctx, billId, activityId, jobId)) {
                this.dealWithWorkFlow(ctx, billId, true);
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label5", (Context)ctx));
        }
    }

    private boolean checkSolution(Context ctx, String billId, String activityId, String jobId) throws EASBizException, BOSException {
        boolean isFinish = false;
        ActivitySolutionInfo solutionInfo = this.getSolutionByBillId(ctx, jobId);
        SolutionActivityInfoCollection solutionActivityColl = solutionInfo.getEntrys();
        HashSet<String> solutionActivityInfofilterSet = new HashSet<String>();
        for (int i = 0; i < solutionActivityColl.size(); ++i) {
            solutionActivityInfofilterSet.add(solutionActivityColl.get(i).getId().toString());
        }
        try {
            EntityViewInfo entity = new EntityViewInfo();
            FilterInfo solutionActivityInfofilter = new FilterInfo();
            entity.setFilter(solutionActivityInfofilter);
            solutionActivityInfofilter.getFilterItems().add(new FilterItemInfo("id", solutionActivityInfofilterSet, CompareType.INCLUDE));
            SolutionActivityInfoCollection coll = SolutionActivityInfoFactory.getLocalInstance((Context)ctx).getSolutionActivityInfoCollection(entity);
            HashSet<String> filterSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                filterSet.add(coll.get(i).getActivity().getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bill", (Object)billId));
            filter.getFilterItems().add(new FilterItemInfo("activity", filterSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("jobState", (Object)2, CompareType.NOTEQUALS));
            isFinish = !ActivityJobInfoFactory.getLocalInstance((Context)ctx).exists(filter);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label6", (Context)ctx));
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label6", (Context)ctx));
        }
        return isFinish;
    }

    private void dealWithWorkFlow(Context ctx, String billId, boolean isPass) {
        try {
            WorkflowProceedFacadeFactory.getLocalInstance((Context)ctx).wfproceedTrigger(billId, true);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected ActivitySolutionInfo getSolutionByBillId(Context ctx, String jobId) throws EASBizException, BOSException {
        ActivitySolutionInfo info = null;
        try {
            ActivityJobInfoCollection coll = ActivityJobInfoFactory.getLocalInstance((Context)ctx).getActivityJobInfoCollection("where jobId = '" + jobId + "'");
            if (coll.size() == 0) {
                throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label7", (Context)ctx));
            }
            if (coll.size() != 1) {
                throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label8", (Context)ctx));
            }
            info = ActivitySolutionFactory.getLocalInstance((Context)ctx).getActivitySolutionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)coll.get(0).getScheme())));
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label9", (Context)ctx));
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label9", (Context)ctx));
        }
        catch (UuidException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(SHRServerResource.getString((String)"com.kingdee.shr.sscaffair.SscaffairResource880", (String)"label9", (Context)ctx));
        }
        return info;
    }
}

