/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.distributionRule;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.SubmitElementFactory;
import com.kingdee.shr.compensation.app.integrate.SubmitElementInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.ssccompensation.app.distributionRule.AbstractRangeConfigEntryFacadeControllerBean;
import com.kingdee.shr.ssccompensation.app.distributionRule.DistributionRuleInfo;
import com.kingdee.shr.ssccompensation.app.distributionRule.RangeConfigEntryFactory;
import com.kingdee.shr.ssccompensation.app.distributionRule.RangeConfigEntryInfo;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitElementCollectionCollection;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitElementCollectionInfo;
import com.kingdee.shr.ssccompensation.dto.Entry;
import com.kingdee.shr.ssccompensation.dto.RangeConfigEntryDTO;
import com.kingdee.shr.ssccompensation.dto.SubmitElement;
import com.kingdee.shr.ssccompensation.exception.DistributionRuleException;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;

public class RangeConfigEntryFacadeControllerBean
extends AbstractRangeConfigEntryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.sscCompensation.app.distributionRule.RangeConfigEntryFacadeControllerBean");

    @Override
    protected void _saveConfig(Context ctx, Map param) throws BOSException, EASBizException {
        String deleteRowId = MapUtils.getString((Map)param, (Object)"deleteRowId");
        String distributionRuleId = MapUtils.getString((Map)param, (Object)"distributionRuleId");
        String configStr = MapUtils.getString((Map)param, (Object)"entry");
        if (StringUtils.isEmpty((String)configStr)) {
            this.beforeDelete(ctx, deleteRowId);
            return;
        }
        RangeConfigEntryDTO saveData = this.buildSchemeFilter(configStr);
        if (saveData == null || saveData.getEntry() == null || saveData.getEntry().isEmpty()) {
            this.beforeDelete(ctx, deleteRowId);
            return;
        }
        List<Entry> entrys = saveData.getEntry();
        RangeConfigEntryInfo config = new RangeConfigEntryInfo();
        BOSObjectType bosType = config.getBOSType();
        CoreBaseCollection entryColl = new CoreBaseCollection();
        HashSet submitElementsCheckList = Sets.newHashSet();
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            Entry entry = entrys.get(i);
            String entryId = entry.getEntryId();
            config = new RangeConfigEntryInfo();
            if (StringUtils.isEmpty((String)entryId)) {
                BOSUuid configId = BOSUuid.create((BOSObjectType)bosType);
                config.setId(configId);
            } else {
                config.setId(BOSUuid.read((String)entryId));
            }
            DistributionRuleInfo rule = new DistributionRuleInfo();
            rule.setId(BOSUuid.read((String)distributionRuleId));
            config.setDistributionRule(rule);
            if (entry.getSubmitElements() != null) {
                SubmitElementCollectionCollection coll = this.assembleSubmitElements(ctx, config, entry.getSubmitElements(), submitElementsCheckList);
                config.put("submitElementCollection", (Object)coll);
            }
            config.setRangeConfig(entry.getConfig());
            config.setIndex(i);
            entryColl.add((CoreBaseInfo)config);
        }
        this.beforeDelete(ctx, deleteRowId);
        RangeConfigEntryFactory.getLocalInstance(ctx).saveBatchData(entryColl);
    }

    protected void beforeDelete(Context ctx, String deleteRowId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)deleteRowId)) {
            return;
        }
        String[] ids = deleteRowId.split(",");
        CmpInSql instance = CmpInSqlFactory.getInstance();
        String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, Arrays.asList(ids));
        RangeConfigEntryFactory.getLocalInstance(ctx).delete("where id in " + createInSqlBaseOnFId);
        instance.release(ctx);
    }

    private RangeConfigEntryDTO buildSchemeFilter(String configStr) {
        JSONObject node = JSONObject.parseObject((String)configStr);
        return (RangeConfigEntryDTO)node.toJavaObject(RangeConfigEntryDTO.class);
    }

    protected SubmitElementCollectionCollection assembleSubmitElements(Context ctx, RangeConfigEntryInfo config, List<SubmitElement> submtElements, Set<String> submitElementsCheckList) throws EASBizException, BOSException {
        SubmitElementCollectionCollection coll = new SubmitElementCollectionCollection();
        for (int i = 0; i < submtElements.size(); ++i) {
            if (submtElements.get(i) == null || submtElements.get(i).getId() == null) continue;
            String submitElementId = submtElements.get(i).getId().toString();
            if (submitElementsCheckList.contains(submitElementId)) {
                SubmitElementInfo errInfo = SubmitElementFactory.getLocalInstance((Context)ctx).getSubmitElementInfo((IObjectPK)new ObjectUuidPK(submitElementId));
                throw new DistributionRuleException(DistributionRuleException.EXCEPTION2, new Object[]{errInfo.getName()});
            }
            submitElementsCheckList.add(submitElementId);
            SubmitElementCollectionInfo info = new SubmitElementCollectionInfo();
            info.setRangeConfigEntry(config);
            SubmitElementInfo submitElement = new SubmitElementInfo();
            submitElement.setId(BOSUuid.read((String)submtElements.get(i).getId()));
            info.setSubmitElement(submitElement);
            coll.add(info);
        }
        return coll;
    }

    @Override
    protected void _createEmp(Context ctx, Map param) throws BOSException, EASBizException {
        String distributionRuleId = (String)param.get("distributionRuleId");
        StringBuilder unionSql = (StringBuilder)param.get("unionSql");
        boolean isEnableSubmitElement = (Boolean)param.get("isEnableSubmitElement");
        Object[] delParam = new Object[]{distributionRuleId};
        String deleteSql = "delete from T_HR_SubmitEmployeeRange where FDistributionRuleID = ?";
        DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])delParam);
        unionSql.append(" order by personId, assignType desc, effectDate desc, leffectDate desc ");
        HashMap filterMap = Maps.newHashMap();
        ArrayList empList = Lists.newArrayList();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)unionSql.toString());
        try {
            while (rs.next()) {
                String key;
                String personId = rs.getString("personId");
                String adminOrgId = rs.getString("adminOrgId");
                String submitElementId = StringUtils.isEmpty((String)rs.getString("submitElementId")) ? null : rs.getString("submitElementId");
                int assignType = rs.getInt("assignType");
                String string = key = isEnableSubmitElement ? personId + "_" + adminOrgId + "_" + submitElementId : personId;
                if ((filterMap.get(key) != null || assignType != 1) && assignType != 0) continue;
                EmployeeRange er = new EmployeeRange();
                er.setDistributionRuleID(rs.getString("distributionRuleId"));
                er.setId(rs.getString("ID"));
                er.setCmpEmpORelationID(rs.getString("cmpEmpORelationId"));
                er.setSubmitElementID(submitElementId);
                er.setAdminOrgUnitID(rs.getString("adminOrgId"));
                empList.add(er);
                filterMap.put(key, key);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (empList.size() > 0) {
            ArrayList params = Lists.newArrayList();
            empList.stream().forEach(a -> params.add(a.getObject()));
            String insertSql = "insert into T_HR_SubmitEmployeeRange(FDistributionRuleID, fid, FCmpEmpORelationID, FSubmitElementID, FAdminOrgUnitID) values (?, ?, ?, ?, ?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSql, (List)params);
        }
    }

    class EmployeeRange {
        private String distributionRuleID;
        private String id;
        private String cmpEmpORelationID;
        private String submitElementID;
        private String adminOrgUnitID;
        private String personID;

        EmployeeRange() {
        }

        public String getDistributionRuleID() {
            return this.distributionRuleID;
        }

        public void setDistributionRuleID(String distributionRuleID) {
            this.distributionRuleID = distributionRuleID;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCmpEmpORelationID() {
            return this.cmpEmpORelationID;
        }

        public void setCmpEmpORelationID(String cmpEmpORelationID) {
            this.cmpEmpORelationID = cmpEmpORelationID;
        }

        public String getSubmitElementID() {
            return this.submitElementID;
        }

        public void setSubmitElementID(String submitElementID) {
            this.submitElementID = submitElementID;
        }

        public String getAdminOrgUnitID() {
            return this.adminOrgUnitID;
        }

        public void setAdminOrgUnitID(String adminOrgUnitID) {
            this.adminOrgUnitID = adminOrgUnitID;
        }

        public String getPersonID() {
            return this.personID;
        }

        public void setPersonID(String personID) {
            this.personID = personID;
        }

        public Object[] getObject() {
            return new Object[]{this.distributionRuleID, this.id, this.cmpEmpORelationID, this.submitElementID, this.adminOrgUnitID};
        }
    }
}

