/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.distributionRule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.ssccompensation.app.ProposerSourceEnum;
import com.kingdee.shr.ssccompensation.app.SubmitConfigPersonCollection;
import com.kingdee.shr.ssccompensation.app.SubmitConfigPersonFactory;
import com.kingdee.shr.ssccompensation.app.SubmitConfigPersonInfo;
import com.kingdee.shr.ssccompensation.app.SubmitTerminalEnum;
import com.kingdee.shr.ssccompensation.app.common.AdminOrgUnitVO;
import com.kingdee.shr.ssccompensation.app.common.CommonUtils;
import com.kingdee.shr.ssccompensation.app.distributionRule.AbstractSubmitAdminOrgAndTerminalControllerBean;
import com.kingdee.shr.ssccompensation.app.distributionRule.DistributionRuleInfo;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalBillCollection;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalBillFactory;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalBillInfo;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalCollection;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalFactory;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SubmitAdminOrgAndTerminalControllerBean
extends AbstractSubmitAdminOrgAndTerminalControllerBean {
    private static Logger logger = Logger.getLogger(SubmitAdminOrgAndTerminalControllerBean.class);

    protected void verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected BatchMessageTipsHeader _referPerson(Context ctx, String ids, String distributionRuleId) throws BOSException {
        String personOql = "select adminOrgUnit.id, adminOrgUnit.name, adminOrgUnit.number, adminOrgUnit.longNumber, proposer.id where id in ('" + ids.replace(",", "','") + "')";
        String billOql = "select id, distributionRule.id, entry.proposer.id, entry.adminOrgUnit.id, entry.adminOrgUnit.number, entry.adminOrgUnit.longNumber, entry.isDownward where distributionRule.id = '" + distributionRuleId + "'";
        BatchMessageTipsHeader tips = new BatchMessageTipsHeader();
        tips.setBillId(distributionRuleId);
        int success = 0;
        int failed = 0;
        ArrayList<SubmitConfigPersonInfo> person4Update = new ArrayList<SubmitConfigPersonInfo>();
        try {
            SubmitAdminOrgAndTerminalBillInfo bill;
            SubmitConfigPersonCollection persons = SubmitConfigPersonFactory.getLocalInstance(ctx).getSubmitConfigPersonCollection(personOql);
            SubmitAdminOrgAndTerminalBillCollection bills = SubmitAdminOrgAndTerminalBillFactory.getLocalInstance(ctx).getSubmitAdminOrgAndTerminalBillCollection(billOql);
            SubmitAdminOrgAndTerminalBillInfo submitAdminOrgAndTerminalBillInfo = bill = bills.isEmpty() ? null : bills.get(0);
            if (null == bill) {
                bill = new SubmitAdminOrgAndTerminalBillInfo();
                bill.setId(BOSUuid.create((BOSObjectType)bill.getBOSType()));
                DistributionRuleInfo ruleInfo = new DistributionRuleInfo();
                ruleInfo.setId(BOSUuid.read((String)distributionRuleId));
                bill.setDistributionRule(ruleInfo);
                this.saveBill(ctx, persons, bill, tips);
                return tips;
            }
            Iterator iterator = persons.iterator();
            HashSet<String> admins = new HashSet<String>();
            while (iterator.hasNext()) {
                SubmitConfigPersonInfo personInfo = (SubmitConfigPersonInfo)iterator.next();
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                ArrayList<String> extList = new ArrayList<String>();
                extList.add(personInfo.getAdminOrgUnit().getNumber());
                extList.add(personInfo.getAdminOrgUnit().getName());
                boolean isSuccessful = true;
                String msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label5", (Context)ctx);
                if (this.checkRepeatedAdminOrgUnit(personInfo, bill.getEntry())) {
                    ++success;
                    person4Update.add(personInfo);
                    iterator.remove();
                    msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label6", (Context)ctx);
                    isSuccessful = true;
                } else if (CommonUtils.isIncluded(personInfo.getAdminOrgUnit(), this.getAdminOrgUnitFromEntry(bill.getEntry()))) {
                    iterator.remove();
                    ++failed;
                    msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label46", (Context)ctx);
                    isSuccessful = false;
                } else if (admins.contains(personInfo.getAdminOrgUnit().getNumber())) {
                    iterator.remove();
                    ++failed;
                    msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label13", (Context)ctx);
                    isSuccessful = false;
                } else {
                    admins.add(personInfo.getAdminOrgUnit().getNumber());
                    ++success;
                }
                body.setId(personInfo.getAdminOrgUnit().getId().toString());
                body.setMuitTipsState(isSuccessful);
                body.setMuitTipsMessage(msg);
                body.setMessageListExt(extList);
                tips.addResult(body);
            }
            this.updateByAdminOrgId(ctx, bill.getId().toString(), person4Update);
            this.insertSubmitPerson2Terminal(ctx, persons, bill);
            tips.setSuccessCount(success);
            tips.setFailureCount(failed);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"refer submit person config error: ", e);
            throw new BOSException(e);
        }
        return tips;
    }

    private List<AdminOrgUnitVO> getAdminOrgUnitFromEntry(SubmitAdminOrgAndTerminalCollection entry) {
        ArrayList<AdminOrgUnitVO> collection = new ArrayList<AdminOrgUnitVO>();
        for (int i = 0; i < entry.size(); ++i) {
            AdminOrgUnitVO vo = new AdminOrgUnitVO();
            vo.setAdminOrgUnitInfo(entry.get(i).getAdminOrgUnit());
            vo.setDownward(entry.get(i).isIsDownward());
            collection.add(vo);
        }
        return collection;
    }

    protected void updateByAdminOrgId(Context ctx, String billId, List<SubmitConfigPersonInfo> persons) throws BOSException {
        if (persons.isEmpty()) {
            return;
        }
        String sql = "update T_HR_SubmitAdminOrgAndTerminal set FProposerId = ? ,fSubmitTerminal = 1 ,fProposerSource = 1 where fBillId = ? and fAdminOrgUnitId = ?";
        ArrayList params = new ArrayList();
        persons.forEach(person -> {
            Object[] param = new Object[]{CommonUtils.getCoreBaseObjectId((CoreBaseInfo)person.getProposer()), billId, person.getAdminOrgUnit().getId().toString()};
            params.add(param);
        });
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }

    protected void saveBill(Context ctx, SubmitConfigPersonCollection persons, SubmitAdminOrgAndTerminalBillInfo bill, BatchMessageTipsHeader tips) throws BOSException, EASBizException {
        CoreBaseCollection entry = this.convertPersonConfig2Terminal(ctx, persons, bill, tips);
        bill.put("entry", entry);
        SubmitAdminOrgAndTerminalBillFactory.getLocalInstance(ctx).save(bill);
    }

    protected void insertSubmitPerson2Terminal(Context ctx, SubmitConfigPersonCollection persons, SubmitAdminOrgAndTerminalBillInfo bill) throws BOSException, EASBizException {
        CoreBaseCollection entry = this.convertWithoutCheck(persons, bill);
        SubmitAdminOrgAndTerminalFactory.getLocalInstance(ctx).saveBatchData(entry);
    }

    protected CoreBaseCollection convertPersonConfig2Terminal(Context ctx, SubmitConfigPersonCollection persons, SubmitAdminOrgAndTerminalBillInfo bill, BatchMessageTipsHeader tips) {
        CoreBaseCollection entry = new CoreBaseCollection();
        SubmitAdminOrgAndTerminalCollection terminals = new SubmitAdminOrgAndTerminalCollection();
        int success = 0;
        int failure = 0;
        String successMsg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label5", (Context)ctx);
        String repeatedMsg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label13", (Context)ctx);
        String hierarchyMsg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label46", (Context)ctx);
        for (int i = 0; i < persons.size(); ++i) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            SubmitConfigPersonInfo person = persons.get(i);
            ArrayList<String> extList = new ArrayList<String>();
            extList.add(person.getAdminOrgUnit().getNumber());
            extList.add(person.getAdminOrgUnit().getName());
            body.setMessageListExt(extList);
            SubmitAdminOrgAndTerminalInfo info = new SubmitAdminOrgAndTerminalInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(person.getAdminOrgUnit().getId());
            adminOrgUnitInfo.setLongNumber(person.getAdminOrgUnit().getLongNumber());
            adminOrgUnitInfo.setNumber(person.getAdminOrgUnit().getNumber());
            info.setAdminOrgUnit(adminOrgUnitInfo);
            info.setBill(bill);
            info.setProposer(person.getProposer());
            info.setProposerSource(ProposerSourceEnum.ASSIGNING);
            info.setSubmitTerminal(SubmitTerminalEnum.WORKBENCH_COORDINATION);
            boolean isRepeated = this.checkRepeatedAdminOrgUnit(person, terminals);
            if (isRepeated) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(repeatedMsg);
                ++failure;
            } else if (CommonUtils.isIncluded(person.getAdminOrgUnit(), this.getAdminOrgUnitFromEntry(terminals))) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(hierarchyMsg);
                ++failure;
            } else {
                entry.add((CoreBaseInfo)info);
                terminals.add(info);
                body.setMuitTipsState(true);
                body.setMuitTipsMessage(successMsg);
                ++success;
            }
            tips.addResult(body);
        }
        tips.setSuccessCount(success);
        tips.setFailureCount(failure);
        return entry;
    }

    protected CoreBaseCollection convertWithoutCheck(SubmitConfigPersonCollection persons, SubmitAdminOrgAndTerminalBillInfo bill) {
        CoreBaseCollection entry = new CoreBaseCollection();
        for (int i = 0; i < persons.size(); ++i) {
            SubmitConfigPersonInfo person = persons.get(i);
            SubmitAdminOrgAndTerminalInfo info = new SubmitAdminOrgAndTerminalInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(person.getAdminOrgUnit().getId());
            info.setAdminOrgUnit(adminOrgUnitInfo);
            info.setBill(bill);
            info.setProposer(person.getProposer());
            info.setProposerSource(ProposerSourceEnum.ASSIGNING);
            info.setSubmitTerminal(SubmitTerminalEnum.WORKBENCH_COORDINATION);
            entry.add((CoreBaseInfo)info);
        }
        return entry;
    }

    protected boolean checkRepeatedAdminOrgUnit(SubmitConfigPersonInfo personInfo, SubmitAdminOrgAndTerminalCollection terminals) {
        for (int i = 0; i < terminals.size(); ++i) {
            SubmitAdminOrgAndTerminalInfo info = terminals.get(i);
            if (!CommonUtils.getCoreBaseObjectId((CoreBaseInfo)personInfo.getAdminOrgUnit()).equals(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info.getAdminOrgUnit()))) continue;
            return true;
        }
        return false;
    }
}

