/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.wizard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.compensation.SscTypeEnum;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitSchemeBillDataSource;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.app.integrate.SubBillSource;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.adj.RecEmpAdjSalaryUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.compensation.util.integrate.IntegrateEntryTableAttrs;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.shr.shareservice.CoActivityJobOptFacadeFactory;
import com.kingdee.shr.ssccompensation.app.ProposerSourceEnum;
import com.kingdee.shr.ssccompensation.app.SubmitTerminalEnum;
import com.kingdee.shr.ssccompensation.app.common.CommonUtils;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillSyncRecordFactory;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillSyncRecordInfo;
import com.kingdee.shr.ssccompensation.app.wizard.AbstractDistributeSubmitBillFacadeControllerBean;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeStatusEnum;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodCollection;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodInfo;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalCollection;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalInfo;
import com.kingdee.shr.ssccompensation.app.wizard.TerminalSubmitBillRelCollection;
import com.kingdee.shr.ssccompensation.app.wizard.TerminalSubmitBillRelFactory;
import com.kingdee.shr.ssccompensation.app.wizard.TerminalSubmitBillRelInfo;
import com.kingdee.shr.ssccompensation.app.wizard.WizardEmployeeRangeCollection;
import com.kingdee.shr.ssccompensation.app.wizard.WizardEmployeeRangeFactory;
import com.kingdee.shr.ssccompensation.app.wizard.WizardEmployeeRangeInfo;
import com.kingdee.shr.ssccompensation.exception.DistributionRuleException;
import com.kingdee.shr.ssccompensation.utils.CmpSscUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DistributeSubmitBillFacadeControllerBean
extends AbstractDistributeSubmitBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger(DistributeSubmitBillFacadeControllerBean.class);

    @Override
    protected Map _getDistributedAdminOrg(Context ctx, String distributePeriodId) throws BOSException {
        HashMap<String, DistributeStatusEnum> map = new HashMap<String, DistributeStatusEnum>();
        WizardEmployeeRangeCollection employeeRange = this.getWizardEmployeeRangeCollection(ctx, distributePeriodId, 150);
        for (int i = 0; i < employeeRange.size(); ++i) {
            String adminOrgId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)employeeRange.get(i).getAdminOrgUnit());
            DistributeStatusEnum distributeStatus = employeeRange.get(i).getDistributeStatus();
            map.put(adminOrgId, distributeStatus);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _createBill(Context ctx, Map param) throws BOSException, EASBizException {
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        String userId = (String)param.get("userId");
        String permItemId = (String)param.get("permItemId");
        String adminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        boolean flag = CmpDistributedLockUtils.tryLock((Context)ctx, (String)"ssc.cmp.distribution.wizard.period.gen", (String)distributionPeriodId);
        if (!flag) {
            logger.error((Object)("System is busy: distributionPeriodId: " + distributionPeriodId + " is occupied by other user"));
            return null;
        }
        try {
            String terminalOql = "where bill.id = '" + distributionPeriodId + "' and adminOrgUnit.id in (" + adminRangeSQL + ")";
            DistributionSubmitTerminalCollection terminals = DistributionSubmitTerminalFactory.getLocalInstance(ctx).getDistributionSubmitTerminalCollection(terminalOql);
            if (terminals.isEmpty()) {
                String string = null;
                return string;
            }
            String periodOql = "select id, description, distributionRule.id, distributionRule.submitScheme.id, distributionRule.hrOrgUnit.id where id = '" + distributionPeriodId + "'";
            DistributionPeriodCollection periods = DistributionPeriodFactory.getLocalInstance(ctx).getDistributionPeriodCollection(periodOql);
            DistributionPeriodInfo period = periods.get(0);
            String submitSchemeId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)period.getDistributionRule().getSubmitScheme());
            String entryTableName = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId((Context)ctx, (String)submitSchemeId);
            List<String> terminalIds = this.getTerminalIds(terminals);
            this.deleteSubmitBillByTerminals(ctx, terminalIds, entryTableName);
            WizardEmployeeRangeCollection employeeRange = this.getWizardEmployeeRangeCollection(ctx, distributionPeriodId, 200);
            this.createSubmitBillInfo(ctx, userId, terminals, period, entryTableName, employeeRange);
            String string = null;
            return string;
        }
        finally {
            CmpDistributedLockUtils.unlock((Context)ctx, (String)"ssc.cmp.distribution.wizard.period.gen", (String)distributionPeriodId);
        }
    }

    protected WizardEmployeeRangeCollection getWizardEmployeeRangeCollection(Context ctx, String distributionPeriodId, int distributeStatus) throws BOSException {
        String employeeRangeOql = "where bill.id = '" + distributionPeriodId + "' and distributeStatus = " + distributeStatus;
        return WizardEmployeeRangeFactory.getLocalInstance(ctx).getWizardEmployeeRangeCollection(employeeRangeOql);
    }

    private List<String> getTerminalIds(DistributionSubmitTerminalCollection terminals) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < terminals.size(); ++i) {
            list.add(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)terminals.get(i)));
        }
        return list;
    }

    @Override
    protected void _clearSubmitBillInfo(Context ctx, List terminals, String entryTableName) throws BOSException {
        this.deleteSubmitBillByTerminals(ctx, terminals, entryTableName);
    }

    protected void deleteSubmitBillByTerminals(Context ctx, List<String> terminals, String entryTableName) throws BOSException {
        ArrayList params = new ArrayList();
        terminals.forEach(e -> {
            Object[] param = new Object[]{e};
            params.add(param);
        });
        String submitBillSQL = "select FSubmitBillID from T_HR_STerminalSubmitBillRel where FSubmitTerminalID = ?  and FDistributeStatus = 200";
        String deleteSubmitBillEntrySQL = "delete from " + entryTableName + " where fBillId in (" + submitBillSQL + ")";
        String deleteFixSubmitBillEntrySQL = "delete from T_HR_SchemeBillEntry where fBillId in (" + submitBillSQL + ")";
        String deleteSubmitBillSQL = "delete from T_HR_SBatchSubmitShemeBill where fid in (" + submitBillSQL + ")";
        String deleteSyncRecordSQL = "delete from T_HR_SubmitBillSyncRecord where FSubmitBillId in (" + submitBillSQL + ")";
        String deleteTerminalSubmitBillRelSQL = "delete from T_HR_STerminalSubmitBillRel where FSubmitBillID in (" + submitBillSQL + ")";
        DbUtil.executeBatch((Context)ctx, (String)deleteSubmitBillEntrySQL, params);
        DbUtil.executeBatch((Context)ctx, (String)deleteFixSubmitBillEntrySQL, params);
        DbUtil.executeBatch((Context)ctx, (String)deleteSubmitBillSQL, params);
        DbUtil.executeBatch((Context)ctx, (String)deleteSyncRecordSQL, params);
        DbUtil.executeBatch((Context)ctx, (String)deleteTerminalSubmitBillRelSQL, params);
    }

    protected void createSubmitBillInfo(Context ctx, String userId, DistributionSubmitTerminalCollection terminals, DistributionPeriodInfo period, String entryTableName, WizardEmployeeRangeCollection employeeRange) throws BOSException, EASBizException {
        CoreBaseCollection submitBills = new CoreBaseCollection();
        CoreBaseCollection relations = new CoreBaseCollection();
        CoreBaseCollection syncCollection = new CoreBaseCollection();
        ArrayList entryParams = new ArrayList();
        java.util.Date applyDate = new java.util.Date();
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        int billCount = 0;
        for (int i = 0; i < terminals.size(); ++i) {
            DistributionSubmitTerminalInfo terminal = terminals.get(i);
            List<WizardEmployeeRangeInfo> employeeRangeInfos = this.filterByTerminal(terminal, employeeRange);
            if (employeeRangeInfos.isEmpty()) continue;
            ProposerSourceEnum proposerSource = terminal.getProposerSource();
            if (proposerSource == ProposerSourceEnum.ONESELF) {
                Map<String, List<WizardEmployeeRangeInfo>> rangeGroup = this.groupByPerson(employeeRangeInfos);
                for (List<WizardEmployeeRangeInfo> list : rangeGroup.values()) {
                    PersonInfo proposer = list.get(0).getPerson();
                    BatchSubmitShemeBillInfo submitBill = this.createSubmitBill(period, applyDate, proposer, terminal.getAdminOrgUnit(), userId, createTime, BatchSubmitSchemeBillDataSource.EMP_SUBMIT);
                    submitBills.add((CoreBaseInfo)submitBill);
                    ++billCount;
                    String billId = submitBill.getId().toString();
                    list.forEach(e -> {
                        Object[] entryParam = this.constituteParam(userId, billId, period, applyDate, createTime, (WizardEmployeeRangeInfo)e);
                        entryParams.add(entryParam);
                    });
                    TerminalSubmitBillRelInfo relation = this.createTerminalSubmitBillRel(period, terminal, submitBill);
                    SubmitBillSyncRecordInfo syncRecord = this.createSubmitBillSyncRecord(submitBill, terminal.getSubmitTerminal());
                    relations.add((CoreBaseInfo)relation);
                    syncCollection.add((CoreBaseInfo)syncRecord);
                }
                continue;
            }
            BatchSubmitShemeBillInfo submitBill = this.createSubmitBill(period, applyDate, terminal.getProposer(), terminal.getAdminOrgUnit(), userId, createTime, BatchSubmitSchemeBillDataSource.COMMIS_SUBMIT);
            submitBills.add((CoreBaseInfo)submitBill);
            ++billCount;
            String billId = submitBill.getId().toString();
            employeeRangeInfos.forEach(e -> {
                Object[] entryParam = this.constituteParam(userId, billId, period, applyDate, createTime, (WizardEmployeeRangeInfo)e);
                entryParams.add(entryParam);
            });
            TerminalSubmitBillRelInfo relation = this.createTerminalSubmitBillRel(period, terminal, submitBill);
            SubmitBillSyncRecordInfo syncRecord = this.createSubmitBillSyncRecord(submitBill, terminal.getSubmitTerminal());
            relations.add((CoreBaseInfo)relation);
            syncCollection.add((CoreBaseInfo)syncRecord);
        }
        if (!submitBills.isEmpty()) {
            this.batchSetSubmitBillNumber(ctx, submitBills, billCount);
            BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).saveBatchData(submitBills);
            TerminalSubmitBillRelFactory.getLocalInstance(ctx).saveBatchData(relations);
            SubmitBillSyncRecordFactory.getLocalInstance(ctx).saveBatchData(syncCollection);
        }
        if (!entryParams.isEmpty()) {
            String entryInsertSQL = this.getEntryInsertSQL(entryTableName);
            DbUtil.executeBatch((Context)ctx, (String)entryInsertSQL, entryParams);
            entryInsertSQL = this.getEntryInsertSQL("T_HR_SchemeBillEntry");
            DbUtil.executeBatch((Context)ctx, (String)entryInsertSQL, entryParams);
        }
    }

    private Map<String, List<WizardEmployeeRangeInfo>> groupByPerson(List<WizardEmployeeRangeInfo> employeeRangeInfos) {
        HashMap<String, List<WizardEmployeeRangeInfo>> map = new HashMap<String, List<WizardEmployeeRangeInfo>>();
        employeeRangeInfos.forEach(e -> {
            List list = map.computeIfAbsent(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)e.getPerson()), k -> new ArrayList());
            list.add(e);
        });
        return map;
    }

    private SubmitBillSyncRecordInfo createSubmitBillSyncRecord(BatchSubmitShemeBillInfo submitBill, SubmitTerminalEnum terminal) {
        SubmitBillSyncRecordInfo syncRecord = new SubmitBillSyncRecordInfo();
        syncRecord.setId(BOSUuid.create((BOSObjectType)syncRecord.getBOSType()));
        syncRecord.setSubmitBill(submitBill);
        syncRecord.setActivityType(terminal);
        return syncRecord;
    }

    private void batchSetSubmitBillNumber(Context ctx, CoreBaseCollection submitBills, int billCount) throws BOSException {
        String hrOrgId;
        BatchSubmitShemeBillInfo submitBill = (BatchSubmitShemeBillInfo)submitBills.get(0);
        String[] numbers = RecEmpAdjSalaryUtil.createBillNumbers((Context)ctx, (IObjectValue)submitBill, (String)(hrOrgId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)submitBill.getHrOrgUnit())), (String)"codingRuleHelper", (String)"DispatchSubmitBill", (int)billCount);
        if (null == numbers) {
            return;
        }
        for (int i = 0; i < billCount; ++i) {
            BatchSubmitShemeBillInfo bill = (BatchSubmitShemeBillInfo)submitBills.get(i);
            bill.setNumber(numbers[i]);
        }
    }

    protected TerminalSubmitBillRelInfo createTerminalSubmitBillRel(DistributionPeriodInfo period, DistributionSubmitTerminalInfo terminal, BatchSubmitShemeBillInfo submitBill) {
        TerminalSubmitBillRelInfo relation = new TerminalSubmitBillRelInfo();
        relation.setDistributionPeriod(period);
        relation.setSubmitBill(submitBill);
        relation.setSubmitTerminal(terminal);
        relation.setDistributeStatus(DistributeStatusEnum.NOT_DISTRIBUTE);
        relation.setId(BOSUuid.create((BOSObjectType)relation.getBOSType()));
        return relation;
    }

    protected String getEntryInsertSQL(String entryTableName) {
        List<String> entryColumns = this.getEntryInsertColumns();
        StringBuilder preparedStmt = new StringBuilder();
        for (int i = 0; i < entryColumns.size(); ++i) {
            if (i > 0) {
                preparedStmt.append(",");
            }
            preparedStmt.append("?");
        }
        return "insert into " + entryTableName + "(" + StringUtils.join((Object[])entryColumns.toArray(), (String)",") + " ) values (" + preparedStmt.toString() + ")";
    }

    protected Object[] constituteParam(String userId, String billId, DistributionPeriodInfo period, java.util.Date applyDate, Timestamp createTime, WizardEmployeeRangeInfo rangeInfo) {
        java.util.Date maxDate;
        Object[] entryParam = new Object[]{billId, CmpDateUtil.toSqlDate((Object)CmpDateUtil.getDateStr((java.util.Date)applyDate)), CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rangeInfo.getPerson()), userId, CmpDateUtil.toSqlDate((java.util.Date)createTime), CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rangeInfo.getAdminOrg()), CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rangeInfo.getPosition()), CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rangeInfo.getCmpEmpORelation()), "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC", (maxDate = CmpDateUtil.getMaxEndDate()) == null ? null : CmpDateUtil.toSqlDate((java.util.Date)maxDate), CommonUtils.getCoreBaseObjectId((CoreBaseInfo)period.getDistributionRule().getHrOrgUnit()), "01", 10, 0, CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rangeInfo.getSubmitElement()), BOSUuid.create((String)"7F647776").toString(), 0};
        return entryParam;
    }

    protected List<String> getEntryInsertColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("FBillID");
        columns.add("FEffectDate");
        columns.add("FPersonID");
        columns.add("FCreatorID");
        columns.add("FCreateTime");
        columns.add("FAdminOrgUnitID");
        columns.add("FPositionID");
        columns.add("FCmpEmpORelationID");
        columns.add("FCurrencyID");
        columns.add("FLeffectDate");
        columns.add("FHrOrgUnitID");
        columns.add("FCalState");
        columns.add("FIsCal");
        columns.add("FBillState");
        columns.add("FSubmitElementID");
        columns.add("FID");
        columns.add("FDealStatus");
        return columns;
    }

    protected List<WizardEmployeeRangeInfo> filterByTerminal(DistributionSubmitTerminalInfo terminal, WizardEmployeeRangeCollection employeeRange) {
        ArrayList<WizardEmployeeRangeInfo> list = new ArrayList<WizardEmployeeRangeInfo>();
        for (int i = 0; i < employeeRange.size(); ++i) {
            WizardEmployeeRangeInfo info = employeeRange.get(i);
            if (!info.getAdminOrgUnit().getId().equals((Object)terminal.getAdminOrgUnit().getId())) continue;
            list.add(info);
        }
        return list;
    }

    protected BatchSubmitShemeBillInfo createSubmitBill(DistributionPeriodInfo period, java.util.Date applyDate, PersonInfo proposer, AdminOrgUnitInfo adminOrgUnitInfo, String userId, Timestamp createTime, BatchSubmitSchemeBillDataSource datasource) {
        BatchSubmitShemeBillInfo submitBill = new BatchSubmitShemeBillInfo();
        submitBill.setSubmitScheme(period.getDistributionRule().getSubmitScheme());
        if (null != proposer) {
            submitBill.setProposer(proposer);
        }
        submitBill.setIsSsc(SscTypeEnum.DISTRIBUTE);
        HROrgUnitInfo hrOrgUnitInfo = period.getDistributionRule().getHrOrgUnit();
        submitBill.setHrOrgUnit(hrOrgUnitInfo);
        submitBill.setAdminOrg(adminOrgUnitInfo);
        submitBill.setApplyDate(applyDate);
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)userId));
        submitBill.setCreator(creator);
        submitBill.setCreateTime(createTime);
        submitBill.setBillState(HRBillStateEnum.SAVED);
        submitBill.setBillSource(SubBillSource.Manual_Add);
        submitBill.setDatasource(datasource);
        submitBill.setId(BOSUuid.create((BOSObjectType)submitBill.getBOSType()));
        submitBill.setDescription(period.getDescription());
        submitBill.setCodingRuleHelper("DispatchSubmitBill");
        return submitBill;
    }

    @Override
    protected Object _distribute(Context ctx, Map param) throws BOSException, EASBizException {
        BatchMessageTipsHeader batchMessageTipsHeader = (BatchMessageTipsHeader)param.get("batchMessageTipsHeader");
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        String billIds = (String)param.get("billIds");
        String userId = (String)param.get("userId");
        java.util.Date CODDate = (java.util.Date)param.get("CODDate");
        TerminalSubmitBillRelCollection terminalSubmitBillRel = this.getTerminalSubmitBillRels(ctx, distributionPeriodId, billIds);
        if (terminalSubmitBillRel.isEmpty()) {
            throw new DistributionRuleException(DistributionRuleException.EXCEPTION4);
        }
        if (StringUtils.isEmpty((CharSequence)billIds)) {
            billIds = CmpStrUtil.join(CmpSscUtil.transColl2Array((IObjectCollection)terminalSubmitBillRel, "id"), (String)",", null);
        }
        Map<Object, Object> term2BillMap = CmpSscUtil.coll2Map((IObjectCollection)terminalSubmitBillRel, "id", null);
        List<String> proposerList = CmpSscUtil.transColl2Array((IObjectCollection)terminalSubmitBillRel, "submitBill.proposer.id");
        Map<String, String> person2UserMap = this.getPerson2UserMap(ctx, proposerList);
        BatchSubmitShemeBillInfo submitBill = terminalSubmitBillRel.get(0).getSubmitBill();
        CalSubmitSchemeInfo submitScheme = submitBill.getSubmitScheme();
        String submitSchemeId = submitScheme.getId().toString();
        String dynamicTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId((Context)ctx, (String)submitSchemeId);
        Map<String, List<Object[]>> billEntryMap = this.getSubmitEntry(ctx, dynamicTable, billIds);
        ArrayList updateEmployeeRange = Lists.newArrayList();
        ArrayList updateStatus = Lists.newArrayList();
        batchMessageTipsHeader.setBillId(billIds);
        String[] billIdArray = billIds.split(",");
        long distributionTime = new java.util.Date().getTime();
        for (String billId : billIdArray) {
            Object[] updParam = new Object[6];
            TerminalSubmitBillRelInfo termBill = (TerminalSubmitBillRelInfo)term2BillMap.get(BOSUuid.read((String)billId));
            BatchMessageTipsBody body = this.doDistribute(ctx, termBill, billId, updParam, person2UserMap);
            if (body.isMuitTipsState()) {
                batchMessageTipsHeader.setSuccessCount(batchMessageTipsHeader.getSuccessCount() + 1);
                updParam[1] = 150;
                updParam[2] = new Date(distributionTime);
                updParam[3] = CODDate == null ? null : new Date(CODDate.getTime());
                updParam[4] = userId;
                updParam[5] = billId;
                updateStatus.add(updParam);
                if (billEntryMap.get(termBill.getSubmitBill().getId().toString()) != null) {
                    updateEmployeeRange.addAll((Collection)billEntryMap.get(termBill.getSubmitBill().getId().toString()));
                }
            } else {
                batchMessageTipsHeader.setFailureCount(batchMessageTipsHeader.getFailureCount() + 1);
            }
            batchMessageTipsHeader.addResult(body);
        }
        HashMap udpParam = Maps.newHashMap();
        udpParam.put("updateStatus", updateStatus);
        udpParam.put("updateEmployeeRange", updateEmployeeRange);
        udpParam.put("distributionPeriodId", distributionPeriodId);
        return this._afterDistribute(ctx, udpParam);
    }

    protected BatchMessageTipsBody doDistribute(Context ctx, TerminalSubmitBillRelInfo termBill, String billId, Object[] updParam, Map<String, String> person2UserMap) {
        BatchMessageTipsBody body = new BatchMessageTipsBody();
        try {
            BatchSubmitShemeBillInfo submitBill;
            String proposerId;
            String userId;
            body.setId(billId);
            ArrayList<String> messageListExt = new ArrayList<String>();
            messageListExt.add(termBill.getSubmitTerminal().getAdminOrgUnit().getName(ctx.getLocale()));
            messageListExt.add(termBill.getSubmitBill().getNumber());
            body.addMessageListExt(messageListExt);
            if (termBill == null || termBill.getSubmitBill() == null || termBill.getSubmitTerminal() == null) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label9", (Locale)ctx.getLocale()));
                return body;
            }
            if (termBill.getDistributeStatus().equals((Object)DistributeStatusEnum.DISTRIBUTED)) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label10", (Locale)ctx.getLocale()));
                return body;
            }
            if (termBill.getSubmitTerminal() == null || termBill.getSubmitTerminal().getSubmitTerminal() == null || SubmitTerminalEnum.WORKBENCH_COORDINATION.equals((Object)termBill.getSubmitTerminal().getSubmitTerminal()) && termBill.getSubmitBill().getProposer() == null) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label19", (Locale)ctx.getLocale()));
                return body;
            }
            if (termBill.getSubmitBill() != null && termBill.getSubmitBill().getProposer() != null && StringUtils.isEmpty((CharSequence)(userId = person2UserMap.get(proposerId = (submitBill = termBill.getSubmitBill()).getProposer().getId().toString())))) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label17", (Locale)ctx.getLocale()));
                return body;
            }
            String jobId = this.createTask(ctx, termBill, person2UserMap);
            if (StringUtils.isEmpty((CharSequence)jobId)) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label11", (Locale)ctx.getLocale()));
                return body;
            }
            updParam[0] = jobId;
        }
        catch (BOSException e) {
            body.setMuitTipsState(false);
            body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label174", (Locale)ctx.getLocale()));
            return body;
        }
        catch (EASBizException e) {
            body.setMuitTipsState(false);
            body.setMuitTipsMessage(e.getMessage());
            if (!StringUtils.isEmpty((CharSequence)e.getMessage()) && e.getMessage().contains("_submit")) {
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label16", (Locale)ctx.getLocale()));
            }
            return body;
        }
        body.setMuitTipsState(true);
        body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"operate_success", (Locale)ctx.getLocale()) + "!");
        return body;
    }

    protected String createTask(Context ctx, TerminalSubmitBillRelInfo termBill, Map<String, String> person2UserMap) throws EASBizException, BOSException {
        SubmitTerminalEnum submitTerminal = termBill.getSubmitTerminal().getSubmitTerminal();
        if (submitTerminal.equals((Object)SubmitTerminalEnum.WORKBENCH_COORDINATION)) {
            return this.createCollaborativeTask(ctx, termBill, person2UserMap);
        }
        return this.createShareTask(ctx, termBill);
    }

    protected String createShareTask(Context ctx, TerminalSubmitBillRelInfo rel) throws EASBizException, BOSException {
        BatchSubmitShemeBillInfo submitBill = rel.getSubmitBill();
        String billId = submitBill.getId().toString();
        Map createJobByActivity = CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).createJobByActivity("5fkKkXIEToSz9wMDPk5GoIIs15U=", null, billId, null);
        if (!((Boolean)createJobByActivity.get("success")).booleanValue() || createJobByActivity.get("data") == null) {
            logger.info((Object)MessageFormat.format("billId:{0}\u751f\u6210\u5171\u4eab\u4efb\u52a1\u5931\u8d25", billId));
            return null;
        }
        String jobId = (String)createJobByActivity.get("data");
        logger.info((Object)MessageFormat.format("billId:{0}\u751f\u6210\u5171\u4eab\u4efb\u52a1\u6210\u529f\uff0cjobId:{1}", billId, jobId));
        return jobId;
    }

    protected String createCollaborativeTask(Context ctx, TerminalSubmitBillRelInfo rel, Map<String, String> person2UserMap) throws EASBizException, BOSException {
        BatchSubmitShemeBillInfo submitBill = rel.getSubmitBill();
        HashSet userSet = Sets.newHashSet();
        if (submitBill.getProposer() == null) {
            logger.info((Object)"\u5f53\u524d\u63d0\u62a5\u4eba\u4e3a\u7a7a");
            return null;
        }
        String proposerId = submitBill.getProposer().getId().toString();
        String userId = person2UserMap.get(proposerId);
        if (StringUtils.isEmpty((CharSequence)userId)) {
            logger.info((Object)"\u63d0\u62a5\u4eba\u5bf9\u5e94\u7528\u6237\u4e3a\u7a7a");
            return null;
        }
        userSet.add(userId);
        HashMap params = Maps.newHashMap();
        params.put("userSet", userSet);
        String billId = submitBill.getId().toString();
        Map createJobByActivity = CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).createJobByActivity("C6cUzsnqT6Og85eppInsx4Is15U=", null, billId, (Map)params);
        if (!((Boolean)createJobByActivity.get("success")).booleanValue() || createJobByActivity.get("data") == null) {
            logger.info((Object)MessageFormat.format("billId:{0}\u751f\u6210\u534f\u4f5c\u4efb\u52a1\u5931\u8d25", billId));
            return null;
        }
        String jobId = (String)createJobByActivity.get("data");
        logger.info((Object)MessageFormat.format("billId:{0}\u751f\u6210\u534f\u4f5c\u4efb\u52a1\u6210\u529f\uff0cjobId:{1}", billId, jobId));
        return jobId;
    }

    public Map<String, String> getPerson2UserMap(Context ctx, List<String> proposerList) throws BOSException {
        HashMap map = Maps.newHashMap();
        CmpInSql instance = CmpInSqlFactory.getInstance();
        try {
            String proposerInSql = instance.createInSqlBaseOnFId(ctx, proposerList);
            String sql = "/*dialect*/ SELECT t.FID, t.FPERSONID FROM (SELECT FID,FPERSONID, row_number() over(partition by FPERSONID order by FTYPE) rn FROM T_PM_User where FPersonID in " + proposerInSql + ") t where t.rn = 1 ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                map.put(rs.getString("FPERSONID"), rs.getString("FID"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    protected TerminalSubmitBillRelCollection getTerminalSubmitBillRels(Context ctx, String distributionPeriodId, String billIds) throws BOSException {
        CmpInSql instance = CmpInSqlFactory.getInstance();
        try {
            String oql = "select distributionPeriod.id, *, submitTerminal.*, submitTerminal.adminOrgUnit.name, submitBill.number, submitBill.id, submitBill.billState, submitBill.submitScheme.id, submitBill.proposer.id, job";
            if (!StringUtils.isEmpty((CharSequence)billIds)) {
                String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, Arrays.asList(billIds.split(",")));
                oql = oql + " where id in " + createInSqlBaseOnFId;
            } else {
                oql = oql + " where distributionPeriod.id = '" + distributionPeriodId + "'";
            }
            TerminalSubmitBillRelCollection terminalSubmitBillRelCollection = TerminalSubmitBillRelFactory.getLocalInstance(ctx).getTerminalSubmitBillRelCollection(oql);
            return terminalSubmitBillRelCollection;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            instance.release(ctx);
        }
    }

    @Override
    protected Object _cancelDistribute(Context ctx, Map param) throws BOSException, EASBizException {
        String[] billIdArray;
        String billIds;
        BatchMessageTipsHeader batchMessageTipsHeader = (BatchMessageTipsHeader)param.get("batchMessageTipsHeader");
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        TerminalSubmitBillRelCollection terminalSubmitBillRel = this.getTerminalSubmitBillRels(ctx, distributionPeriodId, billIds = (String)param.get("billIds"));
        if (terminalSubmitBillRel.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)billIds)) {
            billIds = CmpStrUtil.join(CmpSscUtil.transColl2Array((IObjectCollection)terminalSubmitBillRel, "id"), (String)",", null);
        }
        Map<Object, Object> term2BillMap = CmpSscUtil.coll2Map((IObjectCollection)terminalSubmitBillRel, "id", null);
        List<String> existSubmitBillAttr = this.getExistSubmitBillAttr(ctx, terminalSubmitBillRel);
        BatchSubmitShemeBillInfo submitBill = terminalSubmitBillRel.get(0).getSubmitBill();
        CalSubmitSchemeInfo submitScheme = submitBill.getSubmitScheme();
        String submitSchemeId = submitScheme.getId().toString();
        String dynamicTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId((Context)ctx, (String)submitSchemeId);
        Map<String, List<Object[]>> billEntryMap = this.getSubmitEntry(ctx, dynamicTable, billIds);
        ArrayList updateEmployeeRange = Lists.newArrayList();
        ArrayList updateStatus = Lists.newArrayList();
        batchMessageTipsHeader.setBillId(billIds);
        for (String billId : billIdArray = billIds.split(",")) {
            Object[] udpParam = new Object[6];
            TerminalSubmitBillRelInfo termBill = (TerminalSubmitBillRelInfo)term2BillMap.get(BOSUuid.read((String)billId));
            BatchMessageTipsBody body = this.doCancelDistribute(ctx, termBill, billId, existSubmitBillAttr);
            if (body.isMuitTipsState()) {
                batchMessageTipsHeader.setSuccessCount(batchMessageTipsHeader.getSuccessCount() + 1);
                udpParam[0] = null;
                udpParam[1] = 200;
                udpParam[2] = null;
                udpParam[3] = null;
                udpParam[4] = null;
                udpParam[5] = billId;
                updateStatus.add(udpParam);
                if (billEntryMap.get(termBill.getSubmitBill().getId().toString()) != null) {
                    updateEmployeeRange.addAll((Collection)billEntryMap.get(termBill.getSubmitBill().getId().toString()));
                }
            } else {
                batchMessageTipsHeader.setFailureCount(batchMessageTipsHeader.getFailureCount() + 1);
            }
            batchMessageTipsHeader.addResult(body);
        }
        HashMap udpParam = Maps.newHashMap();
        udpParam.put("updateStatus", updateStatus);
        udpParam.put("updateEmployeeRange", updateEmployeeRange);
        udpParam.put("distributionPeriodId", distributionPeriodId);
        return this._afterCancelDistribute(ctx, udpParam);
    }

    protected BatchMessageTipsBody doCancelDistribute(Context ctx, TerminalSubmitBillRelInfo termBill, String billId, List<String> existSubmitBillAttr) {
        BatchMessageTipsBody body = new BatchMessageTipsBody();
        try {
            body.setId(billId);
            ArrayList<String> messageListExt = new ArrayList<String>();
            messageListExt.add(termBill.getSubmitTerminal().getAdminOrgUnit().getName(ctx.getLocale()));
            messageListExt.add(termBill.getSubmitBill().getNumber());
            body.addMessageListExt(messageListExt);
            if (termBill == null || termBill.getSubmitBill() == null || termBill.getSubmitTerminal() == null) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label12", (Locale)ctx.getLocale()));
                return body;
            }
            if (termBill.getDistributeStatus().equals((Object)DistributeStatusEnum.NOT_DISTRIBUTE)) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label13", (Locale)ctx.getLocale()));
                return body;
            }
            BatchSubmitShemeBillInfo submitBill = termBill.getSubmitBill();
            String submitBillId = submitBill.getId().toString();
            if (existSubmitBillAttr != null && existSubmitBillAttr.contains(submitBillId) || submitBill.getBillState() != HRBillStateEnum.SAVED) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(new DistributionRuleException(DistributionRuleException.EXCEPTION0).getMessage());
                return body;
            }
            HashMap params = Maps.newHashMap();
            params.put("jobId", termBill.getJob());
            params.put("message", EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label20", (Locale)ctx.getLocale()));
            params.put("innerMsg", EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label21", (Locale)ctx.getLocale()));
            Map reverseJob = CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob((Map)params);
            String msg = (String)reverseJob.get("errorMsg");
            if (reverseJob.get("success") == Boolean.FALSE && !StringUtils.isEmpty((CharSequence)msg) && !"null".equals(msg)) {
                body.setMuitTipsState(false);
                body.setMuitTipsMessage(msg);
                if (msg.contains("MissingRecord")) {
                    body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label14", (Locale)ctx.getLocale()));
                }
                return body;
            }
        }
        catch (BOSException e) {
            body.setMuitTipsState(false);
            body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label174", (Locale)ctx.getLocale()));
            return body;
        }
        catch (EASBizException e) {
            body.setMuitTipsState(false);
            body.setMuitTipsMessage(e.getMessage());
            return body;
        }
        body.setMuitTipsState(true);
        body.setMuitTipsMessage(EASResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"operate_success", (Locale)ctx.getLocale()) + "!");
        return body;
    }

    protected List<String> getExistSubmitBillAttr(Context ctx, TerminalSubmitBillRelCollection terminalSubmitBillRel) throws EASBizException, BOSException {
        if (terminalSubmitBillRel.isEmpty()) {
            return Lists.newArrayList();
        }
        List<String> submitBillIds = CmpSscUtil.transColl2Array((IObjectCollection)terminalSubmitBillRel, "submitBill.id");
        BatchSubmitShemeBillInfo submitBill = terminalSubmitBillRel.get(0).getSubmitBill();
        CalSubmitSchemeInfo submitScheme = submitBill.getSubmitScheme();
        String submitSchemeId = submitScheme.getId().toString();
        IntegrateEntryTableAttrs attr = CmpIntegrateEntryHelper.getIntegrateEntryTableAttrs((Context)ctx, (String)submitSchemeId);
        return this.getAllDynamicColValue(ctx, attr, submitBillIds);
    }

    protected List<String> getAllDynamicColValue(Context ctx, IntegrateEntryTableAttrs attr, List<String> submitBillIds) throws BOSException {
        String tableName = attr.getTableName();
        List<String> colNames = this.getColNames(ctx, attr);
        CmpInSql instance = CmpInSqlFactory.getInstance();
        String billSqlId = instance.createInSqlBaseOnFId(ctx, submitBillIds);
        StringBuilder sql = new StringBuilder();
        sql.append("select fbillId from ");
        sql.append(tableName);
        sql.append(" where fbillid in ").append(billSqlId);
        sql.append(" and (");
        StringBuilder whereSql = new StringBuilder();
        for (int i = 0; i < colNames.size(); ++i) {
            whereSql.append(colNames.get(i)).append(" is not null ");
            if (i == colNames.size() - 1) continue;
            whereSql.append(" or ");
        }
        sql.append(whereSql.toString()).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList list = Lists.newArrayList();
        try {
            while (rs.next()) {
                String billId = rs.getString("fbillId");
                list.add(billId);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            instance.release(ctx);
        }
        return list;
    }

    @Override
    protected String _afterDistribute(Context ctx, Map param) throws BOSException, EASBizException {
        String statusSql = "update T_HR_STerminalSubmitBillRel set FJobId = ?, FDistributeStatus = ?, FDistributeDate = ?, FSubmitCOD = ?, FDistributeUserId = ? where FID = ? ";
        List updateStatus = (List)param.get("updateStatus");
        DbUtil.executeBatch((Context)ctx, (String)statusSql, (List)updateStatus);
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        String updRangeSql = "update T_HR_SWizardEmployeeRange set FDistributeStatus = 150 where FCmpEmpORelationID = ? and FSubmitElementID = ?  and FBillID = '" + distributionPeriodId + "'";
        List updateEmployeeRange = (List)param.get("updateEmployeeRange");
        if (updateEmployeeRange != null && !updateEmployeeRange.isEmpty() && ((Object[])updateEmployeeRange.get(0)).length == 1) {
            updRangeSql = "update T_HR_SWizardEmployeeRange set FDistributeStatus = 150 where FCmpEmpORelationID = ? and FSubmitElementID is null  and FBillID = '" + distributionPeriodId + "'";
        }
        DbUtil.executeBatch((Context)ctx, (String)updRangeSql, (List)updateEmployeeRange);
        String sql = "update T_HR_SDistributionPeriod p set FIsCompleted = 100 where not exists (select 1 from T_HR_STerminalSubmitBillRel t where p.Fid = t.FDistributionPeriodID and t.FDistributeStatus = 200) and p.FID = '" + distributionPeriodId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        return null;
    }

    @Override
    protected String _afterCancelDistribute(Context ctx, Map param) throws BOSException, EASBizException {
        String statusSql = "update T_HR_STerminalSubmitBillRel set  FJobId = ?, FDistributeStatus = ?, FDistributeDate = ?, FSubmitCOD = ?, FDistributeUserId = ? where FID = ? ";
        List updateStatus = (List)param.get("updateStatus");
        DbUtil.executeBatch((Context)ctx, (String)statusSql, (List)updateStatus);
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        String updRangeSql = "update T_HR_SWizardEmployeeRange set FDistributeStatus = 200 where FCmpEmpORelationID = ? and FSubmitElementID = ?  and FBillID = '" + distributionPeriodId + "'";
        List updateEmployeeRange = (List)param.get("updateEmployeeRange");
        if (updateEmployeeRange != null && !updateEmployeeRange.isEmpty() && ((Object[])updateEmployeeRange.get(0)).length == 1) {
            updRangeSql = "update T_HR_SWizardEmployeeRange set FDistributeStatus = 200 where FCmpEmpORelationID = ? and FSubmitElementID is null  and FBillID = '" + distributionPeriodId + "'";
        }
        DbUtil.executeBatch((Context)ctx, (String)updRangeSql, (List)updateEmployeeRange);
        String sql = "update T_HR_SDistributionPeriod p set FIsCompleted = 50 where exists (select 1 from T_HR_STerminalSubmitBillRel t where p.Fid = t.FDistributionPeriodID and t.FDistributeStatus = 200) and p.FID = '" + distributionPeriodId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
        return null;
    }

    public Map<String, List<Object[]>> getSubmitEntry(Context ctx, String dynamicTable, String billIds) throws BOSException {
        HashMap result = Maps.newHashMap();
        try {
            String sqlIds = "'" + billIds.replace(",", "','") + "'";
            String sql = "select t.FBillId, t.FCmpEmpORelationID, t.FSubmitElementID from " + dynamicTable + " t  inner join T_HR_STerminalSubmitBillRel rel on t.FBillId = rel.FSubmitBillID  where rel.FID in (" + sqlIds + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String billId = rs.getString("FBillId");
                String cmpEmpORelationID = rs.getString("FCmpEmpORelationID");
                String submitElementID = rs.getString("FSubmitElementID");
                List params = result.computeIfAbsent(billId, k -> Lists.newArrayList());
                if (StringUtils.isEmpty((CharSequence)submitElementID)) {
                    params.add(new Object[]{cmpEmpORelationID});
                    continue;
                }
                params.add(new Object[]{cmpEmpORelationID, submitElementID});
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @Override
    protected String _revoke(Context ctx, Map param) throws BOSException, EASBizException {
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        DistributionPeriodInfo period = DistributionPeriodFactory.getLocalInstance(ctx).getDistributionPeriodInfo((IObjectPK)new ObjectUuidPK(distributionPeriodId));
        if (!period.getIsCompleted().equals((Object)DistributeStatusEnum.COMPLETED)) {
            return null;
        }
        TerminalSubmitBillRelCollection terminalSubmitBillRel = this.getTerminalSubmitBillRels(ctx, distributionPeriodId, null);
        if (terminalSubmitBillRel.isEmpty()) {
            return null;
        }
        List<String> existSubmitBillAttr = this.getExistSubmitBillAttr(ctx, terminalSubmitBillRel);
        ArrayList res = Lists.newArrayList();
        BatchSubmitShemeBillInfo submitBill = terminalSubmitBillRel.get(0).getSubmitBill();
        CalSubmitSchemeInfo submitScheme = submitBill.getSubmitScheme();
        String submitSchemeId = submitScheme.getId().toString();
        String dynamicTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId((Context)ctx, (String)submitSchemeId);
        String billIds = CmpStrUtil.join(CmpSscUtil.transColl2Array((IObjectCollection)terminalSubmitBillRel, "id"), (String)",", null);
        Map<String, List<Object[]>> billEntryMap = this.getSubmitEntry(ctx, dynamicTable, billIds);
        ArrayList updateEmployeeRange = Lists.newArrayList();
        HashMap reverseMap = Maps.newHashMap();
        reverseMap.put("message", EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label20", (Locale)ctx.getLocale()));
        reverseMap.put("innerMsg", EASResource.getString((String)"com.kingdee.shr.ssccompensation.resource.DistributionRuleResource", (String)"label21", (Locale)ctx.getLocale()));
        ArrayList updateStatus = Lists.newArrayList();
        for (int i = 0; i < terminalSubmitBillRel.size(); ++i) {
            TerminalSubmitBillRelInfo termBill = terminalSubmitBillRel.get(i);
            if (termBill == null || termBill.getDistributeStatus().equals((Object)DistributeStatusEnum.NOT_DISTRIBUTE)) continue;
            BatchSubmitShemeBillInfo bill = termBill.getSubmitBill();
            String submitBillId = bill.getId().toString();
            if (existSubmitBillAttr != null && existSubmitBillAttr.contains(submitBillId) || bill.getBillState() != HRBillStateEnum.SAVED) continue;
            reverseMap.put("jobId", termBill.getJob());
            Map reverseJob = CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob((Map)reverseMap);
            String msg = (String)reverseJob.get("errorMsg");
            if (!StringUtils.isEmpty((CharSequence)msg) && !"null".equals(msg)) continue;
            String billId = termBill.getId().toString();
            res.add(billId);
            updateStatus.add(new Object[]{null, 200, null, null, null, billId});
            updateEmployeeRange.addAll((Collection)billEntryMap.get(termBill.getSubmitBill().getId().toString()));
        }
        HashMap udpParam = Maps.newHashMap();
        udpParam.put("updateStatus", updateStatus);
        udpParam.put("updateEmployeeRange", updateEmployeeRange);
        udpParam.put("distributionPeriodId", distributionPeriodId);
        this._afterCancelDistribute(ctx, udpParam);
        return CmpStrUtil.join((Object)res, (String)",", null);
    }

    protected List<String> getColNames(Context ctx, IntegrateEntryTableAttrs attr) {
        return attr.getColNames();
    }

    @Override
    protected String _reverseJob(Context ctx, Map param) throws BOSException, EASBizException {
        Set billId = (Set)param.get("billId");
        HashSet newBillId = new HashSet();
        for (Object obj : billId) {
            obj = StringEscapeUtils.escapeSql((String)String.valueOf(obj));
            newBillId.add(obj);
        }
        String sql = "select FJobId from T_SHR_ActivityJobInfo where FBill in ('" + StringUtils.join((Object[])newBillId.toArray(), (String)"','") + "') and FActivity = '" + "nGlBfKt6Tbi0H0L1aO6O5IIs15U=" + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                String jobId = rs.getString("FJobId");
                if (StringUtils.isEmpty((CharSequence)jobId)) continue;
                HashMap reverseMap = Maps.newHashMap();
                reverseMap.put("jobId", jobId);
                Map reverseJob = CoActivityJobOptFacadeFactory.getLocalInstance((Context)ctx).reverseJob((Map)reverseMap);
                String msg = (String)reverseJob.get("errorMsg");
                if (StringUtils.isEmpty((CharSequence)msg)) continue;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    protected Map<String, Set<String>> _getApprovePerson(Context ctx, Map param) throws BOSException, EASBizException {
        return null;
    }
}

