/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.wizard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.shareservice.CoJobPoolingType;
import com.kingdee.shr.ssccompensation.app.common.CommonUtils;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillActivityInfo;
import com.kingdee.shr.ssccompensation.app.wizard.AbstractDistributeSubmitTerminalFacadeControllerBean;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeSubmitBillFacadeFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalCollection;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalInfo;
import com.kingdee.shr.ssccompensation.app.wizard.IDistributeSubmitBillFacade;
import com.kingdee.shr.ssccompensation.app.wizard.TerminalSubmitBillRelCollection;
import com.kingdee.shr.ssccompensation.app.wizard.TerminalSubmitBillRelFactory;
import com.kingdee.shr.ssccompensation.app.wizard.TerminalSubmitBillRelInfo;
import com.kingdee.shr.ssccompensation.utils.ActivityUtils;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class DistributeSubmitTerminalFacadeControllerBean
extends AbstractDistributeSubmitTerminalFacadeControllerBean {
    private static final Logger LOG = Logger.getLogger(DistributeSubmitTerminalFacadeControllerBean.class);

    @Override
    protected void _deleteTerminals(Context ctx, DistributionSubmitTerminalCollection terminals, String distributionRuleId) throws BOSException {
        ArrayList<Object[]> delTerminalParams = new ArrayList<Object[]>();
        ArrayList<Object[]> delRangeParams = new ArrayList<Object[]>();
        ArrayList<String> terminalIds = new ArrayList<String>();
        for (int i = 0; i < terminals.size(); ++i) {
            DistributionSubmitTerminalInfo info = terminals.get(i);
            Object[] delTerminalParam = new Object[]{CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info)};
            delTerminalParams.add(delTerminalParam);
            Object[] delRangeParam = new Object[]{CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info.getBill()), CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info.getAdminOrgUnit())};
            delRangeParams.add(delRangeParam);
            terminalIds.add(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info));
        }
        String delTerminalSQL = "delete from T_HR_DistributionSubmitTerm where fid = ?";
        DbUtil.executeBatch((Context)ctx, (String)delTerminalSQL, delTerminalParams);
        String delRangeSQL = "delete from T_HR_SWizardEmployeeRange where FBillID = ? and FAdminOrgUnitID = ?";
        DbUtil.executeBatch((Context)ctx, (String)delRangeSQL, delRangeParams);
        String submitSchemeIdSQL = "(select FSubmitSchemeID from T_HR_SDistributionRule where fid = '" + distributionRuleId + "')";
        String entryTableName = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeIdSQL((Context)ctx, (String)submitSchemeIdSQL);
        DistributeSubmitBillFacadeFactory.getLocalInstance(ctx).clearSubmitBillInfo(terminalIds, entryTableName);
    }

    @Override
    protected BatchMessageTipsHeader _updateCOD(Context ctx, Map param) throws BOSException {
        String billIds = (String)param.get("billIds");
        String ids = (String)param.get("ids");
        String codDates = (String)param.get("codDates");
        String jobIds = (String)param.get("jobIds");
        String userId = (String)param.get("userId");
        List<String> billIdList = Arrays.asList(billIds.split(","));
        List<String> idList = Arrays.asList(ids.split(","));
        List<String> dates = Arrays.asList(codDates.split(","));
        List<String> jobIdList = Arrays.asList(jobIds.split(","));
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        String errMsg = EASResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label28", (Locale)ctx.getLocale());
        List<SubmitBillActivityInfo> unfinished = this.getUnfinishedActivities(ctx, billIdList, idList, header, errMsg);
        if (!unfinished.isEmpty()) {
            String updateSQL = "update T_HR_SubmitBillCOD set FCODDate = ?, fLastUpdateUserId = ?, fLastUpdateTime = now() where FSubmitBillId = ? and FJobId = ?";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (SubmitBillActivityInfo activity : unfinished) {
                Object[] arr = new Object[4];
                String billId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)activity.getSubmitBill());
                int index = billIdList.indexOf(billId);
                arr[0] = this.getCODDate(dates, index);
                arr[1] = userId;
                arr[2] = billId;
                arr[3] = jobIdList.get(index);
                params.add(arr);
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, params);
        }
        return header;
    }

    private void filterFillingActivities(Context ctx, List<SubmitBillActivityInfo> unfinished, BatchMessageTipsHeader header, List<String> idList, List<String> billIdList) {
        if (unfinished == null || unfinished.isEmpty()) {
            return;
        }
        Iterator<SubmitBillActivityInfo> iterator = unfinished.iterator();
        String errMsg = EASResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label29", (Locale)ctx.getLocale());
        while (iterator.hasNext()) {
            SubmitBillActivityInfo info = iterator.next();
            if (CommonUtils.isFillingActivity(ctx, info.getActivityId())) continue;
            iterator.remove();
            String submitBillId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info.getSubmitBill());
            String actId = idList.get(billIdList.indexOf(submitBillId));
            this.resetMessageTips(header, errMsg, actId);
        }
    }

    private List<SubmitBillActivityInfo> getUnfinishedActivities(Context ctx, List<String> billIdList, List<String> idList, BatchMessageTipsHeader header, String errMsg) throws BOSException {
        List<SubmitBillActivityInfo> activities = ActivityUtils.getActivityBillInfo(ctx, billIdList);
        List<SubmitBillActivityInfo> unfinished = activities.stream().filter(e -> e.getJobPoolingType() != CoJobPoolingType.Operated && e.getJobPoolingType() != CoJobPoolingType.Delete).collect(Collectors.toList());
        StringBuilder idBuilder = new StringBuilder();
        int success = 0;
        int failure = 0;
        String sucMsg = EASResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label30", (Locale)ctx.getLocale());
        for (String billId : billIdList) {
            BatchMessageTipsBody body = new BatchMessageTipsBody();
            String id = idList.get(billIdList.indexOf(billId));
            body.setId(id);
            Optional<SubmitBillActivityInfo> optional = unfinished.stream().filter(e -> billId.equals(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)e.getSubmitBill()))).findFirst();
            if (optional.isPresent()) {
                body.setMuitTipsState(Boolean.TRUE.booleanValue());
                body.setMuitTipsMessage(sucMsg);
                ++success;
            } else {
                ++failure;
                body.setMuitTipsState(Boolean.FALSE.booleanValue());
                body.setMuitTipsMessage(errMsg);
            }
            if (idBuilder.length() > 0) {
                idBuilder.append(",");
            }
            idBuilder.append(id);
            header.addResult(body);
        }
        header.setSuccessCount(success);
        header.setFailureCount(failure);
        header.setBillId(idBuilder.toString());
        return unfinished;
    }

    private Date getCODDate(List<String> dates, int idx) {
        try {
            java.util.Date d = CmpDateUtil.parseDate((String)dates.get(idx));
            if (d == null) {
                LOG.error((Object)("illegal date format: " + dates.get(idx)));
                return null;
            }
            return CmpDateUtil.toSqlDate((java.util.Date)d);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    protected BatchMessageTipsHeader _modifyOperator(Context ctx, Map param) throws BOSException, EASBizException {
        String billIds = (String)param.get("billIds");
        String ids = (String)param.get("ids");
        String userId = (String)param.get("userId");
        String persons = (String)param.get("persons");
        String cods = (String)param.get("cods");
        List<String> billIdList = Arrays.asList(billIds.split(","));
        List<String> idList = Arrays.asList(ids.split(","));
        List<String> personList = Arrays.asList(persons.split(","));
        List<String> codList = Arrays.asList(cods.split(","));
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        String errMsg = EASResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label31", (Locale)ctx.getLocale());
        List<SubmitBillActivityInfo> unfinished = this.getUnfinishedActivities(ctx, billIdList, idList, header, errMsg);
        this.filterFillingActivities(ctx, unfinished, header, idList, billIdList);
        if (!unfinished.isEmpty()) {
            HashSet submitBillIds = new HashSet();
            unfinished.forEach(e -> submitBillIds.add(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)e.getSubmitBill())));
            String oql = "select id, submitBill.id, submitBill.proposer.id, distributionPeriod.id,  submitCOD, job where submitBill.id in (" + CmpStrUtil.converCollectionToSql(submitBillIds) + ")";
            TerminalSubmitBillRelCollection relCollection = TerminalSubmitBillRelFactory.getLocalInstance(ctx).getTerminalSubmitBillRelCollection(oql);
            IDistributeSubmitBillFacade distributeSubmitBillFacade = DistributeSubmitBillFacadeFactory.getLocalInstance(ctx);
            for (int i = 0; i < relCollection.size(); ++i) {
                TerminalSubmitBillRelInfo rel = relCollection.get(i);
                String submitBillId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rel.getSubmitBill());
                String formerProposer = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rel.getSubmitBill().getProposer());
                HashMap<String, Object> map = new HashMap<String, Object>();
                BatchMessageTipsHeader cancelHeader = new BatchMessageTipsHeader();
                map.put("billIds", CommonUtils.getCoreBaseObjectId(rel));
                map.put("distributionPeriodId", CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rel.getDistributionPeriod()));
                map.put("batchMessageTipsHeader", cancelHeader);
                int index = billIdList.indexOf(submitBillId);
                String actId = idList.get(index);
                distributeSubmitBillFacade.cancelDistribute(map);
                if (cancelHeader.getSuccessCount() == 0) {
                    errMsg = ((BatchMessageTipsBody)cancelHeader.getResult().get(0)).getMuitTipsMessage();
                    this.resetMessageTips(header, errMsg, actId);
                    continue;
                }
                this.addExtList(header, formerProposer, actId);
                String currentProposer = personList.get(index);
                List<Object[]> updateParam = Collections.singletonList(new Object[]{currentProposer, submitBillId});
                this.updateProposer(ctx, updateParam);
                BatchMessageTipsHeader distributeHeader = new BatchMessageTipsHeader();
                map.put("batchMessageTipsHeader", distributeHeader);
                map.put("CODDate", this.getCODDate(codList, index));
                map.put("userId", userId);
                map.put("billIds", CommonUtils.getCoreBaseObjectId(rel));
                map.put("distributionPeriodId", CommonUtils.getCoreBaseObjectId((CoreBaseInfo)rel.getDistributionPeriod()));
                distributeSubmitBillFacade.distribute(map);
                if (distributeHeader.getSuccessCount() == 0) {
                    errMsg = ((BatchMessageTipsBody)distributeHeader.getResult().get(0)).getMuitTipsMessage();
                    this.resetMessageTips(header, errMsg, actId);
                    continue;
                }
                this.addExtList(header, currentProposer, actId);
            }
        }
        return header;
    }

    private void addExtList(BatchMessageTipsHeader header, String proposerId, String actId) {
        Optional<BatchMessageTipsBody> optional = header.getResult().stream().filter(e -> e.getId().equals(actId)).findFirst();
        if (optional.isPresent()) {
            BatchMessageTipsBody body = optional.get();
            ArrayList<String> list = body.getMessageListExt();
            if (null == list) {
                list = new ArrayList<String>();
            }
            list.add(proposerId);
            body.setMessageListExt(list);
        }
    }

    @Override
    protected BatchMessageTipsHeader _urge(Context ctx, Map param) throws BOSException {
        String billIds = (String)param.get("billIds");
        String ids = (String)param.get("ids");
        List<String> billIdList = Arrays.asList(billIds.split(","));
        List<String> idList = Arrays.asList(ids.split(","));
        BatchMessageTipsHeader header = new BatchMessageTipsHeader();
        String errMsg = EASResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label31", (Locale)ctx.getLocale());
        this.getUnfinishedActivities(ctx, billIdList, idList, header, errMsg);
        return header;
    }

    private void updateProposer(Context ctx, List<Object[]> list) throws BOSException {
        String updateSQL = "update T_HR_SBatchSubmitShemeBill set FProposerID = ? where fid = ?";
        DbUtil.executeBatch((Context)ctx, (String)updateSQL, list);
    }

    private void resetMessageTips(BatchMessageTipsHeader header, String errMsg, String actId) {
        Optional<BatchMessageTipsBody> optional = header.getResult().stream().filter(e -> e.getId().equals(actId)).findFirst();
        if (optional.isPresent()) {
            BatchMessageTipsBody body = optional.get();
            body.setMuitTipsMessage(errMsg);
            body.setMuitTipsState(Boolean.FALSE.booleanValue());
            int failure = header.getFailureCount() + 1;
            int success = header.getSuccessCount() - 1;
            header.setFailureCount(failure);
            header.setSuccessCount(success);
        }
    }
}

