/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.wizard;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.ssccompensation.app.ProposerSourceEnum;
import com.kingdee.shr.ssccompensation.app.SubmitConfigPersonCollection;
import com.kingdee.shr.ssccompensation.app.SubmitConfigPersonInfo;
import com.kingdee.shr.ssccompensation.app.SubmitTerminalEnum;
import com.kingdee.shr.ssccompensation.app.common.AdminOrgUnitVO;
import com.kingdee.shr.ssccompensation.app.common.CommonUtils;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalCollection;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalFactory;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitAdminOrgAndTerminalInfo;
import com.kingdee.shr.ssccompensation.app.wizard.AbstractDistributionSubmitTerminalControllerBean;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeStatusEnum;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeSubmitBillFacadeFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeSubmitTerminalFacadeFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodInfo;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalCollection;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionSubmitTerminalInfo;
import com.kingdee.shr.ssccompensation.app.wizard.TerminalDataSourceEnum;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DistributionSubmitTerminalControllerBean
extends AbstractDistributionSubmitTerminalControllerBean {
    private static final Logger LOG = Logger.getLogger(DistributionSubmitTerminalControllerBean.class);

    @Override
    protected BatchMessageTipsHeader _syncFromRule(Context ctx, String distributionRuleId, String billId) throws BOSException, EASBizException {
        BatchMessageTipsHeader tips = new BatchMessageTipsHeader();
        tips.setBillId(billId);
        int success = 0;
        int failure = 0;
        String ruleTerminalSQL = "select submitTerminal, proposerSource, adminOrgUnit.id, adminOrgUnit.name, adminOrgUnit.number, adminOrgUnit.longNumber, proposer.id, isDownward where bill.distributionRule.id = '" + distributionRuleId + "' and state = " + 1;
        SubmitAdminOrgAndTerminalCollection ruleTerminals = SubmitAdminOrgAndTerminalFactory.getLocalInstance(ctx).getSubmitAdminOrgAndTerminalCollection(ruleTerminalSQL);
        if (ruleTerminals.isEmpty()) {
            String msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label19", (Context)ctx);
            throw new EASBizException(new NumericExceptionSubItem("", msg));
        }
        String wizardTerminalSQL = "select id, adminOrgUnit.id, adminOrgUnit.name, adminOrgUnit.number, adminOrgUnit.longNumber, isDownward where bill.id = '" + billId + "'";
        DistributionSubmitTerminalCollection wizardTerminals = this.getDistributionSubmitTerminalCollection(ctx, wizardTerminalSQL);
        ArrayList<IObjectPK> toDelete = new ArrayList<IObjectPK>();
        DistributionPeriodInfo bill = new DistributionPeriodInfo();
        bill.setId(BOSUuid.read((String)billId));
        Iterator iterator = ruleTerminals.iterator();
        List<AdminOrgUnitVO> existedAdminOrgUnits = this.getAdminOrgUnitFromEntry(wizardTerminals);
        String hierarchyErrMsg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label46", (Context)ctx);
        Map adminOrgDistribution = DistributeSubmitBillFacadeFactory.getLocalInstance(ctx).getDistributedAdminOrg(billId);
        while (iterator.hasNext()) {
            SubmitAdminOrgAndTerminalInfo ruleTerminal = (SubmitAdminOrgAndTerminalInfo)iterator.next();
            String adminOrgId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)ruleTerminal.getAdminOrgUnit());
            DistributionSubmitTerminalInfo existed = this.checkRepeatedAdminOrgUnit(ruleTerminal.getAdminOrgUnit(), wizardTerminals);
            String msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label22", (Context)ctx);
            if (null != existed) {
                ++failure;
                iterator.remove();
                msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label20", (Context)ctx);
                this.addBatchMessageBody(tips, ruleTerminal, Boolean.FALSE, msg);
                continue;
            }
            if (adminOrgDistribution.get(adminOrgId) == DistributeStatusEnum.DISTRIBUTED) {
                ++failure;
                iterator.remove();
                msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label21", (Context)ctx);
                this.addBatchMessageBody(tips, ruleTerminal, Boolean.FALSE, msg);
                continue;
            }
            if (CommonUtils.isIncluded(ruleTerminal.getAdminOrgUnit(), existedAdminOrgUnits)) {
                ++failure;
                iterator.remove();
                this.addBatchMessageBody(tips, ruleTerminal, Boolean.FALSE, hierarchyErrMsg);
                continue;
            }
            if (ruleTerminal.isIsDownward()) {
                List<String> childIds = CommonUtils.getChildAdminIds(ruleTerminal.getAdminOrgUnit(), existedAdminOrgUnits);
                if (CommonUtils.hasDistributedData(childIds, adminOrgDistribution)) {
                    ++failure;
                    iterator.remove();
                    msg = SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label49", (Context)ctx);
                    this.addBatchMessageBody(tips, ruleTerminal, Boolean.FALSE, msg);
                    continue;
                }
                int count = this.deleteChildren(ruleTerminal.getAdminOrgUnit(), wizardTerminals, toDelete);
                if (count > 0) {
                    msg = msg + SHRServerResource.getString((String)"com.kingdee.shr.ssccompensation.app.CommonResource", (String)"label51", (Context)ctx);
                }
                this.addBatchMessageBody(tips, ruleTerminal, Boolean.TRUE, msg);
                continue;
            }
            this.addBatchMessageBody(tips, ruleTerminal, Boolean.TRUE, msg);
        }
        success = ruleTerminals.size();
        this.convertAndSave(ctx, bill, ruleTerminals);
        if (!toDelete.isEmpty()) {
            IObjectPK[] pks = this.list2Array(toDelete);
            this.delete(ctx, pks);
        }
        tips.setSuccessCount(success);
        tips.setFailureCount(failure);
        return tips;
    }

    private IObjectPK[] list2Array(List<IObjectPK> toDelete) {
        IObjectPK[] pks = new IObjectPK[toDelete.size()];
        for (int i = 0; i < toDelete.size(); ++i) {
            pks[i] = toDelete.get(i);
        }
        return pks;
    }

    private int deleteChildren(AdminOrgUnitInfo adminOrg, DistributionSubmitTerminalCollection wizardTerminals, List<IObjectPK> toDelete) {
        int children = 0;
        if (null == wizardTerminals || wizardTerminals.isEmpty()) {
            return children;
        }
        String number = adminOrg.getNumber();
        for (int i = 0; i < wizardTerminals.size(); ++i) {
            DistributionSubmitTerminalInfo info = wizardTerminals.get(i);
            String longNumber = info.getAdminOrgUnit().getLongNumber();
            ArrayList numbers = Lists.newArrayList((Object[])longNumber.split("!"));
            if (!numbers.contains(number)) continue;
            ObjectUuidPK pk = new ObjectUuidPK(info.getId());
            toDelete.add((IObjectPK)pk);
            ++children;
        }
        return children;
    }

    protected void addBatchMessageBody(BatchMessageTipsHeader tips, SubmitAdminOrgAndTerminalInfo ruleTerminal, Boolean aFalse, String s) {
        BatchMessageTipsBody body = new BatchMessageTipsBody();
        body.setMuitTipsState(aFalse.booleanValue());
        body.setMuitTipsMessage(s);
        ArrayList<String> extList = new ArrayList<String>();
        extList.add(ruleTerminal.getAdminOrgUnit().getNumber());
        extList.add(ruleTerminal.getAdminOrgUnit().getName());
        body.setMessageListExt(extList);
        tips.addResult(body);
    }

    private void convertAndSave(Context ctx, DistributionPeriodInfo bill, SubmitAdminOrgAndTerminalCollection ruleTerminals) throws BOSException {
        if (ruleTerminals.isEmpty()) {
            return;
        }
        CoreBaseCollection collection = new CoreBaseCollection();
        for (int i = 0; i < ruleTerminals.size(); ++i) {
            SubmitAdminOrgAndTerminalInfo terminal = ruleTerminals.get(i);
            DistributionSubmitTerminalInfo info = new DistributionSubmitTerminalInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setBill(bill);
            info.setDataSource(TerminalDataSourceEnum.AUTO_GENERATED);
            info.setAdminOrgUnit(terminal.getAdminOrgUnit());
            info.setProposer(terminal.getProposer());
            info.setIsDownward(terminal.isIsDownward());
            info.setSubmitTerminal(terminal.getSubmitTerminal());
            info.setProposerSource(terminal.getProposerSource());
            collection.add((CoreBaseInfo)info);
        }
        try {
            super.saveBatchData(ctx, collection);
        }
        catch (BOSException | EASBizException e) {
            throw new BOSException(e);
        }
    }

    @Override
    protected BatchMessageTipsHeader _referPerson(Context ctx, String ids, String distributionPeriodId, String distributionRuleId) throws BOSException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _afterBatchSet(Context ctx, Map param) throws BOSException {
        String distributionRuleId = (String)param.get("distributionRuleId");
        DistributionSubmitTerminalCollection delCollection = (DistributionSubmitTerminalCollection)((Object)param.get("toDelete"));
        DistributionSubmitTerminalCollection pageEntry = (DistributionSubmitTerminalCollection)((Object)param.get("pageEntry"));
        boolean flag = CmpDistributedLockUtils.tryLock((Context)ctx, (String)"ssc.cmp.distribution.wizard.period", (String)distributionRuleId);
        if (!flag) {
            throw new BOSException("System is busy! Please try again later.");
        }
        try {
            if (null != delCollection && !delCollection.isEmpty()) {
                DistributeSubmitTerminalFacadeFactory.getLocalInstance(ctx).deleteTerminals(delCollection, distributionRuleId);
            }
            CoreBaseCollection collection = new CoreBaseCollection();
            for (int i = 0; i < pageEntry.size(); ++i) {
                DistributionSubmitTerminalInfo info = pageEntry.get(i);
                if (null == info.getDataSource()) {
                    info.setDataSource(TerminalDataSourceEnum.MANUAL);
                }
                collection.add((CoreBaseInfo)pageEntry.get(i));
            }
            try {
                super.saveBatchData(ctx, collection);
            }
            catch (EASBizException e) {
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            CmpDistributedLockUtils.unlock((Context)ctx, (String)"ssc.cmp.distribution.wizard.period", (String)distributionRuleId);
        }
    }

    protected void updateByAdminOrgId(Context ctx, String billId, List<SubmitConfigPersonInfo> persons) throws BOSException {
        if (persons.isEmpty()) {
            return;
        }
        String sql = "update T_HR_DistributionSubmitTerm set FProposerId = ? ,fSubmitTerminal = 1 ,fProposerSource = 1 ,fDataSource = 2 where fBillId = ? and fAdminOrgUnitId = ?";
        ArrayList params = new ArrayList();
        persons.forEach(person -> {
            Object[] param = new Object[]{CommonUtils.getCoreBaseObjectId((CoreBaseInfo)person.getProposer()), billId, CommonUtils.getCoreBaseObjectId((CoreBaseInfo)person.getAdminOrgUnit())};
            params.add(param);
        });
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
    }

    protected void insertSubmitPerson2Terminal(Context ctx, SubmitConfigPersonCollection persons, String distributionPeriodId) throws BOSException, EASBizException {
        CoreBaseCollection entry = this.convertPersonConfig2Terminal(persons, distributionPeriodId);
        super.saveBatchData(ctx, entry);
    }

    protected CoreBaseCollection convertPersonConfig2Terminal(SubmitConfigPersonCollection persons, String distributionPeriodId) {
        CoreBaseCollection entry = new CoreBaseCollection();
        DistributionPeriodInfo bill = new DistributionPeriodInfo();
        bill.setId(BOSUuid.read((String)distributionPeriodId));
        for (int i = 0; i < persons.size(); ++i) {
            SubmitConfigPersonInfo person = persons.get(i);
            DistributionSubmitTerminalInfo info = new DistributionSubmitTerminalInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
            adminOrgUnitInfo.setId(person.getAdminOrgUnit().getId());
            info.setAdminOrgUnit(adminOrgUnitInfo);
            info.setBill(bill);
            info.setProposer(person.getProposer());
            info.setProposerSource(ProposerSourceEnum.ASSIGNING);
            info.setSubmitTerminal(SubmitTerminalEnum.WORKBENCH_COORDINATION);
            info.setDataSource(TerminalDataSourceEnum.MANUAL);
            entry.add((CoreBaseInfo)info);
        }
        return entry;
    }

    private List<AdminOrgUnitVO> getAdminOrgUnitFromEntry(DistributionSubmitTerminalCollection entry) {
        ArrayList<AdminOrgUnitVO> collection = new ArrayList<AdminOrgUnitVO>();
        for (int i = 0; i < entry.size(); ++i) {
            AdminOrgUnitVO vo = new AdminOrgUnitVO();
            vo.setAdminOrgUnitInfo(entry.get(i).getAdminOrgUnit());
            vo.setDownward(entry.get(i).isIsDownward());
            collection.add(vo);
        }
        return collection;
    }

    protected DistributionSubmitTerminalInfo checkRepeatedAdminOrgUnit(AdminOrgUnitInfo adminOrgUnitInfo, DistributionSubmitTerminalCollection terminals) {
        if (null == terminals || terminals.isEmpty()) {
            return null;
        }
        for (int i = 0; i < terminals.size(); ++i) {
            DistributionSubmitTerminalInfo info = terminals.get(i);
            if (!adminOrgUnitInfo.getId().equals((Object)info.getAdminOrgUnit().getId())) continue;
            return info;
        }
        return null;
    }
}

