/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rpts.ctrlreport.osf;

import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class OSFObjectUtil {
    private static Logger logger = Logger.getLogger(OSFObjectUtil.class);

    public static IRowSet osfObjectToRowSet(Object obj) {
        DynamicRowSet drs = null;
        HashMap<String, String> types = null;
        try {
            if (obj instanceof Map) {
                Map value = (Map)obj;
                drs = new DynamicRowSet(value.size());
                types = OSFObjectUtil.createMapRowSet(drs, value);
                drs.moveToInsertRow();
                OSFObjectUtil.storeMapToDS(drs, types, value);
                drs.insertRow();
            } else if (obj instanceof List) {
                List value = (List)obj;
                if (value.size() == 0) {
                    drs = new DynamicRowSet(1);
                    drs.setColInfo(1, new ColInfo("data", "data", 12, null));
                    return drs;
                }
                if (value.get(0) instanceof Map) {
                    drs = ((Map)value.get(0)).get("columnOrder") != null ? new DynamicRowSet(((Map)value.get(0)).size() - 1) : new DynamicRowSet(((Map)value.get(0)).size());
                    types = OSFObjectUtil.createMapRowSet(drs, (Map)value.get(0));
                    for (Object o : value) {
                        drs.moveToInsertRow();
                        OSFObjectUtil.storeMapToDS(drs, types, (Map)o);
                        drs.insertRow();
                    }
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("data", obj);
                    drs = new DynamicRowSet(map.size());
                    types = OSFObjectUtil.createMapRowSet(drs, map);
                    drs.moveToInsertRow();
                    OSFObjectUtil.storeMapToDS(drs, types, map);
                    drs.insertRow();
                }
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("data", obj);
                drs = new DynamicRowSet(map.size());
                types = OSFObjectUtil.createMapRowSet(drs, map);
                drs.moveToInsertRow();
                OSFObjectUtil.storeMapToDS(drs, types, map);
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return drs;
    }

    private static void storeMapToDS(DynamicRowSet drs, HashMap<String, String> types, Map value) throws SQLException {
        Iterator it = value.entrySet().iterator();
        ResultSetMetaData meta = drs.getMetaData();
        int size = meta.getColumnCount();
        for (int i = 1; i <= size; ++i) {
            String key = meta.getColumnName(i);
            if (!types.containsKey(key)) continue;
            String type = types.get(key);
            if (type.equals("4")) {
                if (value.get(key) != null) {
                    drs.updateInt(key, ((Integer)value.get(key)).intValue());
                    continue;
                }
                drs.updateInt(key, Integer.valueOf(0).intValue());
                continue;
            }
            if (type.equals("3")) {
                if (value.get(key) != null) {
                    drs.updateBigDecimal(key, (BigDecimal)value.get(key));
                    continue;
                }
                drs.updateBigDecimal(key, BigDecimal.valueOf(0L));
                continue;
            }
            if (value.get(key) != null) {
                drs.updateString(key, value.get(key).toString());
                continue;
            }
            drs.updateString(key, "");
        }
    }

    private static HashMap<String, String> createMapRowSet(DynamicRowSet drs, Map value) throws SQLException {
        HashMap<String, String> types = new HashMap<String, String>();
        if (value.get("columnOrder") != null) {
            ArrayList columnOrder = (ArrayList)value.get("columnOrder");
            int index = 1;
            int size = columnOrder.size();
            for (int i = 0; i < size; ++i) {
                int type = 12;
                String colType = "varchar";
                if (value.get(columnOrder.get(i)) instanceof Integer) {
                    type = 4;
                    colType = "int";
                } else if (value.get(columnOrder.get(i)) instanceof BigDecimal) {
                    type = 3;
                    colType = "decimal";
                }
                types.put(columnOrder.get(i).toString(), "" + type);
                ColInfo colInfo = new ColInfo(columnOrder.get(i).toString(), columnOrder.get(i).toString(), 12, null);
                colInfo.colTypeName = colType;
                drs.setColInfo(index, colInfo);
                ++index;
            }
        } else {
            Iterator it = value.entrySet().iterator();
            int index = 1;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                int type = 12;
                String colType = "varchar";
                if (entry.getValue() instanceof Integer) {
                    type = 4;
                    colType = "int";
                } else if (entry.getValue() instanceof BigDecimal) {
                    type = 3;
                    colType = "decimal";
                }
                types.put(entry.getKey().toString(), "" + type);
                ColInfo colInfo = new ColInfo(entry.getKey().toString(), entry.getKey().toString(), 12, null);
                colInfo.colTypeName = colType;
                drs.setColInfo(index, colInfo);
                ++index;
            }
        }
        return types;
    }
}

