/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.BaseDataChangeType;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BaseItemRelationHRInfo;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.DisatributeState;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.app.AbstractBaseItemRelationHRControllerBean;
import com.kingdee.shr.base.syssetting.util.BaseItemRelationHRUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaseItemRelationHRControllerBean
extends AbstractBaseItemRelationHRControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.BaseItemRelationHRControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BaseItemRelationHRInfo info = (BaseItemRelationHRInfo)model;
        this._verifyData(ctx, model);
        IObjectPK baseInfoORGRefPK = null;
        BaseItemRelationHRInfo oldModel = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseInfoId", (Object)info.getBaseInfoId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUse.id", (Object)info.getHrOrgUse().getId().toString(), CompareType.EQUALS));
        if (this.exists(ctx, filter)) {
            String oql = " where baseInfoId = '" + info.getBaseInfoId() + "' and hrOrgUse.id = '" + info.getHrOrgUse().getId().toString() + "'";
            oldModel = this.getBaseItemRelationHRInfo(ctx, oql);
            if (!oldModel.getState().equals((Object)info.getState())) {
                oldModel.setState(info.getState());
            }
            if (oldModel.isIsComUse() != info.isIsComUse()) {
                oldModel.setIsComUse(info.isIsComUse());
            }
            if (StringUtils.isEmpty((String)oldModel.getIndex()) || !oldModel.getIndex().equals(info.getIndex())) {
                oldModel.setIndex(info.getIndex());
            }
            baseInfoORGRefPK = super._save(ctx, (IObjectValue)oldModel);
        } else {
            baseInfoORGRefPK = super._save(ctx, (IObjectValue)info);
        }
        return baseInfoORGRefPK;
    }

    @Override
    protected void _verifyData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BaseItemRelationHRInfo info = (BaseItemRelationHRInfo)model;
        if (null == info.getBaseInfoId()) {
            throw new BaseItemException(BaseItemException.BASEINFO_ID_NOT_NULL);
        }
        if (null == info.getHrOrgUse() || null == info.getHrOrgUse().getId()) {
            throw new BaseItemException(BaseItemException.HRORG_ID_NOT_NULL);
        }
        if (null == info.getState()) {
            throw new BaseItemException(BaseItemException.STATE_NOT_NULL);
        }
    }

    @Override
    protected void _setGeneralUse(Context ctx, String id, boolean isGeneralUse) throws BOSException, EASBizException {
        if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            throw new BaseItemException(BaseItemException.ID_DATA_NOT_FOUND, new Object[]{id});
        }
        BaseItemRelationHRInfo model = this.getBaseItemRelationHRInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        BaseItemRelationHRInfo newModel = new BaseItemRelationHRInfo();
        newModel.setId(model.getId());
        newModel.setIsComUse(isGeneralUse);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isComUse"));
        this._updatePartial(ctx, (IObjectValue)newModel, sic);
    }

    @Override
    protected void _setIndexCode(Context ctx, String id, String indexCode) throws BOSException, EASBizException {
        if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            throw new BaseItemException(BaseItemException.ID_DATA_NOT_FOUND, new Object[]{id});
        }
        BaseItemRelationHRInfo model = this.getBaseItemRelationHRInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        BaseItemRelationHRInfo newModel = new BaseItemRelationHRInfo();
        newModel.setId(model.getId());
        newModel.setIndex(indexCode);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("index"));
        this._updatePartial(ctx, (IObjectValue)newModel, sic);
    }

    private void validateParam(String shrBaseItemId, String hrOrgUnitId) throws EASBizException {
        if (StringUtils.isEmpty((String)shrBaseItemId)) {
            throw new BaseItemException(BaseItemException.BASEITEM_ID_NOT_NULL);
        }
        if (StringUtils.isEmpty((String)hrOrgUnitId)) {
            throw new BaseItemException(BaseItemException.HRORGUNIT_ID_NOT_NULL);
        }
    }

    private void validateParam0(String id) throws EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            throw new BaseItemException(BaseItemException.BASEITEM_USEID_NOT_NULL);
        }
    }

    @Override
    protected void _enable(Context ctx, String shrBaseItemId, String hrOrgUnitId) throws BOSException, EASBizException {
        this.validateParam(shrBaseItemId, hrOrgUnitId);
        this.doStateByTwoId(ctx, DisatributeState.DONE, shrBaseItemId, hrOrgUnitId);
    }

    @Override
    protected void _disable(Context ctx, String shrBaseItemId, String hrOrgUnitId) throws BOSException, EASBizException {
        this.validateParam(shrBaseItemId, hrOrgUnitId);
        this.doStateByTwoId(ctx, DisatributeState.UNDONE, shrBaseItemId, hrOrgUnitId);
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.validateParam0(id);
        this.doStateById(ctx, DisatributeState.DONE, id);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.validateParam0(id);
        this.doStateById(ctx, DisatributeState.UNDONE, id);
    }

    @Override
    protected IObjectPK _saveByBaseIdAndHRBUId(Context ctx, String shrBaseItemId, String hrOrgUnitId, int state) throws BOSException, EASBizException {
        SHRBaseItemInfo baseItemModel;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseInfoId", (Object)shrBaseItemId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUse.id", (Object)hrOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)100, CompareType.EQUALS));
        if (!(200 != state || BaseItemStateEnum.ENABLE.equals((Object)(baseItemModel = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, shrBaseItemId)).getState()) && UsePolicy.DISTRIBUTION_SHARED.equals((Object)baseItemModel.getUsePolicy()))) {
            throw new BaseItemException(BaseItemException.ONLY_ENABLED_CANCEL);
        }
        BaseItemRelationHRInfo model = null;
        if (this.exists(ctx, filter)) {
            model = BaseItemRelationHRUtil.generateBaseItemRelationHRInfo(ctx, shrBaseItemId, hrOrgUnitId, (DisatributeState)EnumUtils.getEnum(DisatributeState.class, (int)state), Boolean.TRUE, BaseDataChangeType.HRORG, null);
        } else if (100 == state) {
            model = BaseItemRelationHRUtil.generateBaseItemRelationHRInfo(ctx, shrBaseItemId, hrOrgUnitId, (DisatributeState)EnumUtils.getEnum(DisatributeState.class, (int)state), Boolean.TRUE, BaseDataChangeType.HRORG, null);
        } else {
            throw new BaseItemException(BaseItemException.NO_NEED_CANCEL);
        }
        IObjectPK pk = null;
        if (null != model) {
            pk = this._save(ctx, (IObjectValue)model);
            if (null == model.getId()) {
                model.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        return pk;
    }

    @Override
    protected IObjectPK[] _batchSaveByBaseIdAndHRBUId(Context ctx, List baseInfoOrgRefList) throws BOSException, EASBizException {
        ArrayList<IObjectPK> resultList = new ArrayList<IObjectPK>();
        int total = baseInfoOrgRefList.size();
        for (int i = 0; i < total; ++i) {
            if (!(baseInfoOrgRefList.get(i) instanceof Map)) {
                throw new BaseItemException(BaseItemException.LIST_NOT_MAP);
            }
            Map map = (Map)baseInfoOrgRefList.get(i);
            String shrBaseItemId = (String)map.get("shrBaseItemId");
            String hrOrgUnitId = (String)map.get("hrOrgUnitId");
            int state = (Integer)map.get("state");
            BaseItemRelationHRUtil.checkInfoIsNull(shrBaseItemId, hrOrgUnitId, state);
            resultList.add(this._saveByBaseIdAndHRBUId(ctx, shrBaseItemId, hrOrgUnitId, state));
        }
        return BaseItemRelationHRUtil.listToArray(resultList);
    }

    @Override
    protected void _batchSetGeneralUse(Context ctx, List comUseListMap) throws BOSException, EASBizException {
        int total = comUseListMap.size();
        for (int i = 0; i < total; ++i) {
            if (!(comUseListMap.get(i) instanceof Map)) {
                throw new BaseItemException(BaseItemException.LIST_NOT_MAP);
            }
            Map map = (Map)comUseListMap.get(i);
            String id = (String)map.get("id");
            boolean isComUse = (Boolean)map.get("isComUse");
            this._setGeneralUse(ctx, id, isComUse);
        }
    }

    @Override
    protected void _batchSetIndexCode(Context ctx, List indexCodeListMap) throws BOSException, EASBizException {
        int total = indexCodeListMap.size();
        for (int i = 0; i < total; ++i) {
            if (!(indexCodeListMap.get(i) instanceof Map)) {
                throw new BaseItemException(BaseItemException.LIST_NOT_MAP);
            }
            Map map = (Map)indexCodeListMap.get(i);
            String id = (String)map.get("id");
            String index = (String)map.get("index");
            this._setIndexCode(ctx, id, index);
        }
    }

    @Override
    protected void _setComUseAndIndex(Context ctx, String id, boolean isComUse, String index) throws BOSException, EASBizException {
        if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            throw new BaseItemException(BaseItemException.ID_DATA_NOT_FOUND, new Object[]{id});
        }
        BaseItemRelationHRInfo model = this.getBaseItemRelationHRInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        BaseItemRelationHRInfo newModel = new BaseItemRelationHRInfo();
        newModel.setId(model.getId());
        newModel.setIndex(index);
        newModel.setIsComUse(isComUse);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("index"));
        sic.add(new SelectorItemInfo("isComUse"));
        this._updatePartial(ctx, (IObjectValue)newModel, sic);
    }

    private void doStateById(Context ctx, DisatributeState state, String id) throws BOSException, EASBizException {
        BaseItemRelationHRInfo model = null;
        if (!StringUtils.isEmpty((String)id)) {
            model = this.getBaseItemRelationHRInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getBaseItemRelationHRInfoSelector());
            this.doState(ctx, model, state);
        }
    }

    private void doStateByTwoId(Context ctx, DisatributeState state, String shrBaseItemId, String hrOrgUnitId) throws BOSException, EASBizException {
        BaseItemRelationHRInfo model = null;
        if (!StringUtils.isEmpty((String)shrBaseItemId) && !StringUtils.isEmpty((String)hrOrgUnitId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("baseInfoId", (Object)shrBaseItemId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUse.id", (Object)hrOrgUnitId, CompareType.EQUALS));
            if (this.exists(ctx, filter)) {
                model = this.getBaseItemRelationHRInfo(ctx, this.getBaseItemRelationHRInfoOsql(shrBaseItemId, hrOrgUnitId));
                if (!state.equals((Object)model.getState())) {
                    this.doState(ctx, model, state);
                }
            } else if (!DisatributeState.UNDONE.equals((Object)state)) {
                this._save(ctx, (IObjectValue)BaseItemRelationHRUtil.generateBaseItemRelationHRInfo(ctx, shrBaseItemId, hrOrgUnitId, state, Boolean.TRUE, BaseDataChangeType.HRORG, null));
            }
        }
    }

    private void doState(Context ctx, BaseItemRelationHRInfo model, DisatributeState state) throws EASBizException, BOSException {
        if (null != model) {
            SHRBaseItemInfo baseItemModel;
            if (!(!DisatributeState.UNDONE.equals((Object)state) || BaseItemStateEnum.ENABLE.equals((Object)(baseItemModel = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, model.getBaseInfoId())).getState()) && UsePolicy.DISTRIBUTION_SHARED.equals((Object)baseItemModel.getUsePolicy()))) {
                throw new BaseItemException(BaseItemException.ONLY_ENABLED_CANCEL);
            }
            if (model.getHrOrgUse().isIsSealUp() && DisatributeState.DONE.equals((Object)state)) {
                throw new BaseItemException(BaseItemException.SEALED_ORG_UNABLE_ENABLE, new Object[]{model.getHrOrgUse().getNumber()});
            }
            BaseItemRelationHRInfo newModel = new BaseItemRelationHRInfo();
            newModel.setId(model.getId());
            newModel.setState(state);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            this._updatePartial(ctx, (IObjectValue)newModel, sic);
        }
    }

    private SelectorItemCollection getBaseItemRelationHRInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseInfoId"));
        selector.add(new SelectorItemInfo("isComUse"));
        selector.add(new SelectorItemInfo("index"));
        selector.add(new SelectorItemInfo("hrOrgUse.id"));
        selector.add(new SelectorItemInfo("hrOrgUse.isSealUp"));
        selector.add(new SelectorItemInfo("hrOrgUse.name"));
        selector.add(new SelectorItemInfo("hrOrgUse.number"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("changeType"));
        return selector;
    }

    private String getBaseItemRelationHRInfoOsql(String shrBaseItemId, String hrOrgUnitId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select id,baseInfoId,isComUse,index,hrOrgUse.id,hrOrgUse.isSealUp,hrOrgUse.name,hrOrgUse.number,state,changeType").append(" where").append(" baseInfoId = '").append(shrBaseItemId).append("'").append(" and hrOrgUse.id = '").append(hrOrgUnitId).append("'");
        return sb.toString();
    }

    @Override
    protected void _enableDefaultValue(Context ctx, String id) throws BOSException, EASBizException {
        this.doDefaultValue(ctx, id, Boolean.TRUE);
    }

    @Override
    protected void _disableDefaultValue(Context ctx, String id) throws BOSException, EASBizException {
        this.doDefaultValue(ctx, id, Boolean.FALSE);
    }

    private void doDefaultValue(Context ctx, String id, boolean isDefaultValue) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            throw new BaseItemException(BaseItemException.ID_NOT_NULL);
        }
        BaseItemRelationHRInfo newModel = new BaseItemRelationHRInfo();
        newModel.setId(BOSUuid.read((String)id));
        newModel.setIsDefaultValue(isDefaultValue);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isDefaultValue"));
        this._updatePartial(ctx, (IObjectValue)newModel, sic);
    }

    @Override
    protected void _disableByBaseItemId(Context ctx, String shrBaseItemId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)shrBaseItemId)) {
            throw new BaseItemException(BaseItemException.BASEITEM_ID_NOT_NULL);
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, this.getBOSType());
        String tableName = entityObjectInfo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tableName).append(" set FState = ").append(200).append(" where FBaseInfoId ='").append(shrBaseItemId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _disableByHrOrgId(Context ctx, String hrOrgUnitId) throws BOSException, EASBizException {
    }
}

